/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL if the key is not\n       contained in the map.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="collection_funcs")
@ScalaSignature(bytes="\u0006\u0005\tmf\u0001B\u00193\u0001~B\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tU\u0002\u0011\t\u0012)A\u0005O\"A1\u000e\u0001BK\u0002\u0013\u0005a\r\u0003\u0005m\u0001\tE\t\u0015!\u0003h\u0011!i\u0007A!f\u0001\n\u0003q\u0007\u0002C;\u0001\u0005#\u0005\u000b\u0011B8\t\u0011Y\u0004!Q3A\u0005\u0002]D\u0001b\u001f\u0001\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\u0006y\u0002!\t! \u0005\u0007\u0003\u000f\u0001A\u0011I<\t\rq\u0004A\u0011AA\u0005\u0011)\ty\u0001\u0001EC\u0002\u0013%\u0011\u0011\u0003\u0005\n\u0003O\u0001\u0001R1A\u0005\n]D!\"a\u000b\u0001\u0011\u000b\u0007I\u0011BA\u0017\u0011)\ti\u0004\u0001EC\u0002\u0013\u0005\u0013\u0011\u0003\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u0019\u0001\t\u0013\t\u0019\u0007\u0003\u0004\u0002v\u0001!\te\u001e\u0005\b\u0003o\u0002A\u0011IA=\u0011)\t\t\t\u0001EC\u0002\u0013%\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\tY\u000b\u0001C!\u0003[Cq!a0\u0001\t#\n\t\rC\u0004\u0002L\u0002!\t%!4\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAs\u0001E\u0005I\u0011AAt\u0011%\ti\u0010AI\u0001\n\u0003\t9\u000fC\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0003\u0002!I!Q\u0001\u0001\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005\u0017\u0001\u0011\u0011!C!\u0005\u001bA\u0011B!\b\u0001\u0003\u0003%\tAa\b\t\u0013\t\u0005\u0002!!A\u0005\u0002\t\r\u0002\"\u0003B\u0015\u0001\u0005\u0005I\u0011\tB\u0016\u0011%\u0011I\u0004AA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003@\u0001\t\t\u0011\"\u0011\u0003B!I!Q\t\u0001\u0002\u0002\u0013\u0005#qI\u0004\n\u0005W\u0012\u0014\u0011!E\u0001\u0005[2\u0001\"\r\u001a\u0002\u0002#\u0005!q\u000e\u0005\u0007y\u001e\"\tAa\"\t\u0013\t%u%!A\u0005F\t-\u0005\"\u0003BGO\u0005\u0005I\u0011\u0011BH\u0011%\u0011IjJI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\u001c\u001e\n\n\u0011\"\u0001\u0003\b!I!QT\u0014\u0002\u0002\u0013\u0005%q\u0014\u0005\n\u0005[;\u0013\u0013!C\u0001\u0005\u0003A\u0011Ba,(#\u0003%\tAa\u0002\t\u0013\tEv%!A\u0005\n\tM&!C#mK6,g\u000e^!u\u0015\t\u0019D'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001b7\u0003!\u0019\u0017\r^1msN$(BA\u001c9\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003si\nQa\u001d9be.T!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO\u000e\u00011\u0003\u0003\u0001A\t\u001eSUjU-\u0011\u0005\u0005\u0013U\"\u0001\u001a\n\u0005\r\u0013$\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tU)\u0003\u0002Ge\tyq)\u001a;NCB4\u0016\r\\;f+RLG\u000e\u0005\u0002B\u0011&\u0011\u0011J\r\u0002\u0011\u000f\u0016$\u0018I\u001d:bs&#X-\\+uS2\u0004\"!Q&\n\u00051\u0013$aE*vaB|'\u000f^)vKJL8i\u001c8uKb$\bC\u0001(R\u001b\u0005y%B\u0001)7\u0003\u0019)'O]8sg&\u0011!k\u0014\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n9\u0001K]8ek\u000e$\bC\u0001.c\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_}\u00051AH]8pizJ\u0011AV\u0005\u0003CV\u000bq\u0001]1dW\u0006<W-\u0003\u0002dI\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011-V\u0001\u0005Y\u00164G/F\u0001h!\t\t\u0005.\u0003\u0002je\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003Y!WMZ1vYR4\u0016\r\\;f\u001fV$xJ\u001a\"pk:$W#A8\u0011\u0007Q\u0003(/\u0003\u0002r+\n1q\n\u001d;j_:\u0004\"!Q:\n\u0005Q\u0014$a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0018I\u00164\u0017-\u001e7u-\u0006dW/Z(vi>3'i\\;oI\u0002\n1BZ1jY>sWI\u001d:peV\t\u0001\u0010\u0005\u0002Us&\u0011!0\u0016\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}QAap`A\u0001\u0003\u0007\t)\u0001\u0005\u0002B\u0001!)Q-\u0003a\u0001O\")1.\u0003a\u0001O\"9Q.\u0003I\u0001\u0002\u0004y\u0007b\u0002<\n!\u0003\u0005\r\u0001_\u0001\u000f]VdG.\u00138u_2,'/\u00198u)\u0015q\u00181BA\u0007\u0011\u0015)7\u00021\u0001h\u0011\u0015Y7\u00021\u0001h\u0003)i\u0017\r]&fsRK\b/Z\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u000331\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u000f\u0003/\u0011\u0001\u0002R1uCRK\b/\u001a\u0015\u0004\u0019\u0005\u0005\u0002c\u0001+\u0002$%\u0019\u0011QE+\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001F1se\u0006LX\t\\3nK:$h*\u001e7mC\ndW\rK\u0002\u000e\u0003C\t\u0001b\u001c:eKJLgnZ\u000b\u0003\u0003_\u0001RAWA\u0019\u0003kI1!a\re\u0005!y%\u000fZ3sS:<\u0007c\u0001+\u00028%\u0019\u0011\u0011H+\u0003\u0007\u0005s\u0017\u0010K\u0002\u000f\u0003C\t\u0001\u0002Z1uCRK\b/\u001a\u0015\u0004\u001f\u0005\u0005\u0012AC5oaV$H+\u001f9fgV\u0011\u0011Q\t\t\u00065\u0006\u001d\u00131J\u0005\u0004\u0003\u0013\"'aA*fcB!\u0011QCA'\u0013\u0011\ty%a\u0006\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA+!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.i\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002`\u0005e#a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00179,H\u000e\\1cS2LG/\u001f\u000b\u0006q\u0006\u0015\u00141\u000e\u0005\b\u0003O\u0012\u0002\u0019AA5\u0003!)G.Z7f]R\u001c\b\u0003\u0002.\u0002H\u001dDq!!\u001c\u0013\u0001\u0004\ty'A\u0004pe\u0012Lg.\u00197\u0011\u0007Q\u000b\t(C\u0002\u0002tU\u00131!\u00138u\u0003!qW\u000f\u001c7bE2,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCBA\u001b\u0003w\ny\bC\u0004\u0002~Q\u0001\r!!\u000e\u0002\u000bY\fG.^3\t\u000f\u00055D\u00031\u0001\u00026\u0005YAm\\#mK6,g\u000e^!u+\t\t)\tE\u0005U\u0003\u000f\u000b)$!\u000e\u00026%\u0019\u0011\u0011R+\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004fA\u000b\u0002\"\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003#\u000bi*a*\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&3\u0003\u001d\u0019w\u000eZ3hK:LA!a'\u0002\u0016\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002 Z\u0001\r!!)\u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0014\u0006\r\u0016\u0002BAS\u0003+\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002*Z\u0001\r!!%\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011q\u0016\t\u0005\u0003c\u000bIL\u0004\u0003\u00024\u0006U\u0006C\u0001/V\u0013\r\t9,V\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0016Q\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]V+A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)a0a1\u0002H\"1\u0011Q\u0019\rA\u0002\u001d\fqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002Jb\u0001\raZ\u0001\t]\u0016<(+[4ii\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003\u001f\u0004B\u0001\u00169\u0002RB!\u00111[Ak\u001b\u0005A\u0014bAAlq\ta\u0011+^3ss\u000e{g\u000e^3yi\u0006!1m\u001c9z)%q\u0018Q\\Ap\u0003C\f\u0019\u000fC\u0004f5A\u0005\t\u0019A4\t\u000f-T\u0002\u0013!a\u0001O\"9QN\u0007I\u0001\u0002\u0004y\u0007b\u0002<\u001b!\u0003\u0005\r\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIOK\u0002h\u0003W\\#!!<\u0011\t\u0005=\u0018\u0011`\u0007\u0003\u0003cTA!a=\u0002v\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003o,\u0016AC1o]>$\u0018\r^5p]&!\u00111`Ay\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"Aa\u0001+\u0007=\fY/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%!f\u0001=\u0002l\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u0004\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005!A.\u00198h\u0015\t\u0011I\"\u0001\u0003kCZ\f\u0017\u0002BA^\u0005'\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u0007B\u0013\u0011%\u00119#IA\u0001\u0002\u0004\ty'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005[\u0001bAa\f\u00036\u0005URB\u0001B\u0019\u0015\r\u0011\u0019$V\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u001c\u0005c\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019\u0001P!\u0010\t\u0013\t\u001d2%!AA\u0002\u0005U\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u0004\u0003D!I!q\u0005\u0013\u0002\u0002\u0003\u0007\u0011qN\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u0014I\u0005C\u0005\u0003(\u0015\n\t\u00111\u0001\u00026!\u001a\u0002A!\u0014\u0003T\tU#\u0011\fB.\u0005?\u0012\tG!\u001a\u0003hA\u0019\u0011Ia\u0014\n\u0007\tE#GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t]\u0013\u0001\"\u001a\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003%\u001b8eKbL\u0003%\f\u0011SKR,(O\\:!K2,W.\u001a8uA=4\u0007%\u0019:sCf\u0004\u0013\r\u001e\u0011hSZ,g\u000e\t\u00152[\t\f7/\u001a3*A%tG-\u001a=/A%3\u0007%\u00138eKb\u0004\u0013n\u001d\u00111Y)\u0001\u0003\u0005\t\u0011!AM\u0003\u0018M]6!o&dG\u000e\t;ie><\b%\u00198!KJ\u0014xN\u001d\u0018!\u0013\u001a\u0004\u0013N\u001c3fq\u0002b\u0004\u0005\r\u0017!C\u000e\u001cWm]:fg\u0002*G.Z7f]R\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mCN$\b\u0005^8!i\",\u0007EZ5sgRt#\u0002\t\u0011!A\u0001\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA%tG-\u001a=!Kb\u001cW-\u001a3tAQDW\r\t7f]\u001e$\b\u000eI8gAQDW\rI1se\u0006L\b%\u00198e\u0015\u0001\u0002\u0003\u0005\t\u0011!AN\u0004\u0018M]6/gFdg&\u00198tS:*g.\u00192mK\u0012\u0004\u0007%[:!g\u0016$\b\u0005^8!M\u0006d7/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\"(/^3-A%$\b\u0005\u001e5s_^\u001c\b%\u0011:sCfLe\u000eZ3y\u001fV$xJ\u001a\"pk:$7/\u0012=dKB$\u0018n\u001c8\u000bA\u0001\u0002\u0003\u0005\t\u0011g_J\u0004\u0013N\u001c<bY&$\u0007%\u001b8eS\u000e,7O\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\\1qY\u0001ZW-_\u0015![\u0001\u0012V\r^;s]N\u0004c/\u00197vK\u00022wN\u001d\u0011hSZ,g\u000eI6fs:\u0002C\u000b[3!MVt7\r^5p]\u0002\u0012X\r^;s]N\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA-,\u0017\u0010I5tA9|GO\u0003\u0011!A\u0001\u0002\u0003\u0005I2p]R\f\u0017N\\3eA%t\u0007\u0005\u001e5fA5\f\u0007O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003^\u0005a(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\r\u0017!e1\u00023'\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[\u0006\u0004\b&\r\u0017!O\u0005<C\u0006\t\u001a-A\u001d\u0012w%\u000b\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\u0019\u0006!A\u0005)1/\u001b8dK\u0006\u0012!1M\u0001\u0006e9\"d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005S\n\u0001cY8mY\u0016\u001cG/[8o?\u001a,hnY:\u0002\u0013\u0015cW-\\3oi\u0006#\bCA!('\u00159#\u0011\u000fB?!%\u0011\u0019H!\u001fhO>Dh0\u0004\u0002\u0003v)\u0019!qO+\u0002\u000fI,h\u000e^5nK&!!1\u0010B;\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*!!1\u0011B\f\u0003\tIw.C\u0002d\u0005\u0003#\"A!\u001c\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0004\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013y\u0014\tJa%\u0003\u0016\n]\u0005\"B3+\u0001\u00049\u0007\"B6+\u0001\u00049\u0007bB7+!\u0003\u0005\ra\u001c\u0005\bm*\u0002\n\u00111\u0001y\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0015BU!\u0011!\u0006Oa)\u0011\u000fQ\u0013)kZ4pq&\u0019!qU+\u0003\rQ+\b\u000f\\35\u0011!\u0011Y+LA\u0001\u0002\u0004q\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B[!\u0011\u0011\tBa.\n\t\te&1\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
SupportQueryContext,
QueryErrorsBase {
    private transient DataType mapKeyType;
    private transient boolean arrayElementNullable;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private Option<QueryContext> queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt x$0) {
        return ElementAt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.mapKeyType$lzycompute();
        }
        return this.mapKeyType;
    }

    private boolean arrayElementNullable$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.arrayElementNullable = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.arrayElementNullable;
    }

    private boolean arrayElementNullable() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.arrayElementNullable$lzycompute();
        }
        return this.arrayElementNullable;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return new .colon.colon((Object)arrayType, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return new .colon.colon((Object)new MapType(dt, valueType, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        if (tuple2 != null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.right())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !DataTypeUtils$.MODULE$.sameType(e2, e12 = (mapType = (MapType)dataType).keyType())) {
                return new TypeCheckResult.DataTypeMismatch("MAP_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)MapType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        if (ordinal == 0) {
            return false;
        }
        if (elements.length() < scala.math.package$.MODULE$.abs(ordinal)) {
            return !this.failOnError();
        }
        if (ordinal < 0) {
            return ((Expression)elements.apply(elements.length() + ordinal)).nullable();
        }
        return ((Expression)elements.apply(ordinal - 1)).nullable();
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        }
        if (dataType instanceof MapType) {
            return true;
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                Function2 & Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> {
                        int idx;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < scala.math.package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements(), this.getContextOrNull());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                return value2.eval(value2.eval$default$1());
                            }
                            if (None$.MODULE$.equals(option)) {
                                return null;
                            }
                            throw new MatchError(option);
                        }
                        if (index == 0) {
                            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
                        }
                        int n = idx = index > 0 ? index - 1 : array.numElements() + index;
                        if (this.arrayElementNullable() && array.isNullAt(idx)) {
                            return null;
                        }
                        return array.get(idx, this.dataType());
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.doElementAt$lzycompute();
        }
        return this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> {
                Object object;
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |if (" + eval1 + ".isNullAt(" + index + ")) {\n               |  " + ev.isNull() + " = true;\n               |} else\n             ")) : "";
                String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
                if (this.failOnError()) {
                    object = "throw QueryExecutionErrors.invalidElementAtIndexError(" + index + ", " + eval1 + ".numElements(), " + errorContext + ");";
                } else {
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        object = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  " + defaultValueEval.code() + "\n                  " + ev.isNull() + " = " + defaultValueEval.isNull() + ";\n                  " + ev.value() + " = " + defaultValueEval.value() + ";\n                "));
                    } else if (None$.MODULE$.equals(option)) {
                        object = ev.isNull() + " = true;";
                    } else {
                        throw new MatchError(option);
                    }
                }
                String indexOutOfBoundBranch = object;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |int " + index + " = (int) " + eval2 + ";\n             |if (" + eval1 + ".numElements() < Math.abs(" + index + ")) {\n             |  " + indexOutOfBoundBranch + "\n             |} else {\n             |  if (" + index + " == 0) {\n             |    throw QueryExecutionErrors.invalidIndexOfZeroError(" + errorContext + ");\n             |  } else if (" + index + " > 0) {\n             |    " + index + "--;\n             |  } else {\n             |    " + index + " += " + eval1 + ".numElements();\n             |  }\n             |  " + nullCheck + "\n             |  {\n             |    " + ev.value() + " = " + CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index) + ";\n             |  }\n             |}\n           "));
            });
        }
        if (dataType instanceof MapType) {
            return this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        if (this.failOnError() && this.left().resolved() && this.left().dataType() instanceof ArrayType) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.defaultValueOutOfBound();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "defaultValueOutOfBound";
            }
            case 3: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        if (this.failOnError() != elementAt.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
        SupportQueryContext.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

