/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.BitmapOrAgg$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns a bitmap that is the bitwise OR of all of the bitmaps from the child\n    expression. The input should be bitmaps created from bitmap_construct_agg().\n  ", examples="\n    Examples:\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X '10'), (X '20'), (X '40') AS tab(col);\n       700000\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X '10'), (X '10'), (X '10') AS tab(col);\n       100000\n  ", since="3.5.0", group="agg_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\re\u0001B\u00193\u0001~B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005\u0019\"AQ\r\u0001BK\u0002\u0013\u0005a\r\u0003\u0005k\u0001\tE\t\u0015!\u0003h\u0011!Y\u0007A!f\u0001\n\u00031\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B4\t\u000b5\u0004A\u0011\u00018\t\u000b5\u0004A\u0011A:\t\u000bU\u0004A\u0011\t<\t\u000bu\u0004A\u0011\t@\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0005\u0002L\u0001\u0011\r\u0011\"\u0003\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u0013\u0011\f\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002\\!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\t\t\u000b\u0001C!\u0003GC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005e\u0006\"CAh\u0001E\u0005I\u0011AAi\u0011%\t)\u000eAI\u0001\n\u0003\t\t\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\"A\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005a\rC\u0005\u0002l\u0002\t\t\u0011\"\u0001\u0002n\"I\u00111\u001f\u0001\u0002\u0002\u0013\u0005\u0013Q\u001f\u0005\n\u0005\u0007\u0001\u0011\u0011!C\u0001\u0005\u000bA\u0011B!\u0003\u0001\u0003\u0003%\tEa\u0003\t\u0013\t=\u0001!!A\u0005B\tEq!\u0003B\u001be\u0005\u0005\t\u0012\u0001B\u001c\r!\t$'!A\t\u0002\te\u0002BB7(\t\u0003\u0011\t\u0006C\u0005\u0003T\u001d\n\t\u0011\"\u0012\u0003V!I!qK\u0014\u0002\u0002\u0013\u0005%\u0011\f\u0005\n\u0005C:\u0013\u0013!C\u0001\u0003#D\u0011Ba\u0019(#\u0003%\t!!5\t\u0013\t\u0015t%!A\u0005\u0002\n\u001d\u0004\"\u0003B;OE\u0005I\u0011AAi\u0011%\u00119hJI\u0001\n\u0003\t\t\u000eC\u0005\u0003z\u001d\n\t\u0011\"\u0003\u0003|\tY!)\u001b;nCB|%/Q4h\u0015\t\u0019D'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001b7\u0003!\u0019\u0017\r^1msN$(BA\u001c9\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003si\nQa\u001d9be.T!a\u000f\u001f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0014aA8sO\u000e\u00011#\u0002\u0001A\rB3\u0006CA!E\u001b\u0005\u0011%BA\"3\u0003%\twm\u001a:fO\u0006$X-\u0003\u0002F\u0005\n\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB\u0019qI\u0013'\u000e\u0003!S!!\u0013\u001b\u0002\u000bQ\u0014X-Z:\n\u0005-C%!C+oCJLH*[6f!\tie*D\u00013\u0013\ty%G\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002X?:\u0011\u0001,\u0018\b\u00033rk\u0011A\u0017\u0006\u00037z\na\u0001\u0010:p_Rt\u0014\"A*\n\u0005y\u0013\u0016a\u00029bG.\fw-Z\u0005\u0003A\u0006\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0018*\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00031\u000baa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003\u001d\u0004\"!\u00155\n\u0005%\u0014&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"Ba\u001c9reB\u0011Q\n\u0001\u0005\u0006E\u001e\u0001\r\u0001\u0014\u0005\bK\u001e\u0001\n\u00111\u0001h\u0011\u001dYw\u0001%AA\u0002\u001d$\"a\u001c;\t\u000b\tD\u0001\u0019\u0001'\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003]\u0004\"\u0001_>\u000e\u0003eT!A\u001f\u001b\u0002\u0011\u0005t\u0017\r\\=tSNL!\u0001`=\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006Y\nQ\u0001^=qKNLA!!\u0003\u0002\u0004\tAA)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0004\u0011\t\u0005E\u0011\u0011\u0004\b\u0005\u0003'\t)\u0002\u0005\u0002Z%&\u0019\u0011q\u0003*\u0002\rA\u0013X\rZ3g\u0013\u0011\tY\"!\b\u0003\rM#(/\u001b8h\u0015\r\t9BU\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007=\f\u0019\u0003\u0003\u0004\u0002&1\u0001\r\u0001T\u0001\t]\u0016<8\t[5mI\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fF\u0002A\u0003WAa!!\f\u000e\u0001\u00049\u0017!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$Hc\u0001!\u00024!1\u0011Q\u0007\bA\u0002\u001d\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002\u00119,H\u000e\\1cY\u0016,\"!a\u000f\u0011\u0007E\u000bi$C\u0002\u0002@I\u0013qAQ8pY\u0016\fg.A\bbO\u001e\u0014UO\u001a4feN\u001b\u0007.Z7b+\t\t)\u0005\u0005\u0003\u0002\u0002\u0005\u001d\u0013\u0002BA%\u0003\u0007\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003)\u0011\u0017\u000e^7ba\u0006#HO]\u000b\u0003\u0003\u001f\u00022!TA)\u0013\r\t\u0019F\r\u0002\u0013\u0003R$(/\u001b2vi\u0016\u0014VMZ3sK:\u001cW-A\u0006cSRl\u0017\r]!uiJ\u0004\u0013aE1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001cXCAA.!\u00159\u0016QLA(\u0013\r\ty&\u0019\u0002\u0004'\u0016\f\u0018!\u00043fM\u0006,H\u000e\u001e*fgVdG/\u0006\u0002\u0002fA)\u0011+a\u001a\u0002l%\u0019\u0011\u0011\u000e*\u0003\r=\u0003H/[8o!\ri\u0015QN\u0005\u0004\u0003_\u0012$a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0019S:\u0004X\u000f^!hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\u0018!G5oaV$\u0018iZ4Ck\u001a4WM]!uiJL'-\u001e;fg\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u0011\tI(a \u0011\u0007E\u000bY(C\u0002\u0002~I\u0013A!\u00168ji\"9\u0011\u0011Q\fA\u0002\u0005\r\u0015A\u00022vM\u001a,'\u000f\u0005\u0003\u0002\u0006\u0006\u001dU\"\u0001\u001b\n\u0007\u0005%EGA\u0006J]R,'O\\1m%><\u0018AB;qI\u0006$X\r\u0006\u0004\u0002z\u0005=\u0015\u0011\u0013\u0005\b\u0003\u0003C\u0002\u0019AAB\u0011\u001d\t\u0019\n\u0007a\u0001\u0003\u0007\u000bQ!\u001b8qkR\fQ!\\3sO\u0016$b!!\u001f\u0002\u001a\u0006u\u0005bBAN3\u0001\u0007\u00111Q\u0001\bEV4g-\u001a:2\u0011\u001d\ty*\u0007a\u0001\u0003\u0007\u000bqAY;gM\u0016\u0014('\u0001\u0003fm\u0006dG\u0003BAS\u0003W\u00032!UAT\u0013\r\tIK\u0015\u0002\u0004\u0003:L\b\"CAA5A\u0005\t\u0019AAB\u0003\u0011\u0019w\u000e]=\u0015\u000f=\f\t,a-\u00026\"9!m\u0007I\u0001\u0002\u0004a\u0005bB3\u001c!\u0003\u0005\ra\u001a\u0005\bWn\u0001\n\u00111\u0001h\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a/+\u00071\u000bil\u000b\u0002\u0002@B!\u0011\u0011YAf\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017!C;oG\",7m[3e\u0015\r\tIMU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAg\u0003\u0007\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a5+\u0007\u001d\fi,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\t1\fgn\u001a\u0006\u0003\u0003K\fAA[1wC&!\u00111DAp\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!*\u0002p\"A\u0011\u0011_\u0011\u0002\u0002\u0003\u0007q-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0004b!!?\u0002\u0000\u0006\u0015VBAA~\u0015\r\tiPU\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0001\u0003w\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\bB\u0004\u0011%\t\tpIA\u0001\u0002\u0004\t)+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAn\u0005\u001bA\u0001\"!=%\u0003\u0003\u0005\raZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\"1\u0003\u0005\n\u0003c,\u0013\u0011!a\u0001\u0003KC3\u0003\u0001B\f\u0005;\u0011yBa\t\u0003&\t%\"1\u0006B\u0018\u0005c\u00012!\u0014B\r\u0013\r\u0011YB\r\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t#AA6\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2iS2$\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u0004#-\u001b;nCB\u0004C\u000f[1uA%\u001c\b\u0005\u001e5fA\tLGo^5tK\u0002z%\u000bI8gA\u0005dG\u000eI8gAQDW\r\t2ji6\f\u0007o\u001d\u0011ge>l\u0007\u0005\u001e5fA\rD\u0017\u000e\u001c3\u000bA\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011j]B,H\u000fI:i_VdG\r\t2fA\tLG/\\1qg\u0002\u001a'/Z1uK\u0012\u0004cM]8nA\tLG/\\1q?\u000e|gn\u001d;sk\u000e$x,Y4hQ%r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\n\u0002\u0003oT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e];cgR\u0014\u0018N\\4)Q\u0016D\bf\u0018$V\u001d\u000e{\u0006fY8mS%b\u0003\u0005\r\u0017!m%\u0002cIU(NAY\u000bE*V#TA!B\u0006eJ\u00191O%b\u0003\u0005\u000b-!OI\u0002t%\u000b\u0017!Qa\u0003s\u0005\u000e\u0019(S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]\u0002\u0004\u0007\r\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001aXOY:ue&tw\r\u000b5fq\"zf)\u0016(D?\"\u001aw\u000e\\\u0015*Y\u0001\u0002D\u0006\t\u001c*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)1\u0002:\u0013\u0007M\u0014*Y\u0001B\u0003\fI\u00142a\u001dJC\u0006\t\u0015YA\u001d\n\u0004gJ\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112aA\u0002\u0004\u0007\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012!QF\u0001\u0006g9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005g\t\u0011\"Y4h?\u001a,hnY:\u0002\u0017\tKG/\\1q\u001fJ\fum\u001a\t\u0003\u001b\u001e\u001aRa\nB\u001e\u0005\u000f\u0002\u0002B!\u0010\u0003D1;wm\\\u0007\u0003\u0005\u007fQ1A!\u0011S\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0012\u0003@\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\t%#qJ\u0007\u0003\u0005\u0017RAA!\u0014\u0002d\u0006\u0011\u0011n\\\u0005\u0004A\n-CC\u0001B\u001c\u0003!!xn\u0015;sS:<GCAAn\u0003\u0015\t\u0007\u000f\u001d7z)\u001dy'1\fB/\u0005?BQA\u0019\u0016A\u00021Cq!\u001a\u0016\u0011\u0002\u0003\u0007q\rC\u0004lUA\u0005\t\u0019A4\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IG!\u001d\u0011\u000bE\u000b9Ga\u001b\u0011\rE\u0013i\u0007T4h\u0013\r\u0011yG\u0015\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tMT&!AA\u0002=\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A! \u0011\t\u0005u'qP\u0005\u0005\u0005\u0003\u000byN\u0001\u0004PE*,7\r\u001e")
public class BitmapOrAgg
extends ImperativeAggregate
implements UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final AttributeReference bitmapAttr;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return BitmapOrAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BitmapOrAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(BitmapOrAgg x$0) {
        return BitmapOrAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return BitmapOrAgg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return BitmapOrAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, BitmapOrAgg> tupled() {
        return BitmapOrAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, BitmapOrAgg>>> curried() {
        return BitmapOrAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        BitmapOrAgg bitmapOrAgg = this;
        synchronized (bitmapOrAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.child().dataType();
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null ? binaryType$ != null : !dataType.equals(binaryType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BinaryType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bitmap_or_agg";
    }

    @Override
    public BitmapOrAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private AttributeReference bitmapAttr() {
        return this.bitmapAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        AttributeReference attributeReference = this.bitmapAttr();
        return Nil$.MODULE$.$colon$colon((Object)attributeReference);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.apply(Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte())));
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset(), Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        byte[] input_bitmap = (byte[])this.child().eval(input);
        if (input_bitmap != null) {
            byte[] bitmap = buffer.getBinary(this.mutableAggBufferOffset());
            BitmapExpressionUtils.bitmapMerge(bitmap, input_bitmap);
            return;
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        byte[] bitmap1 = buffer1.getBinary(this.mutableAggBufferOffset());
        byte[] bitmap2 = buffer2.getBinary(this.inputAggBufferOffset());
        BitmapExpressionUtils.bitmapMerge(bitmap1, bitmap2);
    }

    @Override
    public Object eval(InternalRow buffer) {
        return buffer.getBinary(this.mutableAggBufferOffset());
    }

    public BitmapOrAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BitmapOrAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BitmapOrAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitmapOrAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitmapOrAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitmapOrAgg bitmapOrAgg = (BitmapOrAgg)x$1;
        if (this.mutableAggBufferOffset() != bitmapOrAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bitmapOrAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = bitmapOrAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitmapOrAgg.canEqual(this)) return false;
        return true;
    }

    public BitmapOrAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        String x$1 = "bitmap";
        BinaryType$ x$22 = BinaryType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("bitmap", (DataType)x$22, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("bitmap", (DataType)x$22, false, x$4);
        this.bitmapAttr = new AttributeReference("bitmap", (DataType)x$22, false, x$4, x$5, x$6);
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$2 -> x$2.newInstance());
    }

    public BitmapOrAgg(Expression child) {
        this(child, 0, 0);
    }
}

