/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$ParseState$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class IntervalUtils$ {
    public static final IntervalUtils$ MODULE$ = new IntervalUtils$();
    private static final long MAX_DAY = 106751991L;
    private static final long MAX_HOUR = 2562047788L;
    private static final long MAX_MINUTE = 153722867280L;
    private static final long MAX_SECOND = 9223372036854L;
    private static final long MIN_SECOND = -9223372036854L;
    private static final String yearMonthPatternString = "([+|-])?(\\d+)-(\\d+)";
    private static final Regex yearMonthRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.yearMonthPatternString()).append("$").toString()));
    private static final Regex yearMonthLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?'").append(MODULE$.yearMonthPatternString()).append("'\\s+YEAR\\s+TO\\s+MONTH$").toString()));
    private static final String yearMonthIndividualPatternString = "([+|-])?(\\d+)";
    private static final Regex yearMonthIndividualRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.yearMonthIndividualPatternString()).append("$").toString()));
    private static final Regex yearMonthIndividualLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(42).append("(?i)^INTERVAL\\s+([+|-])?'").append(MODULE$.yearMonthIndividualPatternString()).append("'\\s+(YEAR|MONTH)$").toString()));
    private static final Map<Tuple2<Object, Object>, Seq<String>> supportedFormat = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]y-m", "INTERVAL [+|-]'[+|-]y-m' YEAR TO MONTH"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]y", "INTERVAL [+|-]'[+|-]y' YEAR"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]m", "INTERVAL [+|-]'[+|-]m' MONTH"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]d", "INTERVAL [+|-]'[+|-]d' DAY"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]d h", "INTERVAL [+|-]'[+|-]d h' DAY TO HOUR"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]d h:m", "INTERVAL [+|-]'[+|-]d h:m' DAY TO MINUTE"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]d h:m:s.n", "INTERVAL [+|-]'[+|-]d h:m:s.n' DAY TO SECOND"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]h", "INTERVAL [+|-]'[+|-]h' HOUR"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]h:m", "INTERVAL [+|-]'[+|-]h:m' HOUR TO MINUTE"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]h:m:s.n", "INTERVAL [+|-]'[+|-]h:m:s.n' HOUR TO SECOND"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]m", "INTERVAL [+|-]'[+|-]m' MINUTE"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]m:s.n", "INTERVAL [+|-]'[+|-]m:s.n' MINUTE TO SECOND"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[+|-]s.n", "INTERVAL [+|-]'[+|-]s.n' SECOND"})))}));
    private static final String normalPattern = "(\\d{1,2})";
    private static final String dayBoundPattern = "(\\d{1,9})";
    private static final String hourBoundPattern = "(\\d{1,10})";
    private static final String minuteBoundPattern = "(\\d{1,12})";
    private static final String secondBoundPattern = "(\\d{1,13})";
    private static final String microPattern = "(\\.\\d{1,9})";
    private static final String dayHourPatternString = new java.lang.StringBuilder(9).append("([+|-])?").append(MODULE$.dayBoundPattern()).append(" ").append(MODULE$.normalPattern()).toString();
    private static final Regex dayHourRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.dayHourPatternString()).append("$").toString()));
    private static final Regex dayHourLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.dayHourPatternString()).append("\\'\\s+DAY\\s+TO\\s+HOUR$").toString()));
    private static final String dayMinutePatternString = new java.lang.StringBuilder(10).append("([+|-])?").append(MODULE$.dayBoundPattern()).append(" ").append(MODULE$.normalPattern()).append(":").append(MODULE$.normalPattern()).toString();
    private static final Regex dayMinuteRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.dayMinutePatternString()).append("$").toString()));
    private static final Regex dayMinuteLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.dayMinutePatternString()).append("\\'\\s+DAY\\s+TO\\s+MINUTE$").toString()));
    private static final String daySecondPatternString = new java.lang.StringBuilder(12).append("([+|-])?").append(MODULE$.dayBoundPattern()).append(" ").append(MODULE$.normalPattern()).append(":").append(MODULE$.normalPattern()).append(":").append(MODULE$.normalPattern()).append(MODULE$.microPattern()).append("?").toString();
    private static final Regex daySecondRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.daySecondPatternString()).append("$").toString()));
    private static final Regex daySecondLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.daySecondPatternString()).append("\\'\\s+DAY\\s+TO\\s+SECOND$").toString()));
    private static final String hourMinutePatternString = new java.lang.StringBuilder(9).append("([+|-])?").append(MODULE$.hourBoundPattern()).append(":").append(MODULE$.normalPattern()).toString();
    private static final Regex hourMinuteRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.hourMinutePatternString()).append("$").toString()));
    private static final Regex hourMinuteLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.hourMinutePatternString()).append("\\'\\s+HOUR\\s+TO\\s+MINUTE$").toString()));
    private static final String hourSecondPatternString = new java.lang.StringBuilder(11).append("([+|-])?").append(MODULE$.hourBoundPattern()).append(":").append(MODULE$.normalPattern()).append(":").append(MODULE$.normalPattern()).append(MODULE$.microPattern()).append("?").toString();
    private static final Regex hourSecondRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.hourSecondPatternString()).append("$").toString()));
    private static final Regex hourSecondLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.hourSecondPatternString()).append("\\'\\s+HOUR\\s+TO\\s+SECOND$").toString()));
    private static final String minuteSecondPatternString = new java.lang.StringBuilder(10).append("([+|-])?").append(MODULE$.minuteBoundPattern()).append(":").append(MODULE$.normalPattern()).append(MODULE$.microPattern()).append("?").toString();
    private static final Regex minuteSecondRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.minuteSecondPatternString()).append("$").toString()));
    private static final Regex minuteSecondLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(52).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(MODULE$.minuteSecondPatternString()).append("\\'\\s+MINUTE\\s+TO\\s+SECOND$").toString()));
    private static final String dayTimeIndividualPatternString = new java.lang.StringBuilder(20).append("([+|-])?").append(MODULE$.secondBoundPattern()).append("(\\.\\d{1,9})?").toString();
    private static final Regex dayTimeIndividualRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(MODULE$.dayTimeIndividualPatternString()).append("$").toString()));
    private static final Regex dayTimeIndividualLiteralRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(54).append("(?i)^INTERVAL\\s+([+|-])?'").append(MODULE$.dayTimeIndividualPatternString()).append("'\\s+(DAY|HOUR|MINUTE|SECOND)$").toString()));
    private static final Regex dayTimePatternLegacy = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([+|-])?((\\d+) )?((\\d+):)?(\\d+):(\\d+)(\\.(\\d+))?$"));
    private static final String fallbackNotice = new java.lang.StringBuilder(41).append(new java.lang.StringBuilder(13).append("set ").append(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()).append(" to true ").toString()).append("to restore the behavior before Spark 3.0.").toString();
    private static final UTF8String intervalStr = MODULE$.unitToUtf8("interval");
    private static final UTF8String yearStr = MODULE$.unitToUtf8("year");
    private static final UTF8String monthStr = MODULE$.unitToUtf8("month");
    private static final UTF8String weekStr = MODULE$.unitToUtf8("week");
    private static final UTF8String dayStr = MODULE$.unitToUtf8("day");
    private static final UTF8String hourStr = MODULE$.unitToUtf8("hour");
    private static final UTF8String minuteStr = MODULE$.unitToUtf8("minute");
    private static final UTF8String secondStr = MODULE$.unitToUtf8("second");
    private static final UTF8String millisStr = MODULE$.unitToUtf8("millisecond");
    private static final UTF8String microsStr = MODULE$.unitToUtf8("microsecond");
    private static final UTF8String nanosStr = MODULE$.unitToUtf8("nanosecond");
    private static final long minDurationSeconds = Math.floorDiv(Long.MIN_VALUE, 1000000L);

    private long MAX_DAY() {
        return MAX_DAY;
    }

    private long MAX_HOUR() {
        return MAX_HOUR;
    }

    private long MAX_MINUTE() {
        return MAX_MINUTE;
    }

    private long MAX_SECOND() {
        return MAX_SECOND;
    }

    private long MIN_SECOND() {
        return MIN_SECOND;
    }

    public int getYears(int months) {
        return months / 12;
    }

    public int getYears(CalendarInterval interval) {
        return this.getYears(interval.months);
    }

    public byte getMonths(int months) {
        return (byte)(months % 12);
    }

    public byte getMonths(CalendarInterval interval) {
        return this.getMonths(interval.months);
    }

    public int getDays(long microseconds) {
        return (int)(microseconds / 86400000000L);
    }

    public int getDays(CalendarInterval interval) {
        int daysInMicroseconds = this.getDays(interval.microseconds);
        return Math.addExact(interval.days, daysInMicroseconds);
    }

    public byte getHours(long microseconds) {
        return (byte)(microseconds % 86400000000L / 3600000000L);
    }

    public byte getHours(CalendarInterval interval) {
        return this.getHours(interval.microseconds);
    }

    public byte getMinutes(long microseconds) {
        return (byte)(microseconds % 3600000000L / 60000000L);
    }

    public byte getMinutes(CalendarInterval interval) {
        return this.getMinutes(interval.microseconds);
    }

    public Decimal getSeconds(long microseconds) {
        return Decimal$.MODULE$.apply(microseconds % 60000000L, 8, 6);
    }

    public Decimal getSeconds(CalendarInterval interval) {
        return this.getSeconds(interval.microseconds);
    }

    private long toLongWithRange(UTF8String fieldName, String s, long minValue, long maxValue) {
        long result = s == null ? 0L : StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s));
        Predef$.MODULE$.require(minValue <= result && result <= maxValue, (Function0 & Serializable)() -> new java.lang.StringBuilder(20).append(fieldName).append(" ").append(result).append(" outside range [").append(minValue).append(", ").append(maxValue).append("]").toString());
        return result;
    }

    private String yearMonthPatternString() {
        return yearMonthPatternString;
    }

    private Regex yearMonthRegex() {
        return yearMonthRegex;
    }

    private Regex yearMonthLiteralRegex() {
        return yearMonthLiteralRegex;
    }

    private String yearMonthIndividualPatternString() {
        return yearMonthIndividualPatternString;
    }

    private Regex yearMonthIndividualRegex() {
        return yearMonthIndividualRegex;
    }

    private Regex yearMonthIndividualLiteralRegex() {
        return yearMonthIndividualLiteralRegex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int finalSign(String firstSign, String secondSign) {
        String string;
        String string2;
        Tuple2 tuple2 = new Tuple2((Object)firstSign, (Object)secondSign);
        if (tuple2 != null) {
            String string3 = (String)tuple2._1();
            String string4 = (String)tuple2._2();
            if ("-".equals(string3) && "-".equals(string4)) {
                return 1;
            }
        }
        if (tuple2 != null && "-".equals(string2 = (String)tuple2._1())) {
            return -1;
        }
        if (tuple2 != null && "-".equals(string = (String)tuple2._2())) {
            return -1;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return 1;
    }

    private String finalSign$default$2() {
        return null;
    }

    private Nothing$ throwIllegalIntervalFormatException(UTF8String input, byte startFiled, byte endField, String intervalStr, String typeName, Option<String> fallBackNotice) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(42).append("Interval string does not match ").append(intervalStr).append(" format of ").toString()).append(new java.lang.StringBuilder(1).append(((IterableOnceOps)((IterableOps)this.supportedFormat().apply((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)startFiled), (Object)BoxesRunTime.boxToByte((byte)endField)))).map((Function1 & Serializable)format -> new java.lang.StringBuilder(2).append("`").append((String)format).append("`").toString())).mkString(", ")).append(" ").toString()).append(new java.lang.StringBuilder(15).append("when cast to ").append(typeName).append(": ").append(input.toString()).toString()).append(String.valueOf(fallBackNotice.map((Function1 & Serializable)s -> new java.lang.StringBuilder(2).append(", ").append((String)s).toString()).getOrElse((Function0 & Serializable)() -> ""))).toString());
    }

    private Option<String> throwIllegalIntervalFormatException$default$6() {
        return None$.MODULE$;
    }

    public Map<Tuple2<Object, Object>, Seq<String>> supportedFormat() {
        return supportedFormat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int castStringToYMInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        Option option3;
        String string = input.trimAll().toString();
        if (string != null && !(option3 = this.yearMonthRegex().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOps)option3.get()).apply(0);
            String year = (String)((LinearSeqOps)option3.get()).apply(1);
            String month = (String)((LinearSeqOps)option3.get()).apply(2);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option2 = this.yearMonthLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOps)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option2.get()).apply(1);
            String year = (String)((LinearSeqOps)option2.get()).apply(2);
            String month = (String)((LinearSeqOps)option2.get()).apply(3);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option = this.yearMonthIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String firstSign = (String)((LinearSeqOps)option.get()).apply(0);
            String value = (String)((LinearSeqOps)option.get()).apply(1);
            return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable)() -> {
                int n;
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                if (endField == YearMonthIntervalType$.MODULE$.YEAR()) {
                    n = sign * Math.toIntExact(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 12L);
                } else if (startField == YearMonthIntervalType$.MODULE$.MONTH()) {
                    n = Math.toIntExact((long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
                } else {
                    throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
                }
                return n;
            }));
        }
        if (string == null) throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
        Option option4 = this.yearMonthIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (option4.isEmpty()) throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
        if (option4.get() == null) throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
        if (((List)option4.get()).lengthCompare(4) != 0) throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
        String firstSign = (String)((LinearSeqOps)option4.get()).apply(0);
        String secondSign = (String)((LinearSeqOps)option4.get()).apply(1);
        String value = (String)((LinearSeqOps)option4.get()).apply(2);
        String unit = (String)((LinearSeqOps)option4.get()).apply(3);
        return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable)() -> {
            int n;
            block4: {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                switch (string == null ? 0 : string.hashCode()) {
                    case 2719805: {
                        if (!"YEAR".equals(string) || !IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.YEAR(), startField, endField)) break;
                        n = sign * Math.toIntExact(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 12L);
                        break block4;
                    }
                    case 73542240: {
                        if (!"MONTH".equals(string) || !IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) break;
                        n = Math.toIntExact((long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)));
                        break block4;
                    }
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
            }
            return n;
        }));
    }

    public CalendarInterval fromYearMonthString(String input) {
        return this.fromYearMonthString(input, YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH());
    }

    public CalendarInterval fromYearMonthString(String input, byte startField, byte endField) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable)() -> "Interval year-month string must be not null");
        int months = this.castStringToYMInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(months, 0, 0L);
    }

    private <T> T safeToInterval(String interval, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new java.lang.StringBuilder(32).append("Error parsing interval ").append(interval).append(" string: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        return (T)object;
    }

    private int toYMInterval(String year, String month, int sign) {
        return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable)() -> {
            long years = MODULE$.toLongWithRange(MODULE$.yearStr(), year, 0L, 0xAAAAAAAL);
            long totalMonths = (long)sign * (years * 12L + MODULE$.toLongWithRange(MODULE$.monthStr(), month, 0L, 11L));
            return Math.toIntExact(totalMonths);
        }));
    }

    private String normalPattern() {
        return normalPattern;
    }

    private String dayBoundPattern() {
        return dayBoundPattern;
    }

    private String hourBoundPattern() {
        return hourBoundPattern;
    }

    private String minuteBoundPattern() {
        return minuteBoundPattern;
    }

    private String secondBoundPattern() {
        return secondBoundPattern;
    }

    private String microPattern() {
        return microPattern;
    }

    private String dayHourPatternString() {
        return dayHourPatternString;
    }

    private Regex dayHourRegex() {
        return dayHourRegex;
    }

    private Regex dayHourLiteralRegex() {
        return dayHourLiteralRegex;
    }

    private String dayMinutePatternString() {
        return dayMinutePatternString;
    }

    private Regex dayMinuteRegex() {
        return dayMinuteRegex;
    }

    private Regex dayMinuteLiteralRegex() {
        return dayMinuteLiteralRegex;
    }

    private String daySecondPatternString() {
        return daySecondPatternString;
    }

    private Regex daySecondRegex() {
        return daySecondRegex;
    }

    private Regex daySecondLiteralRegex() {
        return daySecondLiteralRegex;
    }

    private String hourMinutePatternString() {
        return hourMinutePatternString;
    }

    private Regex hourMinuteRegex() {
        return hourMinuteRegex;
    }

    private Regex hourMinuteLiteralRegex() {
        return hourMinuteLiteralRegex;
    }

    private String hourSecondPatternString() {
        return hourSecondPatternString;
    }

    private Regex hourSecondRegex() {
        return hourSecondRegex;
    }

    private Regex hourSecondLiteralRegex() {
        return hourSecondLiteralRegex;
    }

    private String minuteSecondPatternString() {
        return minuteSecondPatternString;
    }

    private Regex minuteSecondRegex() {
        return minuteSecondRegex;
    }

    private Regex minuteSecondLiteralRegex() {
        return minuteSecondLiteralRegex;
    }

    private String dayTimeIndividualPatternString() {
        return dayTimeIndividualPatternString;
    }

    private Regex dayTimeIndividualRegex() {
        return dayTimeIndividualRegex;
    }

    private Regex dayTimeIndividualLiteralRegex() {
        return dayTimeIndividualLiteralRegex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long castStringToDTInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        Option option6;
        Option option7;
        Option option8;
        Option option9;
        Option option10;
        Option option11;
        Option option12;
        Option option13;
        String string = input.trimAll().toString();
        if (string != null && !(option13 = this.dayHourRegex().unapplySeq((CharSequence)string)).isEmpty() && option13.get() != null && ((List)option13.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOps)option13.get()).apply(0);
            String day = (String)((LinearSeqOps)option13.get()).apply(1);
            String hour = (String)((LinearSeqOps)option13.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option12 = this.dayHourLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option12.get() != null && ((List)option12.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOps)option12.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option12.get()).apply(1);
            String day = (String)((LinearSeqOps)option12.get()).apply(2);
            String hour = (String)((LinearSeqOps)option12.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option11 = this.dayMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option11.get() != null && ((List)option11.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOps)option11.get()).apply(0);
            String day = (String)((LinearSeqOps)option11.get()).apply(1);
            String hour = (String)((LinearSeqOps)option11.get()).apply(2);
            String minute = (String)((LinearSeqOps)option11.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option10 = this.dayMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option10.get() != null && ((List)option10.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOps)option10.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option10.get()).apply(1);
            String day = (String)((LinearSeqOps)option10.get()).apply(2);
            String hour = (String)((LinearSeqOps)option10.get()).apply(3);
            String minute = (String)((LinearSeqOps)option10.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option9 = this.daySecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option9.get() != null && ((List)option9.get()).lengthCompare(6) == 0) {
            String sign = (String)((LinearSeqOps)option9.get()).apply(0);
            String day = (String)((LinearSeqOps)option9.get()).apply(1);
            String hour = (String)((LinearSeqOps)option9.get()).apply(2);
            String minute = (String)((LinearSeqOps)option9.get()).apply(3);
            String second = (String)((LinearSeqOps)option9.get()).apply(4);
            String micro = (String)((LinearSeqOps)option9.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option8 = this.daySecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option8.get() != null && ((List)option8.get()).lengthCompare(7) == 0) {
            String firstSign = (String)((LinearSeqOps)option8.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option8.get()).apply(1);
            String day = (String)((LinearSeqOps)option8.get()).apply(2);
            String hour = (String)((LinearSeqOps)option8.get()).apply(3);
            String minute = (String)((LinearSeqOps)option8.get()).apply(4);
            String second = (String)((LinearSeqOps)option8.get()).apply(5);
            String micro = (String)((LinearSeqOps)option8.get()).apply(6);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option7 = this.hourMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option7.get() != null && ((List)option7.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOps)option7.get()).apply(0);
            String hour = (String)((LinearSeqOps)option7.get()).apply(1);
            String minute = (String)((LinearSeqOps)option7.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option6 = this.hourMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((List)option6.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOps)option6.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option6.get()).apply(1);
            String hour = (String)((LinearSeqOps)option6.get()).apply(2);
            String minute = (String)((LinearSeqOps)option6.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option5 = this.hourSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((List)option5.get()).lengthCompare(5) == 0) {
            String sign = (String)((LinearSeqOps)option5.get()).apply(0);
            String hour = (String)((LinearSeqOps)option5.get()).apply(1);
            String minute = (String)((LinearSeqOps)option5.get()).apply(2);
            String second = (String)((LinearSeqOps)option5.get()).apply(3);
            String micro = (String)((LinearSeqOps)option5.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option4 = this.hourSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((List)option4.get()).lengthCompare(6) == 0) {
            String firstSign = (String)((LinearSeqOps)option4.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option4.get()).apply(1);
            String hour = (String)((LinearSeqOps)option4.get()).apply(2);
            String minute = (String)((LinearSeqOps)option4.get()).apply(3);
            String second = (String)((LinearSeqOps)option4.get()).apply(4);
            String micro = (String)((LinearSeqOps)option4.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option3 = this.minuteSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((List)option3.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOps)option3.get()).apply(0);
            String minute = (String)((LinearSeqOps)option3.get()).apply(1);
            String second = (String)((LinearSeqOps)option3.get()).apply(2);
            String micro = (String)((LinearSeqOps)option3.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (string != null && !(option2 = this.minuteSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOps)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOps)option2.get()).apply(1);
            String minute = (String)((LinearSeqOps)option2.get()).apply(2);
            String second = (String)((LinearSeqOps)option2.get()).apply(3);
            String micro = (String)((LinearSeqOps)option2.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (string != null && !(option = this.dayTimeIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(3) == 0) {
            String firstSign = (String)((LinearSeqOps)option.get()).apply(0);
            String value = (String)((LinearSeqOps)option.get()).apply(1);
            String suffix = (String)((LinearSeqOps)option.get()).apply(2);
            return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)startField), (Object)BoxesRunTime.boxToByte((byte)endField));
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by2 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.DAY() == by2 && suffix == null && value.length() <= 9) {
                        return (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 86400000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by3 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.HOUR() == by3 && suffix == null && value.length() <= 10) {
                        return (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 3600000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by4 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.MINUTE() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by4 && suffix == null && value.length() <= 12) {
                        return (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 60000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by5 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.SECOND() == by && DayTimeIntervalType$.MODULE$.SECOND() == by5 && value.length() <= 13) {
                        int n = sign;
                        switch (n) {
                            case 1: {
                                long l = MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix));
                                return l;
                            }
                            case -1: {
                                long l = MODULE$.parseSecondNano(new java.lang.StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString());
                                return l;
                            }
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                            }
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
            }));
        }
        if (string == null) throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
        Option option14 = this.dayTimeIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (option14.isEmpty()) throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
        if (option14.get() == null) throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
        if (((List)option14.get()).lengthCompare(5) != 0) throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
        String firstSign = (String)((LinearSeqOps)option14.get()).apply(0);
        String secondSign = (String)((LinearSeqOps)option14.get()).apply(1);
        String value = (String)((LinearSeqOps)option14.get()).apply(2);
        String suffix = (String)((LinearSeqOps)option14.get()).apply(3);
        String unit = (String)((LinearSeqOps)option14.get()).apply(4);
        return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable)() -> {
            long l;
            block10: {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                switch (string == null ? 0 : string.hashCode()) {
                    case -2020697580: {
                        if (!"MINUTE".equals(string) || suffix != null || value.length() > 12 || !IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) break;
                        l = (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 60000000L;
                        break block10;
                    }
                    case -1852950412: {
                        long l2;
                        if (!"SECOND".equals(string) || value.length() > 13 || !IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.SECOND(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) break;
                        int n = sign;
                        switch (n) {
                            case 1: {
                                l2 = MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix));
                                break;
                            }
                            case -1: {
                                l2 = MODULE$.parseSecondNano(new java.lang.StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString());
                                break;
                            }
                            default: {
                                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                            }
                        }
                        l = l2;
                        break block10;
                    }
                    case 67452: {
                        if (!"DAY".equals(string) || suffix != null || value.length() > 9 || !IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.DAY(), startField, endField)) break;
                        l = (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 86400000000L;
                        break block10;
                    }
                    case 2223588: {
                        if (!"HOUR".equals(string) || suffix != null || value.length() > 10 || !IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) break;
                        l = (long)sign * StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value)) * 3600000000L;
                        break block10;
                    }
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
            }
            return l;
        }));
    }

    public long toDTInterval(String day, String hour, String minute, String second, int sign) {
        long micros = 0L;
        int days = (int)this.toLongWithRange(this.dayStr(), day, 0L, this.MAX_DAY());
        micros = Math.addExact(micros, (long)(sign * days) * 86400000000L);
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, 23L);
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public long toDTInterval(String hour, String minute, String second, int sign) {
        long micros = 0L;
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, this.MAX_HOUR());
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public long toDTInterval(String minute, String second, int sign) {
        long micros = 0L;
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, this.MAX_MINUTE());
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public CalendarInterval castDayTimeStringToInterval(String input, byte startField, byte endField) {
        long micros = this.castStringToDTInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(0, (int)(micros / 86400000000L), micros % 86400000000L);
    }

    public CalendarInterval fromDayTimeString(String s) {
        return this.fromDayTimeString(s, DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND());
    }

    public CalendarInterval fromDayTimeString(String input, byte from, byte to) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable)() -> "Interval day-time string must be not null");
        return BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING())) ? this.parseDayTimeLegacy(input, from, to) : this.castDayTimeStringToInterval(input, from, to);
    }

    /*
     * Unable to fully structure code
     */
    public CalendarInterval fromIntervalString(String input) {
        block5: {
            try {
                block6: {
                    block8: {
                        block9: {
                            block7: {
                                if (!input.toLowerCase(Locale.ROOT).trim().startsWith("interval")) break block6;
                                var4_2 = false;
                                var5_3 = null;
                                var6_4 = CatalystSqlParser$.MODULE$.parseExpression(input);
                                if (!(var6_4 instanceof Literal)) break block7;
                                var4_2 = true;
                                var5_3 = (Literal)var6_4;
                                months = var5_3.value();
                                if (!(months instanceof Integer)) break block7;
                                var8_6 = BoxesRunTime.unboxToInt((Object)months);
                                if (!(var5_3.dataType() instanceof YearMonthIntervalType)) break block7;
                                var3_7 = new CalendarInterval(var8_6, 0, 0L);
                                break block8;
                            }
                            if (!var4_2 || !((micros = var5_3.value()) instanceof Long)) break block9;
                            var10_9 = BoxesRunTime.unboxToLong((Object)micros);
                            if (!(var5_3.dataType() instanceof DayTimeIntervalType)) break block9;
                            var3_7 = new CalendarInterval(0, 0, var10_9);
                            break block8;
                        }
                        if (!var4_2) ** GOTO lbl-1000
                        cal = var5_3.value();
                        var13_11 = var5_3.dataType();
                        if (!(cal instanceof CalendarInterval)) ** GOTO lbl-1000
                        var14_12 = (CalendarInterval)cal;
                        if (CalendarIntervalType$.MODULE$.equals(var13_11)) {
                            var3_7 = var14_12;
                        } else lbl-1000:
                        // 3 sources

                        {
                            throw new MatchError((Object)var6_4);
                        }
                    }
                    v0 = var3_7;
                    break block5;
                }
                v0 = this.stringToInterval(UTF8String.fromString((String)input));
            }
            catch (Throwable var15_13) {
                var16_14 = var15_13;
                if (var16_14 != null && !(var17_15 = NonFatal$.MODULE$.unapply(var16_14)).isEmpty()) {
                    e = (Throwable)var17_15.get();
                    throw QueryCompilationErrors$.MODULE$.cannotParseIntervalError(input, e);
                }
                throw var15_13;
            }
        }
        return v0;
    }

    private Regex dayTimePatternLegacy() {
        return dayTimePatternLegacy;
    }

    private String fallbackNotice() {
        return fallbackNotice;
    }

    /*
     * Unable to fully structure code
     */
    private CalendarInterval parseDayTimeLegacy(String input, byte from, byte to) {
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        m = this.dayTimePatternLegacy().pattern().matcher(input);
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTimeLegacy$1(java.lang.String ), ()Ljava/lang/String;)((String)input));
        try {
            if (m.group(1) == null) ** GOTO lbl-1000
            v0 = m.group(1);
            var7_5 = "-";
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                v1 = -1;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            sign = v1;
            days = m.group(2) == null ? 0 : (int)this.toLongWithRange(this.dayStr(), m.group(3), 0L, 0x7FFFFFFFL);
            hours = 0L;
            minutes = 0L;
            seconds = 0L;
            if (m.group(5) != null || from == DayTimeIntervalType$.MODULE$.MINUTE()) {
                hours = this.toLongWithRange(this.hourStr(), m.group(5), 0L, 23L);
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else if (m.group(8) != null) {
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else {
                hours = this.toLongWithRange(this.hourStr(), m.group(6), 0L, 23L);
                minutes = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            }
            secondsFraction = this.parseNanos(m.group(9), seconds < 0L);
            var17_12 = to;
            if (DayTimeIntervalType$.MODULE$.HOUR() == var17_12) {
                minutes = 0L;
                seconds = 0L;
                secondsFraction = 0L;
                var4_13 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == var17_12) {
                seconds = 0L;
                secondsFraction = 0L;
                var4_14 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == var17_12) {
                var4_15 = BoxedUnit.UNIT;
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(0).append("Cannot support (").append(new java.lang.StringBuilder(28).append("interval '").append(input).append("' ").append(DayTimeIntervalType$.MODULE$.fieldToString(from)).append(" to ").append(DayTimeIntervalType$.MODULE$.fieldToString(to)).append(") expression").toString()).toString());
            }
            micros = secondsFraction;
            micros = Math.addExact(micros, Math.multiplyExact(hours, 3600000000L));
            micros = Math.addExact(micros, Math.multiplyExact(minutes, 60000000L));
            micros = Math.addExact(micros, Math.multiplyExact(seconds, 1000000L));
            v2 = new CalendarInterval(0, sign * days, (long)sign * micros);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(40).append("Error parsing interval day-time string: ").append(e.getMessage()).toString(), e);
        }
        return v2;
    }

    private long parseNanos(String nanos, boolean isNegative) {
        long l;
        if (nanos != null) {
            int maxNanosLen = 9;
            String alignedStr = nanos.length() < maxNanosLen ? new java.lang.StringBuilder(9).append(nanos).append("000000000").toString().substring(0, maxNanosLen) : nanos;
            long nanoSecond = this.toLongWithRange(this.nanosStr(), alignedStr, 0L, 999999999L);
            long microSecond = nanoSecond / 1000L;
            l = isNegative ? -microSecond : microSecond;
        } else {
            l = 0L;
        }
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long parseSecondNano(String secondNano) {
        long seconds;
        Object object;
        Object object2;
        String[] stringArray = secondNano.split("\\.");
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1) == 0) {
            String secondsStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
            return this.parseSeconds$1(secondsStr);
        }
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String nanosStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            if ("".equals(string)) {
                return this.parseNanos(nanosStr, false);
            }
        }
        if (stringArray == null) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        Object object3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object3)) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3)) == null) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 2) != 0) throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
        String secondsStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 0);
        String nanosStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 1);
        return Math.addExact(seconds, this.parseNanos(nanosStr, (seconds = this.parseSeconds$1(secondsStr)) < 0L));
    }

    public long getDuration(CalendarInterval interval, TimeUnit targetUnit, int daysPerMonth) {
        long monthsDuration = Math.multiplyExact((long)daysPerMonth * 86400000000L, (long)interval.months);
        long daysDuration = Math.multiplyExact(86400000000L, (long)interval.days);
        long result = Math.addExact(interval.microseconds, Math.addExact(daysDuration, monthsDuration));
        return targetUnit.convert(result, TimeUnit.MICROSECONDS);
    }

    public int getDuration$default$3() {
        return 31;
    }

    public boolean isNegative(CalendarInterval interval, int daysPerMonth) {
        return this.getDuration(interval, TimeUnit.MICROSECONDS, daysPerMonth) < 0L;
    }

    public int isNegative$default$2() {
        return 31;
    }

    private CalendarInterval fromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedMonths = MathUtils$.MODULE$.toIntExact((long)monthsWithFraction);
        int truncatedDays = MathUtils$.MODULE$.toIntExact((long)daysWithFraction);
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval(truncatedMonths, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    private CalendarInterval safeFromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedDays = (int)daysWithFraction;
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval((int)monthsWithFraction, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    public CalendarInterval negateExact(CalendarInterval interval) {
        int months = MathUtils$.MODULE$.negateExact(interval.months);
        int days = MathUtils$.MODULE$.negateExact(interval.days);
        long microseconds = MathUtils$.MODULE$.negateExact(interval.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval negate(CalendarInterval interval) {
        return new CalendarInterval(-interval.months, -interval.days, -interval.microseconds);
    }

    public CalendarInterval addExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.addExact(left.months, right.months);
        int days = MathUtils$.MODULE$.addExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.addExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval add(CalendarInterval left, CalendarInterval right) {
        int months = left.months + right.months;
        int days = left.days + right.days;
        long microseconds = left.microseconds + right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtractExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.subtractExact(left.months, right.months);
        int days = MathUtils$.MODULE$.subtractExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.subtractExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval left, CalendarInterval right) {
        int months = left.months - right.months;
        int days = left.days - right.days;
        long microseconds = left.microseconds - right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval multiply(CalendarInterval interval, double num) {
        return this.safeFromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval multiplyExact(CalendarInterval interval, double num) {
        return this.fromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval divide(CalendarInterval interval, double num) {
        if (num == 0.0) {
            return null;
        }
        return this.safeFromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    public CalendarInterval divideExact(CalendarInterval interval, double num) {
        if (num == 0.0) {
            throw QueryExecutionErrors$.MODULE$.divideByZeroError("");
        }
        return this.fromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    private final UTF8String intervalStr() {
        return intervalStr;
    }

    private UTF8String unitToUtf8(String unit) {
        return UTF8String.fromString((String)unit);
    }

    private final UTF8String yearStr() {
        return yearStr;
    }

    private final UTF8String monthStr() {
        return monthStr;
    }

    private final UTF8String weekStr() {
        return weekStr;
    }

    private final UTF8String dayStr() {
        return dayStr;
    }

    private final UTF8String hourStr() {
        return hourStr;
    }

    private final UTF8String minuteStr() {
        return minuteStr;
    }

    private final UTF8String secondStr() {
        return secondStr;
    }

    private final UTF8String millisStr() {
        return millisStr;
    }

    private final UTF8String microsStr() {
        return microsStr;
    }

    private final UTF8String nanosStr() {
        return nanosStr;
    }

    public CalendarInterval safeStringToInterval(UTF8String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval stringToInterval(UTF8String input) {
        boolean bl;
        if (input == null) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be null", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        UTF8String s = input.trimAll().toLowerCase();
        byte[] bytes = s.getBytes();
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        ObjectRef state = ObjectRef.create((Object)IntervalUtils$ParseState$.MODULE$.PREFIX());
        IntRef i = IntRef.create((int)0);
        long currentValue = 0L;
        boolean isNegative = false;
        int months = 0;
        int days = 0;
        long microseconds = 0L;
        int fractionScale = 0;
        int initialFractionScale = (int)100000000L;
        int fraction = 0;
        boolean pointPrefixed = false;
        while (i.elem < bytes.length) {
            BoxedUnit boxedUnit;
            byte b = bytes[i.elem];
            Enumeration.Value value = (Enumeration.Value)state.elem;
            Enumeration.Value value2 = IntervalUtils$ParseState$.MODULE$.PREFIX();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (s.startsWith(this.intervalStr())) {
                    if (s.numBytes() == this.intervalStr().numBytes()) {
                        throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    if (!Character.isWhitespace(bytes[i.elem + this.intervalStr().numBytes()])) {
                        throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(24).append("invalid interval prefix ").append(IntervalUtils$.currentWord$1(s, i)).toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    i.elem += this.intervalStr().numBytes() + 1;
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value4 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.SIGN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value6 = IntervalUtils$ParseState$.MODULE$.SIGN();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                BoxedUnit boxedUnit2;
                currentValue = 0L;
                fraction = 0;
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                fractionScale = -1;
                pointPrefixed = false;
                byte by = b;
                if (45 == by) {
                    isNegative = true;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (43 == by) {
                    isNegative = false;
                    ++i.elem;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (48 <= b && b <= 57) {
                    isNegative = false;
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(22).append("unrecognized number '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    isNegative = false;
                    fractionScale = initialFractionScale;
                    pointPrefixed = true;
                    ++i.elem;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value8 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.VALUE(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value10 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                BoxedUnit boxedUnit3;
                byte by = b;
                if (48 <= b && b <= 57) {
                    BoxedUnit boxedUnit4;
                    try {
                        currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    catch (ArithmeticException e) {
                        throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                    }
                    boxedUnit3 = boxedUnit4;
                } else if (Character.isWhitespace(b)) {
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fractionScale = initialFractionScale;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value12 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                if (48 <= b && b <= 57 && fractionScale > 0) {
                    fraction += (b - 48) * fractionScale;
                    fractionScale /= 10;
                } else {
                    if (!Character.isWhitespace(b) || pointPrefixed && fractionScale >= initialFractionScale) throw 48 <= b && b <= 57 ? IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(57).append("interval can only support nanosecond precision, '").append(IntervalUtils$.currentWord$1(s, i)).append("' is out").toString()).append(" of range").toString(), IntervalUtils$.throwIAE$default$2$1(), input) : IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fraction /= (int)1000L;
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value14 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN(), i, state);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value16 = IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN();
            Enumeration.Value value17 = value;
            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                if (b != 115 && fractionScale >= 0) {
                    throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(30).append("'").append(IntervalUtils$.currentWord$1(s, i)).append("' cannot have fractional part").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                }
                if (isNegative) {
                    currentValue = -currentValue;
                    fraction = -fraction;
                }
                try {
                    byte by = b;
                    switch (by) {
                        case 121: {
                            if (!s.matchAt(this.yearStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long monthsInYears = Math.multiplyExact(12L, currentValue);
                            months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                            i.elem += this.yearStr().numBytes();
                            break;
                        }
                        case 119: {
                            if (!s.matchAt(this.weekStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long daysInWeeks = Math.multiplyExact(7L, currentValue);
                            days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                            i.elem += this.weekStr().numBytes();
                            break;
                        }
                        case 100: {
                            if (!s.matchAt(this.dayStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            days = Math.addExact(days, Math.toIntExact(currentValue));
                            i.elem += this.dayStr().numBytes();
                            break;
                        }
                        case 104: {
                            if (!s.matchAt(this.hourStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long hoursUs = Math.multiplyExact(currentValue, 3600000000L);
                            microseconds = Math.addExact(microseconds, hoursUs);
                            i.elem += this.hourStr().numBytes();
                            break;
                        }
                        case 115: {
                            if (!s.matchAt(this.secondStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long secondsUs = Math.multiplyExact(currentValue, 1000000L);
                            microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                            i.elem += this.secondStr().numBytes();
                            break;
                        }
                        case 109: {
                            if (s.matchAt(this.monthStr(), i.elem)) {
                                months = Math.addExact(months, Math.toIntExact(currentValue));
                                i.elem += this.monthStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.minuteStr(), i.elem)) {
                                long minutesUs = Math.multiplyExact(currentValue, 60000000L);
                                microseconds = Math.addExact(microseconds, minutesUs);
                                i.elem += this.minuteStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.millisStr(), i.elem)) {
                                long millisUs = DateTimeUtils$.MODULE$.millisToMicros(currentValue);
                                microseconds = Math.addExact(microseconds, millisUs);
                                i.elem += this.millisStr().numBytes();
                                break;
                            }
                            if (!s.matchAt(this.microsStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().numBytes();
                            break;
                        }
                        default: {
                            throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        }
                    }
                }
                catch (ArithmeticException e) {
                    throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value18 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                byte by = b;
                switch (by) {
                    case 115: {
                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_END();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                        break;
                    }
                }
                ++i.elem;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Enumeration.Value value20 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value21 = value;
            if (value20 == null) {
                if (value21 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value20.equals(value21)) throw new MatchError((Object)value);
            if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            ++i.elem;
            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = (Enumeration.Value)state.elem;
        Enumeration.Value value22 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            bl = true;
        } else {
            Enumeration.Value value24 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value25 = value;
            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                bl = true;
            } else {
                Enumeration.Value value26 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                Enumeration.Value value27 = value;
                bl = !(value26 != null ? !value26.equals(value27) : value27 != null);
            }
        }
        if (!bl) {
            boolean bl2;
            Enumeration.Value value28 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value29 = value;
            if (value28 == null) {
                if (value29 == null) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            } else if (value28.equals(value29)) {
                throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            }
            Enumeration.Value value30 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value31 = value;
            if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value32 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                Enumeration.Value value33 = value;
                bl2 = !(value32 != null ? !value32.equals(value33) : value33 != null);
            }
            if (!bl2) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(29).append("unknown error when parsing '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(39).append("expect a unit name after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
        }
        CalendarInterval calendarInterval = new CalendarInterval(months, days, microseconds);
        return calendarInterval;
    }

    public CalendarInterval makeInterval(int years, int months, int weeks, int days, int hours, int mins, Decimal secs) {
        int totalMonths = Math.addExact(months, Math.multiplyExact(years, 12));
        int totalDays = Math.addExact(days, Math.multiplyExact(weeks, 7));
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return new CalendarInterval(totalMonths, totalDays, micros);
    }

    public long makeDayTimeInterval(int days, int hours, int mins, Decimal secs) {
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)days, 86400000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return micros;
    }

    private final long minDurationSeconds() {
        return minDurationSeconds;
    }

    public long durationToMicros(Duration duration) {
        return this.durationToMicros(duration, DayTimeIntervalType$.MODULE$.SECOND());
    }

    public long durationToMicros(Duration duration, byte endField) {
        long l;
        long l2;
        long seconds = duration.getSeconds();
        if (seconds == this.minDurationSeconds()) {
            long microsInSeconds = (this.minDurationSeconds() + 1L) * 1000000L;
            int nanoAdjustment = duration.getNano();
            Predef$.MODULE$.assert(0 <= nanoAdjustment && (long)nanoAdjustment < 1000000000L, (Function0 & Serializable)() -> "Duration.getNano() must return the adjustment to the seconds field in the range from 0 to 999999999 nanoseconds, inclusive.");
            l2 = Math.addExact(microsInSeconds, ((long)nanoAdjustment - 1000000000L) / 1000L);
        } else {
            long microsInSeconds = Math.multiplyExact(seconds, 1000000L);
            l2 = Math.addExact(microsInSeconds, (long)duration.getNano() / 1000L);
        }
        long micros = l2;
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            l = micros - micros % 86400000000L;
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            l = micros - micros % 3600000000L;
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            l = micros - micros % 60000000L;
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            l = micros;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return l;
    }

    public Duration microsToDuration(long micros) {
        return Duration.of(micros, ChronoUnit.MICROS);
    }

    public int periodToMonths(Period period) {
        return this.periodToMonths(period, YearMonthIntervalType$.MODULE$.MONTH());
    }

    public int periodToMonths(Period period, byte endField) {
        int monthsInYears = Math.multiplyExact(period.getYears(), 12);
        int months = Math.addExact(monthsInYears, period.getMonths());
        return endField == YearMonthIntervalType$.MODULE$.YEAR() ? months - months % 12 : months;
    }

    public Period monthsToPeriod(int months) {
        return Period.ofMonths(months).normalized();
    }

    public String toYearMonthIntervalString(int months, Enumeration.Value style, byte startField, byte endField) {
        String string;
        String sign = "";
        long absMonths = months;
        if (months < 0) {
            sign = "-";
            absMonths = -absMonths;
        }
        String year = new java.lang.StringBuilder(0).append(sign).append(absMonths / 12L).toString();
        String yearAndMonth = new java.lang.StringBuilder(1).append(year).append("-").append(absMonths % 12L).toString();
        Enumeration.Value value = style;
        Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StringBuilder stringBuilder;
            StringBuilder formatBuilder = new StringBuilder("INTERVAL '");
            if (startField == endField) {
                StringBuilder stringBuilder2;
                byte by = startField;
                if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
                    stringBuilder2 = formatBuilder.append(new java.lang.StringBuilder(6).append(year).append("' YEAR").toString());
                } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
                    stringBuilder2 = formatBuilder.append(new java.lang.StringBuilder(7).append(months).append("' MONTH").toString());
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
                stringBuilder = stringBuilder2;
            } else {
                stringBuilder = formatBuilder.append(new java.lang.StringBuilder(15).append(yearAndMonth).append("' YEAR TO MONTH").toString());
            }
            string = formatBuilder.toString();
        } else {
            Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = String.valueOf(yearAndMonth);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return string;
    }

    public String toDayTimeIntervalString(long micros, Enumeration.Value style, byte startField, byte endField) {
        String string;
        String sign = "";
        long rest = micros;
        String from = DayTimeIntervalType$.MODULE$.fieldToString(startField).toUpperCase();
        String to = DayTimeIntervalType$.MODULE$.fieldToString(endField).toUpperCase();
        String prefix = "INTERVAL '";
        String postfix = new java.lang.StringBuilder(2).append("' ").append((Object)(startField == endField ? from : new java.lang.StringBuilder(4).append(from).append(" TO ").append(to).toString())).toString();
        if (micros < 0L) {
            if (micros == Long.MIN_VALUE) {
                String string2;
                String baseStr = "-106751991 04:00:54.775808000";
                Enumeration.Value value = style;
                Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    String string3;
                    String string4;
                    byte by = startField;
                    if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_DAY()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_HOUR()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_MINUTE()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                        string4 = new java.lang.StringBuilder(8).append("-").append(this.MAX_SECOND()).append(".775808").toString();
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                    }
                    String firstStr = string4;
                    if (startField == endField) {
                        string3 = "";
                    } else {
                        int n;
                        int n2;
                        byte by2 = startField;
                        if (DayTimeIntervalType$.MODULE$.DAY() == by2) {
                            n2 = 10;
                        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by2) {
                            n2 = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by2) {
                            n2 = 16;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
                        }
                        int substrStart = n2;
                        byte by3 = endField;
                        if (DayTimeIntervalType$.MODULE$.HOUR() == by3) {
                            n = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by3) {
                            n = 16;
                        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by3) {
                            n = 26;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by3));
                        }
                        int substrEnd = n;
                        string3 = baseStr.substring(substrStart, substrEnd);
                    }
                    String followingStr = string3;
                    string2 = new java.lang.StringBuilder(0).append(prefix).append(firstStr).append(followingStr).append(postfix).toString();
                } else {
                    Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string2 = baseStr;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                String minIntervalString = string2;
                return minIntervalString;
            }
            sign = "-";
            rest = -rest;
        }
        Enumeration.Value value = style;
        Enumeration.Value value6 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            StringBuilder formatBuilder = new StringBuilder(sign);
            ArrayBuffer formatArgs = new ArrayBuffer();
            byte by = startField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                formatBuilder.append(rest / 86400000000L);
                rest %= 86400000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 3600000000L)));
                rest %= 3600000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 60000000L)));
                rest %= 60000000L;
                boxedUnit2 = BoxedUnit.UNIT;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                String leadZero = rest < 10000000L ? "0" : "";
                boxedUnit2 = formatBuilder.append(new java.lang.StringBuilder(0).append(String.valueOf(leadZero)).append(String.valueOf(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString())).toString());
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            if (startField < DayTimeIntervalType$.MODULE$.HOUR() && DayTimeIntervalType$.MODULE$.HOUR() <= endField) {
                formatBuilder.append(" %02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 3600000000L)));
                rest %= 3600000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.MINUTE() && DayTimeIntervalType$.MODULE$.MINUTE() <= endField) {
                formatBuilder.append(":%02d");
                formatArgs.append((Object)BoxesRunTime.boxToLong((long)(rest / 60000000L)));
                rest %= 60000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.SECOND() && DayTimeIntervalType$.MODULE$.SECOND() <= endField) {
                String leadZero = rest < 10000000L ? "0" : "";
                boxedUnit = formatBuilder.append(new java.lang.StringBuilder(1).append(":").append(leadZero).append(BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString()).toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = new java.lang.StringBuilder(0).append(prefix).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(formatBuilder.toString()), formatArgs.toSeq())).append(postfix).toString();
        } else {
            Enumeration.Value value8 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                long secondsWithFraction = rest % 60000000L;
                long minutes = (rest /= 60000000L) % 60L;
                long hours = (rest /= 60L) % 24L;
                long days = rest / 24L;
                long seconds = secondsWithFraction / 1000000L;
                long nanos = secondsWithFraction % 1000000L * 1000L;
                String arg$macro$1 = sign;
                Long arg$macro$2 = BoxesRunTime.boxToLong((long)days);
                long arg$macro$3 = hours;
                long arg$macro$4 = minutes;
                long arg$macro$5 = seconds;
                long arg$macro$6 = nanos;
                string = StringOps$.MODULE$.format$extension("%s%s %02d:%02d:%02d.%09d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToLong((long)arg$macro$3), BoxesRunTime.boxToLong((long)arg$macro$4), BoxesRunTime.boxToLong((long)arg$macro$5), BoxesRunTime.boxToLong((long)arg$macro$6)}));
            } else {
                throw new MatchError((Object)value);
            }
        }
        String intervalString = string;
        return intervalString;
    }

    public int intToYearMonthInterval(int v, byte endField) {
        int n;
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            int n2;
            try {
                n2 = Math.multiplyExact(v, 12);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), IntegerType$.MODULE$, YearMonthIntervalType$.MODULE$.apply(endField));
            }
            n = n2;
        } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            n = v;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return n;
    }

    public int longToYearMonthInterval(long v, byte endField) {
        int vInt = (int)v;
        if (v != (long)vInt) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), LongType$.MODULE$, YearMonthIntervalType$.MODULE$.apply(endField));
        }
        return this.intToYearMonthInterval(vInt, endField);
    }

    public int yearMonthIntervalToInt(int v, byte startField, byte endField) {
        int n;
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            n = v / 12;
        } else if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            n = v;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return n;
    }

    public short yearMonthIntervalToShort(int v, byte startField, byte endField) {
        short vShort;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vShort = (short)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), new YearMonthIntervalType(startField, endField), ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte yearMonthIntervalToByte(int v, byte startField, byte endField) {
        byte vByte;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vByte = (byte)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), new YearMonthIntervalType(startField, endField), ByteType$.MODULE$);
        }
        return vByte;
    }

    public long intToDayTimeInterval(int v, byte endField) {
        long l;
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            long l2;
            try {
                l2 = Math.multiplyExact((long)v, 86400000000L);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), IntegerType$.MODULE$, DayTimeIntervalType$.MODULE$.apply(endField));
            }
            l = l2;
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            l = (long)v * 3600000000L;
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            l = (long)v * 60000000L;
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            l = (long)v * 1000000L;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return l;
    }

    public long longToDayTimeInterval(long v, byte endField) {
        long l;
        try {
            long l2;
            byte by = endField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                l2 = Math.multiplyExact(v, 86400000000L);
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                l2 = Math.multiplyExact(v, 3600000000L);
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                l2 = Math.multiplyExact(v, 60000000L);
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                l2 = Math.multiplyExact(v, 1000000L);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            l = l2;
        }
        catch (ArithmeticException arithmeticException) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), LongType$.MODULE$, DayTimeIntervalType$.MODULE$.apply(endField));
        }
        return l;
    }

    public long dayTimeIntervalToLong(long v, byte startField, byte endField) {
        long l;
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            l = v / 86400000000L;
        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            l = v / 3600000000L;
        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            l = v / 60000000L;
        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            l = v / 1000000L;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
        }
        return l;
    }

    public int dayTimeIntervalToInt(long v, byte startField, byte endField) {
        int vInt;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vInt = (int)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), IntegerType$.MODULE$);
        }
        return vInt;
    }

    public short dayTimeIntervalToShort(long v, byte startField, byte endField) {
        short vShort;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vShort = (short)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte dayTimeIntervalToByte(long v, byte startField, byte endField) {
        byte vByte;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vByte = (byte)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), ByteType$.MODULE$);
        }
        return vByte;
    }

    private static final boolean checkTargetType$1(byte targetStartField, byte targetEndField, byte startField$1, byte endField$1) {
        return startField$1 == targetStartField && endField$1 == targetEndField;
    }

    private static final String secondAndMicro$1(String second, String micro) {
        return micro != null ? new java.lang.StringBuilder(0).append(second).append(micro).toString() : second;
    }

    private static final boolean checkTargetType$2(byte targetStartField, byte targetEndField, byte startField$2, byte endField$2) {
        return startField$2 == targetStartField && endField$2 == targetEndField;
    }

    public static final /* synthetic */ String $anonfun$parseDayTimeLegacy$1(String input$3) {
        return new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(61).append("Interval string must match day-time format of 'd h:m:s.n': ").append(input$3).append(", ").toString()).append(String.valueOf(MODULE$.fallbackNotice())).toString();
    }

    private final long parseSeconds$1(String secondsStr) {
        return this.toLongWithRange(this.secondStr(), secondsStr, this.MIN_SECOND(), this.MAX_SECOND()) * 1000000L;
    }

    private static final Nothing$ throwIAE$1(String msg, Exception e, UTF8String input$4) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(30).append("Error parsing '").append(input$4).append("' to interval, ").append(msg).toString(), e);
    }

    private static final Exception throwIAE$default$2$1() {
        return null;
    }

    private static final void trimToNextState$1(byte b, Enumeration.Value next, IntRef i$1, ObjectRef state$1) {
        if (Character.isWhitespace(b)) {
            ++i$1.elem;
        } else {
            state$1.elem = next;
        }
    }

    private static final String currentWord$1(UTF8String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.toString().split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.numBytes()).toString().split(sep).length;
        return strings[strings.length - lenRight];
    }

    private IntervalUtils$() {
    }
}

