/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToNumber$;
import org.apache.spark.sql.catalyst.expressions.ToNumberBase;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format 'fmt'.\n       Throws an exception if the conversion fails. The format can consist of the following\n       characters, case insensitive:\n         '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n           string matches a sequence of digits in the input string. If the 0/9 sequence starts with\n           0 and is before the decimal point, it can only match a digit sequence of the same size.\n           Otherwise, if the sequence starts with 9 or is after the decimal poin, it can match a\n           digit sequence that has the same or smaller size.\n         '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n         ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n           one or more 0 or 9 to the left of the rightmost grouping separator. 'expr' must match the\n           grouping separator relevant for the size of the number.\n         '$': Specifies the location of the $ currency sign. This character may only be specified\n           once.\n         'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n           the beginning or end of the format string). Note that 'S' allows '-' but 'MI' does not.\n         'PR': Only allowed at the end of the format string; specifies that 'expr' indicates a\n           negative number with wrapping angled brackets.\n           ('<1>').\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\r\u001b\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015)\u0006\u0001\"\u0015W\u0011\u001dY\u0006!!A\u0005\u0002qCqa\u0018\u0001\u0012\u0002\u0013\u0005\u0001\rC\u0004l\u0001E\u0005I\u0011\u00011\t\u000f1\u0004\u0011\u0011!C![\"9Q\u000fAA\u0001\n\u00031\bb\u0002>\u0001\u0003\u0003%\ta\u001f\u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005\u0002\"CA\u0013\u0001\u0005\u0005I\u0011IA\u0014\u000f%\tYEGA\u0001\u0012\u0003\tiE\u0002\u0005\u001a5\u0005\u0005\t\u0012AA(\u0011\u001915\u0003\"\u0001\u0002h!I\u0011\u0011N\n\u0002\u0002\u0013\u0015\u00131\u000e\u0005\n\u0003[\u001a\u0012\u0011!CA\u0003_B\u0011\"!\u001e\u0014\u0003\u0003%\t)a\u001e\t\u0013\u0005%5#!A\u0005\n\u0005-%\u0001\u0003+p\u001dVl'-\u001a:\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0015-eA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\r)>tU/\u001c2fe\n\u000b7/\u001a\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\b!J|G-^2u!\t\u00194H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qGJ\u0001\u0007yI|w\u000e\u001e \n\u0003=J!A\u000f\u0018\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003u9\nA\u0001\\3giV\t\u0001\t\u0005\u0002*\u0003&\u0011!I\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\u0015\u0001\u0011\u0015qT\u00011\u0001A\u0011\u0015!U\u00011\u0001A\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u001bB\u0011aJ\u0015\b\u0003\u001fB\u0003\"!\u000e\u0018\n\u0005Es\u0013A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u0018\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001%X3\")\u0001l\u0002a\u0001\u0001\u00069a.Z<MK\u001a$\b\"\u0002.\b\u0001\u0004\u0001\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u0011vs\u0006b\u0002 \t!\u0003\u0005\r\u0001\u0011\u0005\b\t\"\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0019\u0016\u0003\u0001\n\\\u0013a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!t\u0013AC1o]>$\u0018\r^5p]&\u0011!.\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u00039\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t1\fgn\u001a\u0006\u0002g\u0006!!.\u0019<b\u0013\t\u0019\u0006/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001x!\ti\u00030\u0003\u0002z]\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011Ap \t\u0003[uL!A \u0018\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u00025\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0001\t\u0006\u0003\u0013\ty\u0001`\u0007\u0003\u0003\u0017Q1!!\u0004/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\tYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003;\u00012!LA\r\u0013\r\tYB\f\u0002\b\u0005>|G.Z1o\u0011!\t\taDA\u0001\u0002\u0004a\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2A\\A\u0012\u0011!\t\t\u0001EA\u0001\u0002\u00049\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\u0005%\u0002\u0002CA\u0001#\u0005\u0005\t\u0019\u0001?)'\u0001\ti#a\r\u00026\u0005e\u00121HA \u0003\u0003\n)%a\u0012\u0011\u0007%\ny#C\u0002\u00022i\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00028\u0005YYP\u0003\u0011!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u00043\u000f\u001e:j]\u001e\u0004s%\u001a=qe\u001e\u0002Co\u001c\u0011bA9,XNY3sA\t\f7/\u001a3!_:\u0004C\u000f[3!gR\u0014\u0018N\\4!M>\u0014X.\u0019;!O\u0019lGo\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!)\"\u0014xn^:!C:\u0004S\r_2faRLwN\u001c\u0011jM\u0002\"\b.\u001a\u0011d_:4XM]:j_:\u0004c-Y5mg:\u0002C\u000b[3!M>\u0014X.\u0019;!G\u0006t\u0007eY8og&\u001cH\u000fI8gAQDW\r\t4pY2|w/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!A\rD\u0017M]1di\u0016\u00148\u000f\f\u0011dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wKjR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u00141O\u0001z'\u000fI\u0014:Oi\u00023\u000b]3dS\u001aLWm\u001d\u0011b]\u0002*\u0007\u0010]3di\u0016$\u0007\u0005Z5hSR\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u0011b]\u0012\u0004\u0013H\f\u0011BAM,\u0017/^3oG\u0016\u0004sN\u001a\u00111A=\u0014\b%\u000f\u0011j]\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000f\u001e:j]\u001e\u0004S.\u0019;dQ\u0016\u001c\b%\u0019\u0011tKF,XM\\2fA=4\u0007\u0005Z5hSR\u001c\b%\u001b8!i\",\u0007%\u001b8qkR\u00043\u000f\u001e:j]\u001et\u0003%\u00134!i\",\u0007\u0005M\u0018:AM,\u0017/^3oG\u0016\u00043\u000f^1siN\u0004s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!C:$\u0007%[:!E\u00164wN]3!i\",\u0007\u0005Z3dS6\fG\u000e\t9pS:$H\u0006I5uA\r\fg\u000eI8oYf\u0004S.\u0019;dQ\u0002\n\u0007\u0005Z5hSR\u00043/Z9vK:\u001cW\rI8gAQDW\rI:b[\u0016\u00043/\u001b>f])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Pi\",'o^5tK2\u0002\u0013N\u001a\u0011uQ\u0016\u00043/Z9vK:\u001cW\rI:uCJ$8\u000fI<ji\"\u0004\u0013\bI8sA%\u001c\b%\u00194uKJ\u0004C\u000f[3!I\u0016\u001c\u0017.\\1mAA|\u0017N\u001c\u0017!SR\u00043-\u00198![\u0006$8\r\u001b\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t3jO&$\be]3rk\u0016t7-\u001a\u0011uQ\u0006$\b\u0005[1tAQDW\rI:b[\u0016\u0004sN\u001d\u0011t[\u0006dG.\u001a:!g&TXM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u001drs\u0005I8sA\u001d\"uE\u000f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011q_NLG/[8oA=4\u0007\u0005\u001e5fA\u0011,7-[7bY\u0002\u0002x.\u001b8uA!z\u0007\u000f^5p]\u0006dG\u0006I8oYf\u0004\u0013\r\u001c7po\u0016$\u0007e\u001c8dK&r#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011(Y\u001d\u0002sN\u001d\u0011(\u000f\u001eR\u0004e\u00159fG&4\u0017.Z:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011he>,\b/\u001b8hA!\"\bn\\;tC:$7/\u000b\u0011tKB\f'/\u0019;pe\u0002BC&\u000b\u0018!)\",'/\u001a\u0011nkN$\bEY3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u001c8fA=\u0014\b%\\8sK\u0002\u0002\u0004e\u001c:!s\u0001\"x\u000e\t;iK\u0002bWM\u001a;!_\u001a\u0004C\u000f[3!e&<\u0007\u000e^7pgR\u0004sM]8va&tw\rI:fa\u0006\u0014\u0018\r^8s]\u0001:S\r\u001f9sO\u0001jWo\u001d;![\u0006$8\r\u001b\u0011uQ\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!OJ|W\u000f]5oO\u0002\u001aX\r]1sCR|'\u000f\t:fY\u00164\u0018M\u001c;!M>\u0014\b\u0005\u001e5fAML'0\u001a\u0011pM\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001:Ce\n\u001e!'B,7-\u001b4jKN\u0004C\u000f[3!Y>\u001c\u0017\r^5p]\u0002zg\r\t;iK\u0002\"\u0003eY;se\u0016t7-\u001f\u0011tS\u001etg\u0006\t+iSN\u00043\r[1sC\u000e$XM\u001d\u0011nCf\u0004sN\u001c7zA\t,\u0007e\u001d9fG&4\u0017.\u001a3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003e\u001c8dK:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0014TO\u0001z'\u000fI\u0014N\u0013\u001eR\u0004e\u00159fG&4\u0017.Z:!i\",\u0007\u0005]8tSRLwN\u001c\u0011pM\u0002\n\u0007eJ\u0017(A=\u0014\beJ\u0016(AMLwM\u001c\u0011)_B$\u0018n\u001c8bY2\u0002sN\u001c7zA\u0005dGn\\<fI\u0002zgnY3!CRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007EY3hS:t\u0017N\\4!_J\u0004SM\u001c3!_\u001a\u0004C\u000f[3!M>\u0014X.\u0019;!gR\u0014\u0018N\\4*]\u0001ru\u000e^3!i\"\fG\u000fI\u0014TO\u0001\nG\u000e\\8xg\u0002:Sf\n\u0011ckR\u0004s%T%(A\u0011|Wm\u001d\u0011o_Rt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011(!J;#\bI(oYf\u0004\u0013\r\u001c7po\u0016$\u0007%\u0019;!i\",\u0007%\u001a8eA=4\u0007\u0005\u001e5fA\u0019|'/\\1uAM$(/\u001b8hw\u0001\u001a\b/Z2jM&,7\u000f\t;iCR\u0004s%\u001a=qe\u001e\u0002\u0013N\u001c3jG\u0006$Xm\u001d\u0011b\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t8fO\u0006$\u0018N^3!]Vl'-\u001a:!o&$\b\u000eI<sCB\u0004\u0018N\\4!C:<G.\u001a3!EJ\f7m[3ug:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!Q\u001db\u0014GP\u0014*])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti$\u0001B,\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":C'\u000e\u001b(Y\u0001:\u0013(O\u001d(SmR\u0001\u0005\t\u0011!A\u0001\u0002C'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007\u000e\u00181a\u001db\u0003e\n\u00191a9\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ*DG\f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQ:C\u0006I\u0014:s1J\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0007N\u001b5\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":Ce\u000e\u001d/cI:C\u0006I\u0014%ser\u0013(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001:\u0004HL\u00193\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013G\r\u00175kQr\u0003(L\u0014-A\u001dJ\u0014\bL\u001d:s9J4kJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A5\n$\u0007N\u001b5]aR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u0007\nQa\r\u00184]A\nQa\u001a:pkB\f#!!\u0013\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0011Q{g*^7cKJ\u0004\"!K\n\u0014\u000bM\t\t&!\u0018\u0011\u000f\u0005M\u0013\u0011\f!A\u00116\u0011\u0011Q\u000b\u0006\u0004\u0003/r\u0013a\u0002:v]RLW.Z\u0005\u0005\u00037\n)FA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0012\u0018AA5p\u0013\ra\u0014\u0011\r\u000b\u0003\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002]\u0006)\u0011\r\u001d9msR)\u0001*!\u001d\u0002t!)aH\u0006a\u0001\u0001\")AI\u0006a\u0001\u0001\u00069QO\\1qa2LH\u0003BA=\u0003\u000b\u0003R!LA>\u0003\u007fJ1!! /\u0005\u0019y\u0005\u000f^5p]B)Q&!!A\u0001&\u0019\u00111\u0011\u0018\u0003\rQ+\b\u000f\\33\u0011!\t9iFA\u0001\u0002\u0004A\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0012\t\u0004_\u0006=\u0015bAAIa\n1qJ\u00196fGR\u0004")
public class ToNumber
extends ToNumberBase {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToNumber x$0) {
        return ToNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ToNumber> tupled() {
        return ToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToNumber>> curried() {
        return ToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String prettyName() {
        return "to_number";
    }

    @Override
    public ToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ToNumber copy(Expression left, Expression right) {
        return new ToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToNumber;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToNumber toNumber = (ToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = toNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toNumber.canEqual(this)) return false;
        return true;
    }

    public ToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super(left, right, true);
    }
}

