/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array, element) - Remove all elements that equal to element from array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null, 3), 3);\n       [1,2,null]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tUb\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015!\b\u0001\"\u0003^\u0011!)\b\u0001#b\u0001\n\u00131\bbBA\u0002\u0001\u0011\u0005\u0013Q\u0001\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002T\u0001!\t&!\u0016\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0004\"CA4\u0001E\u0005I\u0011AA5\u0011%\ty\bAI\u0001\n\u0003\tI\u0007C\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;\u0003\u0011\u0011!C\u0001\u0003?C\u0011\"!*\u0001\u0003\u0003%\t%a*\t\u0013\u0005U\u0006!!A\u0005\u0002\u0005]\u0006\"CAa\u0001\u0005\u0005I\u0011IAb\u0011%\t9\rAA\u0001\n\u0003\nImB\u0005\u0002n\n\n\t\u0011#\u0001\u0002p\u001aA\u0011EIA\u0001\u0012\u0003\t\t\u0010\u0003\u0004X7\u0011\u0005!\u0011\u0002\u0005\n\u0005\u0017Y\u0012\u0011!C#\u0005\u001bA\u0011Ba\u0004\u001c\u0003\u0003%\tI!\u0005\t\u0013\t]1$!A\u0005\u0002\ne\u0001\"\u0003B\u00167\u0005\u0005I\u0011\u0002B\u0017\u0005-\t%O]1z%\u0016lwN^3\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0011\r\fG/\u00197zgRT!a\n\u0015\u0002\u0007M\fHN\u0003\u0002*U\u0005)1\u000f]1sW*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00195oy\"\u0005CA\u00193\u001b\u0005\u0011\u0013BA\u001a#\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00022k%\u0011aG\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001h\u000f\b\u0003ceJ!A\u000f\u0012\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tQ$\u0005\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0015ceB\u0001$L\u001d\t9%*D\u0001I\u0015\tIe&\u0001\u0004=e>|GOP\u0005\u0002\u0003&\u0011!\bQ\u0005\u0003\u001b:\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u000f!\u0002\t1,g\r^\u000b\u0002#B\u0011\u0011GU\u0005\u0003'\n\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2!\u0017.\\!\t\t\u0004\u0001C\u0003P\u000b\u0001\u0007\u0011\u000bC\u0003V\u000b\u0001\u0007\u0011+\u0001\u0005eCR\fG+\u001f9f+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1'\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002MB\u0019QiZ5\n\u0005!t%aA*fcB\u0011qL[\u0005\u0003W\u0002\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0013\u0002\u0011\u0005t\u0017\r\\=tSNL!a\u001d9\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f1\"\u001a7f[\u0016tG\u000fV=qK\u0006AqN\u001d3fe&tw-F\u0001x!\r)\u0005P_\u0005\u0003s:\u0013\u0001b\u0014:eKJLgn\u001a\t\u0003\u007fmL!\u0001 !\u0003\u0007\u0005s\u0017\u0010\u000b\u0002\u000b}B\u0011qh`\u0005\u0004\u0003\u0003\u0001%!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0015Q\u0018qAA\u0006\u0011\u0019\tIa\u0003a\u0001u\u0006\u0019\u0011M\u001d:\t\r\u000551\u00021\u0001{\u0003\u00151\u0018\r\\;f\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u0014\u0005}\u0011\u0011\u0006\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0012\u0002\u000f\r|G-Z4f]&!\u0011QDA\f\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0011\u0019\u0001\u0007\u00111E\u0001\u0004GRD\b\u0003BA\u000b\u0003KIA!a\n\u0002\u0018\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0016\u0019\u0001\u0007\u00111C\u0001\u0003KZ\f\u0001cZ3o\u0007>$WMR8s%\u0016\u001cX\u000f\u001c;\u0015\u0019\u0005E\u0012\u0011IA\"\u0003\u000b\nI%a\u0013\u0011\t\u0005M\u00121\b\b\u0005\u0003k\t9\u0004\u0005\u0002H\u0001&\u0019\u0011\u0011\b!\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI\u0004\u0011\u0005\b\u0003Ci\u0001\u0019AA\u0012\u0011\u001d\tY#\u0004a\u0001\u0003'Aq!a\u0012\u000e\u0001\u0004\t\t$\u0001\u0006j]B,H/\u0011:sCfDq!!\u0004\u000e\u0001\u0004\t\t\u0004C\u0004\u0002N5\u0001\r!!\r\u0002\u00199,w/\u0011:sCf\u001c\u0016N_3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u00022\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u00063\u0006]\u00131\f\u0005\u0007\u00033z\u0001\u0019A)\u0002\u000f9,w\u000fT3gi\"1\u0011QL\bA\u0002E\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003Z\u0003G\n)\u0007C\u0004P!A\u0005\t\u0019A)\t\u000fU\u0003\u0002\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA6U\r\t\u0016QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0010!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0006B!\u0011qQAI\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015\u0001\u00027b]\u001eT!!a$\u0002\t)\fg/Y\u0005\u0005\u0003{\tI)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0018B\u0019q(!'\n\u0007\u0005m\u0005IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002{\u0003CC\u0011\"a)\u0016\u0003\u0003\u0005\r!a&\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000bE\u0003\u0002,\u0006E&0\u0004\u0002\u0002.*\u0019\u0011q\u0016!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\u00065&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!/\u0002@B\u0019q(a/\n\u0007\u0005u\u0006IA\u0004C_>dW-\u00198\t\u0011\u0005\rv#!AA\u0002i\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QQAc\u0011%\t\u0019\u000bGA\u0001\u0002\u0004\t9*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u000bY\r\u0003\u0005\u0002$f\t\t\u00111\u0001{QM\u0001\u0011qZAk\u0003/\fY.!8\u0002b\u0006\r\u0018q]Au!\r\t\u0014\u0011[\u0005\u0004\u0003'\u0014#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00033\faj\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003%\u001a7f[\u0016tG/\u000b\u0011.AI+Wn\u001c<fA\u0005dG\u000eI3mK6,g\u000e^:!i\"\fG\u000fI3rk\u0006d\u0007\u0005^8!K2,W.\u001a8uA\u0019\u0014x.\u001c\u0011beJ\f\u0017PL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q\\\u0001W\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g1\u0002c.\u001e7mY\u0001\u001a\u0014\u0006\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173Y9,H\u000e\\/\u000bA\u0001\nQa\u001a:pkB\f#!!:\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003W\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V-\\8wKB\u0011\u0011gG\n\u00067\u0005M\u0018q \t\b\u0003k\fY0U)Z\u001b\t\t9PC\u0002\u0002z\u0002\u000bqA];oi&lW-\u0003\u0003\u0002~\u0006](!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!\u0011\u0001B\u0004\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\u00055\u0015AA5p\u0013\ri%1\u0001\u000b\u0003\u0003_\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\u000bQ!\u00199qYf$R!\u0017B\n\u0005+AQa\u0014\u0010A\u0002ECQ!\u0016\u0010A\u0002E\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001c\t\u001d\u0002#B \u0003\u001e\t\u0005\u0012b\u0001B\u0010\u0001\n1q\n\u001d;j_:\u0004Ra\u0010B\u0012#FK1A!\nA\u0005\u0019!V\u000f\u001d7fe!A!\u0011F\u0010\u0002\u0002\u0003\u0007\u0011,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\f\u0011\t\u0005\u001d%\u0011G\u0005\u0005\u0005g\tII\u0001\u0004PE*,7\r\u001e")
public class ArrayRemove
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRemove x$0) {
        return ArrayRemove$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRemove> tupled() {
        return ArrayRemove$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRemove>> curried() {
        return ArrayRemove$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)package$.MODULE$.Seq().empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)package$.MODULE$.Seq().empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)package$.MODULE$.Seq().empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(31).append("Input to function ").append(this.prettyName()).append(" should have ").toString()).append(new StringBuilder(59).append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").toString()).append(new StringBuilder(5).append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString()).toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    private DataType elementType() {
        return ((ArrayType)this.left().dataType()).elementType();
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayRemove arrayRemove = this;
        synchronized (arrayRemove) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object[] newArray = new Object[((ArrayData)arr).numElements()];
        IntRef pos = IntRef.create((int)0);
        ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
            ArrayRemove.$anonfun$nullSafeEval$8(this, value, newArray, pos, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        return new GenericArrayData((Object[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.genericArrayOps((Object)newArray), 0, pos.elem));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(arr, value) -> {
            String numsToRemove = ctx.freshName("numsToRemove");
            String newArraySize = ctx.freshName("newArraySize");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.elementType(), i);
            String isEqual = ctx.genEqual(this.elementType(), (String)value, getValue);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n         |int ").append(numsToRemove).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(isEqual).append(") {\n         |    ").append(numsToRemove).append(" = ").append(numsToRemove).append(" + 1;\n         |  }\n         |}\n         |int ").append(newArraySize).append(" = ").append((String)arr).append(".numElements() - ").append(numsToRemove).append(";\n         |").append(this.genCodeForResult(ctx, ev, (String)arr, (String)value, newArraySize)).append("\n       ").toString()));
        });
    }

    public String genCodeForResult(CodegenContext ctx, ExprCode ev, String inputArray, String value, String newArraySize) {
        String values = ctx.freshName("values");
        String i = ctx.freshName("i");
        String pos = ctx.freshName("pos");
        String getValue = CodeGenerator$.MODULE$.getValue(inputArray, this.elementType(), i);
        String isEqual = ctx.genEqual(this.elementType(), value, getValue);
        String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), newArraySize, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), inputArray, pos, i, false);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n       |").append(allocation).append("\n       |int ").append(pos).append(" = 0;\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(inputArray).append(".numElements(); ").append(i).append(" ++) {\n       |  if (").append(inputArray).append(".isNullAt(").append(i).append(")) {\n       |    ").append(values).append(".setNullAt(").append(pos).append(");\n       |    ").append(pos).append(" = ").append(pos).append(" + 1;\n       |  }\n       |  else {\n       |    if (!(").append(isEqual).append(")) {\n       |      ").append(assignment).append("\n       |      ").append(pos).append(" = ").append(pos).append(" + 1;\n       |    }\n       |  }\n       |}\n       |").append(ev.value()).append(" = ").append(values).append(";\n     ").toString()));
    }

    @Override
    public String prettyName() {
        return "array_remove";
    }

    @Override
    public ArrayRemove withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRemove copy(Expression left, Expression right) {
        return new ArrayRemove(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRemove";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRemove;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRemove)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRemove arrayRemove = (ArrayRemove)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRemove.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRemove.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRemove.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayRemove $this, Object value$3, Object[] newArray$1, IntRef pos$1, int i, Object v) {
        block0: {
            if (v != null && $this.ordering().equiv(v, value$3)) break block0;
            newArray$1[pos$1.elem] = v;
            ++pos$1.elem;
        }
    }

    public ArrayRemove(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

