/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0015e\u0001\u0002\u0016,\u0001bB\u0001\"\u0019\u0001\u0003\u0016\u0004%\tA\u0019\u0005\t]\u0002\u0011\t\u0012)A\u0005G\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0001\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003r\u0011!)\bA!f\u0001\n\u00031\b\u0002\u0003>\u0001\u0005#\u0005\u000b\u0011B<\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!11\u0010\u0001C\u0001\u0003\u001bAaa\u001f\u0001\u0005\u0002\u0005M\u0001BB>\u0001\t\u0003\t9\u0002\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003?A!\"!\u000f\u0001\u0011\u000b\u0007I\u0011AA\u001e\u0011)\tY\u0005\u0001EC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003;\u0002\u0001R1A\u0005\u0002\u0005}\u0003bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!!&\u0001\t\u0003\n9\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005%\u0006\u0001\"\u0015\u0002,\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003w\u0003\u0011\u0013!C\u0001\u0003{C\u0011\"a5\u0001#\u0003%\t!!6\t\u0013\u0005e\u0007!%A\u0005\u0002\u0005m\u0007\"CAp\u0001\u0005\u0005I\u0011IAq\u0011%\ti\u000fAA\u0001\n\u0003\ty\u000fC\u0005\u0002x\u0002\t\t\u0011\"\u0001\u0002z\"I\u0011q \u0001\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\n\u0005\u001f\u0001\u0011\u0011!C\u0001\u0005#A\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\t\u0013\tm\u0001!!A\u0005B\tuq!\u0003B!W\u0005\u0005\t\u0012\u0001B\"\r!Q3&!A\t\u0002\t\u0015\u0003BB>#\t\u0003\u00119\u0006C\u0005\u0003Z\t\n\t\u0011\"\u0012\u0003\\!I!Q\f\u0012\u0002\u0002\u0013\u0005%q\f\u0005\n\u0005O\u0012\u0013\u0013!C\u0001\u00037D\u0011B!\u001b#\u0003\u0003%\tIa\u001b\t\u0013\te$%%A\u0005\u0002\u0005m\u0007\"\u0003B>E\u0005\u0005I\u0011\u0002B?\u00051\u0019FO];diN$vnQ:w\u0015\taS&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u00180\u0003!\u0019\u0017\r^1msN$(B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003eM\nQa\u001d9be.T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO\u000e\u00011\u0003\u0003\u0001:{\u00013\u0015\n\u0015,\u0011\u0005iZT\"A\u0016\n\u0005qZ#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ir\u0014BA ,\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002B\t6\t!I\u0003\u0002DW\u000591m\u001c3fO\u0016t\u0017BA#C\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007C\u0001\u001eH\u0013\tA5FA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"AS'\u000f\u0005iZ\u0015B\u0001',\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011Aj\u000b\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\b!J|G-^2u!\t9fL\u0004\u0002Y;:\u0011\u0011\fX\u0007\u00025*\u00111lN\u0001\u0007yI|w\u000e\u001e \n\u0003MK!\u0001\u0014*\n\u0005}\u0003'\u0001D*fe&\fG.\u001b>bE2,'B\u0001'S\u0003\u001dy\u0007\u000f^5p]N,\u0012a\u0019\t\u0005I\"\\7N\u0004\u0002fMB\u0011\u0011LU\u0005\u0003OJ\u000ba\u0001\u0015:fI\u00164\u0017BA5k\u0005\ri\u0015\r\u001d\u0006\u0003OJ\u0003\"\u0001\u001a7\n\u00055T'AB*ue&tw-\u0001\u0005paRLwN\\:!\u0003\u0015\u0019\u0007.\u001b7e+\u0005\t\bC\u0001\u001es\u0013\t\u00198F\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tq\u000fE\u0002Rq.L!!\u001f*\u0003\r=\u0003H/[8o\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\u0015ihp`A\u0001!\tQ\u0004\u0001C\u0003b\u000f\u0001\u00071\rC\u0003p\u000f\u0001\u0007\u0011\u000fC\u0004v\u000fA\u0005\t\u0019A<\u0002\u00119,H\u000e\\1cY\u0016,\"!a\u0002\u0011\u0007E\u000bI!C\u0002\u0002\fI\u0013qAQ8pY\u0016\fg\u000eF\u0003~\u0003\u001f\t\t\u0002C\u0003b\u0013\u0001\u00071\rC\u0003p\u0013\u0001\u0007\u0011\u000fF\u0002~\u0003+AQa\u001c\u0006A\u0002E$R!`A\r\u00037AQa\\\u0006A\u0002EDQ!Y\u0006A\u0002E\faa\u001e:ji\u0016\u0014XCAA\u0011!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\t!![8\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006LA!a\f\u0002&\ty1\t[1s\u0003J\u0014\u0018-_,sSR,'\u000fK\u0002\r\u0003g\u00012!UA\u001b\u0013\r\t9D\u0015\u0002\niJ\fgn]5f]R\f1\"\u001b8qkR\u001c6\r[3nCV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111I\u0018\u0002\u000bQL\b/Z:\n\t\u0005\u001d\u0013\u0011\t\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007fA\u0007\u00024\u0005\u0019q-\u001a8\u0016\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005US&A\u0002dgZLA!!\u0017\u0002T\t\u0011RK\\5w_\u000eLG/_$f]\u0016\u0014\u0018\r^8sQ\rq\u00111G\u0001\nG>tg/\u001a:uKJ,\"!!\u0019\u0011\u000fE\u000b\u0019'a\u001a\u0002n%\u0019\u0011Q\r*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA)\u0002j%\u0019\u00111\u000e*\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002p\u0005]TBAA9\u0015\u0011\t\u0019%a\u001d\u000b\u0007\u0005U\u0014'\u0001\u0004v]N\fg-Z\u0005\u0005\u0003s\n\tH\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3aDA\u001a\u0003!!\u0017\r^1UsB,WCAAA!\u0011\ty$a!\n\t\u0005\u0015\u0015\u0011\t\u0002\t\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u0019Q(a#\t\u000bU\f\u0002\u0019A6\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005\u001d\u0014\u0011\u0013\u0005\b\u0003'\u0013\u0002\u0019AA4\u0003\u00151\u0018\r\\;f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u00033\u0003RaVAN\u0003?K1!!(a\u0005\r\u0019V-\u001d\t\u0005\u0003\u007f\t\t+\u0003\u0003\u0002$\u0006\u0005#\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002W\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2!`AW\u0011\u0019\ty+\u0006a\u0001c\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcB?\u00026\u0006]\u0016\u0011\u0018\u0005\bCZ\u0001\n\u00111\u0001d\u0011\u001dyg\u0003%AA\u0002EDq!\u001e\f\u0011\u0002\u0003\u0007q/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}&fA2\u0002B.\u0012\u00111\u0019\t\u0005\u0003\u000b\fy-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003%)hn\u00195fG.,GMC\u0002\u0002NJ\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t.a2\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]'fA9\u0002B\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAoU\r9\u0018\u0011Y\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\b\u0003BAs\u0003Wl!!a:\u000b\t\u0005%\u0018\u0011F\u0001\u0005Y\u0006tw-C\u0002n\u0003O\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!=\u0011\u0007E\u000b\u00190C\u0002\u0002vJ\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001a\u0002|\"I\u0011Q \u000f\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0001C\u0002B\u0003\u0005\u0017\t9'\u0004\u0002\u0003\b)\u0019!\u0011\u0002*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u000e\t\u001d!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u0002\u0003\u0014!I\u0011Q \u0010\u0002\u0002\u0003\u0007\u0011qM\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002d\ne\u0001\"CA\u007f?\u0005\u0005\t\u0019AAy\u0003\u0019)\u0017/^1mgR!\u0011q\u0001B\u0010\u0011%\ti\u0010IA\u0001\u0002\u0004\t9\u0007K\n\u0001\u0005G\u0011ICa\u000b\u00030\tE\"Q\u0007B\u001c\u0005w\u0011i\u0004E\u0002;\u0005KI1Aa\n,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\f\u0002\u0011~3UKT\"`Q\u0015D\bO].-A=\u0004H/[8ogvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u001a5K\u0016\u0011tiJLgn\u001a\u0011xSRD\u0007%\u0019\u0011hSZ,g\u000eI:ueV\u001cG\u000f\t<bYV,\u0017\u0001C3yC6\u0004H.Z:\"\u0005\tM\u0012!!1\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\r\u00173\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"r\u0017-\\3e?N$(/^2uQ\u001d\"\u0018.\\3(Y\u0001\"xn\u0018;j[\u0016\u001cH/Y7qQ\u001d\u0012\u0004'M\u001b.aaj#GN\u0014-A\u001dJ\u00180_=.\u001b6kC\rZ\u0014*S1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eYz\u0003\u0007O\u00183aE*$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\te\u0012!B\u001a/a9\u0002\u0014!B4s_V\u0004\u0018E\u0001B \u0003%\u00197O^0gk:\u001c7/\u0001\u0007TiJ,8\r^:U_\u000e\u001bh\u000f\u0005\u0002;EM)!Ea\u0012\u0003TAA!\u0011\nB(GF<X0\u0004\u0002\u0003L)\u0019!Q\n*\u0002\u000fI,h\u000e^5nK&!!\u0011\u000bB&\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003G\u0011)&C\u0002`\u0003K!\"Aa\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fu\u0014\tGa\u0019\u0003f!)\u0011-\na\u0001G\")q.\na\u0001c\"9Q/\nI\u0001\u0002\u00049\u0018aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!Q\u000eB;!\u0011\t\u0006Pa\u001c\u0011\rE\u0013\thY9x\u0013\r\u0011\u0019H\u0015\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t]t%!AA\u0002u\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0010\t\u0005\u0003K\u0014\t)\u0003\u0003\u0003\u0004\u0006\u001d(AB(cU\u0016\u001cG\u000f")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv x$0) {
        return StructsToCsv$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                StructType structType;
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof StructType)) {
                    throw QueryExecutionErrors$.MODULE$.inputTypeUnsupportedError(dataType);
                }
                StructType structType2 = structType = (StructType)dataType;
                this.inputSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "options";
                break;
            }
            case 1: {
                string = "child";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

