/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AesDecrypt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, key[, mode[, padding]]) - Returns a decrypted value of `expr` using AES in `mode` with `padding`.\n      Key lengths of 16, 24 and 32 bits are supported. Supported combinations of (`mode`, `padding`) are ('ECB', 'PKCS') and ('GCM', 'NONE').\n      The default mode is GCM.\n  ", arguments="\n    Arguments:\n      * expr - The binary value to decrypt.\n      * key - The passphrase to use to decrypt the data.\n      * mode - Specifies which block cipher mode should be used to decrypt messages.\n               Valid modes: ECB, GCM.\n      * padding - Specifies how to pad messages whose length is not a multiple of the block size.\n                  Valid values: PKCS, NONE, DEFAULT. The DEFAULT padding means PKCS for ECB and NONE for GCM.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(unhex('83F16B2AA704794132802D248E6BFD4E380078182D1544813898AC97E709B28A94'), '0000111122223333');\n       Spark\n      > SELECT _FUNC_(unhex('6E7CA17BBB468D3084B5744BCA729FB7B2B7BCB8E4472847D02670489D95FA97DBBA7D3210'), '0000111122223333', 'GCM');\n       Spark SQL\n      > SELECT _FUNC_(unbase64('3lmwu+Mw0H3fi5NDvcu9lg=='), '1234567890abcdef', 'ECB', 'PKCS');\n       Spark SQL\n  ", since="3.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0013&\u0001JB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t#\u0002\u0011\t\u0012)A\u0005g!A!\u000b\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005T\u0001\tE\t\u0015!\u00034\u0011!!\u0006A!f\u0001\n\u0003\u0001\u0006\u0002C+\u0001\u0005#\u0005\u000b\u0011B\u001a\t\u0011Y\u0003!Q3A\u0005\u0002AC\u0001b\u0016\u0001\u0003\u0012\u0003\u0006Ia\r\u0005\u00061\u0002!\t!\u0017\u0005\t?\u0002A)\u0019!C!!\")\u0001\f\u0001C\u0001A\")\u0001\f\u0001C\u0001I\")q\r\u0001C!Q\")!\u000f\u0001C!g\")A\u0010\u0001C!{\"1q\u0010\u0001C)\u0003\u0003A\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0019\u0001E\u0005I\u0011AA\u000e\u0011%\t\u0019\u0004AI\u0001\n\u0003\tY\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011q\u0007\u0001\u0002\u0002\u0013\u0005\u0013\u0011\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0004\"CA9\u0001\u0005\u0005I\u0011AA:\u0011%\ti\bAA\u0001\n\u0003\ny\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0011\u0002\u0006\u001eI\u0011qV\u0013\u0002\u0002#\u0005\u0011\u0011\u0017\u0004\tI\u0015\n\t\u0011#\u0001\u00024\"1\u0001L\bC\u0001\u0003\u0017D\u0011\"!4\u001f\u0003\u0003%)%a4\t\u0013\u0005Eg$!A\u0005\u0002\u0006M\u0007\"CAo=\u0005\u0005I\u0011QAp\u0011%\t\tPHA\u0001\n\u0013\t\u0019P\u0001\u0006BKN$Um\u0019:zaRT!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\u0007\u0001M:$(P\"\u0011\u0005Q*T\"A\u0013\n\u0005Y*#AC#yaJ,7o]5p]B\u0011A\u0007O\u0005\u0003s\u0015\u0012!CU;oi&lWMU3qY\u0006\u001cW-\u00192mKB\u0011AgO\u0005\u0003y\u0015\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\b!J|G-^2u!\t!EJ\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001*M\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!aS \u0002\u000fA\f7m[1hK&\u0011QJ\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0017~\nQ!\u001b8qkR,\u0012aM\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\u0007-,\u00170\u0001\u0003lKf\u0004\u0013\u0001B7pI\u0016\fQ!\\8eK\u0002\nq\u0001]1eI&tw-\u0001\u0005qC\u0012$\u0017N\\4!\u0003\u0019a\u0014N\\5u}Q)!l\u0017/^=B\u0011A\u0007\u0001\u0005\u0006\u001f&\u0001\ra\r\u0005\u0006%&\u0001\ra\r\u0005\u0006)&\u0001\ra\r\u0005\u0006-&\u0001\raM\u0001\fe\u0016\u0004H.Y2f[\u0016tG\u000f\u0006\u0003[C\n\u001c\u0007\"B(\f\u0001\u0004\u0019\u0004\"\u0002*\f\u0001\u0004\u0019\u0004\"\u0002+\f\u0001\u0004\u0019Dc\u0001.fM\")q\n\u0004a\u0001g!)!\u000b\u0004a\u0001g\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003%\u00042\u0001\u00126m\u0013\tYgJA\u0002TKF\u0004\"!\u001c9\u000e\u00039T!a\\\u0015\u0002\u000bQL\b/Z:\n\u0005Et'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002iB\u0011Q/\u001f\b\u0003m^\u0004\"AR \n\u0005a|\u0014A\u0002)sK\u0012,g-\u0003\u0002{w\n11\u000b\u001e:j]\u001eT!\u0001_ \u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012A \t\u0004\t*\u001c\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0019\u00141\u0001\u0005\b\u0003\u000b\u0001\u0002\u0019AA\u0004\u0003-qWm^\"iS2$'/\u001a8\u0011\t\u0011\u000bIaM\u0005\u0004\u0003\u0017q%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)%Q\u0016\u0011CA\n\u0003+\t9\u0002C\u0004P#A\u0005\t\u0019A\u001a\t\u000fI\u000b\u0002\u0013!a\u0001g!9A+\u0005I\u0001\u0002\u0004\u0019\u0004b\u0002,\u0012!\u0003\u0005\raM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiBK\u00024\u0003?Y#!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Wy\u0014AC1o]>$\u0018\r^5p]&!\u0011qFA\u0013\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003mC:<'BAA#\u0003\u0011Q\u0017M^1\n\u0007i\fy$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002NA\u0019a(a\u0014\n\u0007\u0005EsHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002X\u0005u\u0003c\u0001 \u0002Z%\u0019\u00111L \u0003\u0007\u0005s\u0017\u0010C\u0005\u0002`a\t\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001a\u0011\r\u0005\u001d\u0014QNA,\u001b\t\tIGC\u0002\u0002l}\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty'!\u001b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\nY\bE\u0002?\u0003oJ1!!\u001f@\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0018\u001b\u0003\u0003\u0005\r!a\u0016\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003w\t\t\tC\u0005\u0002`m\t\t\u00111\u0001\u0002N\u00051Q-];bYN$B!!\u001e\u0002\b\"I\u0011q\f\u000f\u0002\u0002\u0003\u0007\u0011q\u000b\u0015\u0018\u0001\u0005-\u0015\u0011SAJ\u0003/\u000bI*!(\u0002 \u0006\r\u0016QUAU\u0003W\u00032\u0001NAG\u0013\r\ty)\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)*\u0001B$\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003e[3z72\u0002Sn\u001c3f72\u0002\u0003/\u00193eS:<W,X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t3fGJL\b\u000f^3eAY\fG.^3!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004So]5oO\u0002\nUi\u0015\u0011j]\u0002\u0002Wn\u001c3fA\u0002:\u0018\u000e\u001e5!AB\fG\rZ5oO\u0002t#\u0002\t\u0011!A\u0001\u00023*Z=!Y\u0016tw\r\u001e5tA=4\u0007%\r\u001c-AI\"\u0004%\u00198eAM\u0012\u0004EY5ug\u0002\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u00023+\u001e9q_J$X\r\u001a\u0011d_6\u0014\u0017N\\1uS>t7\u000fI8gA!\u0002Wn\u001c3fA2\u0002\u0003\r]1eI&tw\rY\u0015!CJ,\u0007\u0005K\u0014F\u0007\n;C\u0006I\u0014Q\u0017\u000e\u001bv%\u000b\u0011b]\u0012\u0004\u0003fJ$D\u001b\u001eb\u0003e\n(P\u001d\u0016;\u0013F\f\u0006!A\u0001\u0002\u0003\u0005\t+iK\u0002\"WMZ1vYR\u0004Sn\u001c3fA%\u001c\beR\"N])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u00111T\u0001\u0004\u0006*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qe\u0002j\u0003\u0005\u00165fA\tLg.\u0019:zAY\fG.^3!i>\u0004C-Z2ssB$hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011lKf\u0004S\u0006\t+iK\u0002\u0002\u0018m]:qQJ\f7/\u001a\u0011u_\u0002*8/\u001a\u0011u_\u0002\"Wm\u0019:zaR\u0004C\u000f[3!I\u0006$\u0018M\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016![>$W\rI\u0017!'B,7-\u001b4jKN\u0004s\u000f[5dQ\u0002\u0012Gn\\2lA\rL\u0007\u000f[3sA5|G-\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002*8/\u001a3!i>\u0004C-Z2ssB$\b%\\3tg\u0006<Wm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AY\u000bG.\u001b3![>$Wm\u001d\u001e!\u000b\u000e\u0013E\u0006I$D\u001b:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005]1eI&tw\rI\u0017!'B,7-\u001b4jKN\u0004\u0003n\\<!i>\u0004\u0003/\u00193![\u0016\u001c8/Y4fg\u0002:\bn\\:fA1,gn\u001a;iA%\u001c\bE\\8uA\u0005\u0004S.\u001e7uSBdW\rI8gAQDW\r\t2m_\u000e\\\u0007e]5{K:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!-\u0006d\u0017\u000e\u001a\u0011wC2,Xm\u001d\u001e!!.\u001b5\u000b\f\u0011O\u001f:+E\u0006\t#F\r\u0006+F\n\u0016\u0018!)\",\u0007\u0005R#G\u0003VcE\u000b\t9bI\u0012Lgn\u001a\u0011nK\u0006t7\u000f\t)L\u0007N\u0003cm\u001c:!\u000b\u000e\u0013\u0005%\u00198eA9{e*\u0012\u0011g_J\u0004siQ'/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0016aa\u0010\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUt\u0007.\u001a=)Oa\u001ad)\r\u001cCe\u0005\u000bu\u0007\r\u001b8sQ\n4G\r\u001d1e\u0011\u0013D\u0007O#7\u0005\u001a#E'R\u001a9aA:\u0004(\r\u001d3\tF*D\u0007\u000e\u001d2gaJ\u0004(Q\":o\u0015;\u0004'\u000f\"3q\u0005KDgJ\u0015-A\u001d\u0002\u0004\u0007\r\u00192cE\n$G\r\u001a3gM\u001a4gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUt\u0007.\u001a=)OY*ugQ!2o\t\u0013%\t\u000e\u001c9\tN\u0002\u0004\b\u000e\"6oQ\"$iQ!8ee2%i\u000e\"3\u0005^\u00125I\u0011\u001dFiQ:$\u0007\u000f\u001b8\tB\u0012dg\u000e\u00195qe\"\u0015(\u000e$Bs]\"%IQ!8\tN\u0012\u0014\u0007M\u0014*Y\u0001:\u0003\u0007\r\u00191cE\n\u0014G\r\u001a3eM\u001a4gM\u0014-A\u001d:5)T\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:lAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015v]\n\f7/\u001a\u001c5Q\u001d\u001aD.\\<vW5;\b\u0007S\u001agSVrEI^2vs1<W(P\u0014*Y\u0001:\u0013GM\u001a5kY:\u0004(\u000f\u0019bE\u000e$WMZ\u0014-A\u001d*5IQ\u0014-A\u001d\u00026jQ*(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qU\u0001\u0006g9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003[\u000b!\"\\5tG~3WO\\2t\u0003)\tUm\u001d#fGJL\b\u000f\u001e\t\u0003iy\u0019RAHA[\u0003\u0003\u0004\u0012\"a.\u0002>N\u001a4g\r.\u000e\u0005\u0005e&bAA^\u007f\u00059!/\u001e8uS6,\u0017\u0002BA`\u0003s\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0007\n!![8\n\u00075\u000b)\r\u0006\u0002\u00022\u0006AAo\\*ue&tw\r\u0006\u0002\u0002<\u0005)\u0011\r\u001d9msRI!,!6\u0002X\u0006e\u00171\u001c\u0005\u0006\u001f\u0006\u0002\ra\r\u0005\u0006%\u0006\u0002\ra\r\u0005\u0006)\u0006\u0002\ra\r\u0005\u0006-\u0006\u0002\raM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\t/!<\u0011\u000by\n\u0019/a:\n\u0007\u0005\u0015xH\u0001\u0004PaRLwN\u001c\t\b}\u0005%8gM\u001a4\u0013\r\tYo\u0010\u0002\u0007)V\u0004H.\u001a\u001b\t\u0011\u0005=(%!AA\u0002i\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u0010\u0005\u0003\u0002>\u0005]\u0018\u0002BA}\u0003\u007f\u0011aa\u00142kK\u000e$\b")
public class AesDecrypt
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Expression key;
    private final Expression mode;
    private final Expression padding;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(AesDecrypt x$0) {
        return AesDecrypt$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, AesDecrypt> tupled() {
        return AesDecrypt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, AesDecrypt>>>> curried() {
        return AesDecrypt$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        AesDecrypt aesDecrypt = this;
        synchronized (aesDecrypt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression key() {
        return this.key;
    }

    public Expression mode() {
        return this.mode;
    }

    public Expression padding() {
        return this.padding;
    }

    private Expression replacement$lzycompute() {
        AesDecrypt aesDecrypt = this;
        synchronized (aesDecrypt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, BinaryType$.MODULE$, "aesDecrypt", (Seq<Expression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.key(), this.mode(), this.padding()}))), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.replacement$lzycompute() : this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, BinaryType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public String prettyName() {
        return "aes_decrypt";
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.input(), this.key(), this.mode(), this.padding()}));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3));
    }

    public AesDecrypt copy(Expression input, Expression key, Expression mode, Expression padding) {
        return new AesDecrypt(input, key, mode, padding);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.key();
    }

    public Expression copy$default$3() {
        return this.mode();
    }

    public Expression copy$default$4() {
        return this.padding();
    }

    @Override
    public String productPrefix() {
        return "AesDecrypt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.input();
                break;
            }
            case 1: {
                object = this.key();
                break;
            }
            case 2: {
                object = this.mode();
                break;
            }
            case 3: {
                object = this.padding();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AesDecrypt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "input";
                break;
            }
            case 1: {
                string = "key";
                break;
            }
            case 2: {
                string = "mode";
                break;
            }
            case 3: {
                string = "padding";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AesDecrypt)) return false;
        boolean bl = true;
        if (!bl) return false;
        AesDecrypt aesDecrypt = (AesDecrypt)x$1;
        Expression expression = this.input();
        Expression expression2 = aesDecrypt.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.key();
        Expression expression4 = aesDecrypt.key();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mode();
        Expression expression6 = aesDecrypt.mode();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.padding();
        Expression expression8 = aesDecrypt.padding();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!aesDecrypt.canEqual(this)) return false;
        return true;
    }

    public AesDecrypt(Expression input, Expression key, Expression mode, Expression padding) {
        this.input = input;
        this.key = key;
        this.mode = mode;
        this.padding = padding;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public AesDecrypt(Expression input, Expression key, Expression mode) {
        this(input, key, mode, Literal$.MODULE$.apply("DEFAULT"));
    }

    public AesDecrypt(Expression input, Expression key) {
        this(input, key, Literal$.MODULE$.apply("GCM"));
    }
}

