/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.Serializable;
import java.util.List;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class ArrowUtils$ {
    public static final ArrowUtils$ MODULE$ = new ArrowUtils$();
    private static final RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);

    public RootAllocator rootAllocator() {
        return rootAllocator;
    }

    public ArrowType toArrowType(DataType dt, String timeZoneId) {
        DecimalType decimalType;
        Option<Tuple2<Object, Object>> option;
        ArrowType.Bool bool;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Bool.INSTANCE;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(8, true);
        } else if (ShortType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(16, true);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(32, true);
        } else if (LongType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(64, true);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        } else if (StringType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Utf8.INSTANCE;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Binary.INSTANCE;
        } else if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            bool = new ArrowType.Decimal(precision, scale);
        } else if (DateType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Date(DateUnit.DAY);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            if (timeZoneId == null) {
                throw QueryExecutionErrors$.MODULE$.timeZoneIdNotSpecifiedForTimestampTypeError();
            }
            bool = new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        } else if (NullType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Null.INSTANCE;
        } else if (dataType instanceof YearMonthIntervalType) {
            bool = new ArrowType.Interval(IntervalUnit.YEAR_MONTH);
        } else if (dataType instanceof DayTimeIntervalType) {
            bool = new ArrowType.Interval(IntervalUnit.DAY_TIME);
        } else {
            throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.catalogString());
        }
        return bool;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType fromArrowType(ArrowType dt) {
        void var2_25;
        boolean bl = false;
        ArrowType.Int intVal = null;
        boolean bl2 = false;
        ArrowType.FloatingPoint floatingPoint = null;
        boolean bl3 = false;
        ArrowType.Interval interval = null;
        ArrowType arrowType = dt;
        ArrowType.Bool bool = ArrowType.Bool.INSTANCE;
        ArrowType arrowType2 = arrowType;
        if (!(bool != null ? !bool.equals(arrowType2) : arrowType2 != null)) {
            BooleanType$ booleanType$ = BooleanType$.MODULE$;
            return var2_25;
        }
        if (arrowType instanceof ArrowType.Int) {
            bl = true;
            intVal = (ArrowType.Int)arrowType;
            if (intVal.getIsSigned() && intVal.getBitWidth() == 8) {
                ByteType$ byteType$ = ByteType$.MODULE$;
                return var2_25;
            }
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 16) {
            ShortType$ shortType$ = ShortType$.MODULE$;
            return var2_25;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 32) {
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            return var2_25;
        }
        if (bl && intVal.getIsSigned() && intVal.getBitWidth() == 64) {
            LongType$ longType$ = LongType$.MODULE$;
            return var2_25;
        }
        if (arrowType instanceof ArrowType.FloatingPoint) {
            bl2 = true;
            floatingPoint = (ArrowType.FloatingPoint)arrowType;
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.SINGLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null)) {
                FloatType$ floatType$ = FloatType$.MODULE$;
                return var2_25;
            }
        }
        if (bl2) {
            FloatingPointPrecision floatingPointPrecision = floatingPoint.getPrecision();
            FloatingPointPrecision floatingPointPrecision3 = FloatingPointPrecision.DOUBLE;
            if (!(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision3) : floatingPointPrecision3 != null)) {
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                return var2_25;
            }
        }
        ArrowType.Utf8 utf8 = ArrowType.Utf8.INSTANCE;
        ArrowType arrowType3 = arrowType;
        if (!(utf8 != null ? !utf8.equals(arrowType3) : arrowType3 != null)) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_25;
        }
        ArrowType.Binary binary = ArrowType.Binary.INSTANCE;
        ArrowType arrowType4 = arrowType;
        if (!(binary != null ? !binary.equals(arrowType4) : arrowType4 != null)) {
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            return var2_25;
        }
        if (arrowType instanceof ArrowType.Decimal) {
            ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
            DecimalType decimalType = new DecimalType(decimal.getPrecision(), decimal.getScale());
            return var2_25;
        }
        if (arrowType instanceof ArrowType.Date) {
            ArrowType.Date date = (ArrowType.Date)arrowType;
            DateUnit dateUnit = date.getUnit();
            DateUnit dateUnit2 = DateUnit.DAY;
            if (!(dateUnit != null ? !dateUnit.equals(dateUnit2) : dateUnit2 != null)) {
                DateType$ dateType$ = DateType$.MODULE$;
                return var2_25;
            }
        }
        if (arrowType instanceof ArrowType.Timestamp) {
            ArrowType.Timestamp timestamp = (ArrowType.Timestamp)arrowType;
            TimeUnit timeUnit = timestamp.getUnit();
            TimeUnit timeUnit2 = TimeUnit.MICROSECOND;
            if (!(timeUnit != null ? !timeUnit.equals(timeUnit2) : timeUnit2 != null)) {
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                return var2_25;
            }
        }
        ArrowType.Null nullVal = ArrowType.Null.INSTANCE;
        ArrowType arrowType5 = arrowType;
        if (!(nullVal != null ? !nullVal.equals(arrowType5) : arrowType5 != null)) {
            NullType$ nullType$ = NullType$.MODULE$;
            return var2_25;
        }
        if (arrowType instanceof ArrowType.Interval) {
            bl3 = true;
            interval = (ArrowType.Interval)arrowType;
            IntervalUnit intervalUnit = interval.getUnit();
            IntervalUnit intervalUnit2 = IntervalUnit.YEAR_MONTH;
            if (!(intervalUnit != null ? !intervalUnit.equals(intervalUnit2) : intervalUnit2 != null)) {
                YearMonthIntervalType yearMonthIntervalType = YearMonthIntervalType$.MODULE$.apply();
                return var2_25;
            }
        }
        if (!bl3) throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.toString());
        IntervalUnit intervalUnit = interval.getUnit();
        IntervalUnit intervalUnit3 = IntervalUnit.DAY_TIME;
        if (intervalUnit == null) {
            if (intervalUnit3 != null) {
                throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.toString());
            }
        } else if (!intervalUnit.equals(intervalUnit3)) throw QueryExecutionErrors$.MODULE$.unsupportedDataTypeError(dt.toString());
        DayTimeIntervalType dayTimeIntervalType = DayTimeIntervalType$.MODULE$.apply();
        return var2_25;
    }

    public Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        Field field2;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("element", elementType, containsNull, timeZoneId)}))).asJava());
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), ClassTag$.MODULE$.apply(Field.class))))).asJava());
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
            field2 = new Field(name, mapType2, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Field[]{this.toArrowField("entries", new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId)}))).asJava());
        } else {
            FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
            field2 = new Field(name, fieldType, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Seq().empty()).asJava());
        }
        return field2;
    }

    public DataType fromArrowField(Field field) {
        DataType dataType;
        ArrowType arrowType = field.getType();
        if (arrowType instanceof ArrowType.Map) {
            Field elementField = (Field)field.getChildren().get(0);
            DataType keyType = this.fromArrowField((Field)elementField.getChildren().get(0));
            DataType valueType = this.fromArrowField((Field)elementField.getChildren().get(1));
            dataType = new MapType(keyType, valueType, ((Field)elementField.getChildren().get(1)).isNullable());
        } else {
            ArrowType.List list = ArrowType.List.INSTANCE;
            ArrowType arrowType2 = arrowType;
            if (!(list != null ? !list.equals(arrowType2) : arrowType2 != null)) {
                Field elementField = (Field)field.getChildren().get(0);
                DataType elementType = this.fromArrowField(elementField);
                dataType = new ArrayType(elementType, elementField.isNullable());
            } else {
                ArrowType.Struct struct = ArrowType.Struct.INSTANCE;
                ArrowType arrowType3 = arrowType;
                if (!(struct != null ? !struct.equals(arrowType3) : arrowType3 != null)) {
                    Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable)child -> {
                        DataType dt = MODULE$.fromArrowField((Field)child);
                        return new StructField(child.getName(), dt, child.isNullable(), StructField$.MODULE$.apply$default$4());
                    });
                    dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq<StructField>)fields.toSeq());
                } else {
                    dataType = this.fromArrowType(arrowType);
                }
            }
        }
        return dataType;
    }

    public Schema toArrowSchema(StructType schema, String timeZoneId) {
        return new Schema((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.map((Function1 & Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId))).asJava());
    }

    public StructType fromArrowSchema(Schema schema) {
        return StructType$.MODULE$.apply((scala.collection.immutable.Seq<StructField>)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            DataType dt = MODULE$.fromArrowField((Field)field);
            return new StructField(field.getName(), dt, field.isNullable(), StructField$.MODULE$.apply$default$4());
        })).toSeq());
    }

    public Map<String, String> getPythonRunnerConfMap(SQLConf conf) {
        scala.collection.immutable.Seq timeZoneConf = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)conf.sessionLocalTimeZone())}));
        scala.collection.immutable.Seq pandasColsByName = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PANDAS_GROUPED_MAP_ASSIGN_COLUMNS_BY_NAME().key()), (Object)Boolean.toString(conf.pandasGroupedMapAssignColumnsByName()))}));
        scala.collection.immutable.Seq arrowSafeTypeCheck = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PANDAS_ARROW_SAFE_TYPE_CONVERSION().key()), (Object)Boolean.toString(conf.arrowSafeTypeConversion()))}));
        return (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)((IterableOps)timeZoneConf.$plus$plus((IterableOnce)pandasColsByName)).$plus$plus((IterableOnce)arrowSafeTypeCheck));
    }

    private ArrowUtils$() {
    }
}

