/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class DateTimeFormatterHelper$ {
    public static final DateTimeFormatterHelper$ MODULE$ = new DateTimeFormatterHelper$();
    private static DateTimeFormatter fractionFormatter;
    private static final Cache<Tuple3<String, Locale, Object>, DateTimeFormatter> cache;
    private static final Regex extractor;
    private static final boolean bugInStandAloneForm;
    private static final Set<Object> weekBasedLetters;
    private static final Set<Object> unsupportedLetters;
    private static final Set<Object> unsupportedLettersForParsing;
    private static final Set<String> unsupportedPatternLengths;
    private static volatile boolean bitmap$0;

    static {
        cache = CacheBuilder.newBuilder().maximumSize(128L).build();
        extractor = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([^S]*)(S*)(.*)$"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("LLL qqq", Locale.US);
        String string = formatter.format(LocalDate.of(2000, 1, 1));
        String string2 = "1 1";
        bugInStandAloneForm = !(string != null ? !string.equals(string2) : string2 != null);
        weekBasedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'Y', 'W', 'w', 'u', 'e', 'c'}));
        unsupportedLetters = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'A', 'n', 'N', 'p'}));
        unsupportedLettersForParsing = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'E', 'F', 'q', 'Q'}));
        unsupportedPatternLengths = ((IterableOnceOps)((IterableOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"G", "M", "L", "E", "Q", "q"})).map((Function1 & Serializable)x$1 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(x$1), 5))).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"y"})).map((Function1 & Serializable)x$2 -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(x$2), 7)))).toSet();
    }

    public Cache<Tuple3<String, Locale, Object>, DateTimeFormatter> cache() {
        return cache;
    }

    public final Regex extractor() {
        return extractor;
    }

    public DateTimeFormatterBuilder createBuilder() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive();
    }

    public DateTimeFormatter toFormatter(DateTimeFormatterBuilder builder, Locale locale) {
        return builder.toFormatter(locale).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    }

    /*
     * WARNING - void declaration
     */
    public DateTimeFormatterBuilder createBuilderWithVarLengthSecondFraction(String pattern) {
        void var2_2;
        DateTimeFormatterBuilder builder = this.createBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'")))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if ("".equals(string) && idx != 0) {
                    return builder.appendLiteral("'");
                }
            }
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (idx % 2 == 0) {
                    String rest = patternPart;
                    while (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rest))) {
                        String string = rest;
                        if (string == null) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        Option option = MODULE$.extractor().unapplySeq((CharSequence)string);
                        if (option.isEmpty()) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        if (option.get() == null) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        if (((List)option.get()).lengthCompare(3) != 0) throw new IllegalArgumentException(new StringBuilder(31).append("Unrecognized datetime pattern: ").append(pattern).toString());
                        String prefix = (String)((LinearSeqOps)option.get()).apply(0);
                        String secondFraction = (String)((LinearSeqOps)option.get()).apply(1);
                        String suffix = (String)((LinearSeqOps)option.get()).apply(2);
                        builder.appendPattern(prefix);
                        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(secondFraction)) ? builder.appendFraction(ChronoField.NANO_OF_SECOND, 1, secondFraction.length(), false) : BoxedUnit.UNIT;
                        rest = suffix;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String patternPart = (String)tuple2._1();
            return builder.appendLiteral(patternPart);
        });
        return var2_2;
    }

    public DateTimeFormatter buildFormatter(String pattern, Locale locale, boolean varLenEnabled) {
        DateTimeFormatterBuilder builder = varLenEnabled ? this.createBuilderWithVarLengthSecondFraction(pattern) : this.createBuilder().appendPattern(pattern);
        return this.toFormatter(builder, locale);
    }

    private DateTimeFormatter fractionFormatter$lzycompute() {
        DateTimeFormatterHelper$ dateTimeFormatterHelper$ = this;
        synchronized (dateTimeFormatterHelper$) {
            if (!bitmap$0) {
                DateTimeFormatterBuilder builder = this.createBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true);
                fractionFormatter = this.toFormatter(builder, TimestampFormatter$.MODULE$.defaultLocale());
                bitmap$0 = true;
            }
        }
        return fractionFormatter;
    }

    public DateTimeFormatter fractionFormatter() {
        return !bitmap$0 ? this.fractionFormatter$lzycompute() : fractionFormatter;
    }

    private final boolean bugInStandAloneForm() {
        return bugInStandAloneForm;
    }

    public final Set<Object> weekBasedLetters() {
        return weekBasedLetters;
    }

    public final Set<Object> unsupportedLetters() {
        return unsupportedLetters;
    }

    public final Set<Object> unsupportedLettersForParsing() {
        return unsupportedLettersForParsing;
    }

    public final Set<String> unsupportedPatternLengths() {
        return unsupportedPatternLengths;
    }

    public String convertIncompatiblePattern(String pattern, boolean isParsing) {
        boolean eraDesignatorContained = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.split("'")))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$1(x0$1)));
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])new StringBuilder(1).append(pattern).append(" ").toString().split("'")))), (Function1 & Serializable)x0$2 -> {
            String string;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String patternPart = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index % 2 == 0) {
                    StringOps$.MODULE$.withFilter$extension(Predef$.MODULE$.augmentString(patternPart), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$3(BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$4(BoxesRunTime.unboxToChar((Object)c)));
                    StringOps$.MODULE$.withFilter$extension(Predef$.MODULE$.augmentString(patternPart), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$5(isParsing, BoxesRunTime.unboxToChar((Object)c)))).foreach((Function1 & Serializable)c -> DateTimeFormatterHelper$.$anonfun$convertIncompatiblePattern$6(BoxesRunTime.unboxToChar((Object)c)));
                    MODULE$.unsupportedPatternLengths().withFilter((Function1 & Serializable)style -> BoxesRunTime.boxToBoolean((boolean)patternPart.contains(style))).foreach((Function1 & Serializable)style -> {
                        throw new IllegalArgumentException(new StringBuilder(26).append("Too many pattern letters: ").append(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(style))).toString());
                    });
                    if (MODULE$.bugInStandAloneForm() && (patternPart.contains("LLL") || patternPart.contains("qqq"))) {
                        throw new IllegalArgumentException("Java 8 has a bug to support stand-alone form (3 or more 'L' or 'q' in the pattern string). Please use 'M' or 'Q' instead, or upgrade your Java version. For more details, please read https://bugs.openjdk.java.net/browse/JDK-8114833");
                    }
                    string = !eraDesignatorContained ? patternPart.replace("y", "u") : patternPart;
                } else {
                    string = patternPart;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String string2 = string;
            return string2;
        }, ClassTag$.MODULE$.apply(String.class))).mkString("'")), " ");
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String patternPart = (String)tuple2._1();
        int index = tuple2._2$mcI$sp();
        boolean bl = index % 2 == 0 && patternPart.contains("G");
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$3(char c) {
        return MODULE$.weekBasedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$4(char c) {
        throw new IllegalArgumentException(new StringBuilder(0).append("All week-based patterns are unsupported since").append(new StringBuilder(67).append(" Spark 3.0, detected: ").append(c).append(", Please use the SQL function EXTRACT instead").toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$convertIncompatiblePattern$5(boolean isParsing$1, char c) {
        return MODULE$.unsupportedLetters().contains((Object)BoxesRunTime.boxToCharacter((char)c)) || isParsing$1 && MODULE$.unsupportedLettersForParsing().contains((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    public static final /* synthetic */ Nothing$ $anonfun$convertIncompatiblePattern$6(char c) {
        throw new IllegalArgumentException(new StringBuilder(27).append("Illegal pattern character: ").append(c).toString());
    }

    private DateTimeFormatterHelper$() {
    }
}

