/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 0.3) FROM VALUES (0), (10) AS tab(col);\n       3.0\n      > SELECT _FUNC_(col, array(0.25, 0.75)) FROM VALUES (0), (10) AS tab(col);\n       [2.5,7.5]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0005\rmb\u0001\u0002 @\u0001:C!\"!\u0001\u0001\u0005+\u0007I\u0011AA\u0002\u0011%\t)\u0001\u0001B\tB\u0003%a\u000e\u0003\u0006\u0002\b\u0001\u0011)\u001a!C\u0001\u0003\u0007A\u0011\"!\u0003\u0001\u0005#\u0005\u000b\u0011\u00028\t\u0015\u0005-\u0001A!f\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u000e\u0001\u0011\t\u0012)A\u0005]\"Q\u0011q\u0002\u0001\u0003\u0016\u0004%\t!!\u0005\t\u0015\u0005e\u0001A!E!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001c\u0001\u0011)\u001a!C\u0001\u0003#A!\"!\b\u0001\u0005#\u0005\u000b\u0011BA\n\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!a\b\u0001\t\u0003\ty\u0003C\u0004\u0002 \u0001!\t!!\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u00111\u000b\u0001\u0005B\u0005U\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\u000b\u0003G\u0002\u0001R1A\u0005\n\u0005\u0015\u0004BCA;\u0001!\u0015\r\u0011\"\u0003\u0002x!9\u0011q\u0011\u0001\u0005B\u0005\r\u0001bBAE\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003\u0017\u0003A\u0011IA\u0002\u0011\u001d\ti\t\u0001C!\u0003KB!\"a$\u0001\u0011\u000b\u0007I\u0011IAI\u0011\u001d\ty\n\u0001C!\u0003CCq!a,\u0001\t\u0003\n\t\fC\u0004\u0002@\u0002!I!!1\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0007bBAs\u0001\u0011\u0005\u0013q\u001d\u0005\b\u0003_\u0004A\u0011IAy\u0011\u001d\t)\u0010\u0001C\u0005\u0003oDq!!@\u0001\t\u0013\ty\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c!9!q\u0006\u0001\u0005B\tE\u0002b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u0005\u000f\u0002A\u0011\u000bB%\u0011%\u00119\u0006AA\u0001\n\u0003\u0011I\u0006C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003h!I!Q\u0010\u0001\u0012\u0002\u0013\u0005!q\r\u0005\n\u0005\u007f\u0002\u0011\u0013!C\u0001\u0005OB\u0011B!!\u0001#\u0003%\tAa!\t\u0013\t\u001d\u0005!%A\u0005\u0002\t\r\u0005\"\u0003BE\u0001\u0005\u0005I\u0011\tBF\u0011%\u0011Y\nAA\u0001\n\u0003\t\t\u0002C\u0005\u0003\u001e\u0002\t\t\u0011\"\u0001\u0003 \"I!Q\u0015\u0001\u0002\u0002\u0013\u0005#q\u0015\u0005\n\u0005g\u0003\u0011\u0011!C\u0001\u0005kC\u0011B!/\u0001\u0003\u0003%\tEa/\t\u0013\t}\u0006!!A\u0005B\t\u0005w!\u0003Bs\u007f\u0005\u0005\t\u0012\u0001Bt\r!qt(!A\t\u0002\t%\bbBA\u0010i\u0011\u00051\u0011\u0001\u0005\n\u0007\u0007!\u0014\u0011!C#\u0007\u000bA\u0011ba\u00025\u0003\u0003%\ti!\u0003\t\u0013\rUA'%A\u0005\u0002\t\r\u0005\"CB\fiE\u0005I\u0011\u0001BB\u0011%\u0019I\u0002NA\u0001\n\u0003\u001bY\u0002C\u0005\u0004.Q\n\n\u0011\"\u0001\u0003\u0004\"I1q\u0006\u001b\u0012\u0002\u0013\u0005!1\u0011\u0005\n\u0007c!\u0014\u0011!C\u0005\u0007g\u0011!\u0002U3sG\u0016tG/\u001b7f\u0015\t\u0001\u0015)A\u0005bO\u001e\u0014XmZ1uK*\u0011!iQ\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002E\u000b\u0006A1-\u0019;bYf\u001cHO\u0003\u0002G\u000f\u0006\u00191/\u001d7\u000b\u0005!K\u0015!B:qCJ\\'B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001\u001f\u0012D\u0017\u000f\u001e\t\u0004!F\u001bV\"A \n\u0005I{$\u0001\u0007+za\u0016$\u0017*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uKB!A+W.b\u001b\u0005)&B\u0001,X\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u00031\u001e\u000bA!\u001e;jY&\u0011!,\u0016\u0002\f\u001fB,g\u000eS1tQ6\u000b\u0007\u000f\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0004B]f\u0014VM\u001a\t\u00039\nL!aY/\u0003\t1{gn\u001a\t\u0003K\u001al\u0011!Q\u0005\u0003O\u0006\u0013a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0004S2tW\"\u00016\u000b\u0005-\u001c\u0015!\u0002;sK\u0016\u001c\u0018BA7k\u0005-!VM\u001d8befd\u0015n[3\u0011\u0005\u0015|\u0017B\u00019B\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u00039JL!a]/\u0003\u000fA\u0013x\u000eZ;diB\u0011Q/ \b\u0003mnt!a\u001e>\u000e\u0003aT!!_'\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0016B\u0001?^\u0003\u001d\u0001\u0018mY6bO\u0016L!A`@\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005ql\u0016!B2iS2$W#\u00018\u0002\r\rD\u0017\u000e\u001c3!\u0003Q\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0006)\u0002/\u001a:dK:$\u0018mZ3FqB\u0014Xm]:j_:\u0004\u0013a\u00054sKF,XM\\2z\u000bb\u0004(/Z:tS>t\u0017\u0001\u00064sKF,XM\\2z\u000bb\u0004(/Z:tS>t\u0007%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\t\t\u0019\u0002E\u0002]\u0003+I1!a\u0006^\u0005\rIe\u000e^\u0001\u0018[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\nA#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018!F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u0005\r\u0012QEA\u0014\u0003S\tY#!\f\u0011\u0005A\u0003\u0001BBA\u0001\u0017\u0001\u0007a\u000e\u0003\u0004\u0002\b-\u0001\rA\u001c\u0005\u0007\u0003\u0017Y\u0001\u0019\u00018\t\u0013\u0005=1\u0002%AA\u0002\u0005M\u0001\"CA\u000e\u0017A\u0005\t\u0019AA\n)\u0019\t\u0019#!\r\u00024!1\u0011\u0011\u0001\u0007A\u00029Da!a\u0002\r\u0001\u0004qG\u0003CA\u0012\u0003o\tI$a\u000f\t\r\u0005\u0005Q\u00021\u0001o\u0011\u0019\t9!\u0004a\u0001]\"1\u0011QH\u0007A\u00029\f\u0011B\u001a:fcV,gnY=\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002DA!\u0011QIA'\u001d\u0011\t9%!\u0013\u0011\u0005]l\u0016bAA&;\u00061\u0001K]3eK\u001aLA!a\u0014\u0002R\t11\u000b\u001e:j]\u001eT1!a\u0013^\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA\u0012\u0003/Bq!!\u0017\u0010\u0001\u0004\t\u0019\"A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002$\u0005}\u0003bBA1!\u0001\u0007\u00111C\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u00170\u0006\u0002\u0002hA\u0019A,!\u001b\n\u0007\u0005-TLA\u0004C_>dW-\u00198)\u0007E\ty\u0007E\u0002]\u0003cJ1!a\u001d^\u0005%!(/\u00198tS\u0016tG/A\u0006qKJ\u001cWM\u001c;bO\u0016\u001cXCAA=!\u0015a\u00161PA@\u0013\r\ti(\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00049\u0006\u0005\u0015bAAB;\n1Ai\\;cY\u0016D3AEA8\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI*R\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\u000b9J\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003G\u0003R!^AS\u0003SK1!a*\u0000\u0005\r\u0019V-\u001d\t\u0005\u0003+\u000bY+\u0003\u0003\u0002.\u0006]%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tIlQ\u0001\tC:\fG._:jg&!\u0011QXA\\\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018!\u0004;p\t>,(\r\\3WC2,X\r\u0006\u0003\u0002\u0000\u0005\r\u0007bBAc5\u0001\u0007\u0011qY\u0001\u0002IB\u0019A,!3\n\u0007\u0005-WLA\u0002B]f\fqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003M\u000ba!\u001e9eCR,G#B*\u0002V\u0006e\u0007BBAl9\u0001\u00071+\u0001\u0004ck\u001a4WM\u001d\u0005\b\u00037d\u0002\u0019AAo\u0003\u0015Ig\u000e];u!\u0011\ty.!9\u000e\u0003\rK1!a9D\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000bM\u000bI/a;\t\r\u0005]W\u00041\u0001T\u0011\u0019\ti/\ba\u0001'\u0006)q\u000e\u001e5fe\u0006!QM^1m)\u0011\t9-a=\t\r\u0005]g\u00041\u0001T\u000399W\r\u001e)fe\u000e,g\u000e^5mKN$B!!?\u0002|B)Q/!*\u0002\u0000!1\u0011q[\u0010A\u0002M\u000babZ3oKJ\fG/Z(viB,H\u000f\u0006\u0003\u0002H\n\u0005\u0001b\u0002B\u0002A\u0001\u0007\u0011\u0011`\u0001\be\u0016\u001cX\u000f\u001c;t\u000359W\r\u001e)fe\u000e,g\u000e^5mKR1\u0011q\u0010B\u0005\u0005+AqAa\u0003\"\u0001\u0004\u0011i!A\u0006bO\u001e\u0014XmQ8v]R\u001c\b#B;\u0002&\n=\u0001#\u0002/\u0003\u0012m\u000b\u0017b\u0001B\n;\n1A+\u001e9mKJBqAa\u0006\"\u0001\u0004\ty(\u0001\u0005q_NLG/[8o\u0003E\u0011\u0017N\\1ssN+\u0017M]2i\u0007>,h\u000e\u001e\u000b\u000b\u0003'\u0011iBa\t\u0003(\t-\u0002b\u0002B\u0010E\u0001\u0007!\u0011E\u0001\fG>,h\u000e^:BeJ\f\u0017\u0010\u0005\u0003]\u0003w\n\u0007b\u0002B\u0013E\u0001\u0007\u00111C\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0005S\u0011\u0003\u0019AA\n\u0003\r)g\u000e\u001a\u0005\u0007\u0005[\u0011\u0003\u0019A1\u0002\u000bY\fG.^3\u0002\u0013M,'/[1mSj,G\u0003\u0002B\u001a\u0005w\u0001R\u0001XA>\u0005k\u00012\u0001\u0018B\u001c\u0013\r\u0011I$\u0018\u0002\u0005\u0005f$X\r\u0003\u0004\u0003>\r\u0002\raU\u0001\u0004_\nT\u0017a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2a\u0015B\"\u0011\u001d\u0011)\u0005\na\u0001\u0005g\tQAY=uKN\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0011\u0005\r\"1\nB(\u0005'BaA!\u0014&\u0001\u0004q\u0017\u0001\u00038fo\u001aK'o\u001d;\t\r\tES\u00051\u0001o\u0003%qWm^*fG>tG\r\u0003\u0004\u0003V\u0015\u0002\rA\\\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)1\t\u0019Ca\u0017\u0003^\t}#\u0011\rB2\u0011!\t\tA\nI\u0001\u0002\u0004q\u0007\u0002CA\u0004MA\u0005\t\u0019\u00018\t\u0011\u0005-a\u0005%AA\u00029D\u0011\"a\u0004'!\u0003\u0005\r!a\u0005\t\u0013\u0005ma\u0005%AA\u0002\u0005M\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005SR3A\u001cB6W\t\u0011i\u0007\u0005\u0003\u0003p\teTB\u0001B9\u0015\u0011\u0011\u0019H!\u001e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B<;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tm$\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\"+\t\u0005M!1N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0012\t\u0005\u0005\u001f\u0013I*\u0004\u0002\u0003\u0012*!!1\u0013BK\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0015\u0001\u00026bm\u0006LA!a\u0014\u0003\u0012\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAd\u0005CC\u0011Ba)/\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u000b\u0005\u0004\u0003,\n=\u0016qY\u0007\u0003\u0005[S!AV/\n\t\tE&Q\u0016\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002h\t]\u0006\"\u0003BRa\u0005\u0005\t\u0019AAd\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t5%Q\u0018\u0005\n\u0005G\u000b\u0014\u0011!a\u0001\u0003'\ta!Z9vC2\u001cH\u0003BA4\u0005\u0007D\u0011Ba)3\u0003\u0003\u0005\r!a2)'\u0001\u00119M!4\u0003P\nM'Q\u001bBm\u00057\u0014yN!9\u0011\u0007\u0015\u0014I-C\u0002\u0003L\u0006\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003R\u0006!IF\u0003\u0011!A\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-\u001a\u0011\\Y\u00012'/Z9vK:\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0011qKJ\u001cWM\u001c;jY\u0016\u0004c/\u00197vK\u0002zg\r\t8v[\u0016\u0014\u0018n\u0019\u0011d_2,XN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t\u0007\u0005]3sG\u0016tG/Y4f]\u0001\"\u0006.\u001a\u0011wC2,X\rI8gAA,'oY3oi\u0006<W\rI7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016T\u0001\u0005\t\u0011!A\u0001\u0002c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,\u0007\u0005]8tSRLg/\u001a\u0011j]R,wM]1m\u0015)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011beJ\f\u0017\u0010\u000b9fe\u000e,g\u000e^1hKF\u00023\f\f\u0011qKJ\u001cWM\u001c;bO\u0016\u0014TL\f\u0018/S\u0001ZF\u0006\t4sKF,XM\\2z;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004S\r_1di*\u0001\u0003\u0005\t\u0011!AA,'oY3oi&dW\r\t<bYV,\u0007%\u0019:sCf\u0004sN\u001a\u0011ok6,'/[2!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK\"\u001a\u0018F\f\u0011FC\u000eD\u0007E^1mk\u0016T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,'\u0002\t\u0011!A\u0001\u0002\u0003o\\:ji&4X\rI5oi\u0016<'/\u00197\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001Bl\u0003\u0005\r%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001a*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005K\u00191S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u0019:sCfD\u0003G\f\u001a6Y\u0001\u0002dfN\u001b*S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&GL\u001b-o9*TL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011i.A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!1]\u0001\u0006e9\nd\u0006M\u0001\u000b!\u0016\u00148-\u001a8uS2,\u0007C\u0001)5'\u0015!$1\u001eB|!5\u0011iOa=o]:\f\u0019\"a\u0005\u0002$5\u0011!q\u001e\u0006\u0004\u0005cl\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005k\u0014yOA\tBEN$(/Y2u\rVt7\r^5p]V\u0002BA!?\u0003\u00006\u0011!1 \u0006\u0005\u0005{\u0014)*\u0001\u0002j_&\u0019aPa?\u0015\u0005\t\u001d\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0015!B1qa2LH\u0003DA\u0012\u0007\u0017\u0019iaa\u0004\u0004\u0012\rM\u0001BBA\u0001o\u0001\u0007a\u000e\u0003\u0004\u0002\b]\u0002\rA\u001c\u0005\u0007\u0003\u00179\u0004\u0019\u00018\t\u0013\u0005=q\u0007%AA\u0002\u0005M\u0001\"CA\u000eoA\u0005\t\u0019AA\n\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u000fUt\u0017\r\u001d9msR!1QDB\u0015!\u0015a6qDB\u0012\u0013\r\u0019\t#\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0015q\u001b)C\u001c8o\u0003'\t\u0019\"C\u0002\u0004(u\u0013a\u0001V;qY\u0016,\u0004\"CB\u0016u\u0005\u0005\t\u0019AA\u0012\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019)\u0004\u0005\u0003\u0003\u0010\u000e]\u0012\u0002BB\u001d\u0005#\u0013aa\u00142kK\u000e$\b")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private transient boolean returnPercentileArray;
    private transient double[] percentages;
    private DataType dataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient scala.collection.immutable.Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private scala.collection.immutable.Seq<Expression> children$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.children;
    }

    @Override
    public final scala.collection.immutable.Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.children$lzycompute() : this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] dArray;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    dArray = null;
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    dArray = new double[]{d};
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    dArray = arrayData.toDoubleArray();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.frequencyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType = this.percentageExpression().dataType();
                DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public scala.collection.immutable.Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
        DoubleType$ percentageExpType = dataType2;
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("The percentage(s) must be a constant literal, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcZD.sp & Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(43).append("Percentage(s) must be between 0.0 and 1.0, ").append(new StringBuilder(8).append("but got ").append(this.percentageExpression()).toString()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    private double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), (ClassTag)ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable)x$1 -> x$1 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw QueryExecutionErrors$.MODULE$.negativeValueUnexpectedError(this.frequencyExpression());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)Percentile.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private scala.collection.immutable.Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq sortedCounts = (scala.collection.immutable.Seq)buffer.toSeq().sortBy((Function1 & Serializable)x$3 -> x$3._1(), ((NumericType)this.child().dataType()).ordering());
        scala.collection.immutable.Seq accumulatedCounts = (scala.collection.immutable.Seq)((IterableOps)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable)(x0$1, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        })).tail();
        long maxPosition = ((Tuple2)accumulatedCounts.last())._2$mcJ$sp() - 1L;
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.percentages()), (Function1)(JFunction1.mcDD.sp & Serializable)percentile -> this.getPercentile((scala.collection.immutable.Seq<Tuple2<Object, Object>>)accumulatedCounts, (double)maxPosition * percentile), (ClassTag)ClassTag$.MODULE$.Double()));
    }

    private Object generateOutput(scala.collection.immutable.Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData((Seq<Object>)results) : results.head());
    }

    private double getPercentile(scala.collection.immutable.Seq<Tuple2<Object, Object>> aggreCounts, double position) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((IterableOnceOps)aggreCounts.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._2$mcJ$sp()))).toArray((ClassTag)ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1 & Serializable)x0$1 -> {
                Percentile.$anonfun$serialize$1(projection, out, buffer, x0$1);
                return BoxedUnit.UNIT;
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
        return byArray;
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), (ClassTag)ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        finally {
            ins.close();
            bis.close();
        }
        return sp2;
    }

    @Override
    public Percentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "percentageExpression";
                break;
            }
            case 2: {
                string = "frequencyExpression";
                break;
            }
            case 3: {
                string = "mutableAggBufferOffset";
                break;
            }
            case 4: {
                string = "inputAggBufferOffset";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable)x$2 -> x$2 + count);
        return l;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(UnsafeProjection projection$1, DataOutputStream out$1, byte[] buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        InternalRow row = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
        UnsafeRow unsafeRow = projection$1.apply(row);
        out$1.writeInt(unsafeRow.getSizeInBytes());
        unsafeRow.writeToStream(out$1, buffer$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

