/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HashExpression;
import org.apache.spark.sql.catalyst.expressions.XXH64;
import org.apache.spark.sql.catalyst.expressions.XxHash64$;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr1, expr2, ...) - Returns a 64-bit hash value of the arguments.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', array(123), 2);\n       5602566077635097486\n  ", since="3.0.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u000f\u001f\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000f\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005Q\u0001\tE\t\u0015!\u00031\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Y\u0007\u0001\"\u0015c\u0011\u0015a\u0007\u0001\"\u0015n\u0011\u0015)\b\u0001\"\u0015w\u0011\u001da\b!!A\u0005\u0002uD\u0011\"!\u0001\u0001#\u0003%\t!a\u0001\t\u0013\u0005e\u0001!%A\u0005\u0002\u0005m\u0001\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0011%\t\t\u0004AA\u0001\n\u0003\t\u0019\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0001\u0002>!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0003'\u0002\u0011\u0011!C\u0001\u0003+B\u0011\"a\u0018\u0001\u0003\u0003%\t%!\u0019\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001dt!CAF=\u0005\u0005\t\u0012AAG\r!ib$!A\t\u0002\u0005=\u0005BB)\u0018\t\u0003\t9\u000bC\u0005\u0002*^\t\t\u0011\"\u0012\u0002,\"I\u0011QV\f\u0002\u0002\u0013\u0005\u0015q\u0016\u0005\n\u0003k;\u0012\u0011!CA\u0003oC\u0011\"!3\u0018\u0003\u0003%I!a3\u0003\u0011aC\b*Y:imQR!a\b\u0011\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003C\t\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003G\u0011\n1a]9m\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<7\u0001A\n\u0005\u000112\u0014\bE\u0002.]Aj\u0011AH\u0005\u0003_y\u0011a\u0002S1tQ\u0016C\bO]3tg&|g\u000e\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003M_:<\u0007CA\u00198\u0013\tA$GA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0012eBA\u001eA\u001d\tat(D\u0001>\u0015\tq$&\u0001\u0004=e>|GOP\u0005\u0002g%\u0011\u0011IM\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Be\u0005A1\r[5mIJ,g.F\u0001H!\rQ\u0004JS\u0005\u0003\u0013\u0012\u00131aU3r!\ti3*\u0003\u0002M=\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013\rD\u0017\u000e\u001c3sK:\u0004\u0013\u0001B:fK\u0012,\u0012\u0001M\u0001\u0006g\u0016,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M#V\u000b\u0005\u0002.\u0001!)Q)\u0002a\u0001\u000f\")a*\u0002a\u0001aQ\u00111k\u0016\u0005\u00061\u001a\u0001\raR\u0001\nCJ<W/\\3oiN\f\u0001\u0002Z1uCRK\b/Z\u000b\u00027B\u0011AlX\u0007\u0002;*\u0011aLI\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A2\u0011\u0005\u0011DgBA3g!\ta$'\u0003\u0002he\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9''A\biCNDWM]\"mCN\u001ch*Y7f\u0003-\u0019w.\u001c9vi\u0016D\u0015m\u001d5\u0015\tAr7\u000f\u001e\u0005\u0006_*\u0001\r\u0001]\u0001\u0006m\u0006dW/\u001a\t\u0003cEL!A\u001d\u001a\u0003\u0007\u0005s\u0017\u0010C\u0003Z\u0015\u0001\u00071\fC\u0003O\u0015\u0001\u0007\u0001'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u00111k\u001e\u0005\u0006q.\u0001\r!_\u0001\f]\u0016<8\t[5mIJ,g\u000eE\u0002;u*K!a\u001f#\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHcA*\u007f\u007f\"9Q\t\u0004I\u0001\u0002\u00049\u0005b\u0002(\r!\u0003\u0005\r\u0001M\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)AK\u0002H\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\u0011\u0014AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiBK\u00021\u0003\u000f\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tA\u0001\\1oO*\u0011\u0011QF\u0001\u0005U\u00064\u0018-C\u0002j\u0003O\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u000e\u0011\u0007E\n9$C\u0002\u0002:I\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001]A \u0011%\t\t%EA\u0001\u0002\u0004\t)$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0002R!!\u0013\u0002PAl!!a\u0013\u000b\u0007\u00055#'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0015\u0002L\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9&!\u0018\u0011\u0007E\nI&C\u0002\u0002\\I\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002BM\t\t\u00111\u0001q\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00121\r\u0005\n\u0003\u0003\"\u0012\u0011!a\u0001\u0003k\ta!Z9vC2\u001cH\u0003BA,\u0003SB\u0001\"!\u0011\u0016\u0003\u0003\u0005\r\u0001\u001d\u0015\u0014\u0001\u00055\u00141OA;\u0003s\nY(a \u0002\u0002\u0006\u0015\u0015q\u0011\t\u0004[\u0005=\u0014bAA9=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA<\u0003%{f)\u0016(D?\"*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:3Y\u0001rcFL\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t\u001c5[\tLG\u000f\t5bg\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\n'oZ;nK:$8OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QP\u0001\\\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u001eb\u0003%\u0019:sCfD\u0013GM\u001a*Y\u0001\u0012\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00116mA\u0012TG\u000e\u001c1o]24'\u000e\u0019:oQBdG\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019)A\u00034]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\n\u0006Q\u0001.Y:i?\u001a,hnY:\u0002\u0011aC\b*Y:imQ\u0002\"!L\f\u0014\u000b]\t\t*!(\u0011\u000f\u0005M\u0015\u0011T$1'6\u0011\u0011Q\u0013\u0006\u0004\u0003/\u0013\u0014a\u0002:v]RLW.Z\u0005\u0005\u00037\u000b)JA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000bY#\u0001\u0002j_&\u00191)!)\u0015\u0005\u00055\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0012!B1qa2LH#B*\u00022\u0006M\u0006\"B#\u001b\u0001\u00049\u0005\"\u0002(\u001b\u0001\u0004\u0001\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003s\u000b)\rE\u00032\u0003w\u000by,C\u0002\u0002>J\u0012aa\u00149uS>t\u0007#B\u0019\u0002B\u001e\u0003\u0014bAAbe\t1A+\u001e9mKJB\u0001\"a2\u001c\u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAg!\u0011\t)#a4\n\t\u0005E\u0017q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class XxHash64
extends HashExpression<Object>
implements Serializable {
    private final Seq<Expression> children;
    private final long seed;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(XxHash64 xxHash64) {
        return XxHash64$.MODULE$.unapply(xxHash64);
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, XxHash64> tupled() {
        return XxHash64$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, XxHash64>> curried() {
        return XxHash64$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "xxhash64";
    }

    @Override
    public String hasherClassName() {
        return XXH64.class.getName();
    }

    @Override
    public long computeHash(Object value, DataType dataType, long seed) {
        return XxHash64Function$.MODULE$.hash(value, dataType, seed);
    }

    @Override
    public XxHash64 withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public XxHash64 copy(Seq<Expression> children2, long seed) {
        return new XxHash64(children2, seed);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public long copy$default$2() {
        return this.seed();
    }

    @Override
    public String productPrefix() {
        return "XxHash64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.seed());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XxHash64;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "seed";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XxHash64)) return false;
        boolean bl = true;
        if (!bl) return false;
        XxHash64 xxHash64 = (XxHash64)x$1;
        if (this.seed() != xxHash64.seed()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = xxHash64.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!xxHash64.canEqual(this)) return false;
        return true;
    }

    public XxHash64(Seq<Expression> children2, long seed) {
        this.children = children2;
        this.seed = seed;
    }

    public XxHash64(Seq<Expression> arguments) {
        this(arguments, 42L);
    }
}

