/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.TimeWindow$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(time_column, window_duration[, slide_duration[, start_time]]) - Bucketize rows into one or more time windows given a timestamp specifying column.\n      Window starts are inclusive but the window ends are exclusive, e.g. 12:05 will be in the window [12:05,12:10) but not in [12:00,12:05).\n      Windows can support microsecond precision. Windows in the order of months are not supported.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#window-operations-on-event-time\">'Window Operations on Event Time'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * window_duration - A string specifying the width of the window represented as \"interval value\".\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.)\n        Note that the duration is a fixed length of time, and does not vary over time according to a calendar.\n      * slide_duration - A string specifying the sliding interval of the window represented as \"interval value\".\n        A new window will be generated every `slide_duration`. Must be less than or equal to the `window_duration`.\n        This duration is likewise absolute, and does not vary according to a calendar.\n      * start_time - The offset with respect to 1970-01-01 00:00:00 UTC with which to start window intervals.\n        For example, in order to have hourly tumbling windows that start 15 minutes past the hour,\n        e.g. 12:15-13:15, 13:15-14:15... provide `start_time` as `15 minutes`.\n  ", examples="\n    Examples:\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:10:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:05:00\t1\n      > SELECT a, window.start, window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:06:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '10 minutes', '5 minutes') ORDER BY a, start;\n        A1\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t2\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t3\n        A1\t2021-01-01 00:05:00\t2021-01-01 00:15:00\t1\n        A2\t2020-12-31 23:55:00\t2021-01-01 00:05:00\t1\n        A2\t2021-01-01 00:00:00\t2021-01-01 00:10:00\t1\n  ", group="datetime_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u0016-\u0001fB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005e\u0001\tE\t\u0015!\u0003b\u0011!)\u0007A!f\u0001\n\u0003\u0001\u0007\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B1\t\u0011\u001d\u0004!Q3A\u0005\u0002\u0001D\u0001\u0002\u001b\u0001\u0003\u0012\u0003\u0006I!\u0019\u0005\u0006S\u0002!\tA\u001b\u0005\u0006S\u0002!\t\u0001\u001d\u0005\u0006S\u0002!\t!\u001e\u0005\u0006S\u0002!\t!\u001f\u0005\u0006y\u0002!\tE\u0017\u0005\u0006{\u0002!\tE \u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\tY\u0002\u0001C!\u0003;A\u0011\"a\f\u0001\u0005\u0004%)%!\r\t\u0011\u0005}\u0003\u0001)A\u0007\u0003gA!\"!\u0019\u0001\u0011\u000b\u0007I\u0011IA2\u0011\u001d\tY\u0007\u0001C!\u0003[Bq!a\u001f\u0001\t#\ni\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011q\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003SC\u0011\"!,\u0001#\u0003%\t!!+\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005%\u0006\"CAY\u0001\u0005\u0005I\u0011IAZ\u0011%\t\u0019\rAA\u0001\n\u0003\t)\rC\u0005\u0002N\u0002\t\t\u0011\"\u0001\u0002P\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003W\u0004\u0011\u0011!C\u0001\u0003[D\u0011\"!=\u0001\u0003\u0003%\t%a=\t\u0013\u0005]\b!!A\u0005B\u0005exa\u0002B\u0012Y!\u0005!Q\u0005\u0004\u0007W1B\tAa\n\t\r%\u001cC\u0011\u0001B\u001d\u0011\u001d\u0011Yd\tC\u0001\u0005{AqAa\u0011$\t\u0003\u0011)\u0005C\u0004\u0003L\r\"\tA!\u0014\t\u0013\t-3%!A\u0005\u0002\n]\u0003\"\u0003B1G\u0005\u0005I\u0011\u0011B2\u0011%\u0011)hIA\u0001\n\u0013\u00119H\u0001\u0006US6,w+\u001b8e_^T!!\f\u0018\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003_A\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\b\u0001ir\u0014\tR$N!\tYD(D\u0001-\u0013\tiDFA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYt(\u0003\u0002AY\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002<\u0005&\u00111\t\f\u0002\f+:,g/\u00197vC\ndW\r\u0005\u0002<\u000b&\u0011a\t\f\u0002\u0011\u001d>t7+\u0015'FqB\u0014Xm]:j_:\u0004\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002O-:\u0011q\n\u0016\b\u0003!Nk\u0011!\u0015\u0006\u0003%b\na\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005UK\u0015a\u00029bG.\fw-Z\u0005\u0003/b\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!V%\u0002\u0015QLW.Z\"pYVlg.F\u0001\\!\tYD,\u0003\u0002^Y\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0017QLW.Z\"pYVlg\u000eI\u0001\u000fo&tGm\\<EkJ\fG/[8o+\u0005\t\u0007C\u0001%c\u0013\t\u0019\u0017J\u0001\u0003M_:<\u0017aD<j]\u0012|w\u000fR;sCRLwN\u001c\u0011\u0002\u001bMd\u0017\u000eZ3EkJ\fG/[8o\u00039\u0019H.\u001b3f\tV\u0014\u0018\r^5p]\u0002\n\u0011b\u001d;beR$\u0016.\\3\u0002\u0015M$\u0018M\u001d;US6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006W2lgn\u001c\t\u0003w\u0001AQ!W\u0005A\u0002mCQaX\u0005A\u0002\u0005DQ!Z\u0005A\u0002\u0005DQaZ\u0005A\u0002\u0005$Ra[9sgRDQ!\u0017\u0006A\u0002mCQa\u0018\u0006A\u0002mCQ!\u001a\u0006A\u0002mCQa\u001a\u0006A\u0002m#Ba\u001b<xq\")\u0011l\u0003a\u00017\")ql\u0003a\u00017\")Qm\u0003a\u00017R\u00191N_>\t\u000bec\u0001\u0019A.\t\u000b}c\u0001\u0019A.\u0002\u000b\rD\u0017\u000e\u001c3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001\u0000!\u0015q\u0015\u0011AA\u0003\u0013\r\t\u0019\u0001\u0017\u0002\u0004'\u0016\f\b\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-\u0001'A\u0003usB,7/\u0003\u0003\u0002\u0010\u0005%!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u000b!\u0011\t9!a\u0006\n\t\u0005e\u0011\u0011\u0002\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003SqA!a\t\u0002&A\u0011\u0001+S\u0005\u0004\u0003OI\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(%\u000bAB\\8eKB\u000bG\u000f^3s]N,\"!a\r\u0011\u000b9\u000b\t!!\u000e\u0011\t\u0005]\u0012\u0011\f\b\u0005\u0003s\t\u0019F\u0004\u0003\u0002<\u0005=c\u0002BA\u001f\u0003\u001brA!a\u0010\u0002L9!\u0011\u0011IA%\u001d\u0011\t\u0019%a\u0012\u000f\u0007A\u000b)%C\u00018\u0013\t)d'\u0003\u00024i%\u0011\u0011GM\u0005\u0003_AJ1!!\u0015/\u0003\u0015!(/Z3t\u0013\u0011\t)&a\u0016\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u0003#r\u0013\u0002BA.\u0003;\u00121\u0002\u0016:fKB\u000bG\u000f^3s]*!\u0011QKA,\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005A!/Z:pYZ,G-\u0006\u0002\u0002fA\u0019\u0001*a\u001a\n\u0007\u0005%\u0014JA\u0004C_>dW-\u00198\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005Ud&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tI(a\u001d\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA6\u0002\u0000!1\u0011\u0011Q\u000bA\u0002m\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\u0005l\u0003\u000f\u000bI)a#\u0002\u000e\"9\u0011L\u0006I\u0001\u0002\u0004Y\u0006bB0\u0017!\u0003\u0005\r!\u0019\u0005\bKZ\u0001\n\u00111\u0001b\u0011\u001d9g\u0003%AA\u0002\u0005\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014*\u001a1,!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002,*\u001a\u0011-!&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00026B!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001\u00027b]\u001eT!!a0\u0002\t)\fg/Y\u0005\u0005\u0003W\tI,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002HB\u0019\u0001*!3\n\u0007\u0005-\u0017JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002R\u0006]\u0007c\u0001%\u0002T&\u0019\u0011Q[%\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002Zv\t\t\u00111\u0001\u0002H\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a8\u0011\r\u0005\u0005\u0018q]Ai\u001b\t\t\u0019OC\u0002\u0002f&\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI/a9\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\ny\u000fC\u0005\u0002Z~\t\t\u00111\u0001\u0002R\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t),!>\t\u0013\u0005e\u0007%!AA\u0002\u0005\u001d\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002f\u0005m\b\"CAmC\u0005\u0005\t\u0019AAiQ]\u0001\u0011q B\u0003\u0005\u000f\u0011YA!\u0004\u0003\u0012\tM!q\u0003B\r\u0005;\u0011y\u0002E\u0002<\u0005\u0003I1Aa\u0001-\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0003\u0002\u000b\u0017Q\u0001\u0005\t\u0011!?\u001a+fjQ0)i&lWmX2pYVlg\u000e\f\u0011xS:$wn^0ekJ\fG/[8o72\u00023\u000f\\5eK~#WO]1uS>t7\f\f\u0011ti\u0006\u0014Ho\u0018;j[\u0016lV,\u000b\u0011.A\t+8m[3uSj,\u0007E]8xg\u0002Jg\u000e^8!_:,\u0007e\u001c:![>\u0014X\r\t;j[\u0016\u0004s/\u001b8e_^\u001c\beZ5wK:\u0004\u0013\r\t;j[\u0016\u001cH/Y7qAM\u0004XmY5gs&tw\rI2pYVlgN\f\u0006!A\u0001\u0002\u0003\u0005I,j]\u0012|w\u000fI:uCJ$8\u000fI1sK\u0002Jgn\u00197vg&4X\r\t2vi\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0011f]\u0012\u001c\b%\u0019:fA\u0015D8\r\\;tSZ,G\u0006I3/O:\u0002\u0013G\r\u001e1k\u0001:\u0018\u000e\u001c7!E\u0016\u0004\u0013N\u001c\u0011uQ\u0016\u0004s/\u001b8e_^\u00043,\r\u001a;aUb\u0013G\r\u001e2a%\u0002#-\u001e;!]>$\b%\u001b8!7F\u0012$\b\r\u0019-cIR\u0004'N\u0015/\u0015\u0001\u0002\u0003\u0005\t\u0011!/&tGm\\<tA\r\fg\u000eI:vaB|'\u000f\u001e\u0011nS\u000e\u0014xn]3d_:$\u0007\u0005\u001d:fG&\u001c\u0018n\u001c8/A]Kg\u000eZ8xg\u0002Jg\u000e\t;iK\u0002z'\u000fZ3sA=4\u0007%\\8oi\"\u001c\b%\u0019:fA9|G\u000fI:vaB|'\u000f^3e])\u0001\u0003\u0005\t\u0011!AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001aHO];diV\u0014X\rZ\u0017tiJ,\u0017-\\5oO6\u0002(o\\4sC6l\u0017N\\4.OVLG-\u001a\u0018ii6d7e^5oI><Xf\u001c9fe\u0006$\u0018n\u001c8t[=tW&\u001a<f]RlC/[7fEy:s+\u001b8e_^\u0004s\n]3sCRLwN\\:!_:\u0004SI^3oi\u0002\"\u0016.\\3(y=\ng\bI5oAM#(/^2ukJ,G\rI*ue\u0016\fW.\u001b8hA\u001d,\u0018\u000eZ3!I>\u001c\u0007EZ8sA\u0011,G/Y5mK\u0012\u0004S\r\u001f9mC:\fG/[8oA\u0005tG\rI3yC6\u0004H.Z:/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\u0011y!\u0001E\\\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C/[7f?\u000e|G.^7oA5\u0002C\u000b[3!G>dW/\u001c8!_J\u0004C\u000f[3!Kb\u0004(/Z:tS>t\u0007\u0005^8!kN,\u0007%Y:!i\",\u0007\u0005^5nKN$\u0018-\u001c9!M>\u0014\be^5oI><\u0018N\\4!Ef\u0004C/[7f]\u0001\"\u0006.\u001a\u0011uS6,\u0007eY8mk6t\u0007%\\;ti\u0002\u0012W\rI8gAQKW.Z:uC6\u0004H+\u001f9f])\u0001\u0003\u0005\t\u0011!A)\u0002s/\u001b8e_^|F-\u001e:bi&|g\u000eI\u0017!\u0003\u0002\u001aHO]5oO\u0002\u001a\b/Z2jMfLgn\u001a\u0011uQ\u0016\u0004s/\u001b3uQ\u0002zg\r\t;iK\u0002:\u0018N\u001c3po\u0002\u0012X\r\u001d:fg\u0016tG/\u001a3!CN\u0004#%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XM\t\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A!\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006\\5uKJ\fGn\u001d\u0018ii6d7%\u001b8uKJ4\u0018\r\\\u0017mSR,'/\u00197#}%sG/\u001a:wC2\u0004C*\u001b;fe\u0006dGhL1?A\u0019|'\u000fI7pe\u0016\u0004C-\u001a;bS2\u001ch&\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u001d>$X\r\t;iCR\u0004C\u000f[3!IV\u0014\u0018\r^5p]\u0002J7\u000fI1!M&DX\r\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\u0018.\\3-A\u0005tG\r\t3pKN\u0004cn\u001c;!m\u0006\u0014\u0018\u0010I8wKJ\u0004C/[7fA\u0005\u001c7m\u001c:eS:<\u0007\u0005^8!C\u0002\u001a\u0017\r\\3oI\u0006\u0014hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tY&$Wm\u00183ve\u0006$\u0018n\u001c8![\u0001\n\u0005e\u001d;sS:<\u0007e\u001d9fG&4\u00170\u001b8hAQDW\rI:mS\u0012Lgn\u001a\u0011j]R,'O^1mA=4\u0007\u0005\u001e5fA]Lg\u000eZ8xAI,\u0007O]3tK:$X\r\u001a\u0011bg\u0002\u0012\u0013N\u001c;feZ\fG\u000e\t<bYV,'E\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003\u0002rWm\u001e\u0011xS:$wn\u001e\u0011xS2d\u0007EY3!O\u0016tWM]1uK\u0012\u0004SM^3ss\u0002\u00027\u000f\\5eK~#WO]1uS>t\u0007M\f\u0011NkN$\bEY3!Y\u0016\u001c8\u000f\t;iC:\u0004sN\u001d\u0011fcV\fG\u000e\t;pAQDW\r\t1xS:$wn^0ekJ\fG/[8oA:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165jg\u0002\"WO]1uS>t\u0007%[:!Y&\\Wm^5tK\u0002\n'm]8mkR,G\u0006I1oI\u0002\"w.Z:!]>$\bE^1ss\u0002\n7mY8sI&tw\r\t;pA\u0005\u00043-\u00197f]\u0012\f'O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\f'\u000f^0uS6,\u0007%\f\u0011UQ\u0016\u0004sN\u001a4tKR\u0004s/\u001b;iAI,7\u000f]3di\u0002\"x\u000eI\u0019:oAj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002\u0004%\u0016+DA]LG\u000f\u001b\u0011xQ&\u001c\u0007\u000e\t;pAM$\u0018M\u001d;!o&tGm\\<!S:$XM\u001d<bYNt#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\u001b8!_J$WM\u001d\u0011u_\u0002B\u0017M^3!Q>,(\u000f\\=!iVl'\r\\5oO\u0002:\u0018N\u001c3poN\u0004C\u000f[1uAM$\u0018M\u001d;!cU\u0002S.\u001b8vi\u0016\u001c\b\u0005]1ti\u0002\"\b.\u001a\u0011i_V\u0014HF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u001dt\u0003%\r\u001a;cUj\u0013g\r\u001e2k1\u0002\u0013g\r\u001e2k5\nDGO\u00196]9r\u0003\u0005\u001d:pm&$W\r\t1ti\u0006\u0014Ho\u0018;j[\u0016\u0004\u0007%Y:!AF*\u0004%\\5okR,7\u000f\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005+\tqq\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u0002s/\u001b8e_^t3\u000f^1si2\u0002s/\u001b8e_^tSM\u001c3-A\r|WO\u001c;)U%\u0002\u0013m\u001d\u0011d]R\u0004cIU(NAY\u000bE*V#TA!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191O%b\u0003\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA2$\b\r\u0019(S1\u0002\u0003fJ!3O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aA:\u0013\u0006I!TAQ\f'\rK1-A\tL\u0003e\u0012*P+B\u0003#-\u001f\u0011bY\u0001zf)\u0016(D?\"\u0012G\u0006I\u00146A5Lg.\u001e;fg\u001eJ\u0003e\u0014*E\u000bJ\u0003#)\u0017\u0011bY\u0001\u001aH/\u0019:uw)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00196uA\u0002\u0014B\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\u000e\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\n\u0004G\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001\u0002\u0003%\u0011\u001a\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ki\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003e^5oI><hf\u001d;beRd\u0003e^5oI><h&\u001a8eY\u0001\u001aw.\u001e8uQ)J\u0003%Y:!G:$\bE\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bs%Q\u0019(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a\u001dJC\u0006\t\u0015(\u0003F:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ii\u001a\u0004gJ\u0015-A!:\u0013)M\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002dG\u000f\u00191O%b\u0003\u0005K\u0014Be\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00192uA\u0002t%\u000b\u0011B'\u0002\"\u0018M\u0019\u0015bY\u0001\u0012\u0017\u0006I$S\u001fV\u0003\u0006EY=!C2\u0002sLR+O\u0007~C#\r\f\u0011(cA\u0002S.\u001b8vi\u0016\u001cx\u0005\f\u0011(k\u0001j\u0017N\\;uKN<\u0013\u0006I(S\t\u0016\u0013\u0006EQ-!C2\u00023\u000f^1sinR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0004'L\u00193[M\n\u0004EM\u001a;kUR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ki\u0002\u0004'\u0003\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014\u0007\r\u001e1a%\u0019$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!2\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA*$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cUR\u0004\u0007M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eAj\u0013GM\u00174c\u0001\u00124GO\u001b6uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;aAJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Be%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE\u0002$\b\r\u0019\nc)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003\u001c\u0005qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0011\u0003\u0015\u0011d\u0006\r\u00181\u0003)!\u0016.\\3XS:$wn\u001e\t\u0003w\r\u001aRa\tB\u0015\u0005_\u00012\u0001\u0013B\u0016\u0013\r\u0011i#\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\t\tE\"qG\u0007\u0003\u0005gQAA!\u000e\u0002>\u0006\u0011\u0011n\\\u0005\u0004/\nMBC\u0001B\u0013\u0003e9W\r^%oi\u0016\u0014h/\u00197J]6K7M]8TK\u000e|g\u000eZ:\u0015\u0007\u0005\u0014y\u0004C\u0004\u0003B\u0015\u0002\r!a\b\u0002\u0011%tG/\u001a:wC2\fq\u0002]1sg\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0004C\n\u001d\u0003B\u0002B%M\u0001\u00071,\u0001\u0003fqB\u0014\u0018!B1qa2LH#C6\u0003P\tE#1\u000bB+\u0011\u0015Iv\u00051\u0001\\\u0011\u0019yv\u00051\u0001\u0002 !1Qm\na\u0001\u0003?AaaZ\u0014A\u0002\u0005}A#C6\u0003Z\tm#Q\fB0\u0011\u0015I\u0006\u00061\u0001\\\u0011\u0015y\u0006\u00061\u0001b\u0011\u0015)\u0007\u00061\u0001b\u0011\u00159\u0007\u00061\u0001b\u0003\u001d)h.\u00199qYf$BA!\u001a\u0003rA)\u0001Ja\u001a\u0003l%\u0019!\u0011N%\u0003\r=\u0003H/[8o!\u001dA%QN.bC\u0006L1Aa\u001cJ\u0005\u0019!V\u000f\u001d7fi!A!1O\u0015\u0002\u0002\u0003\u00071.A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u001f\u0011\t\u0005]&1P\u0005\u0005\u0005{\nIL\u0001\u0004PE*,7\r\u001e")
public class TimeWindow
extends UnaryExpression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final long windowDuration;
    private final long slideDuration;
    private final long startTime;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Object, Object, Object>> unapply(TimeWindow timeWindow) {
        return TimeWindow$.MODULE$.unapply(timeWindow);
    }

    public static long parseExpression(Expression expression) {
        return TimeWindow$.MODULE$.parseExpression(expression);
    }

    public static long getIntervalInMicroSeconds(String string) {
        return TimeWindow$.MODULE$.getIntervalInMicroSeconds(string);
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public long windowDuration() {
        return this.windowDuration;
    }

    public long slideDuration() {
        return this.slideDuration;
    }

    public long startTime() {
        return this.startTime;
    }

    @Override
    public Expression child() {
        return this.timeColumn();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AnyTimestampType$[]{AnyTimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", this.child().dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public String prettyName() {
        return "window";
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        TimeWindow timeWindow = this;
        synchronized (timeWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var1_1;
        TypeCheckResult dataTypeCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (dataTypeCheck.isSuccess()) {
            if (this.windowDuration() <= 0L) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("The window duration (").append(this.windowDuration()).append(") must be greater than 0.").toString());
            }
            if (this.slideDuration() <= 0L) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("The slide duration (").append(this.slideDuration()).append(") must be greater than 0.").toString());
            }
            if (this.slideDuration() > this.windowDuration()) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(48).append("The slide duration (").append(this.slideDuration()).append(") must be less than or equal").toString()).append(new StringBuilder(26).append(" to the windowDuration (").append(this.windowDuration()).append(").").toString()).toString());
            }
            if (RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(this.startTime())) >= this.slideDuration()) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(49).append("The absolute value of start time (").append(this.startTime()).append(") must be less ").toString()).append(new StringBuilder(26).append("than the slideDuration (").append(this.slideDuration()).append(").").toString()).toString());
            }
        }
        return var1_1;
    }

    @Override
    public TimeWindow withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public TimeWindow copy(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        return new TimeWindow(timeColumn, windowDuration, slideDuration, startTime);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public long copy$default$2() {
        return this.windowDuration();
    }

    public long copy$default$3() {
        return this.slideDuration();
    }

    public long copy$default$4() {
        return this.startTime();
    }

    @Override
    public String productPrefix() {
        return "TimeWindow";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.timeColumn();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.windowDuration());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.slideDuration());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToLong((long)this.startTime());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimeWindow;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "timeColumn";
                break;
            }
            case 1: {
                string = "windowDuration";
                break;
            }
            case 2: {
                string = "slideDuration";
                break;
            }
            case 3: {
                string = "startTime";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimeWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimeWindow timeWindow = (TimeWindow)x$1;
        if (this.windowDuration() != timeWindow.windowDuration()) return false;
        if (this.slideDuration() != timeWindow.slideDuration()) return false;
        if (this.startTime() != timeWindow.startTime()) return false;
        Expression expression = this.timeColumn();
        Expression expression2 = timeWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!timeWindow.canEqual(this)) return false;
        return true;
    }

    public TimeWindow(Expression timeColumn, long windowDuration, long slideDuration, long startTime) {
        this.timeColumn = timeColumn;
        this.windowDuration = windowDuration;
        this.slideDuration = slideDuration;
        this.startTime = startTime;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.TIME_WINDOW()}));
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration, Expression startTime) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), TimeWindow$.MODULE$.parseExpression(startTime));
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration, Expression slideDuration) {
        this(timeColumn, TimeWindow$.MODULE$.parseExpression(windowDuration), TimeWindow$.MODULE$.parseExpression(slideDuration), 0L);
    }

    public TimeWindow(Expression timeColumn, Expression windowDuration) {
        this(timeColumn, windowDuration, windowDuration);
    }
}

