/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(BOTH FROM str) - Removes the leading and trailing space characters from `str`.\n\n    _FUNC_(LEADING FROM str) - Removes the leading space characters from `str`.\n\n    _FUNC_(TRAILING FROM str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(BOTH trimStr FROM str) - Remove the leading and trailing `trimStr` characters from `str`.\n\n    _FUNC_(LEADING trimStr FROM str) - Remove the leading `trimStr` characters from `str`.\n\n    _FUNC_(TRAILING trimStr FROM str) - Remove the trailing `trimStr` characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n      * BOTH, FROM - these are keywords to specify trimming string characters from both ends of\n          the string\n      * LEADING, FROM - these are keywords to specify trimming string characters from the left\n          end of the string\n      * TRAILING, FROM - these are keywords to specify trimming string characters from the right\n          end of the string\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(BOTH FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(LEADING FROM '    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_(TRAILING FROM '    SparkSQL   ');\n           SparkSQL\n      > SELECT _FUNC_('SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(BOTH 'SL' FROM 'SSparkSQLS');\n       parkSQ\n      > SELECT _FUNC_(LEADING 'SL' FROM 'SSparkSQLS');\n       parkSQLS\n      > SELECT _FUNC_(TRAILING 'SL' FROM 'SSparkSQLS');\n       SSparkSQ\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055x!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005BB#\u0002\t\u0003\t)\r\u0003\u0005F\u0003\u0005\u0005I\u0011QAe\u0011%\ty-AI\u0001\n\u0003\t9\u0005C\u0005\u0002R\u0006\t\t\u0011\"!\u0002T\"I\u0011\u0011]\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003G\f\u0011\u0011!C\u0005\u0003K4Aa\r\u0013A\u0011\"AQL\u0003BK\u0002\u0013\u0005a\f\u0003\u0005`\u0015\tE\t\u0015!\u0003J\u0011!\u0001'B!f\u0001\n\u0003\t\u0007\u0002C3\u000b\u0005#\u0005\u000b\u0011\u00022\t\u000b\rSA\u0011\u00014\t\u000b\rSA\u0011A5\t\u000b\rSA\u0011\u00017\t\u000b9TA\u0011I8\t\u000baTA\u0011K8\t\u000beTA\u0011\t>\t\reTA\u0011IA\u0006\u0011!\t\u0019B\u0003b\u0001\n\u0003z\u0007bBA\u000b\u0015\u0001\u0006I\u0001\u001d\u0005\b\u0003/QA\u0011KA\r\u0011%\t)CCA\u0001\n\u0003\t9\u0003C\u0005\u0002.)\t\n\u0011\"\u0001\u00020!I\u0011Q\t\u0006\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u0017R\u0011\u0011!C!\u0003\u001bB\u0011\"!\u0017\u000b\u0003\u0003%\t!a\u0017\t\u0013\u0005\r$\"!A\u0005\u0002\u0005\u0015\u0004\"CA9\u0015\u0005\u0005I\u0011IA:\u0011%\t\tICA\u0001\n\u0003\t\u0019\tC\u0005\u0002\u000e*\t\t\u0011\"\u0011\u0002\u0010\"I\u00111\u0013\u0006\u0002\u0002\u0013\u0005\u0013QS\u0001\u000b'R\u0014\u0018N\\4Ue&l'BA\u0013'\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dB\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005I\nQ\"\u0001\u0013\u0003\u0015M#(/\u001b8h)JLWnE\u0002\u0002km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012a!\u00118z%\u00164\u0007C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\tIwNC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u00012\u0003\u0015\t\u0007\u000f\u001d7z)\u00159\u0015qXAb!\t\u0011$bE\u0003\u000b\u00132{%\u000b\u0005\u00023\u0015&\u00111\n\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001aN\u0013\tqEEA\u000bTiJLgn\u001a\u001aUe&lW\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Y\u0002\u0016BA)8\u0005\u001d\u0001&o\u001c3vGR\u0004\"aU.\u000f\u0005QKfBA+Y\u001b\u00051&BA,1\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002[o\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"]\u0015\tQv'\u0001\u0004te\u000e\u001cFO]\u000b\u0002\u0013\u000691O]2TiJ\u0004\u0013a\u0002;sS6\u001cFO]\u000b\u0002EB\u0019agY%\n\u0005\u0011<$AB(qi&|g.\u0001\u0005ue&l7\u000b\u001e:!)\r9u\r\u001b\u0005\u0006;>\u0001\r!\u0013\u0005\bA>\u0001\n\u00111\u0001c)\r9%n\u001b\u0005\u0006AB\u0001\r!\u0013\u0005\u0006;B\u0001\r!\u0013\u000b\u0003\u000f6DQ!X\tA\u0002%\u000b!\u0002\u001d:fiRLh*Y7f+\u0005\u0001\bCA9v\u001d\t\u00118\u000f\u0005\u0002Vo%\u0011AoN\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uo\u0005IA-\u001b:fGRLwN\\\u0001\u0007I>,e/\u00197\u0015\u0007m\f9\u0001E\u0002}\u0003\u0007i\u0011! \u0006\u0003}~\fQ\u0001^=qKNT1!!\u0001+\u0003\u0019)hn]1gK&\u0019\u0011QA?\u0003\u0015U#f\tO*ue&tw\r\u0003\u0004\u0002\nQ\u0001\ra_\u0001\ngJ\u001c7\u000b\u001e:j]\u001e$Ra_A\u0007\u0003\u001fAa!!\u0003\u0016\u0001\u0004Y\bBBA\t+\u0001\u000710\u0001\u0006ue&l7\u000b\u001e:j]\u001e\f!\u0002\u001e:j[6+G\u000f[8e\u0003-!(/[7NKRDw\u000e\u001a\u0011\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA%\u0002\u001c!9\u0011Q\u0004\rA\u0002\u0005}\u0011a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BaUA\u0011\u0013&\u0019\u00111\u0005/\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#B$\u0002*\u0005-\u0002bB/\u001a!\u0003\u0005\r!\u0013\u0005\bAf\u0001\n\u00111\u0001c\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\r+\u0007%\u000b\u0019d\u000b\u0002\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012!C;oG\",7m[3e\u0015\r\tydN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\"\u0003s\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0013+\u0007\t\f\u0019$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+z\u0014\u0001\u00027b]\u001eL1A^A*\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0006E\u00027\u0003?J1!!\u00198\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9'!\u001c\u0011\u0007Y\nI'C\u0002\u0002l]\u00121!\u00118z\u0011%\tyGHA\u0001\u0002\u0004\ti&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0002b!a\u001e\u0002~\u0005\u001dTBAA=\u0015\r\tYhN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA@\u0003s\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QQAF!\r1\u0014qQ\u0005\u0004\u0003\u0013;$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003_\u0002\u0013\u0011!a\u0001\u0003O\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qJAI\u0011%\ty'IA\u0001\u0002\u0004\ti&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u000b\u000b9\nC\u0005\u0002p\t\n\t\u00111\u0001\u0002h!:\"\"a'\u0002\"\u0006\r\u0016qUAU\u0003[\u000by+a-\u00026\u0006e\u00161\u0018\t\u0004e\u0005u\u0015bAAPI\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAS\u0003\u0015\u001d&\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b\"P)\"\u0003cIU(NAM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!C:$\u0007\u0005\u001e:bS2Lgn\u001a\u0011ta\u0006\u001cW\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b'F\u0003\u0012Kej\u0012\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,7\u000f\t;iK\u0002bW-\u00193j]\u001e\u00043\u000f]1dK\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011ge>l\u0007\u0005Y:ue\u0002t#B\u0003\u0011!A\u0001zf)\u0016(D?\"\"&+Q%M\u0013:;\u0005E\u0012*P\u001b\u0002\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0014\u0018.\\*ue\u00022%kT'!gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3!i\",\u0007\u0005\\3bI&tw\rI1oI\u0002\"(/Y5mS:<\u0007\u0005\u0019;sS6\u001cFO\u001d1!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\u00027\u000f\u001e:a])Q\u0001\u0005\t\u0011!?\u001a+fjQ0)\u0005>#\u0006\n\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\ng\u000e\u001a\u0011ue\u0006LG.\u001b8hA\u0001$(/[7TiJ\u0004\u0007e\u00195be\u0006\u001cG/\u001a:tA\u0019\u0014x.\u001c\u0011agR\u0014\bM\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006T#B\t&su\t\t;sS6\u001cFO\u001d\u0011G%>k\u0005e\u001d;sS\u0001j\u0003EU3n_Z,\u0007\u0005\u001e5fA1,\u0017\rZ5oO\u0002\u0002GO]5n'R\u0014\b\rI2iCJ\f7\r^3sg\u00022'o\\7!AN$(\u000f\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!iJLWn\u0015;sA\u0019\u0013v*\u0014\u0011tiJL\u0003%\f\u0011SK6|g/\u001a\u0011uQ\u0016\u0004CO]1jY&tw\r\t1ue&l7\u000b\u001e:aA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a+\u0002\u0007oT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:T\u0001\u0005\t\u0011!A\u0001R\u0003\u0005\u001e:j[N#(\u000fI\u0017!i\",\u0007\u0005\u001e:j[\u0002\u001aHO]5oO\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0011u_\u0002\"(/[7-AQDW\r\t3fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tA\u0005\u00043/\u001b8hY\u0016\u00043\u000f]1dK*\u0001\u0003\u0005\t\u0011!A)\u0002#i\u0014+IY\u00012%kT'![\u0001\"\b.Z:fA\u0005\u0014X\rI6fs^|'\u000fZ:!i>\u00043\u000f]3dS\u001aL\b\u0005\u001e:j[6Lgn\u001a\u0011tiJLgn\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\t|G\u000f\u001b\u0011f]\u0012\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000f[3!gR\u0014\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011+A1+\u0015\tR%O\u000f2\u0002cIU(NA5\u0002C\u000f[3tK\u0002\n'/\u001a\u0011lKf<xN\u001d3tAQ|\u0007e\u001d9fG&4\u0017\u0010\t;sS6l\u0017N\\4!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mK\u001a$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!K:$\u0007e\u001c4!i\",\u0007e\u001d;sS:<'\u0002\t\u0011!A\u0001\u0002#\u0006\t+S\u0003&c\u0015JT$-A\u0019\u0013v*\u0014\u0011.AQDWm]3!CJ,\u0007e[3zo>\u0014Hm\u001d\u0011u_\u0002\u001a\b/Z2jMf\u0004CO]5n[&tw\rI:ue&tw\rI2iCJ\f7\r^3sg\u00022'o\\7!i\",\u0007E]5hQRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001eT\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011W\u0001\u0005b)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\"P)\"\u0003cIU(NA\u001d\u0002\u0003\u0005\t\u0011Ta\u0006\u00148nU)MA\u0001\u0002s%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CC*R!E\u0013:;\u0005E\u0012*P\u001b\u0002:\u0003\u0005\t\u0011!'B\f'o[*R\u0019\u0002\u0002\u0003eJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\u0016*B\u00132Kej\u0012\u0011G%>k\u0005e\n\u0011!A\u0001\u001a\u0006/\u0019:l'Fc\u0005\u0005\t\u0011(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'B\f'o[*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u0015'(A\u0019\u0013v*\u0014\u0011('N\u0003\u0018M]6T#2\u001bv%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a\u0006\u00148nU)\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\t{E\u000b\u0013\u0011('2;\u0003E\u0012*P\u001b\u0002:3k\u00159be.\u001c\u0016\u000bT*(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:l'FS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006T#B\t&su\tI\u0014T\u0019\u001e\u0002cIU(NA\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0018M]6T#2\u001b&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b+S\u0003&c\u0015JT$!OMcu\u0005\t$S\u001f6\u0003seU*qCJ\\7+\u0015'TO%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU*qCJ\\7+\u0015\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qW\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003{\u000bAb\u001d;sS:<wLZ;oGNDa!!1\u0004\u0001\u0004I\u0015aA:ue\")\u0001m\u0001a\u0001\u0013R\u0019q)a2\t\r\u0005\u0005G\u00011\u0001J)\u00159\u00151ZAg\u0011\u0015iV\u00011\u0001J\u0011\u001d\u0001W\u0001%AA\u0002\t\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t).!8\u0011\tY\u001a\u0017q\u001b\t\u0006m\u0005e\u0017JY\u0005\u0004\u00037<$A\u0002+va2,'\u0007\u0003\u0005\u0002`\u001e\t\t\u00111\u0001H\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u001d\b\u0003BA)\u0003SLA!a;\u0002T\t1qJ\u00196fGR\u0004")
public class StringTrim
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrim$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrim stringTrim) {
        return StringTrim$.MODULE$.unapply(stringTrim);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrim$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "trim";
    }

    @Override
    public String direction() {
        return "BOTH";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trim();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trim(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrim copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrim(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrim";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcStr();
                break;
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrim;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcStr";
                break;
            }
            case 1: {
                string = "trimStr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrim)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrim stringTrim = (StringTrim)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrim.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrim.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrim.canEqual(this)) return false;
        return true;
    }

    public StringTrim(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trim";
    }

    public StringTrim(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrim(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

