/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\tEc\u0001B\u0014)\u0001VB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t5\u0002\u0011\t\u0012)A\u0005/\"A1\f\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005]\u0001\tE\t\u0015!\u0003X\u0011!i\u0006A!f\u0001\n\u00031\u0006\u0002\u00030\u0001\u0005#\u0005\u000b\u0011B,\t\u000b}\u0003A\u0011\u00011\t\u000b}\u0003A\u0011A3\t\u000b}\u0003A\u0011A5\t\u000b-\u0004A\u0011\t,\t\u000b1\u0004A\u0011\t,\t\u000b5\u0004A\u0011\t,\t\u000b9\u0004A\u0011I8\t\u000be\u0004A\u0011\t>\t\u000by\u0004A\u0011I@\t\u0015\u00055\u0001\u0001#b\u0001\n\u0013\ty\u0001C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005M\u0002\u0001\"\u0015\u00026!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA3\u0001\u0011E\u0013q\r\u0005\n\u0003k\u0002\u0011\u0011!C\u0001\u0003oB\u0011\"a \u0001#\u0003%\t!!!\t\u0013\u0005]\u0005!%A\u0005\u0002\u0005\u0005\u0005\"CAM\u0001E\u0005I\u0011AAA\u0011%\tY\nAA\u0001\n\u0003\ni\nC\u0005\u0002.\u0002\t\t\u0011\"\u0001\u00020\"I\u0011q\u0017\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u007f\u0003\u0011\u0011!C!\u0003\u0003D\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005m\u0007!!A\u0005B\u0005u\u0007\"CAq\u0001\u0005\u0005I\u0011IAr\u000f%\u00119\u0001KA\u0001\u0012\u0003\u0011IA\u0002\u0005(Q\u0005\u0005\t\u0012\u0001B\u0006\u0011\u0019y\u0016\u0005\"\u0001\u0003$!I!QE\u0011\u0002\u0002\u0013\u0015#q\u0005\u0005\n\u0005S\t\u0013\u0011!CA\u0005WA\u0011Ba\r\"\u0003\u0003%\tI!\u000e\t\u0013\t\u001d\u0013%!A\u0005\n\t%#aC*ue&tw\rV8NCBT!!\u000b\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003W1\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003[9\n1a]9m\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7\u0001A\n\u0007\u0001YRT\b\u0012&\u0011\u0005]BT\"\u0001\u0015\n\u0005eB#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011qgO\u0005\u0003y!\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tq\u0014I\u0004\u00028\u007f%\u0011\u0001\tK\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115I\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0001C\u0003CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017Js!\u0001T)\u000f\u00055\u0003V\"\u0001(\u000b\u0005=#\u0014A\u0002\u001fs_>$h(C\u0001H\u0013\t\u0001e)\u0003\u0002T)\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001IR\u0001\u0005i\u0016DH/F\u0001X!\t9\u0004,\u0003\u0002ZQ\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000bQ,\u0007\u0010\u001e\u0011\u0002\u0013A\f\u0017N\u001d#fY&l\u0017A\u00039bSJ$U\r\\5nA\u0005i1.Z=WC2,X\rR3mS6\fab[3z-\u0006dW/\u001a#fY&l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005C\n\u001cG\r\u0005\u00028\u0001!)Qk\u0002a\u0001/\")1l\u0002a\u0001/\")Ql\u0002a\u0001/R\u0019\u0011M\u001a5\t\u000b\u001dD\u0001\u0019A,\u0002\u000b\rD\u0017\u000e\u001c3\t\u000bmC\u0001\u0019A,\u0015\u0005\u0005T\u0007\"B4\n\u0001\u00049\u0016!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u001d\t\u0004\u0017F\u001c\u0018B\u0001:U\u0005\r\u0019V-\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m2\nQ\u0001^=qKNL!\u0001_;\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003m\u0004\"\u0001\u001e?\n\u0005u,(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d!&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY!!\u0002\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!\"\\1q\u0005VLG\u000eZ3s+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9BK\u0001\u0005kRLG.\u0003\u0003\u0002\u001c\u0005U!\u0001F!se\u0006L()Y:fI6\u000b\u0007OQ;jY\u0012,'/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\"\u0005\u001d\u00121FA\u0018!\r)\u00151E\u0005\u0004\u0003K1%aA!os\"9\u0011\u0011F\tA\u0002\u0005\u0005\u0012aC5oaV$8\u000b\u001e:j]\u001eDq!!\f\u0012\u0001\u0004\t\t#A\btiJLgn\u001a#fY&l\u0017\u000e^3s\u0011\u001d\t\t$\u0005a\u0001\u0003C\t\u0011c[3z-\u0006dW/\u001a#fY&l\u0017\u000e^3s\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u00028\u0005\r\u0013Q\n\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b\u0015\u0002\u000f\r|G-Z4f]&!\u0011\u0011IA\u001e\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA#%\u0001\u0007\u0011qI\u0001\u0004GRD\b\u0003BA\u001d\u0003\u0013JA!a\u0013\u0002<\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA(%\u0001\u0007\u0011qG\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u0006\u0005\u0003\u0002X\u0005}c\u0002BA-\u00037\u0002\"!\u0014$\n\u0007\u0005uc)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;2\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001d9\u0016\u0011NA7\u0003cBa!a\u001b\u0015\u0001\u00049\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005=D\u00031\u0001X\u0003%qWm^*fG>tG\r\u0003\u0004\u0002tQ\u0001\raV\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001d\t\u0017\u0011PA>\u0003{Bq!V\u000b\u0011\u0002\u0003\u0007q\u000bC\u0004\\+A\u0005\t\u0019A,\t\u000fu+\u0002\u0013!a\u0001/\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAABU\r9\u0016QQ\u0016\u0003\u0003\u000f\u0003B!!#\u0002\u00146\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0013$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0006-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0005\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0005Y\u0006twM\u0003\u0002\u0002*\u0006!!.\u0019<b\u0013\u0011\t\t'a)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0006cA#\u00024&\u0019\u0011Q\u0017$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u00121\u0018\u0005\n\u0003{[\u0012\u0011!a\u0001\u0003c\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAb!\u0019\t)-a3\u0002\"5\u0011\u0011q\u0019\u0006\u0004\u0003\u00134\u0015AC2pY2,7\r^5p]&!\u0011QZAd\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0017\u0011\u001c\t\u0004\u000b\u0006U\u0017bAAl\r\n9!i\\8mK\u0006t\u0007\"CA_;\u0005\u0005\t\u0019AA\u0011\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}\u0015q\u001c\u0005\n\u0003{s\u0012\u0011!a\u0001\u0003c\u000ba!Z9vC2\u001cH\u0003BAj\u0003KD\u0011\"!0 \u0003\u0003\u0005\r!!\t)'\u0001\tI/a<\u0002r\u0006U\u0018q_A~\u0003{\u0014\tAa\u0001\u0011\u0007]\nY/C\u0002\u0002n\"\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002t\u0006\u00119b\u0018$V\u001d\u000e{\u0006\u0006^3yinc\u0003\u0005]1je\u0012+G.[7\\Y\u0001ZW-\u001f,bYV,G)\u001a7j[vk\u0016\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!C\u001a$XM\u001d\u0011ta2LG\u000f^5oO\u0002\"\b.\u001a\u0011uKb$\b%\u001b8u_\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001c\b%^:j]\u001e\u0004C-\u001a7j[&$XM]:/A\u0011+g-Y;mi\u0002\"W\r\\5nSR,'o\u001d\u0011be\u0016\u0004s\u0005L\u0014!M>\u0014\b\u0005\u00199bSJ$U\r\\5nA\u0002\ng\u000e\u001a\u0011(u\u001d\u0002cm\u001c:!A.,\u0017PV1mk\u0016$U\r\\5nA:\u0002#i\u001c;iA\u0001\u0004\u0018-\u001b:EK2LW\u000e\u0019\u0011b]\u0012\u0004\u0003m[3z-\u0006dW/\u001a#fY&l\u0007\rI1sK\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011`\u0001\u0002\")\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u0019\u001e2Y\tT$\u0007L2;g\u001db\u0003e\n\u0017(Y\u0001:#hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e#c\tb#E\u0019\u0012;EI\u0012CFI2#u\t\u001a$% \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#H\\;mYvT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u007f\fQA\r\u00181]E\nQa\u001a:pkB\f#A!\u0002\u0002\u00135\f\u0007o\u00184v]\u000e\u001c\u0018aC*ue&tw\rV8NCB\u0004\"aN\u0011\u0014\u000b\u0005\u0012iA!\u0007\u0011\u0011\t=!QC,X/\u0006l!A!\u0005\u000b\u0007\tMa)A\u0004sk:$\u0018.\\3\n\t\t]!\u0011\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\u000e\u0005Ci!A!\b\u000b\t\t}\u0011qU\u0001\u0003S>L1a\u0015B\u000f)\t\u0011I!\u0001\u0005u_N#(/\u001b8h)\t\ty*A\u0003baBd\u0017\u0010F\u0004b\u0005[\u0011yC!\r\t\u000bU#\u0003\u0019A,\t\u000bm#\u0003\u0019A,\t\u000bu#\u0003\u0019A,\u0002\u000fUt\u0017\r\u001d9msR!!q\u0007B\"!\u0015)%\u0011\bB\u001f\u0013\r\u0011YD\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0015\u0013ydV,X\u0013\r\u0011\tE\u0012\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\u0015S%!AA\u0002\u0005\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u0005\u0005\u0003\u0002\"\n5\u0013\u0002\u0002B(\u0003G\u0013aa\u00142kK\u000e$\b")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.pairDelim(), this.keyValueDelim()})).exists((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)StringToMap.$anonfun$checkInputDataTypes$7(x$26))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(31).append(this.prettyName()).append("'s delimiters must be foldable.").toString()) : ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return !this.bitmap$0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.text();
                break;
            }
            case 1: {
                object = this.pairDelim();
                break;
            }
            case 2: {
                object = this.keyValueDelim();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "text";
                break;
            }
            case 1: {
                string = "pairDelim";
                break;
            }
            case 2: {
                string = "keyValueDelim";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$7(Expression x$26) {
        return !x$26.foldable();
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

