/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, len[, pad]) - Returns `str`, right-padded with `pad` to a length of `len`.\n      If `str` is longer than `len`, the return value is shortened to `len` characters.\n      If `pad` is not specified, `str` will be padded to the right with space characters.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('hi', 5, '??');\n       hi???\n      > SELECT _FUNC_('hi', 1, '??');\n       h\n      > SELECT _FUNC_('hi', 5);\n       hi\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005-\"A!\f\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003W\u0011!a\u0006A!f\u0001\n\u0003)\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u000b\u001d\u0004A\u0011I+\t\u000b!\u0004A\u0011I+\t\u000b%\u0004A\u0011I+\t\u000b)\u0004A\u0011I6\t\u000bI\u0004A\u0011I:\t\u000b]\u0004A\u0011\t=\t\r}\u0004A\u0011KA\u0001\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\r\u0001\t#\n\u0019\u0004C\u0005\u0002B\u0001\t\t\u0011\"\u0001\u0002D!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003G\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!\u001a\u0001#\u0003%\t!!\u0014\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\t\u0019\tAA\u0001\n\u0003\t)\tC\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003O\u0003\u0011\u0011!C!\u0003SC\u0011\"!,\u0001\u0003\u0003%\t%a,\b\u0013\u0005Mw%!A\t\u0002\u0005Ug\u0001\u0003\u0014(\u0003\u0003E\t!a6\t\rysB\u0011AAx\u0011%\t\tPHA\u0001\n\u000b\n\u0019\u0010C\u0005\u0002vz\t\t\u0011\"!\u0002x\"I\u0011q \u0010\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0005\u0003q\u0012\u0011!CA\u0005\u0007A\u0011B!\u0006\u001f#\u0003%\t!!\u0014\t\u0013\t]a$!A\u0005\n\te!AC*ue&twM\u0015)bI*\u0011\u0001&K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002+W\u0005A1-\u0019;bYf\u001cHO\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001keb4)\u0013\t\u0003m]j\u0011aJ\u0005\u0003q\u001d\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t1$(\u0003\u0002<O\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002>\u0001:\u0011aGP\u0005\u0003\u007f\u001d\nq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA (!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u001d\u0001&o\u001c3vGR\u0004\"AS)\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(4\u0003\u0019a$o\\8u}%\ta)\u0003\u0002@\u000b&\u0011!k\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u007f\u0015\u000b1a\u001d;s+\u00051\u0006C\u0001\u001cX\u0013\tAvE\u0001\u0006FqB\u0014Xm]:j_:\fAa\u001d;sA\u0005\u0019A.\u001a8\u0002\t1,g\u000eI\u0001\u0004a\u0006$\u0017\u0001\u00029bI\u0002\na\u0001P5oSRtD\u0003\u00021bE\u000e\u0004\"A\u000e\u0001\t\u000bQ;\u0001\u0019\u0001,\t\u000bi;\u0001\u0019\u0001,\t\u000fq;\u0001\u0013!a\u0001-R\u0019\u0001-\u001a4\t\u000bQC\u0001\u0019\u0001,\t\u000biC\u0001\u0019\u0001,\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003!!\u0017\r^1UsB,W#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=\\\u0013!\u0002;za\u0016\u001c\u0018BA9o\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tA\u000fE\u0002Kk2L!A^*\u0003\u0007M+\u0017/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003zyvt\bC\u0001#{\u0013\tYXIA\u0002B]fDQ\u0001\u0016\bA\u0002eDQA\u0017\bA\u0002eDQ\u0001\u0018\bA\u0002e\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\r\u0011qBA\r!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005O\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0007\u0003\u000f\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003#y\u0001\u0019AA\n\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000b\t)\"\u0003\u0003\u0002\u0018\u0005\u001d!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u00037y\u0001\u0019AA\u0002\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\t\u0011\t\u0005\r\u00121\u0006\b\u0005\u0003K\t9\u0003\u0005\u0002M\u000b&\u0019\u0011\u0011F#\u0002\rA\u0013X\rZ3g\u0013\u0011\ti#a\f\u0003\rM#(/\u001b8h\u0015\r\tI#R\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$r\u0001YA\u001b\u0003s\ti\u0004\u0003\u0004\u00028E\u0001\rAV\u0001\t]\u0016<h)\u001b:ti\"1\u00111H\tA\u0002Y\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005}\u0012\u00031\u0001W\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$r\u0001YA#\u0003\u000f\nI\u0005C\u0004U%A\u0005\t\u0019\u0001,\t\u000fi\u0013\u0002\u0013!a\u0001-\"9AL\u0005I\u0001\u0002\u00041\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fR3AVA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA/\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0014q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0014\u0001\u00026bm\u0006LA!!\f\u0002p\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0010\t\u0004\t\u0006}\u0014bAAA\u000b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u00110a\"\t\u0013\u0005%\u0005$!AA\u0002\u0005u\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0010B)\u0011\u0011SALs6\u0011\u00111\u0013\u0006\u0004\u0003++\u0015AC2pY2,7\r^5p]&!\u0011\u0011TAJ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0015Q\u0015\t\u0004\t\u0006\u0005\u0016bAAR\u000b\n9!i\\8mK\u0006t\u0007\u0002CAE5\u0005\u0005\t\u0019A=\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003W\nY\u000bC\u0005\u0002\nn\t\t\u00111\u0001\u0002~\u00051Q-];bYN$B!a(\u00022\"A\u0011\u0011\u0012\u000f\u0002\u0002\u0003\u0007\u0011\u0010K\n\u0001\u0003k\u000bY,!0\u0002B\u0006\r\u0017qYAe\u0003\u001b\fy\rE\u00027\u0003oK1!!/(\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a0\u0002\u0005CQ\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t7f]nc\u0003\u0005]1e;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011agR\u0014\b\r\f\u0011sS\u001eDG/\f9bI\u0012,G\rI<ji\"\u0004\u0003\r]1eA\u0002\"x\u000eI1!Y\u0016tw\r\u001e5!_\u001a\u0004\u0003\r\\3oA:R\u0001\u0005\t\u0011!A\u0001Je\r\t1tiJ\u0004\u0007%[:!Y>tw-\u001a:!i\"\fg\u000e\t1mK:\u0004G\u0006\t;iK\u0002\u0012X\r^;s]\u00022\u0018\r\\;fA%\u001c\be\u001d5peR,g.\u001a3!i>\u0004\u0003\r\\3oA\u0002\u001a\u0007.\u0019:bGR,'o\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011JM\u0002\u0002\u0007/\u00193aA%\u001c\bE\\8uAM\u0004XmY5gS\u0016$G\u0006\t1tiJ\u0004\u0007e^5mY\u0002\u0012W\r\t9bI\u0012,G\r\t;pAQDW\r\t:jO\"$\be^5uQ\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002F\u0006\tYD\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Q&<C\u0006I\u001b-A\u001dzthJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A!LwhP \u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dB\u0017n\n\u0017!c1\u0002seP (SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003N\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(Q&<C\u0006I\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001B\u0017N\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY-A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002R\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006Q1\u000b\u001e:j]\u001e\u0014\u0006+\u00193\u0011\u0005Yr2#\u0002\u0010\u0002Z\u0006\u0015\b\u0003CAn\u0003C4fK\u00161\u000e\u0005\u0005u'bAAp\u000b\u00069!/\u001e8uS6,\u0017\u0002BAr\u0003;\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t9/!<\u000e\u0005\u0005%(\u0002BAv\u0003g\n!![8\n\u0007I\u000bI\u000f\u0006\u0002\u0002V\u0006AAo\\*ue&tw\r\u0006\u0002\u0002l\u0005)\u0011\r\u001d9msR9\u0001-!?\u0002|\u0006u\b\"\u0002+\"\u0001\u00041\u0006\"\u0002.\"\u0001\u00041\u0006b\u0002/\"!\u0003\u0005\rAV\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B\u0003\u0005#\u0001R\u0001\u0012B\u0004\u0005\u0017I1A!\u0003F\u0005\u0019y\u0005\u000f^5p]B1AI!\u0004W-ZK1Aa\u0004F\u0005\u0019!V\u000f\u001d7fg!A!1C\u0012\u0002\u0002\u0003\u0007\u0001-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u000e!\u0011\tiG!\b\n\t\t}\u0011q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class StringRPad
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression str;
    private final Expression len;
    private final Expression pad;

    public static Expression $lessinit$greater$default$3() {
        return StringRPad$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringRPad stringRPad) {
        return StringRPad$.MODULE$.unapply(stringRPad);
    }

    public static Expression apply$default$3() {
        return StringRPad$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringRPad> tupled() {
        return StringRPad$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringRPad>>> curried() {
        return StringRPad$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression len() {
        return this.len;
    }

    public Expression pad() {
        return this.pad;
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.len();
    }

    @Override
    public Expression third() {
        return this.pad();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object str, Object len, Object pad) {
        return ((UTF8String)str).rpad(BoxesRunTime.unboxToInt((Object)len), (UTF8String)pad);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, len, pad) -> new StringBuilder(9).append((String)str).append(".rpad(").append((String)len).append(", ").append((String)pad).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "rpad";
    }

    @Override
    public StringRPad withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringRPad copy(Expression str, Expression len, Expression pad) {
        return new StringRPad(str, len, pad);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.len();
    }

    public Expression copy$default$3() {
        return this.pad();
    }

    @Override
    public String productPrefix() {
        return "StringRPad";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.str();
                break;
            }
            case 1: {
                object = this.len();
                break;
            }
            case 2: {
                object = this.pad();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRPad;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "str";
                break;
            }
            case 1: {
                string = "len";
                break;
            }
            case 2: {
                string = "pad";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRPad)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRPad stringRPad = (StringRPad)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRPad.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.len();
        Expression expression4 = stringRPad.len();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.pad();
        Expression expression6 = stringRPad.pad();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringRPad.canEqual(this)) return false;
        return true;
    }

    public StringRPad(Expression str, Expression len, Expression pad) {
        this.str = str;
        this.len = len;
        this.pad = pad;
        ExpectsInputTypes.$init$(this);
    }

    public StringRPad(Expression str, Expression len) {
        this(str, len, Literal$.MODULE$.apply(" "));
    }
}

