/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.SchemaOfJson$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json[, options]) - Returns schema in the DDL format of JSON string.", examples="\n    Examples:\n      > SELECT _FUNC_('[{\"col\":0}]');\n       ARRAY<STRUCT<`col`: BIGINT>>\n      > SELECT _FUNC_('[{\"col\":01}]', map('allowNumericLeadingZeros', 'true'));\n       ARRAY<STRUCT<`col`: BIGINT>>\n  ", group="json_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t5c\u0001B\u0012%\u0001FB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005b\u0001\tE\t\u0015!\u0003W\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015\u0011\u0007\u0001\"\u0001h\u0011\u0015\u0011\u0007\u0001\"\u0001j\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015!\b\u0001\"\u0011v\u0011!I\b\u0001#b\u0001\n\u0013Q\bBCA\u0006\u0001!\u0015\r\u0011\"\u0003\u0002\u000e!Q\u0011\u0011\u0006\u0001\t\u0006\u0004%I!a\u000b\t\u0013y\u0004\u0001R1A\u0005\n\u0005U\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!!\u001d\u0001\t#\n\u0019\bC\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u00037C\u0011\"a(\u0001\u0003\u0003%\t%!)\t\u0013\u0005E\u0006!!A\u0005\u0002\u0005M\u0006\"CA^\u0001\u0005\u0005I\u0011AA_\u0011%\t\u0019\rAA\u0001\n\u0003\n)\rC\u0005\u0002T\u0002\t\t\u0011\"\u0001\u0002V\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00131\u001c\u0005\n\u0003?\u0004\u0011\u0011!C!\u0003C<\u0011B!\u0002%\u0003\u0003E\tAa\u0002\u0007\u0011\r\"\u0013\u0011!E\u0001\u0005\u0013AaAY\u000f\u0005\u0002\t\u0005\u0002\"\u0003B\u0012;\u0005\u0005IQ\tB\u0013\u0011%\u00119#HA\u0001\n\u0003\u0013I\u0003C\u0005\u00030u\t\t\u0011\"!\u00032!I!1I\u000f\u0002\u0002\u0013%!Q\t\u0002\r'\u000eDW-\\1PM*\u001bxN\u001c\u0006\u0003K\u0019\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0005K\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011FK\u0001\u0004gFd'BA\u0016-\u0003\u0015\u0019\b/\u0019:l\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\u0004\u0001M)\u0001A\r\u001c=\u0005B\u00111\u0007N\u0007\u0002I%\u0011Q\u0007\n\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011qGO\u0007\u0002q)\u0011\u0011\bJ\u0001\bG>$WmZ3o\u0013\tY\u0004HA\bD_\u0012,w-\u001a8GC2d'-Y2l!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u001d\u0001&o\u001c3vGR\u0004\"aQ&\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$1\u0003\u0019a$o\\8u}%\tq(\u0003\u0002K}\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQe(A\u0003dQ&dG-F\u0001Q!\t\u0019\u0014+\u0003\u0002SI\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u001dy\u0007\u000f^5p]N,\u0012A\u0016\t\u0005/nsfL\u0004\u0002Y3B\u0011QIP\u0005\u00035z\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\ri\u0015\r\u001d\u0006\u00035z\u0002\"aV0\n\u0005\u0001l&AB*ue&tw-\u0001\u0005paRLwN\\:!\u0003\u0019a\u0014N\\5u}Q\u0019A-\u001a4\u0011\u0005M\u0002\u0001\"\u0002(\u0006\u0001\u0004\u0001\u0006\"\u0002+\u0006\u0001\u00041FC\u00013i\u0011\u0015qe\u00011\u0001Q)\r!'n\u001b\u0005\u0006\u001d\u001e\u0001\r\u0001\u0015\u0005\u0006)\u001e\u0001\r\u0001U\u0001\tI\u0006$\u0018\rV=qKV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002rQ\u0005)A/\u001f9fg&\u00111\u000f\u001d\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001w!\tit/\u0003\u0002y}\t9!i\\8mK\u0006t\u0017a\u00036t_:|\u0005\u000f^5p]N,\u0012a\u001f\t\u0003y~l\u0011! \u0006\u0003}\u001a\nAA[:p]&\u0019\u0011\u0011A?\u0003\u0017)\u001bvJT(qi&|gn\u001d\u0015\u0004\u0015\u0005\u0015\u0001cA\u001f\u0002\b%\u0019\u0011\u0011\u0002 \u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00036t_:4\u0015m\u0019;pef,\"!a\u0004\u0011\t\u0005E\u00111E\u0007\u0003\u0003'QA!!\u0006\u0002\u0018\u0005!1m\u001c:f\u0015\u0011\tI\"a\u0007\u0002\u000f)\f7m[:p]*!\u0011QDA\u0010\u0003%1\u0017m\u001d;feblGN\u0003\u0002\u0002\"\u0005\u00191m\\7\n\t\u0005\u0015\u00121\u0003\u0002\f\u0015N|gNR1di>\u0014\u0018\u0010K\u0002\f\u0003\u000b\tqB[:p]&sg-\u001a:TG\",W.Y\u000b\u0003\u0003[\u00012\u0001`A\u0018\u0013\r\t\t$ \u0002\u0010\u0015N|g.\u00138gKJ\u001c6\r[3nC\"\u001aA\"!\u0002\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0003j!!a\u000f\u000b\u0007E\fiDC\u0002\u0002@)\na!\u001e8tC\u001a,\u0017\u0002BA\"\u0003w\u0011!\"\u0016+GqM#(/\u001b8hQ\ri\u0011QA\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#2\u0013\u0001C1oC2L8/[:\n\t\u0005U\u0013q\n\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006!QM^1m)\u0011\tY&!\u0019\u0011\u0007u\ni&C\u0002\u0002`y\u00121!\u00118z\u0011%\t\u0019g\u0004I\u0001\u0002\u0004\t)'A\u0001w!\u0011\t9'!\u001b\u000e\u0003\u0019J1!a\u001b'\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001_\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019A-!\u001e\t\r\u0005]\u0014\u00031\u0001Q\u0003!qWm^\"iS2$\u0017\u0001B2paf$R\u0001ZA?\u0003\u007fBqA\u0014\n\u0011\u0002\u0003\u0007\u0001\u000bC\u0004U%A\u0005\t\u0019\u0001,\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0011\u0016\u0004!\u0006\u001d5FAAE!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Me(\u0001\u0006b]:|G/\u0019;j_:LA!a&\u0002\u000e\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0014\u0016\u0004-\u0006\u001d\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$B!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016\u0001\u00027b]\u001eT!!!,\u0002\t)\fg/Y\u0005\u0004A\u0006\u001d\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAA[!\ri\u0014qW\u0005\u0004\u0003ss$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA.\u0003\u007fC\u0011\"!1\u0018\u0003\u0003\u0005\r!!.\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\r\u0005\u0004\u0002J\u0006=\u00171L\u0007\u0003\u0003\u0017T1!!4?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\fYM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001<\u0002X\"I\u0011\u0011Y\r\u0002\u0002\u0003\u0007\u00111L\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002$\u0006u\u0007\"CAa5\u0005\u0005\t\u0019AA[\u0003\u0019)\u0017/^1mgR\u0019a/a9\t\u0013\u0005\u00057$!AA\u0002\u0005m\u0003f\u0005\u0001\u0002h\u00065\u0018q^Az\u0003k\fI0a?\u0002\u0000\n\u0005\u0001cA\u001a\u0002j&\u0019\u00111\u001e\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011_\u0001K?\u001a+fjQ0)UN|gn\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011tG\",W.\u0019\u0011j]\u0002\"\b.\u001a\u0011E\t2\u0003cm\u001c:nCR\u0004sN\u001a\u0011K'>s\u0005e\u001d;sS:<g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t90AAP\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3l\u001f\u0012d_2\u0014#\bM?^O%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u0011*S\u0003fc4\u000b\u0016*V\u0007Rc\u0004mY8mAj\u0002#)S$J\u001dRsdH\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(7n\u00143m\u001c7#uA\nT0X\u0014-A5\f\u0007\u000fK\u0014bY2|wOT;nKJL7\rT3bI&twMW3s_N<C\u0006I\u0014ueV,w%K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013&+Q-='R\u0013Vk\u0011+=A\u000e|G\u000e\u0019\u001e!\u0005&;\u0015J\u0014+?})\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002~\u0006Q!n]8o?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t\r\u0011!\u0002\u001a/i9\u0002\u0014\u0001D*dQ\u0016l\u0017m\u00144Kg>t\u0007CA\u001a\u001e'\u0015i\"1\u0002B\f!\u001d\u0011iAa\u0005Q-\u0012l!Aa\u0004\u000b\u0007\tEa(A\u0004sk:$\u0018.\\3\n\t\tU!q\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003\u0002B\r\u0005?i!Aa\u0007\u000b\t\tu\u00111V\u0001\u0003S>L1\u0001\u0014B\u000e)\t\u00119!\u0001\u0005u_N#(/\u001b8h)\t\t\u0019+A\u0003baBd\u0017\u0010F\u0003e\u0005W\u0011i\u0003C\u0003OA\u0001\u0007\u0001\u000bC\u0003UA\u0001\u0007a+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM\"q\b\t\u0006{\tU\"\u0011H\u0005\u0004\u0005oq$AB(qi&|g\u000eE\u0003>\u0005w\u0001f+C\u0002\u0003>y\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B!C\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003HA!\u0011Q\u0015B%\u0013\u0011\u0011Y%a*\u0003\r=\u0013'.Z2u\u0001")
public class SchemaOfJson
extends UnaryExpression
implements CodegenFallback,
Serializable {
    private transient JSONOptions jsonOptions;
    private transient JsonFactory jsonFactory;
    private transient JsonInferSchema jsonInferSchema;
    private transient UTF8String json;
    private final Expression child;
    private final Map<String, String> options;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Map<String, String>>> unapply(SchemaOfJson schemaOfJson) {
        return SchemaOfJson$.MODULE$.unapply(schemaOfJson);
    }

    public static Function1<Tuple2<Expression, Map<String, String>>, SchemaOfJson> tupled() {
        return SchemaOfJson$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Map<String, String>, SchemaOfJson>> curried() {
        return SchemaOfJson$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private JSONOptions jsonOptions$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.jsonOptions = new JSONOptions(this.options(), "UTC", JSONOptions$.MODULE$.$lessinit$greater$default$3());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.jsonOptions;
    }

    private JSONOptions jsonOptions() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.jsonOptions$lzycompute() : this.jsonOptions;
    }

    private JsonFactory jsonFactory$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonFactory = this.jsonOptions().buildJsonFactory();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonFactory;
    }

    private JsonFactory jsonFactory() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonFactory$lzycompute() : this.jsonFactory;
    }

    private JsonInferSchema jsonInferSchema$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.jsonInferSchema = new JsonInferSchema(this.jsonOptions());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.jsonInferSchema;
    }

    private JsonInferSchema jsonInferSchema() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.jsonInferSchema$lzycompute() : this.jsonInferSchema;
    }

    private UTF8String json$lzycompute() {
        SchemaOfJson schemaOfJson = this;
        synchronized (schemaOfJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.json = (UTF8String)this.child().eval(this.child().eval$default$1());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.json;
    }

    private UTF8String json() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.json$lzycompute() : this.json;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.child().foldable() && this.json() != null ? super.checkInputDataTypes() : new TypeCheckResult.TypeCheckFailure(new StringBuilder(68).append("The input json should be a foldable string expression and not null; ").append(new StringBuilder(14).append("however, got ").append(this.child().sql()).append(".").toString()).toString());
    }

    @Override
    public Object eval(InternalRow v) {
        DataType dt = (DataType)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(this.jsonFactory(), this.json()), (Function1 & Serializable)parser -> {
            ArrayType arrayType;
            DataType dataType;
            parser.nextToken();
            DataType dataType2 = this.jsonInferSchema().inferField((JsonParser)parser);
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(structType, this.jsonOptions()).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()));
            } else if (dataType2 instanceof ArrayType && (arrayType = (ArrayType)dataType2).elementType() instanceof StructType) {
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(arrayType.elementType(), this.jsonOptions()).map((Function1 & Serializable)x$8 -> new ArrayType((DataType)x$8, arrayType.containsNull())).getOrElse((Function0 & Serializable)() -> new ArrayType(StructType$.MODULE$.apply((Seq<StructField>)package$.MODULE$.Nil()), arrayType.containsNull()));
            } else if (dataType2 != null) {
                DataType dataType3 = dataType2;
                dataType = (DataType)this.jsonInferSchema().canonicalizeType(dataType3, this.jsonOptions()).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
            } else {
                throw new MatchError((Object)dataType2);
            }
            return dataType;
        });
        return UTF8String.fromString((String)dt.sql());
    }

    @Override
    public String prettyName() {
        return "schema_of_json";
    }

    @Override
    public SchemaOfJson withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public SchemaOfJson copy(Expression child, Map<String, String> options) {
        return new SchemaOfJson(child, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "SchemaOfJson";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SchemaOfJson;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            case 1: {
                string = "options";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SchemaOfJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        SchemaOfJson schemaOfJson = (SchemaOfJson)x$1;
        Expression expression = this.child();
        Expression expression2 = schemaOfJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = schemaOfJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!schemaOfJson.canEqual(this)) return false;
        return true;
    }

    public SchemaOfJson(Expression child, Map<String, String> options) {
        this.child = child;
        this.options = options;
        CodegenFallback.$init$(this);
    }

    public SchemaOfJson(Expression child) {
        this(child, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public SchemaOfJson(Expression child, Expression options) {
        this(child, ExprUtils$.MODULE$.convertToMapData(options));
    }
}

