/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function4;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".\n\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]g\u0001\u0002\u001c8\u0001\u0012C\u0001\u0002\u001a\u0001\u0003\u0016\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0012)A\u0005M\"A!\u000e\u0001BK\u0002\u0013\u0005Q\r\u0003\u0005l\u0001\tE\t\u0015!\u0003g\u0011!a\u0007A!f\u0001\n\u0003)\u0007\u0002C7\u0001\u0005#\u0005\u000b\u0011\u00024\t\u00119\u0004!Q3A\u0005\u0002\u0015D\u0001b\u001c\u0001\u0003\u0012\u0003\u0006IA\u001a\u0005\u0006a\u0002!\t!\u001d\u0005\u0006a\u0002!\ta\u001e\u0005\u0006w\u0002!\t\u0005 \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0013\tI\u0001C\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\n\u0005u\u0001bCA\u0015\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017A1\"a\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00026!Y\u00111\n\u0001A\u0002\u0003\u0007I\u0011BA'\u0011-\t\t\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u000e\t\u0017\u0005U\u0003\u00011AA\u0002\u0013%\u0011q\u000b\u0005\f\u0003S\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0007C\u0006\u0002p\u0001\u0001\r\u0011!Q!\n\u0005e\u0003bCA:\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013A1\"!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x!Y\u00111\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0006\u0011)\ty\b\u0001EC\u0002\u0013%\u0011\u0011\u0011\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\tY\u000b\u0001C!\u0003[Cq!!/\u0001\t\u0003\nY\fC\u0004\u0002J\u0002!\t%a\u0016\t\u000f\u0005-\u0007\u0001\"\u0015\u0002N\"1\u0011\u0011\u001e\u0001\u0005B\u0015Da!a;\u0001\t\u0003*\u0007BBAw\u0001\u0011\u0005S\r\u0003\u0004\u0002p\u0002!\t%\u001a\u0005\b\u0003c\u0004A\u0011KAz\u0011%\ti\u0010AA\u0001\n\u0003\ty\u0010C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u0003\f!I!\u0011\u0005\u0001\u0012\u0002\u0013\u0005!1\u0002\u0005\n\u0005G\u0001\u0011\u0013!C\u0001\u0005\u0017A\u0011B!\n\u0001#\u0003%\tAa\u0003\t\u0013\t\u001d\u0002!!A\u0005B\t%\u0002\"\u0003B\u0018\u0001\u0005\u0005I\u0011\u0001B\u0019\u0011%\u0011I\u0004AA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003@\u0001\t\t\u0011\"\u0011\u0003B!I!q\n\u0001\u0002\u0002\u0013\u0005!\u0011\u000b\u0005\n\u00057\u0002\u0011\u0011!C!\u0005;B\u0011B!\u0019\u0001\u0003\u0003%\tEa\u0019\b\u000f\t5u\u0007#\u0001\u0003\u0010\u001a1ag\u000eE\u0001\u0005#Ca\u0001\u001d\u0019\u0005\u0002\t\r\u0006b\u0002BSa\u0011\u0005!q\u0015\u0005\n\u0005K\u0003\u0014\u0011!CA\u0005_C\u0011B!/1\u0003\u0003%\tIa/\t\u0013\t5\u0007'!A\u0005\n\t='!\u0004*fO\u0016C\bOU3qY\u0006\u001cWM\u0003\u00029s\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQ4(\u0001\u0005dCR\fG._:u\u0015\taT(A\u0002tc2T!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q)\u0013'T3B\u0011aiR\u0007\u0002o%\u0011\u0001j\u000e\u0002\u0015#V\fG/\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0019S\u0015BA&8\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA'Q\u001d\t1e*\u0003\u0002Po\u00059\u0001/Y2lC\u001e,\u0017BA)S\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aT\u001c\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\u000fA\u0013x\u000eZ;diB\u0011!,\u0019\b\u00037\u0002t!\u0001X0\u000e\u0003uS!AX\"\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016BA(V\u0013\t\u00117M\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002P+\u000691/\u001e2kK\u000e$X#\u00014\u0011\u0005\u0019;\u0017B\u000158\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgV\u0014'.Z2uA\u00051!/Z4fqB\fqA]3hKb\u0004\b%A\u0002sKB\fAA]3qA\u0005\u0019\u0001o\\:\u0002\tA|7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001cH/\u001e<\u0011\u0005\u0019\u0003\u0001\"\u00023\n\u0001\u00041\u0007\"\u00026\n\u0001\u00041\u0007\"\u00027\n\u0001\u00041\u0007\"\u00028\n\u0001\u00041G\u0003\u0002:ysjDQ\u0001\u001a\u0006A\u0002\u0019DQA\u001b\u0006A\u0002\u0019DQ\u0001\u001c\u0006A\u0002\u0019\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0011(\u0001\u0005b]\u0006d\u0017p]5t\u0013\r\t)a \u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006IA.Y:u%\u0016<W\r_\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0003usB,7OC\u0002\u0002\u0016u\na!\u001e8tC\u001a,\u0017\u0002BA\r\u0003\u001f\u0011!\"\u0016+GqM#(/\u001b8h\u00035a\u0017m\u001d;SK\u001e,\u0007p\u0018\u0013fcR!\u0011qDA\u0013!\r!\u0016\u0011E\u0005\u0004\u0003G)&\u0001B+oSRD\u0011\"a\n\u000e\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013'\u0001\u0006mCN$(+Z4fq\u0002B3ADA\u0017!\r!\u0016qF\u0005\u0004\u0003c)&!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u001d\u0001\u0018\r\u001e;fe:,\"!a\u000e\u0011\t\u0005e\u0012qI\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005)!/Z4fq*!\u0011\u0011IA\"\u0003\u0011)H/\u001b7\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002<\t9\u0001+\u0019;uKJt\u0017a\u00039biR,'O\\0%KF$B!a\b\u0002P!I\u0011q\u0005\t\u0002\u0002\u0003\u0007\u0011qG\u0001\ta\u0006$H/\u001a:oA!\u001a\u0011#!\f\u0002\u001f1\f7\u000f\u001e*fa2\f7-Z7f]R,\"!!\u0017\u0011\t\u0005m\u00131\r\b\u0005\u0003;\ny\u0006\u0005\u0002]+&\u0019\u0011\u0011M+\u0002\rA\u0013X\rZ3g\u0013\u0011\t)'a\u001a\u0003\rM#(/\u001b8h\u0015\r\t\t'V\u0001\u0014Y\u0006\u001cHOU3qY\u0006\u001cW-\\3oi~#S-\u001d\u000b\u0005\u0003?\ti\u0007C\u0005\u0002(M\t\t\u00111\u0001\u0002Z\u0005\u0001B.Y:u%\u0016\u0004H.Y2f[\u0016tG\u000f\t\u0015\u0004)\u00055\u0012!\u00067bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\tO\u0001\u001aY\u0006\u001cHOU3qY\u0006\u001cW-\\3oi&sW\u000b\u0016$9?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005e\u0004\"CA\u0014-\u0005\u0005\t\u0019AA\u0006\u0003Ya\u0017m\u001d;SKBd\u0017mY3nK:$\u0018J\\+U\rb\u0002\u0003fA\f\u0002.\u00051!/Z:vYR,\"!a!\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fSA!!#\u0002D\u0005!A.\u00198h\u0013\u0011\ti)a\"\u0003\u0019M#(/\u001b8h\u0005V4g-\u001a:)\u0007a\ti#\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0006\u0002\u0016\u0006m\u0015qTAR\u0003O\u00032\u0001VAL\u0013\r\tI*\u0016\u0002\u0004\u0003:L\bbBAO3\u0001\u0007\u0011QS\u0001\u0002g\"9\u0011\u0011U\rA\u0002\u0005U\u0015!\u00019\t\u000f\u0005\u0015\u0016\u00041\u0001\u0002\u0016\u0006\t!\u000fC\u0004\u0002*f\u0001\r!!&\u0002\u0003%\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003_\u0003B!!-\u000266\u0011\u00111\u0017\u0006\u0004\u0003#Y\u0014\u0002BA\\\u0003g\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA_!\u0015Q\u0016qXAb\u0013\r\t\tm\u0019\u0002\u0004'\u0016\f\b\u0003BAY\u0003\u000bLA!a2\u00024\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty-a7\u0002fB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002V^\nqaY8eK\u001e,g.\u0003\u0003\u0002Z\u0006M'\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005uW\u00041\u0001\u0002`\u0006\u00191\r\u001e=\u0011\t\u0005E\u0017\u0011]\u0005\u0005\u0003G\f\u0019N\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005\u001dX\u00041\u0001\u0002P\u0006\u0011QM^\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\r\u0019|WO\u001d;i\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0005s\u0003k\f90!?\u0002|\"1\u0011\u0011\u001e\u0012A\u0002\u0019Da!a;#\u0001\u00041\u0007BBAwE\u0001\u0007a\r\u0003\u0004\u0002p\n\u0002\rAZ\u0001\u0005G>\u0004\u0018\u0010F\u0005s\u0005\u0003\u0011\u0019A!\u0002\u0003\b!9Am\tI\u0001\u0002\u00041\u0007b\u00026$!\u0003\u0005\rA\u001a\u0005\bY\u000e\u0002\n\u00111\u0001g\u0011\u001dq7\u0005%AA\u0002\u0019\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u000e)\u001aaMa\u0004,\u0005\tE\u0001\u0003\u0002B\n\u0005;i!A!\u0006\u000b\t\t]!\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0007V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0011)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u000b\u0011\t\u0005\u0015%QF\u0005\u0005\u0003K\n9)\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00034A\u0019AK!\u000e\n\u0007\t]RKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0016\nu\u0002\"CA\u0014U\u0005\u0005\t\u0019\u0001B\u001a\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\"!\u0019\u0011)Ea\u0013\u0002\u00166\u0011!q\t\u0006\u0004\u0005\u0013*\u0016AC2pY2,7\r^5p]&!!Q\nB$\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tM#\u0011\f\t\u0004)\nU\u0013b\u0001B,+\n9!i\\8mK\u0006t\u0007\"CA\u0014Y\u0005\u0005\t\u0019AAK\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t-\"q\f\u0005\n\u0003Oi\u0013\u0011!a\u0001\u0005g\ta!Z9vC2\u001cH\u0003\u0002B*\u0005KB\u0011\"a\n/\u0003\u0003\u0005\r!!&)/\u0001\u0011IGa\u001c\u0003r\tU$q\u000fB>\u0005{\u0012\tIa!\u0003\b\n%\u0005c\u0001$\u0003l%\u0019!QN\u001c\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1O\u0001h?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\b\u000f\f\u0011sKB\\F\u0006\t9pg&$\u0018n\u001c8^S\u0001j\u0003EU3qY\u0006\u001cWm\u001d\u0011bY2\u00043/\u001e2tiJLgnZ:!_\u001a\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;![\u0006$8\r\u001b\u0011ae\u0016<W\r\u001f9aA]LG\u000f\u001b\u0011ae\u0016\u0004\bML\u0001\nCJ<W/\\3oiN\f#A!\u001f\u0002\u000foS\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011tK\u0006\u00148\r\u001b\u0011g_J\u0004\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004\u0003/\u0019;uKJt\u0007%\\1uG\"t#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b\u000fI\u0017!C\u0002\u001aHO]5oO\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hA\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I:ue&tw\rI:i_VdG\r\t2fA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:R!\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000f\t\u0015j]\u000edW\u000fZ5oO\u0002\u0012XmZ3yAA\fG\u000f^3s]NL\u0003%\u0019:fAUtWm]2ba\u0016$\u0007%\u001b8!_V\u0014\beU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005]1sg\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003\u0005^8![\u0006$8\r\u001b\u0011#9\u0006\u00147M\t\u0017!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!M>\u0014\b\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011dC:\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012c\f\u0018/bE\u000e$#E\f\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[3sK\u0002J7\u000fI1!'Fc\u0005eY8oM&<\u0007eJ:qCJ\\gf]9m]A\f'o]3s]\u0015\u001c8-\u00199fIN#(/\u001b8h\u0019&$XM]1mg\u001e\u0002C\u000f[1uA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t4bY2\u0014\u0017mY6!i>\u0004C\u000f[3!'B\f'o\u001b\u00112]Y\u0002#-\u001a5bm&|'\u000f\t:fO\u0006\u0014H-\u001b8hAM$(/\u001b8hA1LG/\u001a:bY\u0002\u0002\u0018M]:j]\u001et\u0003ER8sA\u0015D\u0018-\u001c9mK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg\u0002*g.\u00192mK\u0012d\u0003\u0005\u001e5fA\u0001\u0014XmZ3ya\u0002\u0004C\u000f[1uA\r\fg\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014\u0003%[:!Eyc\u0016MY2%E9R\u0001\u0005\t\u0011!A\u0001R\u0003E]3qA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]\u0002\"x\u000e\t:fa2\f7-\u001a\u0011nCR\u001c\u0007.\u001a3!gV\u00147\u000f\u001e:j]\u001e\u001chF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011q_NLG/[8oA5\u0002\u0013\r\t9pg&$\u0018N^3!S:$XmZ3sA1LG/\u001a:bY\u0002\"\b.\u0019;!S:$\u0017nY1uKN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002:\u0018\u000e\u001e5j]\u0002\u00027\u000f\u001e:aAQ|\u0007EY3hS:\u00043/Z1sG\"Lgn\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[3!I\u00164\u0017-\u001e7uA%\u001c\b%\r\u0018!\u0013\u001a\u0004\u0003o\\:ji&|g\u000eI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!G\"\f'/Y2uKJ\u001c\b%\u001b8!AN$(\u000f\u0019\u0017!i\",\u0007E]3tk2$\b%[:!AN$(\u000f\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u007f\n1K\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(cA\u0002TF\r\u00191O1\u0002s\u0005\u000b/]I.Js\u0005\f\u0011(]Vlw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!]VlWF\\;n\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001BC\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\u0011Y)\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0007SK\u001e,\u0005\u0010\u001d*fa2\f7-\u001a\t\u0003\rB\u001aR\u0001\rBJ\u00053\u00032\u0001\u0016BK\u0013\r\u00119*\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\t\tm%\u0011U\u0007\u0003\u0005;SAAa(\u0002D\u0005\u0011\u0011n\\\u0005\u0004E\nuEC\u0001BH\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0011(\u0011\u0016BV\u0005[CQ\u0001\u001a\u001aA\u0002\u0019DQA\u001b\u001aA\u0002\u0019DQ\u0001\u001c\u001aA\u0002\u0019$\u0012B\u001dBY\u0005g\u0013)La.\t\u000b\u0011\u001c\u0004\u0019\u00014\t\u000b)\u001c\u0004\u0019\u00014\t\u000b1\u001c\u0004\u0019\u00014\t\u000b9\u001c\u0004\u0019\u00014\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0018Be!\u0015!&q\u0018Bb\u0013\r\u0011\t-\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fQ\u0013)M\u001a4gM&\u0019!qY+\u0003\rQ+\b\u000f\\35\u0011!\u0011Y\rNA\u0001\u0002\u0004\u0011\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u001b\t\u0005\u0003\u000b\u0013\u0019.\u0003\u0003\u0003V\u0006\u001d%AB(cU\u0016\u001cG\u000f")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.pos().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Position expression must be foldable, but got ").append(this.pos()).toString());
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        return posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(47).append("Position expression must be positive, but got: ").append(posEval).toString());
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        Object object;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                m.appendReplacement(this.result(), this.lastReplacement());
            }
            m.appendTail(this.result());
            object = UTF8String.fromString((String)this.result().toString());
        } else {
            object = s;
        }
        return object;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(subject, regexp, rep, pos) -> new StringBuilder(610).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      String ").append(source).append(" = ").append((String)subject).append(".toString();\n      int ").append(position).append(" = ").append((String)pos).append(" - 1;\n      if (").append(position).append(" < ").append(source).append(".length()) {\n        ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n        java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append(source).append(");\n        ").append(matcher).append(".region(").append(position).append(", ").append(source).append(".length());\n\n        while (").append(matcher).append(".find()) {\n          ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n        }\n        ").append(matcher).append(".appendTail(").append(termResult).append(");\n        ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n        ").append(termResult).append(" = null;\n      } else {\n        ").append(ev.value()).append(" = ").append((String)subject).append(";\n      }\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    @Override
    public Expression first() {
        return this.subject();
    }

    @Override
    public Expression second() {
        return this.regexp();
    }

    @Override
    public Expression third() {
        return this.rep();
    }

    @Override
    public Expression fourth() {
        return this.pos();
    }

    @Override
    public RegExpReplace withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.subject();
                break;
            }
            case 1: {
                object = this.regexp();
                break;
            }
            case 2: {
                object = this.rep();
                break;
            }
            case 3: {
                object = this.pos();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "subject";
                break;
            }
            case 1: {
                string = "regexp";
                break;
            }
            case 2: {
                string = "rep";
                break;
            }
            case 3: {
                string = "pos";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

