/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003Q\u0011!!\u0006A!f\u0001\n\u0003I\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000bY\u0003A\u0011A0\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000ba\u0004A\u0011K=\t\u000fq\u0004\u0011\u0011!C\u0001{\"I\u00111\u0001\u0001\u0012\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003;A\u0011\"!\t\u0001#\u0003%\t!!\u0002\t\u0013\u0005\r\u0002!!A\u0005B\u0005\u0015\u0002\"CA\u001b\u0001\u0005\u0005I\u0011AA\u001c\u0011%\ty\u0004AA\u0001\n\u0003\t\t\u0005C\u0005\u0002H\u0001\t\t\u0011\"\u0011\u0002J!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\b\u0013\u0005M\u0015%!A\t\u0002\u0005Ue\u0001\u0003\u0011\"\u0003\u0003E\t!a&\t\rYSB\u0011AAX\u0011%\t\tLGA\u0001\n\u000b\n\u0019\fC\u0005\u00026j\t\t\u0011\"!\u00028\"I\u0011q\u0018\u000e\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u001fT\u0012\u0011!C\u0005\u0003#\u00141\u0002U1sg\u0016$v\u000eR1uK*\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001_M2D\b\u0005\u00021c5\t\u0011%\u0003\u00023C\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005u*eB\u0001 D\u001d\ty$)D\u0001A\u0015\t\tU&\u0001\u0004=e>|GOP\u0005\u0002s%\u0011A\tO\u0001\ba\u0006\u001c7.Y4f\u0013\t1uI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Eq\u0005!A.\u001a4u+\u0005Q\u0005C\u0001\u0019L\u0013\ta\u0015E\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\naAZ8s[\u0006$X#\u0001)\u0011\u0007]\n&*\u0003\u0002Sq\t1q\n\u001d;j_:\fqAZ8s[\u0006$\b%A\u0003dQ&dG-\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taK&l\u0017\t\u0003a\u0001AQ\u0001S\u0004A\u0002)CQAT\u0004A\u0002ACQ\u0001V\u0004A\u0002)#2\u0001W/_\u0011\u0015A\u0005\u00021\u0001K\u0011\u0015q\u0005\u00021\u0001K)\tA\u0006\rC\u0003I\u0013\u0001\u0007!*A\u0007fqB\u00148OU3qY\u0006\u001cW\rZ\u000b\u0002GB\u0019Q\b\u001a&\n\u0005\u0015<%aA*fc\u0006ia\r\\1u\u0003J<W/\\3oiN,\u0012\u0001\u001b\t\u0004{%\\\u0017B\u00016H\u0005!IE/\u001a:bi>\u0014\bCA\u001cm\u0013\ti\u0007HA\u0002B]f\f!\u0002\u001d:fiRLh*Y7f+\u0005\u0001\bCA9v\u001d\t\u00118\u000f\u0005\u0002@q%\u0011A\u000fO\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uq\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"\u0001\u0017>\t\u000bml\u0001\u0019\u0001&\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR)\u0001L`@\u0002\u0002!9\u0001J\u0004I\u0001\u0002\u0004Q\u0005b\u0002(\u000f!\u0003\u0005\r\u0001\u0015\u0005\b):\u0001\n\u00111\u0001K\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0002+\u0007)\u000bIa\u000b\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C;oG\",7m[3e\u0015\r\t)\u0002O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\b+\u0007A\u000bI!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\t1\fgn\u001a\u0006\u0003\u0003c\tAA[1wC&\u0019a/a\u000b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0002cA\u001c\u0002<%\u0019\u0011Q\b\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007-\f\u0019\u0005C\u0005\u0002FQ\t\t\u00111\u0001\u0002:\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0013\u0011\u000b\u00055\u00131K6\u000e\u0005\u0005=#bAA)q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007)\fy%\u0001\u0005dC:,\u0015/^1m)\u0011\tI&a\u0018\u0011\u0007]\nY&C\u0002\u0002^a\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002FY\t\t\u00111\u0001l\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u001d\u0012Q\r\u0005\n\u0003\u000b:\u0012\u0011!a\u0001\u0003s\ta!Z9vC2\u001cH\u0003BA-\u0003WB\u0001\"!\u0012\u0019\u0003\u0003\u0005\ra\u001b\u0015\u0018\u0001\u0005=\u0014QOA<\u0003w\ni(!!\u0002\u0004\u0006\u001d\u0015\u0011RAG\u0003\u001f\u00032\u0001MA9\u0013\r\t\u0019(\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI(AA]\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b3bi\u0016|6\u000f\u001e:\\Y\u00012W\u000e^/*A5\u0002\u0003+\u0019:tKN\u0004C\u000f[3!A\u0012\fG/Z0tiJ\u0004\u0007%\u001a=qe\u0016\u001c8/[8oA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003MZ7uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011u_*\u0001\u0003\u0005\t\u0011!A\u0005\u0004C-\u0019;f]\u0001\u0012V\r^;s]N\u0004c.\u001e7mA]LG\u000f\u001b\u0011j]Z\fG.\u001b3!S:\u0004X\u000f\u001e\u0018!\u0005f\u0004C-\u001a4bk2$H\u0006I5uA\u0019|G\u000e\\8xg\u0002\u001a\u0017m\u001d;j]\u001e\u0004#/\u001e7fg\u0002\"x\u000eI1!I\u0006$X\rI5g\u0015\u0001\u0002\u0003\u0005\t\u0011!i\",\u0007\u0005\u00194ni\u0002\u0004\u0013n\u001d\u0011p[&$H/\u001a3/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\ty(\u0001B\u0010\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C-\u0019;f?N$(\u000fI\u0017!\u0003\u0002\u001aHO]5oO\u0002\"x\u000e\t2fAA\f'o]3eAQ|\u0007\u0005Z1uK:R\u0001\u0005\t\u0011!A\u0001R\u0003EZ7uA5\u0002C)\u0019;fA\u0019|'/\\1uAA\fG\u000f^3s]\u0002\"x\u000e\t4pY2|wO\f\u0011TK\u0016\u0004C(\u0019\u0011ie\u00164WH\t5uiB\u001c(hL\u0018ta\u0006\u00148NL1qC\u000eDWML8sO>\"wnY:0Y\u0006$Xm\u001d;0gFdWF]3g[\u0011\fG/\u001a;j[\u0016l\u0003/\u0019;uKJtg\u0006\u001b;nY\nrD)\u0019;fi&lW\r\t)biR,'O\\:=_\u0005t\u0004EZ8sAY\fG.\u001b3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!I\u0006$X\rI1oI\u0002\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:og:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QQ\u0001\u0002.)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aAJT\u0006M\u001c.gAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1cYj\u0013GM\u00174c\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cYj\u0013GM\u00174c)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\f\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAI\u0003\u0015\td&\u000e\u00181\u0003-\u0001\u0016M]:f)>$\u0015\r^3\u0011\u0005AR2#\u0002\u000e\u0002\u001a\u0006\u0015\u0006\u0003CAN\u0003CS\u0005K\u0013-\u000e\u0005\u0005u%bAAPq\u00059!/\u001e8uS6,\u0017\u0002BAR\u0003;\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t9+!,\u000e\u0005\u0005%&\u0002BAV\u0003_\t!![8\n\u0007\u0019\u000bI\u000b\u0006\u0002\u0002\u0016\u0006AAo\\*ue&tw\r\u0006\u0002\u0002(\u0005)\u0011\r\u001d9msR9\u0001,!/\u0002<\u0006u\u0006\"\u0002%\u001e\u0001\u0004Q\u0005\"\u0002(\u001e\u0001\u0004\u0001\u0006\"\u0002+\u001e\u0001\u0004Q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\fY\r\u0005\u00038#\u0006\u0015\u0007CB\u001c\u0002H*\u0003&*C\u0002\u0002Jb\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAg=\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002TB!\u0011\u0011FAk\u0013\u0011\t9.a\u000b\u0003\r=\u0013'.Z2u\u0001")
public class ParseToDate
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToDate parseToDate) {
        return ParseToDate$.MODULE$.unapply(parseToDate);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToDate>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public ParseToDate withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToDate(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "format";
                break;
            }
            case 2: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToDate.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new Cast(new GetTimestamp(left, format, TimestampType$.MODULE$, GetTimestamp$.MODULE$.apply$default$4(), GetTimestamp$.MODULE$.apply$default$5()), DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, DateType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
    }
}

