/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ", arguments="\n    Arguments:\n      * buckets - an int expression which is number of buckets to divide the rows in.\n          Default value is 1.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u0015+\u0001^B\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\t9\u0002\u0011\t\u0012)A\u0005\u000b\")Q\f\u0001C\u0001=\")Q\f\u0001C\u0001C\")!\r\u0001C!7\")1\r\u0001C!I\"91\u000e\u0001b\u0001\n\u0013a\u0007B\u00029\u0001A\u0003%Q\u000eC\u0004r\u0001\t\u0007I\u0011\u00027\t\rI\u0004\u0001\u0015!\u0003n\u0011\u001d\u0019\bA1A\u0005\n1Da\u0001\u001e\u0001!\u0002\u0013i\u0007bB;\u0001\u0005\u0004%I\u0001\u001c\u0005\u0007m\u0002\u0001\u000b\u0011B7\t\u000b]\u0004A\u0011\u0002=\t\u000fy\u0004!\u0019!C!\u007f\"A\u0011\u0011\u0003\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0011\u0002\u0016!A\u0011\u0011\u0004\u0001!\u0002\u0013\t9\u0002C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0011\u0002\u0016!A\u0011Q\u0004\u0001!\u0002\u0013\t9\u0002\u0003\u0005\u0002 \u0001\u0011\r\u0011\"\u0011m\u0011\u001d\t\t\u0003\u0001Q\u0001\n5Dq!a\t\u0001\t#\n)\u0003C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u0011\u0011\u0007\u0001\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u0013\u0002\u0011\u0011!C!\u0003\u0017B\u0011\"!\u0018\u0001\u0003\u0003%\t!a\u0018\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0004\"CA;\u0001\u0005\u0005I\u0011IA<\u0011%\t\t\tAA\u0001\n\u0003\t\u0019\tC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0011\u0002\u0010\"I\u00111\u0013\u0001\u0002\u0002\u0013\u0005\u0013QS\u0004\n\u0003\u007fS\u0013\u0011!E\u0001\u0003\u00034\u0001\"\u000b\u0016\u0002\u0002#\u0005\u00111\u0019\u0005\u0007;\u000e\"\t!a7\t\u0013\u0005u7%!A\u0005F\u0005}\u0007\"CAqG\u0005\u0005I\u0011QAr\u0011%\t9oIA\u0001\n\u0003\u000bI\u000fC\u0005\u0002v\u000e\n\t\u0011\"\u0003\u0002x\n)a\nV5mK*\u00111\u0006L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002.]\u0005A1-\u0019;bYf\u001cHO\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014!B:qCJ\\'BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001qqz\u0004J\u0014\t\u0003sij\u0011AK\u0005\u0003w)\u0012QBU8x\u001dVl'-\u001a:MS.,\u0007CA\u001d>\u0013\tq$FA\fTSj,')Y:fI^Kg\u000eZ8x\rVt7\r^5p]B\u0019\u0001iQ#\u000e\u0003\u0005S!A\u0011\u0017\u0002\u000bQ\u0014X-Z:\n\u0005\u0011\u000b%!C+oCJLH*[6f!\tId)\u0003\u0002HU\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\u000fA\u0013x\u000eZ;diB\u0011qj\u0016\b\u0003!Vs!!\u0015+\u000e\u0003IS!a\u0015\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0015B\u0001,K\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005YS\u0015a\u00022vG.,Go]\u000b\u0002\u000b\u0006A!-^2lKR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0002\u0004\"!\u000f\u0001\t\u000bi\u001b\u0001\u0019A#\u0015\u0003}\u000bQa\u00195jY\u0012\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q2\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003U\u001e\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0007EV\u001c7.\u001a;\u0016\u00035\u0004\"!\u000f8\n\u0005=T#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fqAY;dW\u0016$\b%A\bck\u000e\\W\r\u001e+ie\u0016\u001c\bn\u001c7e\u0003A\u0011WoY6fiRC'/Z:i_2$\u0007%\u0001\u0006ck\u000e\\W\r^*ju\u0016\f1BY;dW\u0016$8+\u001b>fA\u0005\u0011\"-^2lKR\u001cx+\u001b;i!\u0006$G-\u001b8h\u0003M\u0011WoY6fiN<\u0016\u000e\u001e5QC\u0012$\u0017N\\4!\u00039\u0011WoY6fi>3XM\u001d4m_^$\"!\u001f?\u0011\u0005eR\u0018BA>+\u0005\tIe\rC\u0003~\u001f\u0001\u0007Q)A\u0001f\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\t\t\t\u0001E\u0003\u0002\u0004\u00055Q.\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%IW.\\;uC\ndWMC\u0002\u0002\f)\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty!!\u0002\u0003\u0007M+\u0017/\u0001\u000bbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7\u000fI\u0001\u000eS:LG/[1m-\u0006dW/Z:\u0016\u0005\u0005]\u0001#BA\u0002\u0003\u001b)\u0015AD5oSRL\u0017\r\u001c,bYV,7\u000fI\u0001\u0012kB$\u0017\r^3FqB\u0014Xm]:j_:\u001c\u0018AE;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0002\n!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006\u0019RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8oA\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aXA\u0014\u0011\u0019\tI\u0003\u0007a\u0001\u000b\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcA0\u00020!9!,\u0007I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kQ3!RA\u001cW\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0013Ut7\r[3dW\u0016$'bAA\"\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0013Q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002NA!\u0011qJA-\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00027b]\u001eT!!a\u0016\u0002\t)\fg/Y\u0005\u0005\u00037\n\tF\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00022!SA2\u0013\r\t)G\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\n\t\bE\u0002J\u0003[J1!a\u001cK\u0005\r\te.\u001f\u0005\n\u0003gj\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA=!\u0019\tY(! \u0002l5\u0011\u0011\u0011B\u0005\u0005\u0003\u007f\nIA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAC\u0003\u0017\u00032!SAD\u0013\r\tII\u0013\u0002\b\u0005>|G.Z1o\u0011%\t\u0019hHA\u0001\u0002\u0004\tY'\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA'\u0003#C\u0011\"a\u001d!\u0003\u0003\u0005\r!!\u0019\u0002\r\u0015\fX/\u00197t)\u0011\t))a&\t\u0013\u0005M\u0014%!AA\u0002\u0005-\u0004f\u0006\u0001\u0002\u001c\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u00024\u0006U\u0016\u0011XA^!\rI\u0014QT\u0005\u0004\u0003?S#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003K\u000bAO\u0003\u0011!A\u0001zf)\u0016(D?\"r\u0017\u0006I\u0017!\t&4\u0018\u000eZ3tAQDW\r\t:poN\u0004cm\u001c:!K\u0006\u001c\u0007\u000eI<j]\u0012|w\u000f\t9beRLG/[8oA%tGo\u001c\u0011a]\u0002\u0004#-^2lKR\u001c\bE]1oO&twM\u0003\u0011!A\u0001\u0002\u0003E\u001a:p[\u0002\n\u0004\u0005^8!CR\u0004Sn\\:uA\u0001t\u0007M\f\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003W\u000b\u0011Q\u0002\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\t,8m[3ug\u0002j\u0003%\u00198!S:$\b%\u001a=qe\u0016\u001c8/[8oA]D\u0017n\u00195!SN\u0004c.^7cKJ\u0004sN\u001a\u0011ck\u000e\\W\r^:!i>\u0004C-\u001b<jI\u0016\u0004C\u000f[3!e><8\u000fI5o])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t#fM\u0006,H\u000e\u001e\u0011wC2,X\rI5tAEr#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!-\u0002\u0003/S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!E2\u0002sLR+O\u0007~C#'\u000b\u0011P-\u0016\u0013\u0006\u0005\u000b)B%RKE+S(OA\tK\u0006%\u0019\u0011P%\u0012+%\u000b\t\"ZA\tL\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bs%Q\u0019(Y\u0001\u0012\u0014\u0006\f\u0011)O\u0005\u000bt\u0005\f\u00112S1\u0002\u0003fJ!3O1\u00023'\u000b\u0017!Q\u001d\n\u0015g\n\u0017!c%\u0002C/\u00192)C2\u0002#-K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ\u0011'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ\u0011'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!'\u0003\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ1'C\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a.\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0016\u0001D<j]\u0012|wo\u00184v]\u000e\u001c\u0018!\u0002(US2,\u0007CA\u001d$'\u0015\u0019\u0013QYAi!\u0019\t9-!4F?6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017T\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u001f\fIMA\tBEN$(/Y2u\rVt7\r^5p]F\u0002B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0005\u0003/\f)&\u0001\u0002j_&\u0019\u0001,!6\u0015\u0005\u0005\u0005\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0013!B1qa2LHcA0\u0002f\")!L\na\u0001\u000b\u00069QO\\1qa2LH\u0003BAv\u0003c\u0004B!SAw\u000b&\u0019\u0011q\u001e&\u0003\r=\u0003H/[8o\u0011!\t\u0019pJA\u0001\u0002\u0004y\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011 \t\u0005\u0003\u001f\nY0\u0003\u0003\u0002~\u0006E#AB(cU\u0016\u001cG\u000f")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction,
UnaryLike<Expression> {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private transient Seq<Expression> children;
    private AttributeReference n;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(NTile nTile) {
        return NTile$.MODULE$.unapply(nTile);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, NTile> compose(Function1<A$, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NTile nTile = this;
        synchronized (nTile) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Expression child() {
        return this.buckets();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.buckets().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append("Buckets expression must be foldable, but got ").append(this.buckets()).toString());
        }
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(49).append("Buckets expression must be integer type, but got ").append(this.buckets()).toString());
        }
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        return i > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Buckets expression must be positive, but got: ").append(i).toString());
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public NTile withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.buckets();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "buckets";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        UnaryLike.$init$(this);
        String x$1 = "bucket";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("bucket", x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("bucket", x$2, false, x$4);
        this.bucket = new AttributeReference("bucket", x$2, false, x$4, x$5, x$6);
        String x$7 = "bucketThreshold";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("bucketThreshold", x$8, false, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6("bucketThreshold", x$8, false, x$10);
        this.bucketThreshold = new AttributeReference("bucketThreshold", x$8, false, x$10, x$11, x$12);
        String x$13 = "bucketSize";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5("bucketSize", x$14, false, x$16);
        Seq<String> x$18 = AttributeReference$.MODULE$.apply$default$6("bucketSize", x$14, false, x$16);
        this.bucketSize = new AttributeReference("bucketSize", x$14, false, x$16, x$17, x$18);
        String x$19 = "bucketsWithPadding";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5("bucketsWithPadding", x$20, false, x$22);
        Seq<String> x$24 = AttributeReference$.MODULE$.apply$default$6("bucketsWithPadding", x$20, false, x$22);
        this.bucketsWithPadding = new AttributeReference("bucketsWithPadding", x$20, false, x$22, x$23, x$24);
        this.aggBufferAttributes = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{this.rowNumber(), this.bucket(), this.bucketThreshold(), this.bucketSize(), this.bucketsWithPadding()}));
        this.initialValues = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.zero(), this.zero(), this.zero(), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).cast(DecimalType$.MODULE$.IntDecimal())).$div(package$expressions$.MODULE$.DslExpression(buckets).cast(DecimalType$.MODULE$.IntDecimal()))).cast(IntegerType$.MODULE$), package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast(IntegerType$.MODULE$)}));
        this.updateExpressions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), NoOp$.MODULE$, NoOp$.MODULE$}));
        this.evaluateExpression = this.bucket();
        Statics.releaseFence();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

