/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u0016-\u0001fB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tC\u0002\u0011\t\u0012)A\u0005=\"A!\r\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003_\u0011!!\u0007A!f\u0001\n\u0003i\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u00020\t\u0011\u0019\u0004!Q3A\u0005\u0002\u001dD\u0001b\u001d\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\u0006i\u0002!\ta\u001f\u0005\u0006i\u0002!\tA \u0005\u0007\u0003\u000b\u0001A\u0011I/\t\r\u0005\u001d\u0001\u0001\"\u0011^\u0011\u0019\tI\u0001\u0001C!;\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!I\u0011q\u000f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003\u0007\u0003\u0011\u0013!C\u0001\u0003\u000bC\u0011\"a'\u0001#\u0003%\t!!\"\t\u0013\u0005u\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAP\u0001E\u0005I\u0011AAQ\u0011%\t)\u000bAA\u0001\n\u0003\n9\u000bC\u0005\u00028\u0002\t\t\u0011\"\u0001\u0002:\"I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00111\u0019\u0005\n\u0003\u0013\u0004\u0011\u0011!C!\u0003\u0017D\u0011\"!7\u0001\u0003\u0003%\t!a7\t\u0013\u0005\u0015\b!!A\u0005B\u0005\u001d\b\"CAv\u0001\u0005\u0005I\u0011IAw\u000f%\u0011\t\u0002LA\u0001\u0012\u0003\u0011\u0019B\u0002\u0005,Y\u0005\u0005\t\u0012\u0001B\u000b\u0011\u0019!8\u0005\"\u0001\u0003.!I!qF\u0012\u0002\u0002\u0013\u0015#\u0011\u0007\u0005\n\u0005g\u0019\u0013\u0011!CA\u0005kA\u0011Ba\u0010$#\u0003%\t!!)\t\u0013\t\u00053%!A\u0005\u0002\n\r\u0003\"\u0003B)GE\u0005I\u0011AAQ\u0011%\u0011\u0019fIA\u0001\n\u0013\u0011)FA\u0007N_:$\bn\u001d\"fi^,WM\u001c\u0006\u0003[9\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0006M\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011GM\u0001\u0004gFd'BA\u001a5\u0003\u0015\u0019\b/\u0019:l\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\u0004\u0001M9\u0001A\u000f B\t.\u000b\u0006CA\u001e=\u001b\u0005a\u0013BA\u001f-\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003w}J!\u0001\u0011\u0017\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\u001eC\u0013\t\u0019EF\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t)\u0005J\u0004\u0002<\r&\u0011q\tL\u0001\ba\u0006\u001c7.Y4f\u0013\tI%J\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u001dc\u0003C\u0001'P\u001b\u0005i%\"\u0001(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ak%a\u0002)s_\u0012,8\r\u001e\t\u0003%fs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005YC\u0014A\u0002\u001fs_>$h(C\u0001O\u0013\t9U*\u0003\u0002[7\na1+\u001a:jC2L'0\u00192mK*\u0011q)T\u0001\u0006I\u0006$X-M\u000b\u0002=B\u00111hX\u0005\u0003A2\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019!\u0017\r^32A\u0005)A-\u0019;fe\u00051A-\u0019;fe\u0001\n\u0001B]8v]\u0012|eMZ\u0001\ne>,h\u000eZ(gM\u0002\n!\u0002^5nKj{g.Z%e+\u0005A\u0007c\u0001'jW&\u0011!.\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051\u0004hBA7o!\t!V*\u0003\u0002p\u001b\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\tyW*A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003wobL(\u0010\u0005\u0002<\u0001!)A,\u0003a\u0001=\")!-\u0003a\u0001=\")A-\u0003a\u0001=\"9a-\u0003I\u0001\u0002\u0004AGc\u0001<}{\")AL\u0003a\u0001=\")!M\u0003a\u0001=R1ao`A\u0001\u0003\u0007AQ\u0001X\u0006A\u0002yCQAY\u0006A\u0002yCQ\u0001Z\u0006A\u0002y\u000bQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017AC5oaV$H+\u001f9fgV\u0011\u0011q\u0002\t\u0006%\u0006E\u0011QC\u0005\u0004\u0003'Y&aA*fcB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001cA\nQ\u0001^=qKNLA!a\b\u0002\u001a\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011Q\u0005\t\u0005\u0003/\t9#\u0003\u0003\u0002*\u0005e!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0007y\ny\u0003C\u0003g#\u0001\u00071.\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u00026\u0005m\u0012qHA\"!\ra\u0015qG\u0005\u0004\u0003si%aA!os\"9\u0011Q\b\nA\u0002\u0005U\u0012A\u0001;2\u0011\u001d\t\tE\u0005a\u0001\u0003k\t!\u0001\u001e\u001a\t\r\u0011\u0014\u0002\u0019AA\u001b\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002J\u0005U\u0013q\f\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0017\u0002\u000f\r|G-Z4f]&!\u00111KA'\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA,'\u0001\u0007\u0011\u0011L\u0001\u0004GRD\b\u0003BA&\u00037JA!!\u0018\u0002N\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA1'\u0001\u0007\u0011\u0011J\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005Y\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001d1\u00181NA8\u0003gBa!!\u001c\u0016\u0001\u0004q\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005ET\u00031\u0001_\u0003%qWm^*fG>tG\r\u0003\u0004\u0002vU\u0001\rAX\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)%1\u00181PA?\u0003\u007f\n\t\tC\u0004]-A\u0005\t\u0019\u00010\t\u000f\t4\u0002\u0013!a\u0001=\"9AM\u0006I\u0001\u0002\u0004q\u0006b\u00024\u0017!\u0003\u0005\r\u0001[\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9IK\u0002_\u0003\u0013[#!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+k\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011TAH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002$*\u001a\u0001.!#\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\t1\fgn\u001a\u0006\u0003\u0003g\u000bAA[1wC&\u0019\u0011/!,\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0006c\u0001'\u0002>&\u0019\u0011qX'\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u0012Q\u0019\u0005\n\u0003\u000fl\u0012\u0011!a\u0001\u0003w\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAg!\u0019\ty-!6\u000265\u0011\u0011\u0011\u001b\u0006\u0004\u0003'l\u0015AC2pY2,7\r^5p]&!\u0011q[Ai\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u\u00171\u001d\t\u0004\u0019\u0006}\u0017bAAq\u001b\n9!i\\8mK\u0006t\u0007\"CAd?\u0005\u0005\t\u0019AA\u001b\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005%\u0016\u0011\u001e\u0005\n\u0003\u000f\u0004\u0013\u0011!a\u0001\u0003w\u000ba!Z9vC2\u001cH\u0003BAo\u0003_D\u0011\"a2\"\u0003\u0003\u0005\r!!\u000e)'\u0001\t\u00190!?\u0002|\u0006}(\u0011\u0001B\u0003\u0005\u000f\u0011YA!\u0004\u0011\u0007m\n)0C\u0002\u0002x2\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002~\u0006\u0019\u0019A\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007/\r\u0017!i&lWm\u001d;b[B\u00144\f\f\u0011s_VtGm\u00144g;&\u0002S\u0006I%gA\u0001$\u0018.\\3ti\u0006l\u0007/\r1!SN\u0004C.\u0019;fe\u0002\"\b.\u00198!ARLW.Z:uC6\u0004(\u0007\u0019\u0017!i\",g\u000e\t;iK\u0002\u0012Xm];mi*\u0001\u0003\u0005\t\u0011!A%\u001c\b\u0005]8tSRLg/\u001a\u0018!\u0013\u001a\u0004\u0003\r^5nKN$\u0018-\u001c92A\u0002\ng\u000e\u001a\u0011ai&lWm\u001d;b[B\u0014\u0004\rI1sK\u0002zg\u000e\t;iK\u0002\u001a\u0018-\\3!I\u0006L\be\u001c4![>tG\u000f\u001b\u0017!_J\u0004#m\u001c;i\u0015\u0001\u0002\u0003\u0005\t\u0011!CJ,\u0007\u0005\u001e5fA1\f7\u000f\u001e\u0011eCf\u0004sN\u001a\u0011n_:$\b\u000e\f\u0011uS6,\u0007e\u001c4!I\u0006L\be^5mY\u0002\u0012W\rI5h]>\u0014X\r\u001a\u0018!\u001fRDWM]<jg\u0016d\u0003\u0005\u001e5fA\u0011LgMZ3sK:\u001cW\rI5t\u0015\u0001\u0002\u0003\u0005\t\u0011!G\u0006d7-\u001e7bi\u0016$\u0007EY1tK\u0012\u0004sN\u001c\u00114c\u0001\"\u0017-_:!a\u0016\u0014\b%\\8oi\"d\u0003%\u00198eAI|WO\u001c3fI\u0002\"x\u000e\t\u001d!I&<\u0017\u000e^:!k:dWm]:!e>,h\u000eZ(gMv2\u0017\r\\:f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\u0019!AA=\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013'O\u001d8[A\u0012TF\r\u001d!cAR4\u0007\r\u001e1a\u001db\u0003eJ\u0019:sYj\u0013\u0007M\u00174a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/sQJT'\u000f\u001c8o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%M\u001d:o5\u0002$'\f\u001a9AE\u0002$h\r\u0019;aA:C\u0006I\u00142se2T&\r\u0019.gA:C\u0006\t4bYN,\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114]e\"\u0014(N\u001d7o]\"\u0014'O\u001a6ia*$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t%\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u001f\tQ!\r\u00186]A\nQ\"T8oi\"\u001c()\u001a;xK\u0016t\u0007CA\u001e$'\u0015\u0019#q\u0003B\u0012!%\u0011IBa\b_=zCg/\u0004\u0002\u0003\u001c)\u0019!QD'\u0002\u000fI,h\u000e^5nK&!!\u0011\u0005B\u000e\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()!!\u0011FAY\u0003\tIw.C\u0002[\u0005O!\"Aa\u0005\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!+\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013Y\u00149D!\u000f\u0003<\tu\u0002\"\u0002/'\u0001\u0004q\u0006\"\u00022'\u0001\u0004q\u0006\"\u00023'\u0001\u0004q\u0006b\u00024'!\u0003\u0005\r\u0001[\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B#\u0005\u001b\u0002B\u0001T5\u0003HA9AJ!\u0013_=zC\u0017b\u0001B&\u001b\n1A+\u001e9mKRB\u0001Ba\u0014)\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003XA!\u00111\u0016B-\u0013\u0011\u0011Y&!,\u0003\r=\u0013'.Z2u\u0001")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression first() {
        return this.date1();
    }

    @Override
    public Expression second() {
        return this.date2();
    }

    @Override
    public Expression third() {
        return this.roundOff();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    @Override
    public MonthsBetween withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.date1();
                break;
            }
            case 1: {
                object = this.date2();
                break;
            }
            case 2: {
                object = this.roundOff();
                break;
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "date1";
                break;
            }
            case 1: {
                string = "date2";
                break;
            }
            case 2: {
                string = "roundOff";
                break;
            }
            case 3: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

