/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\rMb\u0001\u0002\"D\u0001BC\u0001b\u001d\u0001\u0003\u0016\u0004%\t\u0001\u001e\u0005\tq\u0002\u0011\t\u0012)A\u0005k\"A\u0011\u0010\u0001BK\u0002\u0013\u0005A\u000f\u0003\u0005{\u0001\tE\t\u0015!\u0003v\u0011!Y\bA!f\u0001\n\u0003!\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B;\t\u0011u\u0004!Q3A\u0005\u0002QD\u0001B \u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\t\u007f\u0002\u0011)\u001a!C\u0001i\"I\u0011\u0011\u0001\u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\n\u0003\u0007\u0001!Q3A\u0005\u0002QD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B;\t\u0015\u0005\u001d\u0001A!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0012)A\u0005\u0003\u0017A!\"a\u0005\u0001\u0005+\u0007I\u0011AA\u000b\u0011)\tI\u0003\u0001B\tB\u0003%\u0011q\u0003\u0005\u000b\u0003W\u0001!Q3A\u0005\u0002\u00055\u0002BCA\u001b\u0001\tE\t\u0015!\u0003\u00020!Q\u0011q\u0007\u0001\u0003\u0016\u0004%\t%!\u000f\t\u0015\u0005\u001d\u0003A!E!\u0002\u0013\tY\u0004C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005%\u0003\u0001\"\u0001\u0002d!9\u0011\u0011\n\u0001\u0005\u0002\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t9\n\u0001C!\u0003[Aq!!'\u0001\t\u0003\nY\nC\u0004\u0002 \u0002!I!!)\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\"9\u00111\u001e\u0001\u0005B\u00055\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u0005\u001b\u0001A\u0011\u000bB\b\u0011%\u0011Y\u0002AA\u0001\n\u0003\u0011i\u0002C\u0005\u00034\u0001\t\n\u0011\"\u0001\u00036!I!1\n\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0001\u0005kA\u0011Ba\u0014\u0001#\u0003%\tA!\u000e\t\u0013\tE\u0003!%A\u0005\u0002\tU\u0002\"\u0003B*\u0001E\u0005I\u0011\u0001B\u001b\u0011%\u0011)\u0006AI\u0001\n\u0003\u00119\u0006C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^!I!\u0011\r\u0001\u0012\u0002\u0013\u0005!1\r\u0005\n\u0005O\u0002\u0011\u0013!C\u0001\u0005SB\u0011B!\u001c\u0001\u0003\u0003%\tEa\u001c\t\u0013\tm\u0004!!A\u0005\u0002\tu\u0004\"\u0003B@\u0001\u0005\u0005I\u0011\u0001BA\u0011%\u00119\tAA\u0001\n\u0003\u0012I\tC\u0005\u0003\u0018\u0002\t\t\u0011\"\u0001\u0003\u001a\"I!Q\u0014\u0001\u0002\u0002\u0013\u0005#q\u0014\u0005\n\u0005G\u0003\u0011\u0011!C!\u0005K;\u0011Ba4D\u0003\u0003E\tA!5\u0007\u0011\t\u001b\u0015\u0011!E\u0001\u0005'Dq!!\u00135\t\u0003\u0011Y\u000fC\u0005\u0003nR\n\t\u0011\"\u0012\u0003p\"I!\u0011\u001f\u001b\u0002\u0002\u0013\u0005%1\u001f\u0005\n\u0007\u0013!\u0014\u0013!C\u0001\u0005/B\u0011ba\u00035#\u0003%\tA!\u0018\t\u0013\r5A'%A\u0005\u0002\t\r\u0004\"CB\biE\u0005I\u0011\u0001B5\u0011%\u0019\t\u0002NA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0004\"Q\n\n\u0011\"\u0001\u0003X!I11\u0005\u001b\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0007K!\u0014\u0013!C\u0001\u0005GB\u0011ba\n5#\u0003%\tA!\u001b\t\u0013\r%B'!A\u0005\n\r-\"!D'bW\u0016$\u0016.\\3ti\u0006l\u0007O\u0003\u0002E\u000b\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1u)\u0001\u0005dCR\fG._:u\u0015\tA\u0015*A\u0002tc2T!AS&\u0002\u000bM\u0004\u0018M]6\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011+\u0016-\\E\"\u0004\"AU*\u000e\u0003\rK!\u0001V\"\u0003'M+\u0007\u000f^3oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I3\u0016BA,D\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002S3&\u0011!l\u0011\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Al\u0018\b\u0003%vK!AX\"\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tq6\t\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GMA\u0004Qe>$Wo\u0019;\u0011\u0005%\u0004hB\u00016p\u001d\tYg.D\u0001m\u0015\tiw*\u0001\u0004=e>|GOP\u0005\u0002K&\u0011a\fZ\u0005\u0003cJ\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u00183\u0002\te,\u0017M]\u000b\u0002kB\u0011!K^\u0005\u0003o\u000e\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015IX-\u0019:!\u0003\u0015iwN\u001c;i\u0003\u0019iwN\u001c;iA\u0005\u0019A-Y=\u0002\t\u0011\f\u0017\u0010I\u0001\u0005Q>,(/A\u0003i_V\u0014\b%A\u0002nS:\fA!\\5oA\u0005\u00191/Z2\u0002\tM,7\rI\u0001\ti&lWM_8oKV\u0011\u00111\u0002\t\u0005G\u00065Q/C\u0002\u0002\u0010\u0011\u0014aa\u00149uS>t\u0017!\u0003;j[\u0016TxN\\3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0003\u0003/\u0001RaYA\u0007\u00033\u0001B!a\u0007\u0002$9!\u0011QDA\u0010!\tYG-C\u0002\u0002\"\u0011\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011I\u0006YA/[7f5>tW-\u00133!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0005\u0005=\u0002cA2\u00022%\u0019\u00111\u00073\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u001d\u000bQ\u0001^=qKNLA!!\u0012\u0002@\tAA)\u0019;b)f\u0004X-A\u0005eCR\fG+\u001f9fA\u00051A(\u001b8jiz\"b#!\u0014\u0002P\u0005E\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011\r\t\u0003%\u0002AQa]\u000bA\u0002UDQ!_\u000bA\u0002UDQa_\u000bA\u0002UDQ!`\u000bA\u0002UDQa`\u000bA\u0002UDa!a\u0001\u0016\u0001\u0004)\b\"CA\u0004+A\u0005\t\u0019AA\u0006\u0011%\t\u0019\"\u0006I\u0001\u0002\u0004\t9\u0002C\u0005\u0002,U\u0001\n\u00111\u0001\u00020!I\u0011qG\u000b\u0011\u0002\u0003\u0007\u00111\b\u000b\u000f\u0003\u001b\n)'a\u001a\u0002j\u0005-\u0014QNA8\u0011\u0015\u0019h\u00031\u0001v\u0011\u0015Ih\u00031\u0001v\u0011\u0015Yh\u00031\u0001v\u0011\u0015ih\u00031\u0001v\u0011\u0015yh\u00031\u0001v\u0011\u0019\t\u0019A\u0006a\u0001kR\u0001\u0012QJA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014q\u0010\u0005\u0006g^\u0001\r!\u001e\u0005\u0006s^\u0001\r!\u001e\u0005\u0006w^\u0001\r!\u001e\u0005\u0006{^\u0001\r!\u001e\u0005\u0006\u007f^\u0001\r!\u001e\u0005\u0007\u0003\u00079\u0002\u0019A;\t\r\u0005\u001dq\u00031\u0001v\u0003!\u0019\u0007.\u001b7ee\u0016tWCAAC!\u0011I\u0017qQ;\n\u0007\u0005%%OA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\t\ty\tE\u0003j\u0003\u000f\u000b\t\n\u0005\u0003\u0002>\u0005M\u0015\u0002BAK\u0003\u007f\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\fAb^5uQRKW.\u001a.p]\u0016$2!VAO\u0011\u001d\t\u0019b\u0007a\u0001\u00033\t\u0001\u0002^8NS\u000e\u0014xn\u001d\u000b\u0011\u0003G\u000bI+!-\u00024\u0006U\u0016qWA]\u0003\u0007\u00042aYAS\u0013\r\t9\u000b\u001a\u0002\u0004\u0003:L\bBB:\u001d\u0001\u0004\tY\u000bE\u0002d\u0003[K1!a,e\u0005\rIe\u000e\u001e\u0005\u0007sr\u0001\r!a+\t\rmd\u0002\u0019AAV\u0011\u0019iH\u00041\u0001\u0002,\"1q\u0010\ba\u0001\u0003WCq!a/\u001d\u0001\u0004\ti,\u0001\u0007tK\u000e\fe\u000eZ'jGJ|7\u000f\u0005\u0003\u0002>\u0005}\u0016\u0002BAa\u0003\u007f\u0011q\u0001R3dS6\fG\u000eC\u0004\u0002Fr\u0001\r!a2\u0002\ri|g.Z%e!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA\u0001^5nK*\u0011\u0011\u0011[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0006-'A\u0002.p]\u0016LE-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\t\u0002$\u0006m\u0017Q\\Ap\u0003C\f\u0019/!:\u0002h\"11/\ba\u0001\u0003GCa!_\u000fA\u0002\u0005\r\u0006BB>\u001e\u0001\u0004\t\u0019\u000b\u0003\u0004~;\u0001\u0007\u00111\u0015\u0005\u0007\u007fv\u0001\r!a)\t\u000f\u0005\rQ\u00041\u0001\u0002$\"9\u0011qA\u000fA\u0002\u0005%\b#B2\u0002\u000e\u0005\r\u0016!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty/a?\u0003\u0006A!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\u000e\u000bqaY8eK\u001e,g.\u0003\u0003\u0002z\u0006M(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005uh\u00041\u0001\u0002\u0000\u0006\u00191\r\u001e=\u0011\t\u0005E(\u0011A\u0005\u0005\u0005\u0007\t\u0019P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t\u001da\u00041\u0001\u0002p\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA\r\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0002N\tE\u0001b\u0002B\nA\u0001\u0007!QC\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003j\u0005/)\u0018b\u0001B\re\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\u0017\u0003\u001b\u0012yB!\t\u0003$\t\u0015\"q\u0005B\u0015\u0005W\u0011iCa\f\u00032!91/\tI\u0001\u0002\u0004)\bbB=\"!\u0003\u0005\r!\u001e\u0005\bw\u0006\u0002\n\u00111\u0001v\u0011\u001di\u0018\u0005%AA\u0002UDqa`\u0011\u0011\u0002\u0003\u0007Q\u000f\u0003\u0005\u0002\u0004\u0005\u0002\n\u00111\u0001v\u0011%\t9!\tI\u0001\u0002\u0004\tY\u0001C\u0005\u0002\u0014\u0005\u0002\n\u00111\u0001\u0002\u0018!I\u00111F\u0011\u0011\u0002\u0003\u0007\u0011q\u0006\u0005\n\u0003o\t\u0003\u0013!a\u0001\u0003w\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00038)\u001aQO!\u000f,\u0005\tm\u0002\u0003\u0002B\u001f\u0005\u000fj!Aa\u0010\u000b\t\t\u0005#1I\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0012e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\u0012yDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011IF\u000b\u0003\u0002\f\te\u0012AD2paf$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005?RC!a\u0006\u0003:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012JTC\u0001B3U\u0011\tyC!\u000f\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cA*\"Aa\u001b+\t\u0005m\"\u0011H\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tE\u0004\u0003\u0002B:\u0005sj!A!\u001e\u000b\t\t]\u0014qZ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\tU\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAV\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a)\u0003\u0004\"I!Q\u0011\u0018\u0002\u0002\u0003\u0007\u00111V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0005C\u0002BG\u0005'\u000b\u0019+\u0004\u0002\u0003\u0010*\u0019!\u0011\u00133\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0016\n=%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\f\u0003\u001c\"I!Q\u0011\u0019\u0002\u0002\u0003\u0007\u00111U\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003r\t\u0005\u0006\"\u0003BCc\u0005\u0005\t\u0019AAV\u0003\u0019)\u0017/^1mgR!\u0011q\u0006BT\u0011%\u0011)IMA\u0001\u0002\u0004\t\u0019\u000bK\f\u0001\u0005W\u0013\tLa-\u00038\ne&Q\u0018B`\u0005\u0007\u0014)M!3\u0003LB\u0019!K!,\n\u0007\t=6IA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tU\u0016!a0`\rVs5i\u0018\u0015zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c7\f\f\u0011uS6,'p\u001c8f;&\u0002S\u0006I\"sK\u0006$X\r\t;j[\u0016\u001cH/Y7qA\u0019\u0014x.\u001c\u0011zK\u0006\u0014H\u0006I7p]RDG\u0006\t3bs2\u0002\u0003n\\;sY\u0001j\u0017N\u001c\u0017!g\u0016\u001c\u0007%\u00198eAQLW.\u001a>p]\u0016\u0004c-[3mINt\u0003\u0005\u00165fAI,7/\u001e7uA\u0011\fG/\u0019\u0011usB,\u0007%[:!G>t7/[:uK:$\be^5uQ\u0002\"\b.\u001a\u0011wC2,X\rI8gA\r|gNZ5hkJ\fG/[8oA\u0001\u001c\b/\u0019:l]M\fHN\f;j[\u0016\u001cH/Y7q)f\u0004X\rY\u0001\nCJ<W/\\3oiN\f#Aa/\u0002\u000b/S\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I=fCJ\u0004S\u0006\t;iK\u0002JX-\u0019:!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u0004\u0013(O\u001d:\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jwN\u001c;iA5\u0002C\u000f[3![>tG\u000f[\u0017pM6JX-\u0019:!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!Q)\u000bg.^1ss&\u0002Co\u001c\u00112e\u0001BC)Z2f[\n,'/\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u0006L\b%\f\u0011uQ\u0016\u0004C-Y=._\u001alSn\u001c8uQ\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001\"x\u000eI\u001a2\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001Bw.\u001e:![\u0001\"\b.\u001a\u0011i_V\u0014Xf\u001c4.I\u0006L\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!eMR\u0001\u0005\t\u0011!A\u0001R\u0003%\\5oA5\u0002C\u000f[3![&tW\u000f^3._\u001al\u0003n\\;sAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00111AQ|\u0007%N\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM,7\rI\u0017!i\",\u0007e]3d_:$Wf\u001c4.[&tW\u000f^3!C:$\u0007%\u001b;tA5L7M]8.MJ\f7\r^5p]\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000e\t\u001c1])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011wC2,X\rI2b]\u0002\u0012W\rI3ji\",'\u000fI1oA%tG/Z4fe\u0002b\u0017n[3!cM\u0002C\u0006I8sA\u0005\u0004cM]1di&|g\u000e\t7jW\u0016\u0004\u0013g\r\u00182eMr#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00134!i\",\u0007e]3dA\u0005\u0014x-^7f]R\u0004S-];bYN\u0004Co\u001c\u00117a1\u0002C\u000f[3!g\u0016\u001cwN\u001c3tA\u0019LW\r\u001c3!SN\u00043/\u001a;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u0004\u0003\u0007I1oI\u0002\n\u0004%\\5okR,\u0007%[:!C\u0012$W\r\u001a\u0011u_\u0002\"\b.\u001a\u0011gS:\fG\u000e\t;j[\u0016\u001cH/Y7q])\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fu>tW\rI\u0017!i\",\u0007\u0005^5nK\u0002RxN\\3!S\u0012,g\u000e^5gS\u0016\u0014h\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003eQ#UY\u0001*Fk\u0011\u0011b]\u0012\u0004S\r^2/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t\u0005\u0017aa)\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014\u0007\u000e\u0017!cIb\u0003E\r\u001d-AYb\u0003e\r\u0019-AQ*d\u0006\u000f\u001d8SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TF\r\u001d!aYR4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\nD\u0007\f\u00112e1\u0002#\u0007\u000f\u0017!m1\u00023\u0007\r\u0017!iUr\u0003\bO\u001c-A\u001d\u001aU\tV\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001b.cIj#g\u000e\u00113ci\u001a\u0004G\u000f\u001b6]aBtG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aEJD\u0006\t\u001c-AM\u0002D\u0006\t\u001a4Y\u0001*\u0014\b\f\u00117a%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002t'\f\u00192AA\u0002$\b\r\u0019;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002c\u0007\f\u00114a1\u0002#g\r\u0017!keb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'O\u00171m5\u001a\u0004\u0007\t\u001a4uUJ$\bM\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QI\u0002\u0014'\u000f\u0017!cMb\u0003%\r\u0017!cAb\u0003%M\u0019-AE\u0012D\u0006I\u0014Q'R;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8vY2d\u0003e\u000e\u0017!eIb\u0003%M\u001b-AM\u0002D\u0006\t\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\nQa\u001a:pkB\f#Aa2\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!QZ\u0001\u0006g9\u0002d\u0006M\u0001\u000e\u001b\u0006\\W\rV5nKN$\u0018-\u001c9\u0011\u0005I#4#\u0002\u001b\u0003V\n\u0005\b\u0003\u0006Bl\u0005;,X/^;vk\u0006-\u0011qCA\u0018\u0003w\ti%\u0004\u0002\u0003Z*\u0019!1\u001c3\u0002\u000fI,h\u000e^5nK&!!q\u001cBm\u0005I\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0019\u0011\t\t\r(\u0011^\u0007\u0003\u0005KTAAa:\u0002P\u0006\u0011\u0011n\\\u0005\u0004c\n\u0015HC\u0001Bi\u0003!!xn\u0015;sS:<GC\u0001B9\u0003\u0015\t\u0007\u000f\u001d7z)Y\tiE!>\u0003x\ne(1 B\u007f\u0005\u007f\u001c\taa\u0001\u0004\u0006\r\u001d\u0001\"B:8\u0001\u0004)\b\"B=8\u0001\u0004)\b\"B>8\u0001\u0004)\b\"B?8\u0001\u0004)\b\"B@8\u0001\u0004)\bBBA\u0002o\u0001\u0007Q\u000fC\u0005\u0002\b]\u0002\n\u00111\u0001\u0002\f!I\u00111C\u001c\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\n\u0003W9\u0004\u0013!a\u0001\u0003_A\u0011\"a\u000e8!\u0003\u0005\r!a\u000f\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\nq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%s\u0005\u0001\u0012\r\u001d9ms\u0012\"WMZ1vYR$\u0013\u0007M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019)b!\b\u0011\u000b\r\fiaa\u0006\u0011#\r\u001cI\"^;vkV,\u00181BA\f\u0003_\tY$C\u0002\u0004\u001c\u0011\u0014q\u0001V;qY\u0016\f\u0004\u0007C\u0005\u0004 q\n\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0004.A!!1OB\u0018\u0013\u0011\u0019\tD!\u001e\u0003\r=\u0013'.Z2u\u0001")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static DataType $lessinit$greater$default$10() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>> unapply(MakeTimestamp makeTimestamp) {
        return MakeTimestamp$.MODULE$.unapply(makeTimestamp);
    }

    public static DataType apply$default$10() {
        return MakeTimestamp$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, Function1<DataType, MakeTimestamp>>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.year(), this.month(), this.day(), this.hour(), this.min(), this.sec()})).$plus$plus(this.timezone());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(16, 6)})).$plus$plus((IterableOnce)this.timezone().map((Function1 & Serializable)x$8 -> StringType$.MODULE$));
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.nullable())) : true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        DataType x$10 = this.copy$default$10();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9, x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            Long l;
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable)() -> new StringBuilder(61).append("Seconds fraction must have 6 digits for microseconds but got ").append(secAndMicros.scale()).toString());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, (int)1000000L);
            int nanos = Math.floorMod(totalMicros, (int)1000000L) * (int)1000L;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError();
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            if (!(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null)) {
                l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant()));
                return l;
            }
            l = BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt));
            return l;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof DateTimeException)) throw throwable;
            if (this.failOnError()) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw e;" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable)tz -> new StringBuilder(23).append(dtu).append(".getZoneId(").append((String)tz).append(".toString())").toString()).getOrElse((Function0 & Serializable)() -> zid);
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            String toMicrosCode = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n           |java.time.Instant instant = ldt.atZone(").append(zoneId).append(").toInstant();\n           |").append(ev.value()).append(" = ").append(dtu).append(".instantToMicros(instant);\n           |").toString())) : new StringBuilder(31).append(ev.value()).append(" = ").append(dtu).append(".localDateTimeToMicros(ldt);").toString();
            return new StringBuilder(740).append("\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = ").append((String)secAndNanos).append(".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = ").append(d).append("$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((").append((String)secAndNanos).append(".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              ").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError();\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(").append((String)year).append(", ").append((String)month).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", seconds, nanos);\n        }\n        ").append(toMicrosCode).append("\n      } catch (java.time.DateTimeException e) {\n        ").append(failOnErrorBranch).append("\n      }").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError, dataType);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public DataType copy$default$10() {
        return this.dataType();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = this.timeZoneId();
                break;
            }
            case 8: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            case 9: {
                object = this.dataType();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "year";
                break;
            }
            case 1: {
                string = "month";
                break;
            }
            case 2: {
                string = "day";
                break;
            }
            case 3: {
                string = "hour";
                break;
            }
            case 4: {
                string = "min";
                break;
            }
            case 5: {
                string = "sec";
                break;
            }
            case 6: {
                string = "timezone";
                break;
            }
            case 7: {
                string = "timeZoneId";
                break;
            }
            case 8: {
                string = "failOnError";
                break;
            }
            case 9: {
                string = "dataType";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = makeTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        this.dataType = dataType;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), SQLConf$.MODULE$.get().timestampType());
    }
}

