/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0015^\u0011\u0015)\u0007\u0001\"\u0015g\u0011\u001dY\u0007!!A\u0005\u00021Dqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004|\u0001E\u0005I\u0011\u00019\t\u000fq\u0004\u0011\u0011!C!{\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\teB\u0005\u0002lm\t\t\u0011#\u0001\u0002n\u0019A!dGA\u0001\u0012\u0003\ty\u0007\u0003\u0004N)\u0011\u0005\u0011q\u0011\u0005\n\u0003\u0013#\u0012\u0011!C#\u0003\u0017C\u0011\"!$\u0015\u0003\u0003%\t)a$\t\u0013\u0005UE#!A\u0005\u0002\u0006]\u0005\"CAU)\u0005\u0005I\u0011BAV\u0005!aUm]:UQ\u0006t'B\u0001\u000f\u001e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001IS\u0006\u000e\u001e\u0011\u0005)ZS\"A\u000e\n\u00051Z\"\u0001\u0005\"j]\u0006\u0014\u0018pQ8na\u0006\u0014\u0018n]8o!\tq\u0013G\u0004\u0002+_%\u0011\u0001gG\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114G\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005AZ\u0002CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$a\u0002)s_\u0012,8\r\u001e\t\u0003w\ts!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}:\u0013A\u0002\u001fs_>$h(C\u00018\u0013\t\u0001d'\u0003\u0002D\t\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001GN\u0001\u0005Y\u00164G/F\u0001H!\tQ\u0003*\u0003\u0002J7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019q\nU)\u0011\u0005)\u0002\u0001\"B#\u0006\u0001\u00049\u0005\"B&\u0006\u0001\u00049\u0015AB:z[\n|G.F\u0001U!\t)\u0016L\u0004\u0002W/B\u0011QHN\u0005\u00031Z\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001LN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004=\u0006\u001c\u0007CA\u001b`\u0013\t\u0001gGA\u0002B]fDQAY\u0004A\u0002y\u000ba!\u001b8qkR\f\u0004\"\u00023\b\u0001\u0004q\u0016AB5oaV$('A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019qiZ5\t\u000b!D\u0001\u0019A$\u0002\u000f9,w\u000fT3gi\")!\u000e\u0003a\u0001\u000f\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcA(n]\"9Q)\u0003I\u0001\u0002\u00049\u0005bB&\n!\u0003\u0005\raR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\t(FA$sW\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003%)hn\u00195fG.,GM\u0003\u0002ym\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i,(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!A.\u00198h\u0015\t\t9!\u0001\u0003kCZ\f\u0017b\u0001.\u0002\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0002\t\u0004k\u0005E\u0011bAA\nm\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a,!\u0007\t\u0013\u0005ma\"!AA\u0002\u0005=\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"A)\u00111EA\u0015=6\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0014AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0012q\u0007\t\u0004k\u0005M\u0012bAA\u001bm\t9!i\\8mK\u0006t\u0007\u0002CA\u000e!\u0005\u0005\t\u0019\u00010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004}\u0006u\u0002\"CA\u000e#\u0005\u0005\t\u0019AA\b\u0003\u0019)\u0017/^1mgR!\u0011\u0011GA\"\u0011!\tYBEA\u0001\u0002\u0004q\u0006f\u0006\u0001\u0002H\u00055\u0013qJA*\u0003+\nI&a\u0017\u0002`\u0005\u0005\u0014QMA4!\rQ\u0013\u0011J\u0005\u0004\u0003\u0017Z\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003#\n!)\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!SN\u0004C.Z:tAQD\u0017M\u001c\u0011aKb\u0004(O\r1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002X\u0005\u0011\u0019J\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004sN\u001d3fe\u0016$g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\\1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011pe\u0012,'/\u00192mK2\u00023o\u001c\u0011ji*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5tA9|G\u000fI:vaB|'\u000f^3e]\u00012uN\u001d\u0011d_6\u0004H.\u001a=!if\u0004Xm\u001d\u0011tk\u000eD\u0007%\u0019:sCf|3\u000f\u001e:vGRd\u0003\u0005\u001e5fA\u0011\fG/\u0019\u0011usB,7\u000fI8gA\u0019LW\r\u001c3tA5,8\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti&\u0001BR\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\n\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112]E\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006\r\u001d.aE\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c\u0001zf)\u0016(D?\u0002rU\u000b\u0014'<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111M\u0001\u0006c9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003S\nq\u0002\u001d:fI&\u001c\u0017\r^3`MVt7m]\u0001\t\u0019\u0016\u001c8\u000f\u00165b]B\u0011!\u0006F\n\u0006)\u0005E\u0014Q\u0010\t\b\u0003g\nIhR$P\u001b\t\t)HC\u0002\u0002xY\nqA];oi&lW-\u0003\u0003\u0002|\u0005U$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qPAC\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0011AA5p\u0013\r\u0019\u0015\u0011\u0011\u000b\u0003\u0003[\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002}\u0006)\u0011\r\u001d9msR)q*!%\u0002\u0014\")Qi\u0006a\u0001\u000f\")1j\u0006a\u0001\u000f\u00069QO\\1qa2LH\u0003BAM\u0003K\u0003R!NAN\u0003?K1!!(7\u0005\u0019y\u0005\u000f^5p]B)Q'!)H\u000f&\u0019\u00111\u0015\u001c\u0003\rQ+\b\u000f\\33\u0011!\t9\u000bGA\u0001\u0002\u0004y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0016\t\u0004\u007f\u0006=\u0016\u0002BAY\u0003\u0003\u0011aa\u00142kK\u000e$\b")
public class LessThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan lessThan) {
        return LessThan$.MODULE$.unapply(lessThan);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

