/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000e\u001d\u0001&B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\"AA\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005N\u0001\tE\t\u0015!\u0003I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0015_\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015\u0019\b\u0001\"\u0015u\u0011\u001dI\b!!A\u0005\u0002iDq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003wA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0003\"CA.\u0001\u0005\u0005I\u0011IA/\u000f%\t9\tHA\u0001\u0012\u0003\tII\u0002\u0005\u001c9\u0005\u0005\t\u0012AAF\u0011\u0019qU\u0003\"\u0001\u0002$\"I\u0011QU\u000b\u0002\u0002\u0013\u0015\u0013q\u0015\u0005\n\u0003S+\u0012\u0011!CA\u0003WC\u0011\"!-\u0016\u0003\u0003%\t)a-\t\u0013\u0005\u0015W#!A\u0005\n\u0005\u001d'aB#rk\u0006dGk\u001c\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M)\u0001A\u000b\u00186wA\u00111\u0006L\u0007\u00029%\u0011Q\u0006\b\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"a\f\u001a\u000f\u0005-\u0002\u0014BA\u0019\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!a\r\u001b\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0011\u0007\b\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\ta4I\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001\tK\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!!M\u001c\n\u0005\u0011+%\u0001D*fe&\fG.\u001b>bE2,'BA\u00198\u0003\u0011aWM\u001a;\u0016\u0003!\u0003\"aK%\n\u0005)c\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001)R%B\u00111\u0006\u0001\u0005\u0006\r\u0016\u0001\r\u0001\u0013\u0005\u0006\u0019\u0016\u0001\r\u0001S\u0001\u0007gfl'm\u001c7\u0016\u0003U\u0003\"A\u0016.\u000f\u0005]C\u0006C\u0001 8\u0013\tIv'\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-8\u00031qW\u000f\u001c7TC\u001a,WI^1m)\ry&m\u0019\t\u0003m\u0001L!!Y\u001c\u0003\u0007\u0005s\u0017\u0010C\u0003G\u000f\u0001\u0007q\fC\u0003M\u000f\u0001\u0007q,A\u0005e_\u001e+gnQ8eKR\u0019a\r\\9\u0011\u0005\u001dTW\"\u00015\u000b\u0005%d\u0012aB2pI\u0016<WM\\\u0005\u0003W\"\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006[\"\u0001\rA\\\u0001\u0004GRD\bCA4p\u0013\t\u0001\bN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000bID\u0001\u0019\u00014\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0001Vo\u001e\u0005\u0006m&\u0001\r\u0001S\u0001\b]\u0016<H*\u001a4u\u0011\u0015A\u0018\u00021\u0001I\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$2\u0001U>}\u0011\u001d1%\u0002%AA\u0002!Cq\u0001\u0014\u0006\u0011\u0002\u0003\u0007\u0001*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003}T3\u0001SA\u0001W\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0007o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0011q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\rY\u0016QD\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00012ANA\u0017\u0013\r\tyc\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u0006U\u0002\"CA\u001c\u001f\u0005\u0005\t\u0019AA\u0016\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\b\t\u0006\u0003\u007f\t)eX\u0007\u0003\u0003\u0003R1!a\u00118\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA'\u0003'\u00022ANA(\u0013\r\t\tf\u000e\u0002\b\u0005>|G.Z1o\u0011!\t9$EA\u0001\u0002\u0004y\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0007\u0002Z!I\u0011q\u0007\n\u0002\u0002\u0003\u0007\u00111F\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0013q\f\u0005\t\u0003o\u0019\u0012\u0011!a\u0001?\":\u0002!a\u0019\u0002j\u0005-\u0014qNA9\u0003k\n9(a\u001f\u0002~\u0005\u0005\u00151\u0011\t\u0004W\u0005\u0015\u0014bAA49\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA7\u0003A+\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\u0012V\r^;s]N\u0004CO];fA%4\u0007\u0005Y3yaJ\f\u0004\rI3rk\u0006d7\u000f\t1fqB\u0014(\u0007\u0019\u0017!_J\u0004c-\u00197tK\u0002zG\u000f[3so&\u001cXML\u0001\nCJ<W/\\3oiN\f#!a\u001d\u0002\u0005;R\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\fD\u0006I3yaJ\u0014\u0004%\f\u0011uQ\u0016\u0004Co^8!Kb\u0004(/Z:tS>t7\u000fI7vgR\u0004#-\u001a\u0011tC6,\u0007\u0005^=qK\u0002z'\u000fI2b]\u0002\u0012W\rI2bgR,G\r\t;pA\u0005\u00043m\\7n_:\u0004C/\u001f9fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1oI\u0002jWo\u001d;!E\u0016\u0004\u0013\r\t;za\u0016\u0004C\u000f[1uA\r\fg\u000e\t2fAU\u001cX\r\u001a\u0011j]\u0002*\u0017/^1mSRL\beY8na\u0006\u0014\u0018n]8o]\u0001j\u0015\r\u001d\u0011usB,\u0007%[:!]>$\be];qa>\u0014H/\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003ER8sA\r|W\u000e\u001d7fq\u0002\"\u0018\u0010]3tAM,8\r\u001b\u0011beJ\f\u0017pL:ueV\u001cG\u000f\f\u0011uQ\u0016\u0004C-\u0019;bAQL\b/Z:!_\u001a\u0004c-[3mIN\u0004S.^:uA\t,\u0007e\u001c:eKJ\f'\r\\3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0014!a\u001e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAI\u0002sLR+O\u0007~\u0003#g\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!OE:3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005\u001e:vK\u0002zf)\u0016(D?\u0002rU\u000b\u0014'<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!\u001dVcE\nI0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0000\u0005)\u0011G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011QQ\u0001\u0010aJ,G-[2bi\u0016|f-\u001e8dg\u00069Q)];bYR{\u0007CA\u0016\u0016'\u0015)\u0012QRAM!\u001d\ty)!&I\u0011Bk!!!%\u000b\u0007\u0005Mu'A\u0004sk:$\u0018.\\3\n\t\u0005]\u0015\u0011\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u0015\u0011E\u0001\u0003S>L1\u0001RAO)\t\tI)\u0001\u0005u_N#(/\u001b8h)\t\tI\"A\u0003baBd\u0017\u0010F\u0003Q\u0003[\u000by\u000bC\u0003G1\u0001\u0007\u0001\nC\u0003M1\u0001\u0007\u0001*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0016\u0011\u0019\t\u0006m\u0005]\u00161X\u0005\u0004\u0003s;$AB(qi&|g\u000eE\u00037\u0003{C\u0005*C\u0002\u0002@^\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAb3\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002JB!\u00111DAf\u0013\u0011\ti-!\b\u0003\r=\u0013'.Z2u\u0001")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> ctx.genEqual(this.left().dataType(), (String)c1, (String)c2));
    }

    @Override
    public EqualTo withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

