/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n  ", since="2.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011!Q\u0006\u0001#b\u0001\n\u0013Y\u0006\u0002\u0003/\u0001\u0011\u000b\u0007I\u0011B/\t\u000b\u0005\u0004A\u0011\t(\t\u000b\t\u0004A\u0011I2\t\u000b)\u0004A\u0011I6\t\u000bI\u0004A\u0011I:\t\u000bu\u0004A\u0011\u000b@\t\u000f\u0005e\u0001\u0001\"\u0015\u0002\u001c!I\u0011q\u0005\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0006\u0005\n\u0003_\u0001\u0011\u0013!C\u0001\u0003cA\u0011\"a\u0012\u0001#\u0003%\t!!\u0013\t\u0013\u00055\u0003!!A\u0005B\u0005=\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tY\u0007AA\u0001\n\u0003\ti\u0007C\u0005\u0002t\u0001\t\t\u0011\"\u0011\u0002v!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u0013\u0003\u0011\u0011!C!\u0003\u0017C\u0011\"a$\u0001\u0003\u0003%\t%!%\b\u0013\u0005U6%!A\t\u0002\u0005]f\u0001\u0003\u0012$\u0003\u0003E\t!!/\t\rMSB\u0011AAi\u0011%\t\u0019NGA\u0001\n\u000b\n)\u000eC\u0005\u0002Xj\t\t\u0011\"!\u0002Z\"I\u0011q\u001c\u000e\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003CT\u0012\u0011!CA\u0003GD\u0011\"!>\u001b#\u0003%\t!!\u0013\t\u0013\u0005]($!A\u0005\n\u0005e(aA#mi*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001cUZ\u0004C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\b!J|G-^2u!\taDI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iL\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!aQ\u001c\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0007^\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\u0013B\u0019AHS\u0019\n\u0005-3%aA*fc\u0006I1\r[5mIJ,g\u000eI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001P!\t1\u0004+\u0003\u0002Ro\t9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013A\u0002\u001fj]&$h\bF\u0002V-^\u0003\"A\r\u0001\t\u000b\u001d+\u0001\u0019A%\t\u000f5+\u0001\u0013!a\u0001\u001fR\u0011Q+\u0017\u0005\u0006\u000f\u001a\u0001\r!S\u0001\nS:$W\r_#yaJ,\u0012!M\u0001\u000bS:\u0004X\u000f^#yaJ\u001cX#\u00010\u0011\u0007Yz\u0016'\u0003\u0002ao\t)\u0011I\u001d:bs\u0006Aa.\u001e7mC\ndW-\u0001\u0005eCR\fG+\u001f9f+\u0005!\u0007CA3i\u001b\u00051'BA4(\u0003\u0015!\u0018\u0010]3t\u0013\tIgM\u0001\u0005ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005a\u0007CA7q\u001b\u0005q'BA8&\u0003!\tg.\u00197zg&\u001c\u0018BA9o\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001B3wC2$\"\u0001^<\u0011\u0005Y*\u0018B\u0001<8\u0005\r\te.\u001f\u0005\bq2\u0001\n\u00111\u0001z\u0003\u0015Ig\u000e];u!\tQ80D\u0001&\u0013\taXEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015y\u00181BA\u000b!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003G\u000591m\u001c3fO\u0016t\u0017\u0002BA\u0005\u0003\u0007\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u001bi\u0001\u0019AA\b\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0003\t\t\"\u0003\u0003\u0002\u0014\u0005\r!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003/i\u0001\u0019A@\u0002\u0005\u00154\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r)\u0016Q\u0004\u0005\b\u0003?q\u0001\u0019AA\u0011\u0003-qWm^\"iS2$'/\u001a8\u0011\tq\n\u0019#M\u0005\u0004\u0003K1%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u0015)\u00161FA\u0017\u0011\u001d9u\u0002%AA\u0002%Cq!T\b\u0011\u0002\u0003\u0007q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M\"fA%\u00026-\u0012\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003%)hn\u00195fG.,GMC\u0002\u0002B]\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)%a\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-#fA(\u00026\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!A.\u00198h\u0015\t\tY&\u0001\u0003kCZ\f\u0017\u0002BA0\u0003+\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA3!\r1\u0014qM\u0005\u0004\u0003S:$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001;\u0002p!I\u0011\u0011\u000f\u000b\u0002\u0002\u0003\u0007\u0011QM\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0004#BA=\u0003\u007f\"XBAA>\u0015\r\tihN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAA\u0003w\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q*a\"\t\u0011\u0005Ed#!AA\u0002Q\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011KAG\u0011%\t\thFA\u0001\u0002\u0004\t)'\u0001\u0004fcV\fGn\u001d\u000b\u0004\u001f\u0006M\u0005\u0002CA91\u0005\u0005\t\u0019\u0001;)'\u0001\t9*!(\u0002 \u0006\r\u0016QUAU\u0003W\u000by+!-\u0011\u0007I\nI*C\u0002\u0002\u001c\u000e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\"\u0006\u00119K\u0003\u0011!A\u0001zf)\u0016(D?\"rG\u0006I5oaV$\u0018\u0007\f\u0011j]B,HO\r\u0017!]9r\u0013\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t1oA6\"\b\u000eI5oaV$H\u0006I3/O:b\u0003E]3ukJt7\u000f\t1j]B,HO\r1!o\",g\u000e\t1oA\u0002J7\u000f\t\u001a/\u0015\u0001\u0002\u0003\u0005\t+iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003\u0013N\u001a\u0011uQ\u0016\u0004\u0013N\u001c3fq\u0002*\u0007pY3fIN\u0004C\u000f[3!Y\u0016tw\r\u001e5!_\u001a\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0006!A\u0001\u0002\u0013M\u001c3!AN\u0004\u0018M]6/gFdg&\u00198tS:*g.\u00192mK\u0012\u0004\u0007%[:!g\u0016$\b\u0005^8!M\u0006d7/\u001a\u0018!\u0013\u001a\u0004\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004CO];fY)\u0001\u0003\u0005\t\u0011ji\u0002\"\bN]8xg\u0002\n%O]1z\u0013:$W\r_(vi>3'i\\;oIN,\u0005pY3qi&|g\u000e\t4pe\u0002JgN^1mS\u0012\u0004\u0013N\u001c3jG\u0016\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAT\u0003%S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0017!OM\u001c\u0017\r\\1(Y\u0001:#.\u0019<bO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e]2bY\u0006T\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003[\u000bQA\r\u00181]A\nQa\u001a:pkB\f#!a-\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0007\u0015cG\u000f\u0005\u000235M)!$a/\u0002HB9\u0011QXAb\u0013>+VBAA`\u0015\r\t\tmN\u0001\beVtG/[7f\u0013\u0011\t)-a0\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002J\u0006=WBAAf\u0015\u0011\ti-!\u0017\u0002\u0005%|\u0017bA#\u0002LR\u0011\u0011qW\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0006+\u0006m\u0017Q\u001c\u0005\u0006\u000fv\u0001\r!\u0013\u0005\b\u001bv\u0001\n\u00111\u0001P\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\f\t\u0010E\u00037\u0003O\fY/C\u0002\u0002j^\u0012aa\u00149uS>t\u0007#\u0002\u001c\u0002n&{\u0015bAAxo\t1A+\u001e9mKJB\u0001\"a= \u0003\u0003\u0005\r!V\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002|B!\u00111KA\u007f\u0013\u0011\ty0!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class Elt
extends Expression
implements Serializable {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt elt) {
        return Elt$.MODULE$.unapply(elt);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.indexExpr$lzycompute() : this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((IterableOnceOps)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.inputExprs$lzycompute() : this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$10 -> x$10.dataType(), ClassTag$.MODULE$.apply(DataType.class)))).getOrElse((Function0 & Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.children().size() < 2) {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("elt function requires at least two arguments");
        } else {
            Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$11 -> x$11.dataType(), ClassTag$.MODULE$.apply(DataType.class)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType indexType = (DataType)tuple2._1();
            DataType[] inputTypes = (DataType[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
            Tuple2 tuple23 = tuple22;
            DataType indexType2 = (DataType)tuple23._1();
            DataType[] inputTypes2 = (DataType[])tuple23._2();
            DataType dataType = indexType2;
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(32).append("first input to function ").append(this.prettyName()).append(" should ").toString()).append(new StringBuilder(16).append("have ").append(IntegerType$.MODULE$.catalogString()).append(", but it's ").append(indexType2.catalogString()).toString()).toString());
            }
            if (ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append(new StringBuilder(35).append("input to function ").append(this.prettyName()).append(" should have ").append(StringType$.MODULE$.catalogString()).append(" or ").toString()).append(new StringBuilder(11).append(BinaryType$.MODULE$.catalogString()).append(", but it's ").toString()).append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])inputTypes2), (Function1 & Serializable)x$13 -> x$13.catalogString(), ClassTag$.MODULE$.apply(String.class))).mkString("[", ", ", "]")).toString());
            }
            typeCheckResult = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)inputTypes2), new StringBuilder(9).append("function ").append(this.prettyName()).toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            object = null;
        } else {
            int index = BoxesRunTime.unboxToInt((Object)indexObj);
            if (index <= 0 || index > this.inputExprs().length) {
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.invalidArrayIndexError(index, this.inputExprs().length);
                }
                object = null;
            } else {
                object = this.inputExprs()[index - 1].eval(input);
            }
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs()), (Function1 & Serializable)x$14 -> x$14.genCode(ctx), ClassTag$.MODULE$.apply(ExprCode.class));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])inputs))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n         |if (").append(indexVal).append(" == ").append(index + 1).append(") {\n         |  ").append(eval.code()).append("\n         |  ").append(inputVal).append(" = ").append(eval.isNull()).append(" ? null : ").append(eval.value()).append(";\n         |  ").append(indexMatched).append(" = true;\n         |  continue;\n         |}\n      ").toString()));
            return string;
        }, ClassTag$.MODULE$.apply(String.class));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)assignInputValue), "eltFunc", (Seq<Tuple2<String, String>>)package$.MODULE$.Nil().$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |").append("boolean").append(" ").append(indexMatched).append(" = false;\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(indexMatched).append(";\n         ").toString())), (Function1<Seq<String>, String>)(Function1 & Serializable)x$15 -> ((IterableOnceOps)x$15.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n           |").append(indexMatched).append(" = ").append((String)funcCall).append(";\n           |if (").append(indexMatched).append(") {\n           |  continue;\n           |}\n         ").toString())))).mkString());
        String indexOutOfBoundBranch = this.failOnError() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n         |if (!").append(indexMatched).append(") {\n         |  throw QueryExecutionErrors.invalidArrayIndexError(").append(index.value()).append(", ").append(this.inputExprs().length).append(");\n         |}\n       ").toString())) : "";
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |final int ", " = ", ";\n         |", " ", " = false;\n         |", " = null;\n         |do {\n         |  ", "\n         |} while (false);\n         |", "\n         |final ", " ", " = ", ";\n         |final boolean ", " = ", " == null;\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Elt withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "children";
                break;
            }
            case 1: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        if (this.failOnError() != elt.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        return !package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BinaryType$.MODULE$})).contains((Object)tpe);
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

