/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%d\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t-\u0002\u0011\t\u0012)A\u0005!\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005]\u0001\tE\t\u0015!\u0003Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u001d)\u0007A1A\u0005F\u0019Da! \u0001!\u0002\u001b9\u0007\"\u0002@\u0001\t#z\bBCA\u0006\u0001!\u0015\r\u0011\"\u0011\u0002\u000e!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t)\u0006\u0001C!\u0003/Ba\u0001\f\u0001\u0005B\u0005%\u0004bBA6\u0001\u0011%\u0011Q\u000e\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011%\t\t\nAA\u0001\n\u0003\t\u0019\nC\u0005\u0002\u001a\u0002\t\n\u0011\"\u0001\u0002\u001c\"I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003o\u0003\u0011\u0011!C!\u0003sC\u0011\"!3\u0001\u0003\u0003%\t!a3\t\u0013\u0005M\u0007!!A\u0005\u0002\u0005U\u0007\"CAn\u0001\u0005\u0005I\u0011IAo\u0011%\tY\u000fAA\u0001\n\u0003\ti\u000fC\u0005\u0002r\u0002\t\t\u0011\"\u0011\u0002t\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0013\u0011`\u0004\b\u0005G9\u0003\u0012\u0001B\u0013\r\u00191s\u0005#\u0001\u0003(!1Q,\bC\u0001\u0005sAqAa\u000f\u001e\t\u0003\u0011i\u0004C\u0004\u0003Du!\tA!\u0012\t\u0013\tmR$!A\u0005\u0002\n%\u0003\"\u0003B(;E\u0005I\u0011AAZ\u0011%\u0011\t&HA\u0001\n\u0003\u0013\u0019\u0006C\u0005\u0003^u\t\n\u0011\"\u0001\u00024\"I!qL\u000f\u0002\u0002\u0013%!\u0011\r\u0002\t\u0007\u0006\u001cXm\u00165f]*\u0011\u0001&K\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002+W\u0005A1-\u0019;bYf\u001cHO\u0003\u0002-[\u0005\u00191/\u001d7\u000b\u00059z\u0013!B:qCJ\\'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001keb$\n\u0005\u00027o5\tq%\u0003\u00029O\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005YR\u0014BA\u001e(\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"!P$\u000f\u0005y\"eBA C\u001b\u0005\u0001%BA!4\u0003\u0019a$o\\8u}%\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\r\u00069\u0001/Y2lC\u001e,'\"A\"\n\u0005!K%\u0001D*fe&\fG.\u001b>bE2,'BA#G!\tYE*D\u0001G\u0013\tieIA\u0004Qe>$Wo\u0019;\u0002\u0011\t\u0014\u0018M\\2iKN,\u0012\u0001\u0015\t\u0004{E\u001b\u0016B\u0001*J\u0005\r\u0019V-\u001d\t\u0005\u0017R+T'\u0003\u0002V\r\n1A+\u001e9mKJ\n\u0011B\u0019:b]\u000eDWm\u001d\u0011\u0002\u0013\u0015d7/\u001a,bYV,W#A-\u0011\u0007-SV'\u0003\u0002\\\r\n1q\n\u001d;j_:\f!\"\u001a7tKZ\u000bG.^3!\u0003\u0019a\u0014N\\5u}Q\u0019q\fY1\u0011\u0005Y\u0002\u0001\"\u0002(\u0006\u0001\u0004\u0001\u0006bB,\u0006!\u0003\u0005\r!W\u0001\tG\"LG\u000e\u001a:f]V\tA\rE\u0002>#V\nAB\\8eKB\u000bG\u000f^3s]N,\u0012a\u001a\t\u0004{EC\u0007CA5{\u001d\tQwO\u0004\u0002lk:\u0011A\u000e\u001e\b\u0003[Nt!A\u001c:\u000f\u0005=\fhBA q\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\tqs&\u0003\u0002-[%\u0011!fK\u0005\u0003m&\nQ\u0001\u001e:fKNL!\u0001_=\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003m&J!a\u001f?\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003qf\fQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r)\u0014\u0011\u0001\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0003-qWm^\"iS2$'/\u001a8\u0011\tu\n9!N\u0005\u0004\u0003\u0013I%AC%oI\u0016DX\rZ*fc\u0006!\u0012N\u001c9viRK\b/Z:G_JlUM]4j]\u001e,\"!a\u0004\u0011\tu\n\u0016\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u0016\u0002\u000bQL\b/Z:\n\t\u0005m\u0011Q\u0003\u0002\t\t\u0006$\u0018\rV=qK\"\u001a!\"a\b\u0011\u0007-\u000b\t#C\u0002\u0002$\u0019\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00119,H\u000e\\1cY\u0016,\"!!\u000b\u0011\u0007-\u000bY#C\u0002\u0002.\u0019\u0013qAQ8pY\u0016\fg.A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:%\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003{\t9DA\bUsB,7\t[3dWJ+7/\u001e7u\u0003\u0011)g/\u00197\u0015\t\u0005\r\u0013\u0011\n\t\u0004\u0017\u0006\u0015\u0013bAA$\r\n\u0019\u0011I\\=\t\u0013\u0005-S\u0002%AA\u0002\u00055\u0013!B5oaV$\b\u0003BA(\u0003#j\u0011!K\u0005\u0004\u0003'J#aC%oi\u0016\u0014h.\u00197S_^\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\u0002B!a\u0017\u0002d9!\u0011QLA0!\tyd)C\u0002\u0002b\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1\rV\u0011\u0011\u0011L\u0001\u0015[VdG/\u001b\"sC:\u001c\u0007.Z:D_\u0012,w-\u001a8\u0015\r\u0005=\u00141PAC!\u0011\t\t(a\u001e\u000e\u0005\u0005M$bAA;O\u000591m\u001c3fO\u0016t\u0017\u0002BA=\u0003g\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003{\u0002\u0002\u0019AA@\u0003\r\u0019G\u000f\u001f\t\u0005\u0003c\n\t)\u0003\u0003\u0002\u0004\u0006M$AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u000f\u0003\u0002\u0019AA8\u0003\t)g/A\u0005e_\u001e+gnQ8eKR1\u0011qNAG\u0003\u001fCq!! \u0012\u0001\u0004\ty\bC\u0004\u0002\bF\u0001\r!a\u001c\u0002\t\r|\u0007/\u001f\u000b\u0006?\u0006U\u0015q\u0013\u0005\b\u001dJ\u0001\n\u00111\u0001Q\u0011\u001d9&\u0003%AA\u0002e\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001e*\u001a\u0001+a(,\u0005\u0005\u0005\u0006\u0003BAR\u0003[k!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a+G\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\u000b)KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00026*\u001a\u0011,a(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\fAA[1wC&!\u0011QMA`\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\rE\u0002L\u0003\u001fL1!!5G\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019%a6\t\u0013\u0005ew#!AA\u0002\u00055\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002`B1\u0011\u0011]At\u0003\u0007j!!a9\u000b\u0007\u0005\u0015h)\u0001\u0006d_2dWm\u0019;j_:LA!!;\u0002d\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI#a<\t\u0013\u0005e\u0017$!AA\u0002\u0005\r\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a/\u0002v\"I\u0011\u0011\u001c\u000e\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00121 \u0005\n\u00033\\\u0012\u0011!a\u0001\u0003\u0007Bs\u0003AA\u0000\u0005\u000b\u00119Aa\u0003\u0003\u000e\tE!1\u0003B\f\u00053\u0011iBa\b\u0011\u0007Y\u0012\t!C\u0002\u0003\u0004\u001d\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\n\u0005\tYfQ!T\u000b\u0002:\u0006*\u0012(!Kb\u0004(/\r\u0011U\u0011\u0016s\u0005%\u001a=qeJ\u00023l\u0016%F\u001d\u0002*\u0007\u0010\u001d:4AQCUI\u0014\u0011fqB\u0014H'\u0018\u0016!7\u0016c5+\u0012\u0011fqB\u0014X'\u0018\u0011F\u001d\u0012\u0003S\u0006I,iK:\u0004\u0003-\u001a=qeF\u0002\u0007%\u0010\u0011ueV,G\u0006\t:fiV\u0014hn\u001d\u0011aKb\u0004(O\r1<A\u0015d7/\u001a\u0011xQ\u0016t\u0007\u0005Y3yaJ\u001c\u0004\rI\u001f!iJ,X\r\f\u0011sKR,(O\\:!A\u0016D\bO\u001d\u001baw\u0001*Gn]3!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:6A:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\t=\u0011!!?\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:2Y\u0001*\u0007\u0010\u001d:4A5\u0002C\u000f[3!EJ\fgn\u00195!G>tG-\u001b;j_:\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tAMDw.\u001e7eA\u0005dG\u000e\t2fA\t|w\u000e\\3b]\u0002\"\u0018\u0010]3/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:3Y\u0001*\u0007\u0010\u001d:5Y\u0001*\u0007\u0010\u001d:6A5\u0002C\u000f[3!EJ\fgn\u00195!m\u0006dW/\u001a\u0011fqB\u0014Xm]:j_:\u001c\b%\u00198eA\u0015d7/\u001a\u0011wC2,X\rI3yaJ,7o]5p]\u0002\u001a\bn\\;mI\u0002\nG\u000e\u001c\u0011cK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:b[\u0016\u0004C/\u001f9fA=\u0014\beY8fe\u000eL'\r\\3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!\u0006\u0002\u0005\u000bQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001r\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011?AA\u0002C\u000bS#OAIr\u0003\u0007I#M'\u0016\u0003\u0013G\f\u001a!\u000b:#5H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u00033)Q*FA]CUI\u0014\u00112Aq\u0002\u0003\u0007\t+I\u000b:\u0003\u0013\u0007I,I\u000b:\u0003#\u0007\t !a\u0001\"\u0006*\u0012(!e9\u0002\u0004%\u0012'T\u000b\u0002\ndF\r\u0011F\u001d\u0012[$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00181\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u001a\u0015iU#!/\"+e\nI\u0019!y\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\n\u0004e\u0016%F\u001d\u0002\u0012\u0004\u0005\u0010\u00111AQCUI\u0014\u00113]A\u0002SI\u0014#<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)1/\u001b8dK\u0006\u0012!1D\u0001\u0006c9\u0002d&M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005C\t\u0011cY8oI&$\u0018n\u001c8bY~3WO\\2t\u0003!\u0019\u0015m]3XQ\u0016t\u0007C\u0001\u001c\u001e'\u0015i\"\u0011\u0006B\u0018!\rY%1F\u0005\u0004\u0005[1%AB!osJ+g\r\u0005\u0003\u00032\t]RB\u0001B\u001a\u0015\u0011\u0011)$a1\u0002\u0005%|\u0017b\u0001%\u00034Q\u0011!QE\u0001\u0006CB\u0004H.\u001f\u000b\u0006?\n}\"\u0011\t\u0005\u0006\u001d~\u0001\r\u0001\u0015\u0005\u0006/~\u0001\r!N\u0001\u0011GJ,\u0017\r^3Ge>l\u0007+\u0019:tKJ$2a\u0018B$\u0011\u0015q\u0005\u00051\u0001e)\u0015y&1\nB'\u0011\u0015q\u0015\u00051\u0001Q\u0011\u001d9\u0016\u0005%AA\u0002e\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)F!\u0017\u0011\t-S&q\u000b\t\u0005\u0017R\u0003\u0016\f\u0003\u0005\u0003\\\r\n\t\u00111\u0001`\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\u0004\u0003BA_\u0005KJAAa\u001a\u0002@\n1qJ\u00196fGR\u0004")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((IterableOps)this.branches().flatMap((Function1 & Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)expression);
        })).$plus$plus(this.elseValue());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return super.legacyWithNewChildren(newChildren);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$1 -> ((Expression)x$1._2()).dataType())).$plus$plus((IterableOnce)this.elseValue().map((Function1 & Serializable)x$2 -> x$2.dataType()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return !this.bitmap$trans$0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$3))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$1(x$5)))) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$6)));
                typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(0).append("WHEN expressions in CaseWhen should all be boolean type, ").append(new StringBuilder(37).append("but the ").append(index + 1).append("th when expression's type is ").append(((Tuple2)this.branches().apply(index))._1()).toString()).toString());
            }
        } else {
            String branchesStr = ((IterableOnceOps)((IterableOps)this.branches().map((Function1 & Serializable)x$7 -> ((Expression)x$7._2()).dataType())).map((Function1 & Serializable)dt -> new StringBuilder(14).append("WHEN ... THEN ").append(dt.catalogString()).toString())).mkString(" ");
            String elseStr = (String)this.elseValue().map((Function1 & Serializable)expr -> new StringBuilder(6).append(" ELSE ").append(expr.dataType().catalogString()).toString()).getOrElse((Function0 & Serializable)() -> "");
            typeCheckResult = new TypeCheckResult.TypeCheckFailure(new StringBuilder(80).append("THEN and ELSE expressions should all be same type or coercible to a common type,").append(new StringBuilder(14).append(" got CASE ").append(branchesStr).append(elseStr).append(" END").toString()).toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            return string;
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$8 -> new StringBuilder(6).append(" ELSE ").append(x$8).toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            return string;
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$9 -> new StringBuilder(6).append(" ELSE ").append(x$9.sql()).toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression condExpr = (Expression)tuple2._1();
            Expression valueExpr = (Expression)tuple2._2();
            ExprCode cond = condExpr.genCode(ctx);
            ExprCode res = valueExpr.genCode(ctx);
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString()));
            return string;
        });
        Option elseCode = this.elseValue().map((Function1 & Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString()));
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((IterableOnce)elseCode);
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable x$4 = (Function1 & Serializable)func -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString()));
        Function1 & Serializable x$5 = (Function1 & Serializable)x$10 -> ((IterableOnceOps)x$10.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())))).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, "caseWhen", x$6, "byte", (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.branches().length() == 1 ? new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev) : this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.branches();
                break;
            }
            case 1: {
                object = this.elseValue();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "branches";
                break;
            }
            case 1: {
                string = "elseValue";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$3) {
        return ((Expression)x$3._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(Tuple2 x$5) {
        DataType dataType = ((Expression)x$5._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$6) {
        DataType dataType = ((Expression)x$6._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.CASE_WHEN()}));
    }
}

