/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.BitwiseGet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, pos) - Returns the value of the bit (0 or 1) at the specified position.\n      The positions are numbered from right to left, starting at zero.\n      The position argument cannot be negative.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(11, 0);\n       1\n      > SELECT _FUNC_(11, 2);\n       0\n  ", since="3.2.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0010 \u00012B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015!\u0007\u0001\"\u0011f\u0011!I\u0007\u0001#b\u0001\n\u0003Q\u0007\"\u00028\u0001\t\u0003z\u0007\"B<\u0001\t\u0003B\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003C\u0001A\u0011KA\u0012\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00026\u0001\t\n\u0011\"\u0001\u00028!I\u0011Q\n\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003\u001f\u0002\u0011\u0011!C!\u0003#B\u0001\"!\u0019\u0001\u0003\u0003%\tA\u001b\u0005\n\u0003G\u0002\u0011\u0011!C\u0001\u0003KB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAD\u0001\u0005\u0005I\u0011IAE\u0011%\ti\tAA\u0001\n\u0003\nyiB\u0005\u00024~\t\t\u0011#\u0001\u00026\u001aAadHA\u0001\u0012\u0003\t9\f\u0003\u0004U1\u0011\u0005\u0011q\u001a\u0005\n\u0003#D\u0012\u0011!C#\u0003'D\u0011\"!6\u0019\u0003\u0003%\t)a6\t\u0013\u0005u\u0007$!A\u0005\u0002\u0006}\u0007\"CAy1\u0005\u0005I\u0011BAz\u0005)\u0011\u0015\u000e^<jg\u0016<U\r\u001e\u0006\u0003A\u0005\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!eI\u0001\tG\u0006$\u0018\r\\=ti*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M1\u0001!L\u00195w\u0005\u0003\"AL\u0018\u000e\u0003}I!\u0001M\u0010\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00183\u0013\t\u0019tD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t)\u0004H\u0004\u0002/m%\u0011qgH\u0001\ba\u0006\u001c7.Y4f\u0013\tI$H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005]z\u0002C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0005&s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u0019[\u0013A\u0002\u001fs_>$h(C\u0001?\u0013\t9T(\u0003\u0002K\u0017\na1+\u001a:jC2L'0\u00192mK*\u0011q'P\u0001\u0005Y\u00164G/F\u0001O!\tqs*\u0003\u0002Q?\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019ak\u0016-\u0011\u00059\u0002\u0001\"\u0002'\u0006\u0001\u0004q\u0005\"\u0002*\u0006\u0001\u0004q\u0015AC5oaV$H+\u001f9fgV\t1\fE\u0002C9zK!!X&\u0003\u0007M+\u0017\u000f\u0005\u0002`E6\t\u0001M\u0003\u0002bG\u0005)A/\u001f9fg&\u00111\r\u0019\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002MB\u0011qlZ\u0005\u0003Q\u0002\u0014\u0001\u0002R1uCRK\b/Z\u0001\bE&$8+\u001b>f+\u0005Y\u0007C\u0001\u001fm\u0013\tiWHA\u0002J]R\fAB\\;mYN\u000bg-Z#wC2$2\u0001]:v!\ta\u0014/\u0003\u0002s{\t\u0019\u0011I\\=\t\u000bQL\u0001\u0019\u00019\u0002\rQ\f'oZ3u\u0011\u00151\u0018\u00021\u0001q\u0003\r\u0001xn]\u0001\nI><UM\\\"pI\u0016$B!_@\u0002\nA\u0011!0`\u0007\u0002w*\u0011ApH\u0001\bG>$WmZ3o\u0013\tq8P\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\tA\u0003a\u0001\u0003\u0007\t1a\u0019;y!\rQ\u0018QA\u0005\u0004\u0003\u000fY(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0017Q\u0001\u0019A=\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005]\u0001C\u0001#>\u0013\r\tI\"P\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0011q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005eQ(A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)a+!\n\u0002*!1\u0011q\u0005\u0007A\u00029\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002,1\u0001\rAT\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u00151\u0016\u0011GA\u001a\u0011\u001daU\u0002%AA\u00029CqAU\u0007\u0011\u0002\u0003\u0007a*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"f\u0001(\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002Hu\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&!\u0011QDA,\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001]A4\u0011!\tIGEA\u0001\u0002\u0004Y\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002pA)\u0011\u0011OA<a6\u0011\u00111\u000f\u0006\u0004\u0003kj\u0014AC2pY2,7\r^5p]&!\u0011\u0011PA:\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0014Q\u0011\t\u0004y\u0005\u0005\u0015bAAB{\t9!i\\8mK\u0006t\u0007\u0002CA5)\u0005\u0005\t\u0019\u00019\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003'\nY\t\u0003\u0005\u0002jU\t\t\u00111\u0001l\u0003\u0019)\u0017/^1mgR!\u0011qPAI\u0011!\tIGFA\u0001\u0002\u0004\u0001\bf\u0005\u0001\u0002\u0016\u0006m\u0015QTAQ\u0003G\u000b9+!+\u0002.\u0006=\u0006c\u0001\u0018\u0002\u0018&\u0019\u0011\u0011T\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qT\u0001\u0002(*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006\t9pg&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\u0012\u0017\u000e\u001e\u0011)a\u0001z'\u000fI\u0019*A\u0005$\b\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007\u0005]8tSRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004\u0003o\\:ji&|gn\u001d\u0011be\u0016\u0004c.^7cKJ,G\r\t4s_6\u0004#/[4ii\u0002\"x\u000e\t7fMRd\u0003e\u001d;beRLgn\u001a\u0011bi\u0002RXM]8/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007\u0005]8tSRLwN\u001c\u0011be\u001e,X.\u001a8uA\r\fgN\\8uA\t,\u0007E\\3hCRLg/\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003K\u000bqL\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152c1\u0002\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013'\r\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111V\u0001\u0006g9\u0012d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003c\u000bQBY5uo&\u001cXm\u00184v]\u000e\u001c\u0018A\u0003\"ji^L7/Z$fiB\u0011a\u0006G\n\u00061\u0005e\u0016Q\u0019\t\b\u0003w\u000b\tM\u0014(W\u001b\t\tiLC\u0002\u0002@v\nqA];oi&lW-\u0003\u0003\u0002D\u0006u&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qYAg\u001b\t\tIM\u0003\u0003\u0002L\u0006m\u0013AA5p\u0013\rQ\u0015\u0011\u001a\u000b\u0003\u0003k\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\nQ!\u00199qYf$RAVAm\u00037DQ\u0001T\u000eA\u00029CQAU\u000eA\u00029\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002b\u00065\b#\u0002\u001f\u0002d\u0006\u001d\u0018bAAs{\t1q\n\u001d;j_:\u0004R\u0001PAu\u001d:K1!a;>\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u001e\u000f\u0002\u0002\u0003\u0007a+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!>\u0011\t\u0005U\u0013q_\u0005\u0005\u0003s\f9F\u0001\u0004PE*,7\r\u001e")
public class BitwiseGet
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private int bitSize;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(BitwiseGet bitwiseGet) {
        return BitwiseGet$.MODULE$.unapply(bitwiseGet);
    }

    public static Function1<Tuple2<Expression, Expression>, BitwiseGet> tupled() {
        return BitwiseGet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, BitwiseGet>> curried() {
        return BitwiseGet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return ByteType$.MODULE$;
    }

    private int bitSize$lzycompute() {
        BitwiseGet bitwiseGet = this;
        synchronized (bitwiseGet) {
            if (!this.bitmap$0) {
                int n;
                DataType dataType = this.left().dataType();
                if (ByteType$.MODULE$.equals(dataType)) {
                    n = 8;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    n = 16;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    n = 32;
                } else if (LongType$.MODULE$.equals(dataType)) {
                    n = 64;
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.bitSize = n;
                this.bitmap$0 = true;
            }
        }
        return this.bitSize;
    }

    public int bitSize() {
        return !this.bitmap$0 ? this.bitSize$lzycompute() : this.bitSize;
    }

    @Override
    public Object nullSafeEval(Object target, Object pos) {
        int posInt = BoxesRunTime.unboxToInt((Object)pos);
        BitwiseGetUtil$.MODULE$.checkPosition(posInt, this.bitSize());
        return BoxesRunTime.boxToByte((byte)((byte)(((Number)target).longValue() >> posInt & 1L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(target, pos) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |org.apache.spark.sql.catalyst.expressions.BitwiseGetUtil.checkPosition(").append((String)pos).append(", ").append(this.bitSize()).append(");\n         |").append(ev.value()).append(" = (byte) ((((long) ").append((String)target).append(") >> ").append((String)pos).append(") & 1);\n       ").toString())));
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "bit_get");
    }

    @Override
    public BitwiseGet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public BitwiseGet copy(Expression left, Expression right) {
        return new BitwiseGet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "BitwiseGet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseGet;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseGet)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseGet bitwiseGet = (BitwiseGet)x$1;
        Expression expression = this.left();
        Expression expression2 = bitwiseGet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = bitwiseGet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!bitwiseGet.canEqual(this)) return false;
        return true;
    }

    public BitwiseGet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

