/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")!\f\u0001C!7\")!\r\u0001C)G\")\u0011\u000e\u0001C!U\")\u0001\u0010\u0001C!s\"9\u0011Q\u0001\u0001\u0005R\u0005\u001d\u0001\"CA\u0007\u0001\u0005\u0005I\u0011AA\b\u0011%\t\u0019\u0002AI\u0001\n\u0003\t)\u0002C\u0005\u0002,\u0001\t\t\u0011\"\u0011\u0002.!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0014\u0001\u0003\u0003%\t%!\u0015\t\u0013\u0005}\u0003!!A\u0005\u0002\u0005\u0005\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\t\t\bAA\u0001\n\u0003\n\u0019hB\u0005\u0002\u0018n\t\t\u0011#\u0001\u0002\u001a\u001aA!dGA\u0001\u0012\u0003\tY\n\u0003\u0004O)\u0011\u0005\u00111\u0017\u0005\n\u0003k#\u0012\u0011!C#\u0003oC\u0011\"!/\u0015\u0003\u0003%\t)a/\t\u0013\u0005}F#!A\u0005\u0002\u0006\u0005\u0007\"CAg)\u0005\u0005I\u0011BAh\u0005%\u0011\u0015\u000e\u001e'f]\u001e$\bN\u0003\u0002\u001d;\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqr$\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0013%A\u0002tc2T!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011&\f\u00198{A\u0011!fK\u0007\u00027%\u0011Af\u0007\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011!FL\u0005\u0003_m\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003cQr!A\u000b\u001a\n\u0005MZ\u0012a\u00029bG.\fw-Z\u0005\u0003kY\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000247A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001 F\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002CO\u00051AH]8pizJ\u0011AO\u0005\u0003geJ!AR$\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005MJ\u0014!B2iS2$W#\u0001&\u0011\u0005)Z\u0015B\u0001'\u001c\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0001\u0016\u000b\u0005\u0002+\u0001!)\u0001j\u0001a\u0001\u0015\u0006AA-\u0019;b)f\u0004X-F\u0001U!\t)\u0006,D\u0001W\u0015\t9v$A\u0003usB,7/\u0003\u0002Z-\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0018\t\u0004}u{\u0016B\u00010H\u0005\r\u0019V-\u001d\t\u0003+\u0002L!!\u0019,\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGC\u00013h!\tAT-\u0003\u0002gs\t\u0019\u0011I\\=\t\u000b!4\u0001\u0019\u00013\u0002\u000bY\fG.^3\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA6rmB\u0011An\\\u0007\u0002[*\u0011anG\u0001\bG>$WmZ3o\u0013\t\u0001XN\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015\u0011x\u00011\u0001t\u0003\r\u0019G\u000f\u001f\t\u0003YRL!!^7\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")qo\u0002a\u0001W\u0006\u0011QM^\u0001\u000baJ,G\u000f^=OC6,W#\u0001>\u0011\u0005m|hB\u0001?~!\t\u0001\u0015(\u0003\u0002\u007fs\u00051\u0001K]3eK\u001aLA!!\u0001\u0002\u0004\t11\u000b\u001e:j]\u001eT!A`\u001d\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\r\u0001\u0016\u0011\u0002\u0005\u0007\u0003\u0017I\u0001\u0019\u0001&\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019\u0001+!\u0005\t\u000f!S\u0001\u0013!a\u0001\u0015\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\fU\rQ\u0015\u0011D\u0016\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005v]\u000eDWmY6fI*\u0019\u0011QE\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0005}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A.\u00198h\u0015\t\tI$\u0001\u0003kCZ\f\u0017\u0002BA\u0001\u0003g\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0011\u0007a\n\u0019%C\u0002\u0002Fe\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001ZA&\u0011%\tiEDA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002R!!\u0016\u0002\\\u0011l!!a\u0016\u000b\u0007\u0005e\u0013(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019'!\u001b\u0011\u0007a\n)'C\u0002\u0002he\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002NA\t\t\u00111\u0001e\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u0012q\u000e\u0005\n\u0003\u001b\n\u0012\u0011!a\u0001\u0003\u0003\na!Z9vC2\u001cH\u0003BA2\u0003kB\u0001\"!\u0014\u0013\u0003\u0003\u0005\r\u0001\u001a\u0015\u0014\u0001\u0005e\u0014qPAA\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151\u0013\t\u0004U\u0005m\u0014bAA?7\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAB\u0003Y{f)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\tLG\u000f\t7f]\u001e$\b\u000eI8gAM$(/\u001b8hA\u0011\fG/\u0019\u0011pe\u0002rW/\u001c2fe\u0002zg\r\t2jiN\u0004sN\u001a\u0011cS:\f'/\u001f\u0011eCR\fg&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI)A \u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]\u0012$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0015!\u0002\u001a/g9\u0002\u0014!B4s_V\u0004\u0018EAAK\u00031\u0019HO]5oO~3WO\\2t\u0003%\u0011\u0015\u000e\u001e'f]\u001e$\b\u000e\u0005\u0002+)M)A#!(\u0002*B1\u0011qTAS\u0015Bk!!!)\u000b\u0007\u0005\r\u0016(A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u0016qG\u0001\u0003S>L1ARAW)\t\tI*\u0001\u0005u_N#(/\u001b8h)\t\ty#A\u0003baBd\u0017\u0010F\u0002Q\u0003{CQ\u0001S\fA\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002D\u0006%\u0007\u0003\u0002\u001d\u0002F*K1!a2:\u0005\u0019y\u0005\u000f^5p]\"A\u00111\u001a\r\u0002\u0002\u0003\u0007\u0001+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!5\u0011\t\u0005E\u00121[\u0005\u0005\u0003+\f\u0019D\u0001\u0004PE*,7\r\u001e")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength bitLength) {
        return BitLength$.MODULE$.unapply(bitLength);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> function1) {
        return BitLength$.MODULE$.andThen(function1);
    }

    public static <A$> Function1<A$, BitLength> compose(Function1<A$, Expression> function1) {
        return BitLength$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$}))}));
    }

    @Override
    public Object nullSafeEval(Object value) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(17).append("(").append((String)c).append(").numBytes() * 8").toString());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").length * 8").toString());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    @Override
    public BitLength withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "child";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

