/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriterSettings;
import com.univocity.parsers.csv.UnescapedQuoteHandling;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.ParseMode$;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SQLConf$LegacyBehaviorPolicy$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEg\u0001\u00021b\u00019D!\"a\u0004\u0001\u0005\u000b\u0007I\u0011AA\t\u0011)\ty\u0003\u0001B\u0001B\u0003%\u00111\u0003\u0005\u000b\u0003s\u0001!Q1A\u0005\u0002\u0005m\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002>!Q\u0011Q\t\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u001d\u0003A!A!\u0002\u0013\ty\u0002C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005%\u0003\u0001\"\u0001\u0002Z!9\u0011\u0011\n\u0001\u0005\u0002\u0005\u001d\u0004bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\t\t\n\u0001C\u0005\u0003'C\u0011\"!'\u0001#\u0003%I!a'\t\u0013\u0005E\u0006A1A\u0005\u0002\u0005M\u0006\u0002CA[\u0001\u0001\u0006I!a\b\t\u0013\u0005]\u0006A1A\u0005\u0002\u0005e\u0006\u0002CAa\u0001\u0001\u0006I!a/\t\u0013\u0005\r\u0007A1A\u0005\u0002\u0005M\u0006\u0002CAc\u0001\u0001\u0006I!a\b\t\u0013\u0005\u001d\u0007A1A\u0005\u0002\u0005%\u0007\u0002CAf\u0001\u0001\u0006I!!\u001e\t\u0013\u00055\u0007A1A\u0005\u0002\u0005%\u0007\u0002CAh\u0001\u0001\u0006I!!\u001e\t\u0013\u0005E\u0007A1A\u0005\u0002\u0005M\u0007\u0002CAn\u0001\u0001\u0006I!!6\t\u0013\u0005u\u0007A1A\u0005\u0002\u0005%\u0007\u0002CAp\u0001\u0001\u0006I!!\u001e\t\u0013\u0005\u0005\bA1A\u0005\u0002\u0005m\u0002\u0002CAr\u0001\u0001\u0006I!!\u0010\t\u0013\u0005\u0015\bA1A\u0005\u0002\u0005m\u0002\u0002CAt\u0001\u0001\u0006I!!\u0010\t\u0013\u0005%\bA1A\u0005\u0002\u0005m\u0002\u0002CAv\u0001\u0001\u0006I!!\u0010\t\u0013\u00055\bA1A\u0005\u0002\u0005m\u0002\u0002CAx\u0001\u0001\u0006I!!\u0010\t\u0013\u0005E\bA1A\u0005\u0002\u0005m\u0002\u0002CAz\u0001\u0001\u0006I!!\u0010\t\u0013\u0005U\bA1A\u0005\u0002\u0005m\u0002\u0002CA|\u0001\u0001\u0006I!!\u0010\t\u0013\u0005e\bA1A\u0005\u0002\u0005M\u0006\u0002CA~\u0001\u0001\u0006I!a\b\t\u0013\u0005u\bA1A\u0005\u0002\u0005M\u0006\u0002CA\u0000\u0001\u0001\u0006I!a\b\t\u0013\t\u0005\u0001A1A\u0005\u0002\u0005M\u0006\u0002\u0003B\u0002\u0001\u0001\u0006I!a\b\t\u0013\t\u0015\u0001A1A\u0005\u0002\u0005M\u0006\u0002\u0003B\u0004\u0001\u0001\u0006I!a\b\t\u0013\t%\u0001A1A\u0005\u0002\u0005M\u0006\u0002\u0003B\u0006\u0001\u0001\u0006I!a\b\t\u0013\t5\u0001A1A\u0005\u0002\t=\u0001\u0002\u0003B\n\u0001\u0001\u0006IA!\u0005\t\u0013\tU\u0001A1A\u0005\u0002\t]\u0001\u0002\u0003B\u0015\u0001\u0001\u0006IA!\u0007\t\u0013\t-\u0002A1A\u0005\u0002\t5\u0002\u0002\u0003B\u001d\u0001\u0001\u0006IAa\f\t\u0013\tm\u0002A1A\u0005\u0002\u0005M\u0006\u0002\u0003B\u001f\u0001\u0001\u0006I!a\b\t\u0013\t}\u0002A1A\u0005\u0002\u0005M\u0006\u0002\u0003B!\u0001\u0001\u0006I!a\b\t\u0013\t\r\u0003A1A\u0005\u0002\u0005m\u0002\u0002\u0003B#\u0001\u0001\u0006I!!\u0010\t\u0013\t\u001d\u0003A1A\u0005\u0002\t%\u0003\u0002\u0003B&\u0001\u0001\u0006I!a\"\t\u0013\t5\u0003A1A\u0005\u0002\t%\u0003\u0002\u0003B(\u0001\u0001\u0006I!a\"\t\u0013\tE\u0003A1A\u0005\u0002\u0005m\u0002\u0002\u0003B*\u0001\u0001\u0006I!!\u0010\t\u0013\tU\u0003A1A\u0005\u0002\u0005m\u0002\u0002\u0003B,\u0001\u0001\u0006I!!\u0010\t\u0013\te\u0003A1A\u0005\u0002\t%\u0003\u0002\u0003B.\u0001\u0001\u0006I!a\"\t\u0013\tu\u0003A1A\u0005\u0002\u0005m\u0002\u0002\u0003B0\u0001\u0001\u0006I!!\u0010\t\u0013\t\u0005\u0004A1A\u0005\u0002\t\r\u0004\u0002\u0003B6\u0001\u0001\u0006IA!\u001a\t\u0013\t5\u0004A1A\u0005\u0002\u0005m\u0002\u0002\u0003B8\u0001\u0001\u0006I!!\u0010\t\u0013\tE\u0004A1A\u0005\u0002\t=\u0001\u0002\u0003B:\u0001\u0001\u0006IA!\u0005\t\u0013\tU\u0004A1A\u0005\u0002\u0005M\u0006\u0002\u0003B<\u0001\u0001\u0006I!a\b\t\u0013\te\u0004A1A\u0005\u0002\u0005M\u0006\u0002\u0003B>\u0001\u0001\u0006I!a\b\t\u0013\tu\u0004A1A\u0005\u0002\t=\u0001\u0002\u0003B@\u0001\u0001\u0006IA!\u0005\t\u0013\t\u0005\u0005A1A\u0005\u0002\t\r\u0005\u0002\u0003BJ\u0001\u0001\u0006IA!\"\t\u0013\tU\u0005A1A\u0005\u0002\t=\u0001\u0002\u0003BL\u0001\u0001\u0006IA!\u0005\t\u0013\te\u0005A1A\u0005\u0002\tm\u0005\u0002\u0003BP\u0001\u0001\u0006IA!(\t\u0013\t\u0005\u0006A1A\u0005\u0002\t\r\u0006\u0002\u0003B^\u0001\u0001\u0006IA!*\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"9!q\u0019\u0001\u0005\u0002\t%'AC\"T->\u0003H/[8og*\u0011!mY\u0001\u0004GN4(B\u00013f\u0003!\u0019\u0017\r^1msN$(B\u00014h\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q&\fQa\u001d9be.T!A[6\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0017aA8sO\u000e\u00011\u0003\u0002\u0001pkn\u0004\"\u0001]:\u000e\u0003ET\u0011A]\u0001\u0006g\u000e\fG.Y\u0005\u0003iF\u0014a!\u00118z%\u00164\u0007C\u0001<z\u001b\u00059(B\u0001=h\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001>x\u0005\u001daunZ4j]\u001e\u00042\u0001`A\u0005\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q.\u0001\u0004=e>|GOP\u0005\u0002e&\u0019\u0011qA9\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t9!]\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001cXCAA\n!\u0019\t)\"a\u0007\u0002 5\u0011\u0011q\u0003\u0006\u0004\u00033\u0019\u0017\u0001B;uS2LA!!\b\u0002\u0018\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q!\u0011\t\t#!\u000b\u000f\t\u0005\r\u0012Q\u0005\t\u0003}FL1!a\nr\u0003\u0019\u0001&/\u001a3fM&!\u00111FA\u0017\u0005\u0019\u0019FO]5oO*\u0019\u0011qE9\u0002\u0017A\f'/Y7fi\u0016\u00148\u000f\t\u0015\u0004\u0005\u0005M\u0002c\u00019\u00026%\u0019\u0011qG9\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!D2pYVlg\u000e\u0015:v]&tw-\u0006\u0002\u0002>A\u0019\u0001/a\u0010\n\u0007\u0005\u0005\u0013OA\u0004C_>dW-\u00198\u0002\u001d\r|G.^7o!J,h.\u001b8hA\u0005\tB-\u001a4bk2$H+[7f5>tW-\u00133\u0002A\u0011,g-Y;mi\u000e{G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u0013\u0011KA*\u0003+\n9\u0006E\u0002\u0002P\u0001i\u0011!\u0019\u0005\b\u0003\u001f9\u0001\u0019AA\n\u0011\u001d\tId\u0002a\u0001\u0003{Aq!!\u0012\b\u0001\u0004\ty\u0002C\u0004\u0002H\u001d\u0001\r!a\b\u0015\u0011\u00055\u00131LA2\u0003KBq!a\u0004\t\u0001\u0004\ti\u0006\u0005\u0005\u0002\"\u0005}\u0013qDA\u0010\u0013\u0011\t\t'!\f\u0003\u00075\u000b\u0007\u000fC\u0004\u0002:!\u0001\r!!\u0010\t\u000f\u0005\u0015\u0003\u00021\u0001\u0002 QQ\u0011QJA5\u0003W\ni'a\u001c\t\u000f\u0005=\u0011\u00021\u0001\u0002^!9\u0011\u0011H\u0005A\u0002\u0005u\u0002bBA#\u0013\u0001\u0007\u0011q\u0004\u0005\b\u0003\u000fJ\u0001\u0019AA\u0010\u0003\u001d9W\r^\"iCJ$b!!\u001e\u0002|\u0005}\u0004c\u00019\u0002x%\u0019\u0011\u0011P9\u0003\t\rC\u0017M\u001d\u0005\b\u0003{R\u0001\u0019AA\u0010\u0003%\u0001\u0018M]1n\u001d\u0006lW\rC\u0004\u0002\u0002*\u0001\r!!\u001e\u0002\u000f\u0011,g-Y;mi\u00061q-\u001a;J]R$b!a\"\u0002\u000e\u0006=\u0005c\u00019\u0002\n&\u0019\u00111R9\u0003\u0007%sG\u000fC\u0004\u0002~-\u0001\r!a\b\t\u000f\u0005\u00055\u00021\u0001\u0002\b\u00069q-\u001a;C_>dGCBA\u001f\u0003+\u000b9\nC\u0004\u0002~1\u0001\r!a\b\t\u0013\u0005\u0005E\u0002%AA\u0002\u0005u\u0012!E4fi\n{w\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0014\u0016\u0005\u0003{\tyj\u000b\u0002\u0002\"B!\u00111UAW\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016!C;oG\",7m[3e\u0015\r\tY+]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAX\u0003K\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%!W\r\\5nSR,'/\u0006\u0002\u0002 \u0005QA-\u001a7j[&$XM\u001d\u0011\u0002\u0013A\f'o]3N_\u0012,WCAA^!\u0011\t)\"!0\n\t\u0005}\u0016q\u0003\u0002\n!\u0006\u00148/Z'pI\u0016\f!\u0002]1sg\u0016lu\u000eZ3!\u0003\u001d\u0019\u0007.\u0019:tKR\f\u0001b\u00195beN,G\u000fI\u0001\u0006cV|G/Z\u000b\u0003\u0003k\na!];pi\u0016\u0004\u0013AB3tG\u0006\u0004X-A\u0004fg\u000e\f\u0007/\u001a\u0011\u00023\rD\u0017M\u001d+p\u000bN\u001c\u0017\r]3Rk>$X-R:dCBLgnZ\u000b\u0003\u0003+\u0004R\u0001]Al\u0003kJ1!!7r\u0005\u0019y\u0005\u000f^5p]\u0006Q2\r[1s)>,5oY1qKF+x\u000e^3Fg\u000e\f\u0007/\u001b8hA\u000591m\\7nK:$\u0018\u0001C2p[6,g\u000e\u001e\u0011\u0002\u0015!,\u0017\rZ3s\r2\fw-A\u0006iK\u0006$WM\u001d$mC\u001e\u0004\u0013aD5oM\u0016\u00148k\u00195f[\u00064E.Y4\u0002!%tg-\u001a:TG\",W.\u0019$mC\u001e\u0004\u0013!H5h]>\u0014X\rT3bI&twm\u00165ji\u0016\u001c\u0006/Y2f\u0013:\u0014V-\u00193\u0002=%<gn\u001c:f\u0019\u0016\fG-\u001b8h/\"LG/Z*qC\u000e,\u0017J\u001c*fC\u0012\u0004\u0013AH5h]>\u0014X\r\u0016:bS2LgnZ,iSR,7\u000b]1dK&s'+Z1e\u0003}IwM\\8sKR\u0013\u0018-\u001b7j]\u001e<\u0006.\u001b;f'B\f7-Z%o%\u0016\fG\rI\u0001#S\u001etwN]3MK\u0006$\u0017N\\4XQ&$Xm\u00159bG\u00164E.Y4J]^\u0013\u0018\u000e^3\u0002G%<gn\u001c:f\u0019\u0016\fG-\u001b8h/\"LG/Z*qC\u000e,g\t\\1h\u0013:<&/\u001b;fA\u0005\u0019\u0013n\u001a8pe\u0016$&/Y5mS:<w\u000b[5uKN\u0003\u0018mY3GY\u0006<\u0017J\\,sSR,\u0017\u0001J5h]>\u0014X\r\u0016:bS2LgnZ,iSR,7\u000b]1dK\u001ac\u0017mZ%o/JLG/\u001a\u0011\u00023\r|G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ\u0001\u001bG>dW/\u001c8OC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H\rI\u0001\n]VdGNV1mk\u0016\f!B\\;mYZ\u000bG.^3!\u0003!q\u0017M\u001c,bYV,\u0017!\u00038b]Z\u000bG.^3!\u0003-\u0001xn]5uSZ,\u0017J\u001c4\u0002\u0019A|7/\u001b;jm\u0016LeN\u001a\u0011\u0002\u00179,w-\u0019;jm\u0016LeNZ\u0001\r]\u0016<\u0017\r^5wK&sg\rI\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\"A!\u0005\u0011\u000bA\f9.a\b\u0002#\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007%\u0001\u0004{_:,\u0017\nZ\u000b\u0003\u00053\u0001BAa\u0007\u0003&5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#\u0001\u0003uS6,'B\u0001B\u0012\u0003\u0011Q\u0017M^1\n\t\t\u001d\"Q\u0004\u0002\u00075>tW-\u00133\u0002\u000fi|g.Z%eA\u00051An\\2bY\u0016,\"Aa\f\u0011\t\tE\"QG\u0007\u0003\u0005gQA!!\u0007\u0003\"%!!q\u0007B\u001a\u0005\u0019aunY1mK\u00069An\\2bY\u0016\u0004\u0013A\u00033bi\u00164uN]7bi\u0006YA-\u0019;f\r>\u0014X.\u0019;!\u0003=!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$\u0018\u0001\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;!\u0003%iW\u000f\u001c;j\u0019&tW-\u0001\u0006nk2$\u0018\u000eT5oK\u0002\n!\"\\1y\u0007>dW/\u001c8t+\t\t9)A\u0006nCb\u001cu\u000e\\;n]N\u0004\u0013!E7bq\u000eC\u0017M]:QKJ\u001cu\u000e\\;n]\u0006\u0011R.\u0019=DQ\u0006\u00148\u000fU3s\u0007>dW/\u001c8!\u00031)7oY1qKF+x\u000e^3t\u00035)7oY1qKF+x\u000e^3tA\u0005A\u0011/^8uK\u0006cG.A\u0005rk>$X-\u00117mA\u0005)R.\u0019=FeJ|'oQ8oi\u0016tG\u000fT3oORD\u0017AF7bq\u0016\u0013(o\u001c:D_:$XM\u001c;MK:<G\u000f\u001b\u0011\u0002\u0019%\u001c8i\\7nK:$8+\u001a;\u0002\u001b%\u001c8i\\7nK:$8+\u001a;!\u00035\u0019\u0018-\u001c9mS:<'+\u0019;j_V\u0011!Q\r\t\u0004a\n\u001d\u0014b\u0001B5c\n1Ai\\;cY\u0016\fab]1na2Lgn\u001a*bi&|\u0007%A\u0007f]\u001a|'oY3TG\",W.Y\u0001\u000fK:4wN]2f'\u000eDW-\\1!\u0003))W\u000e\u001d;z-\u0006dW/Z\u0001\fK6\u0004H/\u001f,bYV,\u0007%\u0001\tf[B$\u0018PV1mk\u0016LeNU3bI\u0006\tR-\u001c9usZ\u000bG.^3J]J+\u0017\r\u001a\u0011\u0002#\u0015l\u0007\u000f^=WC2,X-\u00138Xe&$X-\u0001\nf[B$\u0018PV1mk\u0016Len\u0016:ji\u0016\u0004\u0013!\u00047j]\u0016\u001cV\r]1sCR|'/\u0001\bmS:,7+\u001a9be\u0006$xN\u001d\u0011\u0002'1Lg.Z*fa\u0006\u0014\u0018\r^8s\u0013:\u0014V-\u00193\u0016\u0005\t\u0015\u0005#\u00029\u0002X\n\u001d\u0005#\u00029\u0003\n\n5\u0015b\u0001BFc\n)\u0011I\u001d:bsB\u0019\u0001Oa$\n\u0007\tE\u0015O\u0001\u0003CsR,\u0017\u0001\u00067j]\u0016\u001cV\r]1sCR|'/\u00138SK\u0006$\u0007%\u0001\u000bmS:,7+\u001a9be\u0006$xN]%o/JLG/Z\u0001\u0016Y&tWmU3qCJ\fGo\u001c:J]^\u0013\u0018\u000e^3!\u0003=Ig\u000e];u\u0005V4g-\u001a:TSj,WC\u0001BO!\u0015\u0001\u0018q[AD\u0003AIg\u000e];u\u0005V4g-\u001a:TSj,\u0007%\u0001\fv]\u0016\u001c8-\u00199fIF+x\u000e^3IC:$G.\u001b8h+\t\u0011)\u000b\u0005\u0003\u0003(\n]VB\u0001BU\u0015\r\u0011'1\u0016\u0006\u0005\u0005[\u0013y+A\u0004qCJ\u001cXM]:\u000b\t\tE&1W\u0001\nk:Lgo\\2jifT!A!.\u0002\u0007\r|W.\u0003\u0003\u0003:\n%&AF+oKN\u001c\u0017\r]3e#V|G/\u001a%b]\u0012d\u0017N\\4\u0002/UtWm]2ba\u0016$\u0017+^8uK\"\u000bg\u000e\u001a7j]\u001e\u0004\u0013\u0001E1t/JLG/\u001a:TKR$\u0018N\\4t+\t\u0011\t\r\u0005\u0003\u0003(\n\r\u0017\u0002\u0002Bc\u0005S\u0013\u0011cQ:w/JLG/\u001a:TKR$\u0018N\\4t\u0003A\t7\u000fU1sg\u0016\u00148+\u001a;uS:<7/\u0006\u0002\u0003LB!!q\u0015Bg\u0013\u0011\u0011yM!+\u0003#\r\u001bh\u000fU1sg\u0016\u00148+\u001a;uS:<7\u000f")
public class CSVOptions
implements Logging,
Serializable {
    private final transient CaseInsensitiveMap<String> parameters;
    private final boolean columnPruning;
    private final String defaultTimeZoneId;
    private final String defaultColumnNameOfCorruptRecord;
    private final String delimiter;
    private final ParseMode parseMode;
    private final String charset;
    private final char quote;
    private final char escape;
    private final Option<Object> charToEscapeQuoteEscaping;
    private final char comment;
    private final boolean headerFlag;
    private final boolean inferSchemaFlag;
    private final boolean ignoreLeadingWhiteSpaceInRead;
    private final boolean ignoreTrailingWhiteSpaceInRead;
    private final boolean ignoreLeadingWhiteSpaceFlagInWrite;
    private final boolean ignoreTrailingWhiteSpaceFlagInWrite;
    private final String columnNameOfCorruptRecord;
    private final String nullValue;
    private final String nanValue;
    private final String positiveInf;
    private final String negativeInf;
    private final Option<String> compressionCodec;
    private final ZoneId zoneId;
    private final Locale locale;
    private final String dateFormat;
    private final String timestampFormat;
    private final boolean multiLine;
    private final int maxColumns;
    private final int maxCharsPerColumn;
    private final boolean escapeQuotes;
    private final boolean quoteAll;
    private final int maxErrorContentLength;
    private final boolean isCommentSet;
    private final double samplingRatio;
    private final boolean enforceSchema;
    private final Option<String> emptyValue;
    private final String emptyValueInRead;
    private final String emptyValueInWrite;
    private final Option<String> lineSeparator;
    private final Option<byte[]> lineSeparatorInRead;
    private final Option<String> lineSeparatorInWrite;
    private final Option<Object> inputBufferSize;
    private final UnescapedQuoteHandling unescapedQuoteHandling;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CaseInsensitiveMap<String> parameters() {
        return this.parameters;
    }

    public boolean columnPruning() {
        return this.columnPruning;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char getChar(String paramName, char c) {
        String value;
        Option<String> paramValue = this.parameters().get(paramName);
        boolean bl = false;
        Some some = null;
        Option<String> option = paramValue;
        if (None$.MODULE$.equals(option)) {
            return c;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            if (string == null) {
                return c;
            }
        }
        if (bl && (value = (String)some.value()).length() == 0) {
            return '\u0000';
        }
        if (!bl) throw QueryExecutionErrors$.MODULE$.paramExceedOneCharError(paramName);
        String value2 = (String)some.value();
        if (value2.length() != 1) throw QueryExecutionErrors$.MODULE$.paramExceedOneCharError(paramName);
        return value2.charAt(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getInt(String paramName, int n) {
        Option<String> paramValue = this.parameters().get(paramName);
        boolean bl = false;
        Some some = null;
        Option<String> option = paramValue;
        if (None$.MODULE$.equals(option)) {
            return n;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string = (String)some.value();
            if (string == null) {
                return n;
            }
        }
        if (!bl) throw new MatchError(option);
        String value = (String)some.value();
        try {
            int n2 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value));
            return n2;
        }
        catch (NumberFormatException e) {
            throw QueryExecutionErrors$.MODULE$.paramIsNotIntegerError(paramName, value);
        }
    }

    private boolean getBool(String paramName, boolean bl) {
        boolean bl2;
        String param = (String)this.parameters().getOrElse(paramName, (Function0 & Serializable)() -> Boolean.toString(bl));
        if (param == null) {
            bl2 = bl;
        } else {
            String string = param.toLowerCase(Locale.ROOT);
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                bl2 = true;
            } else {
                String string3 = param.toLowerCase(Locale.ROOT);
                String string4 = "false";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    bl2 = false;
                } else {
                    throw QueryExecutionErrors$.MODULE$.paramIsNotBooleanValueError(paramName);
                }
            }
        }
        return bl2;
    }

    private boolean getBool$default$2() {
        return false;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public ParseMode parseMode() {
        return this.parseMode;
    }

    public String charset() {
        return this.charset;
    }

    public char quote() {
        return this.quote;
    }

    public char escape() {
        return this.escape;
    }

    public Option<Object> charToEscapeQuoteEscaping() {
        return this.charToEscapeQuoteEscaping;
    }

    public char comment() {
        return this.comment;
    }

    public boolean headerFlag() {
        return this.headerFlag;
    }

    public boolean inferSchemaFlag() {
        return this.inferSchemaFlag;
    }

    public boolean ignoreLeadingWhiteSpaceInRead() {
        return this.ignoreLeadingWhiteSpaceInRead;
    }

    public boolean ignoreTrailingWhiteSpaceInRead() {
        return this.ignoreTrailingWhiteSpaceInRead;
    }

    public boolean ignoreLeadingWhiteSpaceFlagInWrite() {
        return this.ignoreLeadingWhiteSpaceFlagInWrite;
    }

    public boolean ignoreTrailingWhiteSpaceFlagInWrite() {
        return this.ignoreTrailingWhiteSpaceFlagInWrite;
    }

    public String columnNameOfCorruptRecord() {
        return this.columnNameOfCorruptRecord;
    }

    public String nullValue() {
        return this.nullValue;
    }

    public String nanValue() {
        return this.nanValue;
    }

    public String positiveInf() {
        return this.positiveInf;
    }

    public String negativeInf() {
        return this.negativeInf;
    }

    public Option<String> compressionCodec() {
        return this.compressionCodec;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public Locale locale() {
        return this.locale;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public String timestampFormat() {
        return this.timestampFormat;
    }

    public boolean multiLine() {
        return this.multiLine;
    }

    public int maxColumns() {
        return this.maxColumns;
    }

    public int maxCharsPerColumn() {
        return this.maxCharsPerColumn;
    }

    public boolean escapeQuotes() {
        return this.escapeQuotes;
    }

    public boolean quoteAll() {
        return this.quoteAll;
    }

    public int maxErrorContentLength() {
        return this.maxErrorContentLength;
    }

    public boolean isCommentSet() {
        return this.isCommentSet;
    }

    public double samplingRatio() {
        return this.samplingRatio;
    }

    public boolean enforceSchema() {
        return this.enforceSchema;
    }

    public Option<String> emptyValue() {
        return this.emptyValue;
    }

    public String emptyValueInRead() {
        return this.emptyValueInRead;
    }

    public String emptyValueInWrite() {
        return this.emptyValueInWrite;
    }

    public Option<String> lineSeparator() {
        return this.lineSeparator;
    }

    public Option<byte[]> lineSeparatorInRead() {
        return this.lineSeparatorInRead;
    }

    public Option<String> lineSeparatorInWrite() {
        return this.lineSeparatorInWrite;
    }

    public Option<Object> inputBufferSize() {
        return this.inputBufferSize;
    }

    public UnescapedQuoteHandling unescapedQuoteHandling() {
        return this.unescapedQuoteHandling;
    }

    /*
     * WARNING - void declaration
     */
    public CsvWriterSettings asWriterSettings() {
        void var1_1;
        CsvWriterSettings writerSettings = new CsvWriterSettings();
        CsvFormat format = (CsvFormat)writerSettings.getFormat();
        format.setDelimiter(this.delimiter());
        format.setQuote(this.quote());
        format.setQuoteEscape(this.escape());
        this.charToEscapeQuoteEscaping().foreach((Function1 & Serializable)x$1 -> {
            format.setCharToEscapeQuoteEscaping(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        if (this.isCommentSet()) {
            format.setComment(this.comment());
        }
        this.lineSeparatorInWrite().foreach((Function1 & Serializable)x$1 -> {
            format.setLineSeparator(x$1);
            return BoxedUnit.UNIT;
        });
        writerSettings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhiteSpaceFlagInWrite());
        writerSettings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhiteSpaceFlagInWrite());
        writerSettings.setNullValue(this.nullValue());
        writerSettings.setEmptyValue(this.emptyValueInWrite());
        writerSettings.setSkipEmptyLines(true);
        writerSettings.setQuoteAllFields(this.quoteAll());
        writerSettings.setQuoteEscapingEnabled(this.escapeQuotes());
        writerSettings.setErrorContentLength(this.maxErrorContentLength());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CsvParserSettings asParserSettings() {
        void var1_1;
        CsvParserSettings settings = new CsvParserSettings();
        CsvFormat format = (CsvFormat)settings.getFormat();
        format.setDelimiter(this.delimiter());
        format.setQuote(this.quote());
        format.setQuoteEscape(this.escape());
        this.lineSeparator().foreach((Function1 & Serializable)x$1 -> {
            format.setLineSeparator(x$1);
            return BoxedUnit.UNIT;
        });
        this.charToEscapeQuoteEscaping().foreach((Function1 & Serializable)x$1 -> {
            format.setCharToEscapeQuoteEscaping(BoxesRunTime.unboxToChar((Object)x$1));
            return BoxedUnit.UNIT;
        });
        if (this.isCommentSet()) {
            format.setComment(this.comment());
        } else {
            settings.setCommentProcessingEnabled(false);
        }
        settings.setIgnoreLeadingWhitespaces(this.ignoreLeadingWhiteSpaceInRead());
        settings.setIgnoreTrailingWhitespaces(this.ignoreTrailingWhiteSpaceInRead());
        settings.setReadInputOnSeparateThread(false);
        this.inputBufferSize().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> settings.setInputBufferSize(x$1));
        settings.setMaxColumns(this.maxColumns());
        settings.setNullValue(this.nullValue());
        settings.setEmptyValue(this.emptyValueInRead());
        settings.setMaxCharsPerColumn(this.maxCharsPerColumn());
        settings.setUnescapedQuoteHandling(this.unescapedQuoteHandling());
        settings.setLineSeparatorDetectionEnabled(this.lineSeparatorInRead().isEmpty() && this.multiLine());
        this.lineSeparatorInRead().foreach((Function1 & Serializable)x$4 -> {
            settings.setNormalizeLineEndingsWithinQuotes(!this.multiLine());
            return BoxedUnit.UNIT;
        });
        settings.setErrorContentLength(this.maxErrorContentLength());
        return var1_1;
    }

    public static final /* synthetic */ String $anonfun$delimiter$1(CSVOptions $this) {
        return (String)$this.parameters().getOrElse("delimiter", (Function0 & Serializable)() -> ",");
    }

    public static final /* synthetic */ ParseMode $anonfun$parseMode$1(String mode) {
        return ParseMode$.MODULE$.fromString(mode);
    }

    public static final /* synthetic */ PermissiveMode$ $anonfun$parseMode$2() {
        return PermissiveMode$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$charset$1(CSVOptions $this) {
        return (String)$this.parameters().getOrElse("charset", (Function0 & Serializable)() -> StandardCharsets.UTF_8.name());
    }

    public static final /* synthetic */ String $anonfun$columnNameOfCorruptRecord$1(CSVOptions $this) {
        return $this.defaultColumnNameOfCorruptRecord;
    }

    public static final /* synthetic */ String $anonfun$nullValue$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$nanValue$1() {
        return "NaN";
    }

    public static final /* synthetic */ String $anonfun$positiveInf$1() {
        return "Inf";
    }

    public static final /* synthetic */ String $anonfun$negativeInf$1() {
        return "-Inf";
    }

    public static final /* synthetic */ Option $anonfun$compressionCodec$1(CSVOptions $this) {
        return $this.parameters().get("codec");
    }

    public static final /* synthetic */ String $anonfun$compressionCodec$2(String name) {
        return CompressionCodecs$.MODULE$.getCodecClassName(name);
    }

    public static final /* synthetic */ String $anonfun$zoneId$1(CSVOptions $this) {
        return $this.defaultTimeZoneId;
    }

    public static final /* synthetic */ Locale $anonfun$locale$1(String x$1) {
        return Locale.forLanguageTag(x$1);
    }

    public static final /* synthetic */ Locale $anonfun$locale$2() {
        return Locale.US;
    }

    public static final /* synthetic */ String $anonfun$dateFormat$1() {
        return DateFormatter$.MODULE$.defaultPattern();
    }

    public static final /* synthetic */ String $anonfun$timestampFormat$1() {
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = SQLConf$LegacyBehaviorPolicy$.MODULE$.LEGACY();
        return !(value != null ? !value.equals(value2) : value2 != null) ? new StringBuilder(18).append(DateFormatter$.MODULE$.defaultPattern()).append("'T'HH:mm:ss.SSSXXX").toString() : new StringBuilder(22).append(DateFormatter$.MODULE$.defaultPattern()).append("'T'HH:mm:ss[.SSS][XXX]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$multiLine$2() {
        return false;
    }

    public static final /* synthetic */ double $anonfun$samplingRatio$2() {
        return 1.0;
    }

    public static final /* synthetic */ String $anonfun$emptyValueInRead$1() {
        return "";
    }

    public static final /* synthetic */ String $anonfun$emptyValueInWrite$1() {
        return "\"\"";
    }

    public static final /* synthetic */ String $anonfun$lineSeparator$1(String sep) {
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sep)), (Function0 & Serializable)() -> "'lineSep' cannot be an empty string.");
        Predef$.MODULE$.require(sep.length() == 1, (Function0 & Serializable)() -> "'lineSep' can contain only 1 character.");
        return sep;
    }

    public static final /* synthetic */ byte[] $anonfun$lineSeparatorInRead$1(CSVOptions $this, String lineSep) {
        return lineSep.getBytes($this.charset());
    }

    public static final /* synthetic */ Option $anonfun$inputBufferSize$2() {
        return SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.CSV_INPUT_BUFFER_SIZE());
    }

    public static final /* synthetic */ String $anonfun$unescapedQuoteHandling$1() {
        return "STOP_AT_DELIMITER";
    }

    /*
     * Unable to fully structure code
     */
    public CSVOptions(CaseInsensitiveMap<String> parameters, boolean columnPruning, String defaultTimeZoneId, String defaultColumnNameOfCorruptRecord) {
        block7: {
            block6: {
                this.parameters = parameters;
                this.columnPruning = columnPruning;
                this.defaultTimeZoneId = defaultTimeZoneId;
                this.defaultColumnNameOfCorruptRecord = defaultColumnNameOfCorruptRecord;
                super();
                Logging.$init$((Logging)this);
                this.delimiter = CSVExprUtils$.MODULE$.toDelimiterStr((String)parameters.getOrElse("sep", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$delimiter$1(org.apache.spark.sql.catalyst.csv.CSVOptions ), ()Ljava/lang/String;)((CSVOptions)this)));
                this.parseMode = (ParseMode)parameters.get("mode").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseMode$1(java.lang.String ), (Ljava/lang/String;)Lorg/apache/spark/sql/catalyst/util/ParseMode;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseMode$2(), ()Lorg/apache/spark/sql/catalyst/util/PermissiveMode$;)());
                this.charset = (String)parameters.getOrElse("encoding", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$charset$1(org.apache.spark.sql.catalyst.csv.CSVOptions ), ()Ljava/lang/String;)((CSVOptions)this));
                this.quote = this.getChar("quote", '\"');
                this.escape = this.getChar("escape", '\\');
                var6_5 = false;
                var7_6 = null;
                var8_7 = parameters.get("charToEscapeQuoteEscaping");
                if (!None$.MODULE$.equals(var8_7)) break block6;
                var5_8 = None$.MODULE$;
                break block7;
            }
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            var9_9 = (String)var7_6.value();
            if (var9_9 == null) {
                var5_8 = None$.MODULE$;
            } else if (var6_5 && (value = (String)var7_6.value()).length() == 0) {
                var5_8 = None$.MODULE$;
            } else if (var6_5 && (value = (String)var7_6.value()).length() == 1) {
                var5_8 = new Some((Object)BoxesRunTime.boxToCharacter((char)value.charAt(0)));
            } else {
                throw QueryExecutionErrors$.MODULE$.paramExceedOneCharError("charToEscapeQuoteEscaping");
            }
        }
        this.charToEscapeQuoteEscaping = var5_8;
        this.comment = this.getChar("comment", '\u0000');
        this.headerFlag = this.getBool("header", this.getBool$default$2());
        this.inferSchemaFlag = this.getBool("inferSchema", this.getBool$default$2());
        this.ignoreLeadingWhiteSpaceInRead = this.getBool("ignoreLeadingWhiteSpace", false);
        this.ignoreTrailingWhiteSpaceInRead = this.getBool("ignoreTrailingWhiteSpace", false);
        this.ignoreLeadingWhiteSpaceFlagInWrite = this.getBool("ignoreLeadingWhiteSpace", true);
        this.ignoreTrailingWhiteSpaceFlagInWrite = this.getBool("ignoreTrailingWhiteSpace", true);
        this.columnNameOfCorruptRecord = (String)parameters.getOrElse("columnNameOfCorruptRecord", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$columnNameOfCorruptRecord$1(org.apache.spark.sql.catalyst.csv.CSVOptions ), ()Ljava/lang/String;)((CSVOptions)this));
        this.nullValue = (String)parameters.getOrElse("nullValue", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$nullValue$1(), ()Ljava/lang/String;)());
        this.nanValue = (String)parameters.getOrElse("nanValue", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$nanValue$1(), ()Ljava/lang/String;)());
        this.positiveInf = (String)parameters.getOrElse("positiveInf", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$positiveInf$1(), ()Ljava/lang/String;)());
        this.negativeInf = (String)parameters.getOrElse("negativeInf", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$negativeInf$1(), ()Ljava/lang/String;)());
        name = parameters.get("compression").orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$compressionCodec$1(org.apache.spark.sql.catalyst.csv.CSVOptions ), ()Lscala/Option;)((CSVOptions)this));
        this.compressionCodec = name.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$compressionCodec$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        this.zoneId = DateTimeUtils$.MODULE$.getZoneId((String)parameters.getOrElse(DateTimeUtils$.MODULE$.TIMEZONE_OPTION(), (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$zoneId$1(org.apache.spark.sql.catalyst.csv.CSVOptions ), ()Ljava/lang/String;)((CSVOptions)this)));
        this.locale = (Locale)parameters.get("locale").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$locale$1(java.lang.String ), (Ljava/lang/String;)Ljava/util/Locale;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$locale$2(), ()Ljava/util/Locale;)());
        this.dateFormat = (String)parameters.getOrElse("dateFormat", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$dateFormat$1(), ()Ljava/lang/String;)());
        this.timestampFormat = (String)parameters.getOrElse("timestampFormat", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$timestampFormat$1(), ()Ljava/lang/String;)());
        this.multiLine = BoxesRunTime.unboxToBoolean((Object)parameters.get("multiLine").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$multiLine$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$multiLine$2(), ()Z)()));
        this.maxColumns = this.getInt("maxColumns", 20480);
        this.maxCharsPerColumn = this.getInt("maxCharsPerColumn", -1);
        this.escapeQuotes = this.getBool("escapeQuotes", true);
        this.quoteAll = this.getBool("quoteAll", false);
        this.maxErrorContentLength = 1000;
        this.isCommentSet = this.comment() != '\u0000';
        this.samplingRatio = BoxesRunTime.unboxToDouble((Object)parameters.get("samplingRatio").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$samplingRatio$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()D, $anonfun$samplingRatio$2(), ()D)()));
        this.enforceSchema = this.getBool("enforceSchema", true);
        this.emptyValue = parameters.get("emptyValue");
        this.emptyValueInRead = (String)this.emptyValue().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$emptyValueInRead$1(), ()Ljava/lang/String;)());
        this.emptyValueInWrite = (String)this.emptyValue().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$emptyValueInWrite$1(), ()Ljava/lang/String;)());
        this.lineSeparator = parameters.get("lineSep").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lineSeparator$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        this.lineSeparatorInRead = this.lineSeparator().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lineSeparatorInRead$1(org.apache.spark.sql.catalyst.csv.CSVOptions java.lang.String ), (Ljava/lang/String;)[B)((CSVOptions)this));
        this.lineSeparatorInWrite = this.lineSeparator();
        this.inputBufferSize = parameters.get("inputBufferSize").map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$inputBufferSize$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)()).orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$inputBufferSize$2(), ()Lscala/Option;)());
        this.unescapedQuoteHandling = UnescapedQuoteHandling.valueOf((String)((String)parameters.getOrElse("unescapedQuoteHandling", (Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$unescapedQuoteHandling$1(), ()Ljava/lang/String;)())).toUpperCase(Locale.ROOT));
    }

    public CSVOptions(Map<String, String> parameters, boolean columnPruning, String defaultTimeZoneId) {
        this(CaseInsensitiveMap$.MODULE$.apply(parameters), columnPruning, defaultTimeZoneId, SQLConf$.MODULE$.get().columnNameOfCorruptRecord());
    }

    public CSVOptions(Map<String, String> parameters, boolean columnPruning, String defaultTimeZoneId, String defaultColumnNameOfCorruptRecord) {
        this(CaseInsensitiveMap$.MODULE$.apply(parameters), columnPruning, defaultTimeZoneId, defaultColumnNameOfCorruptRecord);
    }

    public static final /* synthetic */ Object $anonfun$multiLine$1$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$1)));
    }

    public static final /* synthetic */ Object $anonfun$samplingRatio$1$adapted(String x$2) {
        return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$2)));
    }

    public static final /* synthetic */ Object $anonfun$inputBufferSize$1$adapted(String x$3) {
        return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$3)));
    }
}

