/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u0014(\u0001RB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011!!\u0006A!f\u0001\n\u0003i\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011\u0001/\t\u000bY\u0003A\u0011\u00011\t\u000b\t\u0004A\u0011I2\t\u000b\u001d\u0004A\u0011I'\t\u000b!\u0004A\u0011I'\t\u000b%\u0004A\u0011I'\t\u000b)\u0004A\u0011I6\t\u000bu\u0004A\u0011\t@\t\u0015\u0005\u0015\u0001\u0001#b\u0001\n\u0013\t9\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005-\u0002\u0001\"\u0015\u0002.!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA/\u0001\u0011E\u0013q\f\u0005\n\u0003[\u0002\u0011\u0011!C\u0001\u0003_B\u0011\"a\u001e\u0001#\u0003%\t!!\u001f\t\u0013\u0005=\u0005!%A\u0005\u0002\u0005e\u0004\"CAI\u0001E\u0005I\u0011AA=\u0011%\t\u0019\nAA\u0001\n\u0003\n)\nC\u0005\u0002&\u0002\t\t\u0011\"\u0001\u0002(\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003o\u0003\u0011\u0011!C!\u0003sC\u0011\"a2\u0001\u0003\u0003%\t!!3\t\u0013\u00055\u0007!!A\u0005B\u0005=w!CAzO\u0005\u0005\t\u0012AA{\r!1s%!A\t\u0002\u0005]\bB\u0002,!\t\u0003\u0011)\u0001C\u0005\u0003\b\u0001\n\t\u0011\"\u0012\u0003\n!I!1\u0002\u0011\u0002\u0002\u0013\u0005%Q\u0002\u0005\n\u0005+\u0001\u0013\u0011!CA\u0005/A\u0011B!\u000b!\u0003\u0003%IAa\u000b\u0003\u0017M#(/\u001b8h)>l\u0015\r\u001d\u0006\u0003Q%\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011!fK\u0001\tG\u0006$\u0018\r\\=ti*\u0011A&L\u0001\u0004gFd'B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0004\u0001M1\u0001!N\u001d=\u0007&\u0003\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00027u%\u00111h\n\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001fA\u001d\t1d(\u0003\u0002@O\u00059\u0001/Y2lC\u001e,\u0017BA!C\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aP\u0014\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000fA\u0013x\u000eZ;diB\u0011AIS\u0005\u0003\u0017\u0016\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001^3yiV\ta\n\u0005\u00027\u001f&\u0011\u0001k\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u0002;fqR\u0004\u0013!\u00039bSJ$U\r\\5n\u0003)\u0001\u0018-\u001b:EK2LW\u000eI\u0001\u000eW\u0016Lh+\u00197vK\u0012+G.[7\u0002\u001d-,\u0017PV1mk\u0016$U\r\\5nA\u00051A(\u001b8jiz\"B\u0001W-[7B\u0011a\u0007\u0001\u0005\u0006\u0019\u001e\u0001\rA\u0014\u0005\u0006%\u001e\u0001\rA\u0014\u0005\u0006)\u001e\u0001\rA\u0014\u000b\u00041v{\u0006\"\u00020\t\u0001\u0004q\u0015!B2iS2$\u0007\"\u0002*\t\u0001\u0004qEC\u0001-b\u0011\u0015q\u0016\u00021\u0001O\u0003!\u0019H/\u0019;fMVdW#\u00013\u0011\u0005\u0011+\u0017B\u00014F\u0005\u001d\u0011un\u001c7fC:\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017AC5oaV$H+\u001f9fgV\tA\u000eE\u0002ni^t!A\\:\u000f\u0005=\u0014X\"\u00019\u000b\u0005E\u001c\u0014A\u0002\u001fs_>$h(C\u0001G\u0013\tyT)\u0003\u0002vm\n\u00191+Z9\u000b\u0005}*\u0005C\u0001=|\u001b\u0005I(B\u0001>,\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0018P\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001\u0000!\rA\u0018\u0011A\u0005\u0004\u0003\u0007I(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00155\f\u0007OQ;jY\u0012,'/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010%\nA!\u001e;jY&!\u00111CA\u0007\u0005Q\t%O]1z\u0005\u0006\u001cX\rZ'ba\n+\u0018\u000e\u001c3fe\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u0011\u0011DA\u0010\u0003G\t9\u0003E\u0002E\u00037I1!!\bF\u0005\r\te.\u001f\u0005\b\u0003C\t\u0002\u0019AA\r\u0003-Ig\u000e];u'R\u0014\u0018N\\4\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002\u001a\u0005y1\u000f\u001e:j]\u001e$U\r\\5nSR,'\u000fC\u0004\u0002*E\u0001\r!!\u0007\u0002#-,\u0017PV1mk\u0016$U\r\\5nSR,'/A\u0005e_\u001e+gnQ8eKR1\u0011qFA\u001e\u0003\u000b\u0002B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k9\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003s\t\u0019D\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tiD\u0005a\u0001\u0003\u007f\t1a\u0019;y!\u0011\t\t$!\u0011\n\t\u0005\r\u00131\u0007\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t9E\u0005a\u0001\u0003_\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002NA!\u0011qJA,\u001d\u0011\t\t&a\u0015\u0011\u0005=,\u0015bAA+\u000b\u00061\u0001K]3eK\u001aLA!!\u0017\u0002\\\t11\u000b\u001e:j]\u001eT1!!\u0016F\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004O\u0003C\n)'!\u001b\t\r\u0005\rD\u00031\u0001O\u0003!qWm\u001e$jeN$\bBBA4)\u0001\u0007a*A\u0005oK^\u001cVmY8oI\"1\u00111\u000e\u000bA\u00029\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004Y\u0003c\n\u0019(!\u001e\t\u000f1+\u0002\u0013!a\u0001\u001d\"9!+\u0006I\u0001\u0002\u0004q\u0005b\u0002+\u0016!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYHK\u0002O\u0003{Z#!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013+\u0015AC1o]>$\u0018\r^5p]&!\u0011QRAB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bA\u0001\\1oO*\u0011\u0011\u0011U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002Z\u0005m\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAU!\r!\u00151V\u0005\u0004\u0003[+%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\r\u0003gC\u0011\"!.\u001c\u0003\u0003\u0005\r!!+\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\f\u0005\u0004\u0002>\u0006\r\u0017\u0011D\u0007\u0003\u0003\u007fS1!!1F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\fyL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00013\u0002L\"I\u0011QW\u000f\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0011\f\t\u000eC\u0005\u00026z\t\t\u00111\u0001\u0002\u001a!\u001a\u0002!!6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI/!<\u0002pB\u0019a'a6\n\u0007\u0005ewEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0017Aa\u0006`\rVs5i\u0018\u0015uKb$8\f\f\u0011qC&\u0014H)\u001a7j[nc\u0003e[3z-\u0006dW/\u001a#fY&lW,X\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002\ng\r^3sAM\u0004H.\u001b;uS:<\u0007\u0005\u001e5fAQ,\u0007\u0010\u001e\u0011j]R|\u0007e[3z_Y\fG.^3!a\u0006L'o\u001d\u0011vg&tw\r\t3fY&l\u0017\u000e^3sg:\u0002C)\u001a4bk2$\b\u0005Z3mS6LG/\u001a:tA\u0005\u0014X\rI\u0014-O\u00012wN\u001d\u0011aa\u0006L'\u000fR3mS6\u0004\u0007%\u00198eA\u001dRt\u0005\t4pe\u0002\u00027.Z=WC2,X\rR3mS6\u0004g\u0006\t\"pi\"\u0004\u0003\r]1je\u0012+G.[7aA\u0005tG\r\t1lKf4\u0016\r\\;f\t\u0016d\u0017.\u001c1!CJ,\u0007\u0005\u001e:fCR,G\rI1tAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\\:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAs\u0003\u0005\u0005\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014buEb#M\u000f\u001a-Gj\u001at\u0005\f\u0011(Y\u001db\u0003e\n\u001e(SmR\u0001\u0005\t\u0011!A\u0001\u00023PI1#u\t\n$\u0005\f\u0012cEi\u0012#G\t\u0017#G\nR$e\r\u0012~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013mJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001eok2dWP\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY/A\u00033]Ar\u0013'A\u0003he>,\b/\t\u0002\u0002r\u0006IQ.\u00199`MVt7m]\u0001\f'R\u0014\u0018N\\4U_6\u000b\u0007\u000f\u0005\u00027AM!\u0001%!?J!!\tYP!\u0001O\u001d:CVBAA\u007f\u0015\r\ty0R\u0001\beVtG/[7f\u0013\u0011\u0011\u0019!!@\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002v\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0018\u0006)\u0011\r\u001d9msR9\u0001La\u0004\u0003\u0012\tM\u0001\"\u0002'$\u0001\u0004q\u0005\"\u0002*$\u0001\u0004q\u0005\"\u0002+$\u0001\u0004q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u00053\u0011)\u0003E\u0003E\u00057\u0011y\"C\u0002\u0003\u001e\u0015\u0013aa\u00149uS>t\u0007C\u0002#\u0003\"9se*C\u0002\u0003$\u0015\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0014I\u0005\u0005\t\u0019\u0001-\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0017!\u0011\tIJa\f\n\t\tE\u00121\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if (!this.bitmap$0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(text, pd, kvd) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

