/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathList$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a string array of values within the nodes of xml that match the XPath expression.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b/text()');\n       [\"b1\",\"b2\",\"b3\"]\n      > SELECT _FUNC_('<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>','a/b');\n       [null,null,null]\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u000e\u001c\u0001*B\u0001\u0002\b\u0001\u0003\u0016\u0004%\t\u0001\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005s!Aa\b\u0001BK\u0002\u0013\u0005\u0001\b\u0003\u0005@\u0001\tE\t\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u001d9\u0007!!A\u0005\u0002!Dqa\u001b\u0001\u0012\u0002\u0013\u0005A\u000eC\u0004x\u0001E\u0005I\u0011\u00017\t\u000fa\u0004\u0011\u0011!C!s\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001fA\u0011\"!\u0006\u0001\u0003\u0003%\t%a\u0006\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u000f%\t9fGA\u0001\u0012\u0003\tIF\u0002\u0005\u001b7\u0005\u0005\t\u0012AA.\u0011\u0019\u0001E\u0003\"\u0001\u0002j!I\u00111\u000e\u000b\u0002\u0002\u0013\u0015\u0013Q\u000e\u0005\n\u0003_\"\u0012\u0011!CA\u0003cB\u0011\"a\u001e\u0015\u0003\u0003%\t)!\u001f\t\u0013\u0005-E#!A\u0005\n\u00055%!\u0003-QCRDG*[:u\u0015\taR$A\u0002y[2T!AH\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003A\u0005\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003E\r\n1a]9m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-zS\u0007\u0005\u0002-[5\t1$\u0003\u0002/7\ta\u0001\fU1uQ\u0016CHO]1diB\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t9\u0001K]8ek\u000e$\bC\u0001\u00197\u0013\t9\u0014G\u0001\u0007TKJL\u0017\r\\5{C\ndW-F\u0001:!\tQ4(D\u0001\u001e\u0013\taTD\u0001\u0006FqB\u0014Xm]:j_:\fA\u0001_7mA\u0005!\u0001/\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0019a\u0014N\\5u}Q\u0019!i\u0011#\u0011\u00051\u0002\u0001\"\u0002\u000f\u0006\u0001\u0004I\u0004\"\u0002 \u0006\u0001\u0004I\u0014A\u00039sKR$\u0018PT1nKV\tq\t\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015Fj\u0011a\u0013\u0006\u0003\u0019&\na\u0001\u0010:p_Rt\u0014B\u0001(2\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u000b\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003Q\u0003\"!\u0016-\u000e\u0003YS!aV\u0011\u0002\u000bQL\b/Z:\n\u0005e3&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007q{\u0006\r\u0005\u00021;&\u0011a,\r\u0002\u0004\u0003:L\b\"\u0002\u000f\t\u0001\u0004a\u0006\"\u0002 \t\u0001\u0004a\u0016aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u00115-\u001a\u0005\u0006I&\u0001\r!O\u0001\b]\u0016<H*\u001a4u\u0011\u00151\u0017\u00021\u0001:\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$2AQ5k\u0011\u001da\"\u0002%AA\u0002eBqA\u0010\u0006\u0011\u0002\u0003\u0007\u0011(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u00035T#!\u000f8,\u0003=\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\u0013Ut7\r[3dW\u0016$'B\u0001;2\u0003)\tgN\\8uCRLwN\\\u0005\u0003mF\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0\u0001\u0003mC:<'\"A@\u0002\t)\fg/Y\u0005\u0003!r\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0002\u0011\u0007A\nI!C\u0002\u0002\fE\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001XA\t\u0011%\t\u0019bDA\u0001\u0002\u0004\t9!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00033\u0001R!a\u0007\u0002\"qk!!!\b\u000b\u0007\u0005}\u0011'\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001e\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI#a\f\u0011\u0007A\nY#C\u0002\u0002.E\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0014E\t\t\u00111\u0001]\u0003\u0019)\u0017/^1mgR!\u0011\u0011FA\u001b\u0011!\t\u0019BEA\u0001\u0002\u0004a\u0006f\u0005\u0001\u0002:\u0005}\u0012\u0011IA#\u0003\u000f\nY%!\u0014\u0002R\u0005M\u0003c\u0001\u001e\u0002<%\u0019\u0011QH\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111I\u0001o?\u001a+fjQ0)q6dG\u0006\t=qCRD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043\u000f\u001e:j]\u001e\u0004\u0013M\u001d:bs\u0002zg\r\t<bYV,7\u000fI<ji\"Lg\u000e\t;iK\u0002rw\u000eZ3tA=4\u0007\u0005_7mAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t;iK\u0002B\u0006+\u0019;iA\u0015D\bO]3tg&|gNL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011J\u0001\u0002f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt$-\r\u001f0Ezb$M\u001023y=\u0012g\b\u00102?ENbtF\u0019 =Gz\u001a\u0017\u0007P\u0018d}q\u001agh\u0019\u001a=_\rtDhL1?O1:\u0013m\f20i\u0016DH\u000fK\u0015(SmR\u0001\u0005\t\u0011!A\u0001\u00023L\t22E1\u0012#M\r\u0012-E\t\u001c$%\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?EFbtF\u0019 =Ez\u0012'\u0007P\u0018c}q\u0012gHY\u001a=_\ttDh\u0019 dcqz3M\u0010\u001fd}\r\u0014DhL2?y=\ngh\n\u0017(C>\u0012w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7:,H\u000e\u001c\u0017ok2dGF\\;mYvS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001f\nQA\r\u00181]A\nQa\u001a:pkB\f#!!\u0016\u0002\u0013alGn\u00184v]\u000e\u001c\u0018!\u0003-QCRDG*[:u!\taCc\u0005\u0003\u0015\u0003;*\u0004cBA0\u0003KJ\u0014HQ\u0007\u0003\u0003CR1!a\u00192\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u001a\u0002b\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005e\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003i\fQ!\u00199qYf$RAQA:\u0003kBQ\u0001H\fA\u0002eBQAP\fA\u0002e\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\u0005\u001d\u0005#\u0002\u0019\u0002~\u0005\u0005\u0015bAA@c\t1q\n\u001d;j_:\u0004R\u0001MABseJ1!!\"2\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0012\r\u0002\u0002\u0003\u0007!)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0012\t\u0004w\u0006E\u0015bAAJy\n1qJ\u00196fGR\u0004")
public class XPathList
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathList xPathList) {
        return XPathList$.MODULE$.unapply(xPathList);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathList> tupled() {
        return XPathList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathList>> curried() {
        return XPathList$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath";
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        NodeList nodeList = this.xpathUtil().evalNodeList(((UTF8String)xml).toString(), this.pathString());
        if (nodeList != null) {
            UTF8String[] ret = new UTF8String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ret[i] = UTF8String.fromString((String)nodeList.item(i).getNodeValue());
            }
            return new GenericArrayData((Object)ret);
        }
        return null;
    }

    @Override
    public XPathList withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathList copy(Expression xml, Expression path) {
        return new XPathList(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathList";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.xml();
            }
            case 1: {
                return this.path();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathList)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathList xPathList = (XPathList)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathList.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathList.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathList.canEqual(this)) return false;
        return true;
    }

    public XPathList(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

