/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllUnionAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, allowDifferentLgConfigK) - Returns the estimated number of unique values.\n      `allowDifferentLgConfigK` (optional) Allow sketches with different lgConfigK values\n       to be unioned (defaults to false).", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(sketch, true)) FROM (SELECT hll_sketch_agg(col) as sketch FROM VALUES (1) tab(col) UNION ALL SELECT hll_sketch_agg(col, 20) as sketch FROM VALUES (1) tab(col));\n       1\n  ", group="agg_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0001\t-f\u0001\u0002\u001b6\u0001\u0012C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005;\"AQ\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003^\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u0011U\u0004!Q3A\u0005\u0002AD\u0001B\u001e\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\t}\u0002A)\u0019!C\u0001\u007f\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!1q\u000f\u0001C\u0001\u0003'Aaa\u001e\u0001\u0005\u0002\u0005e\u0001BB<\u0001\t\u0003\ty\u0002C\u0004\u0002&\u0001!\t%a\n\t\u000f\u00055\u0002\u0001\"\u0011\u00020!9\u0011Q\u0007\u0001\u0005R\u0005]\u0002bBA!\u0001\u0011\u0005\u00131\t\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\ti\b\u0001C!\u0003\u007fBa!a\"\u0001\t\u0003z\bbBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\tY\n\u0001C!\u0003;Cq!a,\u0001\t\u0003\n\t\fC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9\u0011q\u001b\u0001\u0005B\u0005e\u0007\"CAp\u0001\u0005\u0005I\u0011AAq\u0011%\tY\u000fAI\u0001\n\u0003\ti\u000fC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0001\u0002n\"I!Q\u0001\u0001\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005\u0017\u0001\u0011\u0013!C\u0001\u0005\u000fA\u0011B!\u0004\u0001\u0003\u0003%\tEa\u0004\t\u0011\t}\u0001!!A\u0005\u0002AD\u0011B!\t\u0001\u0003\u0003%\tAa\t\t\u0013\t%\u0002!!A\u0005B\t-\u0002\"\u0003B\u001d\u0001\u0005\u0005I\u0011\u0001B\u001e\u0011%\u0011y\u0004AA\u0001\n\u0003\u0012\teB\u0005\u0003fU\n\t\u0011#\u0001\u0003h\u0019AA'NA\u0001\u0012\u0003\u0011I\u0007\u0003\u0004xU\u0011\u0005!q\u000f\u0005\n\u0005sR\u0013\u0011!C#\u0005wB\u0011B! +\u0003\u0003%\tIa \t\u0013\t%%&%A\u0005\u0002\t\u001d\u0001\"\u0003BFUE\u0005I\u0011\u0001B\u0004\u0011%\u0011iIKA\u0001\n\u0003\u0013y\tC\u0005\u0003\u001e*\n\n\u0011\"\u0001\u0003\b!I!q\u0014\u0016\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005CS\u0013\u0011!C\u0005\u0005G\u00131\u0002\u00137m+:LwN\\!hO*\u0011agN\u0001\nC\u001e<'/Z4bi\u0016T!\u0001O\u001d\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003um\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003yu\n1a]9m\u0015\tqt(A\u0003ta\u0006\u00148N\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0015;\u0016\rZ4\u0011\u0007\u0019;\u0015*D\u00016\u0013\tAUG\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042AS'P\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB(qi&|g\u000e\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006\u0019\u0001\u000e\u001c7\u000b\u0005Q{\u0014\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018B\u0001,R\u0005\u0015)f.[8o!\rA6,X\u0007\u00023*\u0011!,O\u0001\u0006iJ,Wm]\u0005\u00039f\u0013!BQ5oCJLH*[6f!\tqv,D\u00018\u0013\t\u0001wG\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\u00182\n\u0005\r<$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011!*Z\u0005\u0003M.\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002KQ&\u0011\u0011n\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001^\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001r!\tQ%/\u0003\u0002t\u0017\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)\u0015I(p\u001f?~!\t1\u0005\u0001C\u0003k\u0013\u0001\u0007Q\fC\u0003n\u0013\u0001\u0007Q\fC\u0004p\u0013A\u0005\t\u0019A9\t\u000fUL\u0001\u0013!a\u0001c\u00069\u0012\r\u001c7po\u0012KgMZ3sK:$HjZ\"p]\u001aLwmS\u000b\u0003\u0003\u0003\u00012ASA\u0002\u0013\r\t)a\u0013\u0002\b\u0005>|G.Z1o\u0003)!\u0018M]4fiRK\b/Z\u000b\u0003\u0003\u0017\u00012\u0001UA\u0007\u0013\r\ty!\u0015\u0002\u000b)\u001e$\b\n\u001c7UsB,\u0017a\u0003;be\u001e,G\u000fV=qK\u0002\"2!_A\u000b\u0011\u0019\t9\"\u0004a\u0001;\u0006)1\r[5mIR)\u00110a\u0007\u0002\u001e!1\u0011q\u0003\bA\u0002uCQA \bA\u0002u#R!_A\u0011\u0003GAa!a\u0006\u0010\u0001\u0004i\u0006B\u0002@\u0010\u0001\u0004\t\t!A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\rI\u0018\u0011\u0006\u0005\u0007\u0003W\u0001\u0002\u0019A9\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\u0007e\f\t\u0004\u0003\u0004\u00024E\u0001\r!]\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000be\fI$!\u0010\t\r\u0005m\"\u00031\u0001^\u0003\u001dqWm\u001e'fMRDa!a\u0010\u0013\u0001\u0004i\u0016\u0001\u00038foJKw\r\u001b;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002FA!\u0011qIA+\u001d\u0011\tI%!\u0015\u0011\u0007\u0005-3*\u0004\u0002\u0002N)\u0019\u0011qJ\"\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019fS\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0013\u0011\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005M3*\u0001\u0006j]B,H\u000fV=qKN,\"!a\u0018\u0011\r\u0005\u0005\u00141NA9\u001d\u0011\t\u0019'a\u001a\u000f\t\u0005-\u0013QM\u0005\u0002\u0019&\u0019\u0011\u0011N&\u0002\u000fA\f7m[1hK&!\u0011QNA8\u0005\r\u0019V-\u001d\u0006\u0004\u0003SZ\u0005\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]4(A\u0003usB,7/\u0003\u0003\u0002|\u0005U$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAAA!\u0011\t\u0019(a!\n\t\u0005\u0015\u0015Q\u000f\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\t\u0011*\u0001\td_6\u0004\u0018M]3MO\u000e{gNZ5h\u0017R1\u0011\u0011SAL\u00033\u00032ASAJ\u0013\r\t)j\u0013\u0002\u0005+:LG\u000fC\u0003k1\u0001\u0007\u0011\u000fC\u0003n1\u0001\u0007\u0011/\u0001\u0004va\u0012\fG/\u001a\u000b\u0006\u0013\u0006}\u00151\u0015\u0005\u0007\u0003CK\u0002\u0019A%\u0002\u0017Ut\u0017n\u001c8PaRLwN\u001c\u0005\b\u0003KK\u0002\u0019AAT\u0003\u0015Ig\u000e];u!\u0011\tI+a+\u000e\u0003eJ1!!,:\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b5,'oZ3\u0015\u000b%\u000b\u0019,!.\t\r\u0005\u0005&\u00041\u0001J\u0011\u0019\t9L\u0007a\u0001\u0013\u0006Y\u0011N\u001c9vi>\u0003H/[8o\u0003\u0011)g/\u00197\u0015\t\u0005u\u00161\u0019\t\u0004\u0015\u0006}\u0016bAAa\u0017\n\u0019\u0011I\\=\t\r\u0005\u00056\u00041\u0001J\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002J\u0006U\u0007#\u0002&\u0002L\u0006=\u0017bAAg\u0017\n)\u0011I\u001d:bsB\u0019!*!5\n\u0007\u0005M7J\u0001\u0003CsR,\u0007BBAQ9\u0001\u0007\u0011*A\u0006eKN,'/[1mSj,GcA%\u0002\\\"9\u0011Q\\\u000fA\u0002\u0005%\u0017A\u00022vM\u001a,'/\u0001\u0003d_BLH#C=\u0002d\u0006\u0015\u0018q]Au\u0011\u001dQg\u0004%AA\u0002uCq!\u001c\u0010\u0011\u0002\u0003\u0007Q\fC\u0004p=A\u0005\t\u0019A9\t\u000fUt\u0002\u0013!a\u0001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAxU\ri\u0016\u0011_\u0016\u0003\u0003g\u0004B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0005v]\u000eDWmY6fI*\u0019\u0011Q`&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0002\u0005](!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0013Q3!]Ay\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\t!\u0011\u0011\u0019B!\b\u000e\u0005\tU!\u0002\u0002B\f\u00053\tA\u0001\\1oO*\u0011!1D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002X\tU\u0011\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\u0013)\u0003\u0003\u0005\u0003(\u0015\n\t\u00111\u0001r\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0006\t\u0007\u0005_\u0011)$!0\u000e\u0005\tE\"b\u0001B\u001a\u0017\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t]\"\u0011\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0002\tu\u0002\"\u0003B\u0014O\u0005\u0005\t\u0019AA_\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0001B\"\u0011%\u00119\u0003KA\u0001\u0002\u0004\ti\fK\n\u0001\u0005\u000f\u0012iEa\u0014\u0003T\tU#\u0011\fB.\u0005?\u0012\t\u0007E\u0002_\u0005\u0013J1Aa\u00138\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\u0015\u0002\u0003\u007fS\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011bY2|w\u000fR5gM\u0016\u0014XM\u001c;MO\u000e{gNZ5h\u0017&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Sm\u001d;j[\u0006$X\r\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002*h.[9vK\u00022\u0018\r\\;fg:R\u0001\u0005\t\u0011!A\u0001\u0002\u0017\r\u001c7po\u0012KgMZ3sK:$HjZ\"p]\u001aLwm\u00131!Q=\u0004H/[8oC2L\u0003%\u00117m_^\u00043o[3uG\",7\u000fI<ji\"\u0004C-\u001b4gKJ,g\u000e\u001e\u0011mO\u000e{gNZ5h\u0017\u00022\u0018\r\\;fg*\u0001\u0003\u0005\t\u0011!A\u0001\"x\u000e\t2fAUt\u0017n\u001c8fI\u0002BC-\u001a4bk2$8\u000f\t;pA\u0019\fGn]3*]\u0005AQ\r_1na2,7/\t\u0002\u0003X\u0005\tYM\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iY2|6o[3uG\"|Vm\u001d;j[\u0006$X\rK0G+:\u001bu\fK:lKR\u001c\u0007\u000e\f\u0011ueV,\u0017&\u000b\u0011G%>k\u0005\u0005K*F\u0019\u0016\u001bE\u000b\t5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2L\u0003%Y:!g.,Go\u00195!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152S\u0001\"\u0018M\u0019\u0015d_2L\u0003%\u0016(J\u001f:\u0003\u0013\t\u0014'!'\u0016cUi\u0011+!Q2dwl]6fi\u000eDw,Y4hQ\r|G\u000e\f\u00113a%\u0002\u0013m\u001d\u0011tW\u0016$8\r\u001b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*AQ\f'\rK2pY&J3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\nQa\u001a:pkB\f#A!\u0018\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B2\u0003\u0015\u0019d&\u000e\u00181\u0003-AE\u000e\\+oS>t\u0017iZ4\u0011\u0005\u0019S3\u0003\u0002\u0016\u0003l\u001d\u0004\u0012B!\u001c\u0003tuk\u0016/]=\u000e\u0005\t=$b\u0001B9\u0017\u00069!/\u001e8uS6,\u0017\u0002\u0002B;\u0005_\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\u00119'\u0001\u0005u_N#(/\u001b8h)\t\u0011\t\"A\u0003baBd\u0017\u0010F\u0005z\u0005\u0003\u0013\u0019I!\"\u0003\b\")!.\fa\u0001;\")Q.\fa\u0001;\"9q.\fI\u0001\u0002\u0004\t\bbB;.!\u0003\u0005\r!]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE%\u0011\u0014\t\u0005\u00156\u0013\u0019\nE\u0004K\u0005+kV,]9\n\u0007\t]5J\u0001\u0004UkBdW\r\u000e\u0005\t\u00057\u0003\u0014\u0011!a\u0001s\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\u000b\u0005\u0003\u0003\u0014\t\u001d\u0016\u0002\u0002BU\u0005+\u0011aa\u00142kK\u000e$\b")
public class HllUnionAgg
extends TypedImperativeAggregate<Option<Union>>
implements BinaryLike<Expression>,
ExpectsInputTypes,
scala.Serializable {
    private boolean allowDifferentLgConfigK;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final TgtHllType targetType;
    private transient Seq<Expression> children;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$4() {
        return HllUnionAgg$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HllUnionAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HllUnionAgg hllUnionAgg) {
        return HllUnionAgg$.MODULE$.unapply(hllUnionAgg);
    }

    public static int apply$default$4() {
        return HllUnionAgg$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HllUnionAgg$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HllUnionAgg> tupled() {
        return HllUnionAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HllUnionAgg>>>> curried() {
        return HllUnionAgg$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HllUnionAgg hllUnionAgg = this;
        synchronized (hllUnionAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private boolean allowDifferentLgConfigK$lzycompute() {
        HllUnionAgg hllUnionAgg = this;
        synchronized (hllUnionAgg) {
            if (!this.bitmap$0) {
                this.allowDifferentLgConfigK = BoxesRunTime.unboxToBoolean((Object)this.right().eval(this.right().eval$default$1()));
                this.bitmap$0 = true;
            }
        }
        return this.allowDifferentLgConfigK;
    }

    public boolean allowDifferentLgConfigK() {
        if (!this.bitmap$0) {
            return this.allowDifferentLgConfigK$lzycompute();
        }
        return this.allowDifferentLgConfigK;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllUnionAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HllUnionAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public HllUnionAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "hll_union_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Option<Union> createAggregationBuffer() {
        return None$.MODULE$;
    }

    public void compareLgConfigK(int left, int right) {
        if (!this.allowDifferentLgConfigK() && left != right) {
            throw QueryExecutionErrors$.MODULE$.hllUnionDifferentLgK(left, right, this.prettyName());
        }
    }

    @Override
    public Option<Union> update(Option<Union> unionOption, InternalRow input) {
        Object v = this.left().eval(input);
        if (v != null) {
            DataType dataType = this.left().dataType();
            if (BinaryType$.MODULE$.equals(dataType)) {
                Some some;
                try {
                    HllSketch sketch = HllSketch.wrap((Memory)Memory.wrap((byte[])((byte[])v)));
                    Union union = (Union)unionOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Union(sketch.getLgConfigK()));
                    this.compareLgConfigK(union.getLgConfigK(), sketch.getLgConfigK());
                    union.update(sketch);
                    some = new Some((Object)union);
                }
                catch (Error error) {
                    throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
                }
                return some;
            }
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        return unionOption;
    }

    @Override
    public Option<Union> merge(Option<Union> unionOption, Option<Union> inputOption) {
        Tuple2 tuple2 = new Tuple2(unionOption, inputOption);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Union union = (Union)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Union input = (Union)some2.value();
                    this.compareLgConfigK(union.getLgConfigK(), input.getLgConfigK());
                    union.update(input.getResult(this.targetType()));
                    return new Some((Object)union);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some && None$.MODULE$.equals(option3)) {
                return unionOption;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                return inputOption;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                return unionOption;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Object eval(Option<Union> unionOption) {
        Option<Union> option = unionOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Union union = (Union)some.value();
            return union.toUpdatableByteArray();
        }
        if (None$.MODULE$.equals(option)) {
            return new Union().toUpdatableByteArray();
        }
        throw new MatchError(option);
    }

    @Override
    public byte[] serialize(Option<Union> unionOption) {
        Option<Union> option = unionOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Union union = (Union)some.value();
            return union.toUpdatableByteArray();
        }
        if (None$.MODULE$.equals(option)) {
            return new byte[0];
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Union> deserialize(byte[] buffer) {
        if (buffer.length != 0) {
            return new Some((Object)Union.heapify((byte[])buffer));
        }
        return None$.MODULE$;
    }

    public HllUnionAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HllUnionAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HllUnionAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllUnionAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllUnionAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllUnionAgg hllUnionAgg = (HllUnionAgg)x$1;
        Expression expression = this.left();
        Expression expression2 = hllUnionAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = hllUnionAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != hllUnionAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hllUnionAgg.inputAggBufferOffset()) return false;
        if (!hllUnionAgg.canEqual(this)) return false;
        return true;
    }

    public HllUnionAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllUnionAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)false)), 0, 0);
    }

    public HllUnionAgg(Expression child, Expression allowDifferentLgConfigK) {
        this(child, allowDifferentLgConfigK, 0, 0);
    }

    public HllUnionAgg(Expression child, boolean allowDifferentLgConfigK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)allowDifferentLgConfigK)), 0, 0);
    }
}

