/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.types.PhysicalNumericType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate `percentile` of the numeric or\n      ansi interval column `col` which is the smallest value in the ordered `col` values (sorted\n      from least to greatest) such that no more than `percentage` of `col` values is less than\n      the value or equal to that value. The value of percentage must be between 0.0 and 1.0.\n      The `accuracy` parameter (default: 10000) is a positive numeric literal which controls\n      approximation accuracy at the cost of memory. Higher value of `accuracy` yields better\n      accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(col, array(0.5, 0.4, 0.1), 100) FROM VALUES (0), (1), (2), (10) AS tab(col);\n       [1,1,0]\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (0), (6), (7), (9), (10) AS tab(col);\n       7\n      > SELECT _FUNC_(col, 0.5, 100) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '1' MONTH), (INTERVAL '2' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-1\n      > SELECT _FUNC_(col, array(0.5, 0.7), 100) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '1' SECOND), (INTERVAL '2' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:01.000000000,0 00:00:02.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\rUd\u0001\u0002'N\u0001rC!\"!0\u0001\u0005+\u0007I\u0011\u0001B\f\u0011)\u0011I\u0002\u0001B\tB\u0003%\u0011q\u0018\u0005\u000b\u0003\u0013\u0004!Q3A\u0005\u0002\t]\u0001B\u0003B\u000e\u0001\tE\t\u0015!\u0003\u0002@\"Q\u0011Q\u001a\u0001\u0003\u0016\u0004%\tAa\u0006\t\u0015\tu\u0001A!E!\u0002\u0013\ty\f\u0003\u0006\u0002R\u0002\u0011)\u001a!C!\u0003\u000fA!Ba\b\u0001\u0005#\u0005\u000b\u0011BA\u0005\u0011)\t)\u000e\u0001BK\u0002\u0013\u0005\u0013q\u0001\u0005\u000b\u0005C\u0001!\u0011#Q\u0001\n\u0005%\u0001bBA\u0001\u0001\u0011\u0005!1\u0005\u0005\b\u0003\u0003\u0001A\u0011\u0001B\u0018\u0011\u001d\t\t\u0001\u0001C\u0001\u0005oA!B!\u0010\u0001\u0011\u000b\u0007I\u0011\u0002B \u0011)\u00119\u0005\u0001EC\u0002\u0013%!\u0011\n\u0005\b\u0005#\u0002A\u0011\tB*\u00111\t\t\u0004\u0001I\u0001\u0012\u000f\u0007K\u0011\u0002B2\u0011)\u0011Y\u0007\u0001EC\u0002\u0013%\u00111\n\u0005\u000b\u0003{\u0002\u0001R1A\u0005\n\t5\u0004b\u0002B8\u0001\u0011\u0005#\u0011\u000f\u0005\b\u0005\u007f\u0002A\u0011\tBA\u0011\u001d\u0011\u0019\t\u0001C!\u0005\u000bCq!!\u0018\u0001\t\u0003\u00129\nC\u0004\u0003\u001e\u0002!\tEa(\t\u000f\t%\u0006\u0001\"\u0011\u0003,\"9!\u0011\u0017\u0001\u0005B\tM\u0006b\u0002B\\\u0001\u0011\u0005#q\u0003\u0005\b\u0005s\u0003A\u0011\tB\f\u0011\u001d\u0011Y\f\u0001C!\u0005/AqA!0\u0001\t\u0003\nY\u0005\u0003\u0006\u0003@\u0002A)\u0019!C\u0005\u0005\u0003DqA!3\u0001\t\u0003\u0012\t\rC\u0004\u0003L\u0002!\tE!4\t\u000f\u0005]\u0005\u0001\"\u0011\u0003`\"9\u0011q\u0015\u0001\u0005B\t\r\bb\u0002Bt\u0001\u0011E#\u0011\u001e\u0005\n\u0005o\u0004\u0011\u0011!C\u0001\u0005sD\u0011b!\u0002\u0001#\u0003%\taa\u0002\t\u0013\ru\u0001!%A\u0005\u0002\r\u001d\u0001\"CB\u0010\u0001E\u0005I\u0011AB\u0004\u0011%\u0019\t\u0003AI\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004(\u0001\t\n\u0011\"\u0001\u0004$!I1\u0011\u0006\u0001\u0002\u0002\u0013\u000531\u0006\u0005\n\u0007c\u0001\u0011\u0011!C\u0001\u0003\u000fA\u0011ba\r\u0001\u0003\u0003%\ta!\u000e\t\u0013\re\u0002!!A\u0005B\rm\u0002\"CB%\u0001\u0005\u0005I\u0011AB&\u0011%\u0019y\u0005AA\u0001\n\u0003\u001a\tfB\u0003u\u001b\"\u0005QOB\u0003M\u001b\"\u0005a\u000fC\u0004\u0002\u0002I\"\t!a\u0001\t\u0013\u0005\u0015!G1A\u0005\u0002\u0005\u001d\u0001\u0002CA\be\u0001\u0006I!!\u0003\u0007\r\u0005E!\u0007AA\n\u0011)\t)B\u000eBA\u0002\u0013%\u0011q\u0003\u0005\u000b\u0003K1$\u00111A\u0005\n\u0005\u001d\u0002BCA\u001am\t\u0005\t\u0015)\u0003\u0002\u001a!9\u0011\u0011\u0001\u001c\u0005\u0002\u0005U\u0002bBA\u0001m\u0011\u0005\u0011Q\b\u0005\t\u0003\u00132D\u0011A*\u0002L!9\u00111\u000b\u001c\u0005\u0002\u0005]\u0001bBA+m\u0011\u0005\u0011q\u000b\u0005\b\u0003;2D\u0011AA0\u0011\u001d\t)G\u000eC\u0001\u0003OBq!!\"7\t\u001b\t9I\u0002\u0004\u0002\nJ\u0002\u00111\u0012\u0005\b\u0003\u0003\u0011E\u0011AAG\u0011\u001d\t\tJ\u0011C\u0007\u0003'Cq!a&C\t\u000b\tI\nC\u0004\u0002(\n#)!!+\t\u0013\u0005=&G1A\u0005\u0002\u0005E\u0006\u0002CAZe\u0001\u0006I!a$\t\u0013\u0005U&'!A\u0005\u0002\u0006]\u0006\"CAle\u0005\u0005I\u0011QAm\u0011%\tYOMA\u0001\n\u0013\tiOA\u000bBaB\u0014x\u000e_5nCR,\u0007+\u001a:dK:$\u0018\u000e\\3\u000b\u00059{\u0015!C1hOJ,w-\u0019;f\u0015\t\u0001\u0016+A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001*T\u0003!\u0019\u0017\r^1msN$(B\u0001+V\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-^\u000bQa\u001d9be.T!\u0001W-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0016aA8sO\u000e\u00011#\u0003\u0001^\u0003\u007f\u0014)A!\u0005~!\rqv,Y\u0007\u0002\u001b&\u0011\u0001-\u0014\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007C\u000127\u001d\t\u0019\u0017G\u0004\u0002eg:\u0011QM\u001d\b\u0003MFt!a\u001a9\u000f\u0005!|gBA5o\u001d\tQW.D\u0001l\u0015\ta7,\u0001\u0004=e>|GOP\u0005\u00025&\u0011\u0001,W\u0005\u0003-^K!\u0001V+\n\u0005I\u001b\u0016B\u0001)R\u0013\tqu*A\u000bBaB\u0014x\u000e_5nCR,\u0007+\u001a:dK:$\u0018\u000e\\3\u0011\u0005y\u00134c\u0001\u001ax{B\u0011\u0001p_\u0007\u0002s*\t!0A\u0003tG\u0006d\u0017-\u0003\u0002}s\n1\u0011I\\=SK\u001a\u0004\"\u0001\u001f@\n\u0005}L(\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001v\u0003m!UIR!V\u0019R{\u0006+\u0012*D\u000b:#\u0016\nT#`\u0003\u000e\u001bUKU!D3V\u0011\u0011\u0011\u0002\t\u0004q\u0006-\u0011bAA\u0007s\n\u0019\u0011J\u001c;\u00029\u0011+e)Q+M)~\u0003VIU\"F\u001dRKE*R0B\u0007\u000e+&+Q\"ZA\t\u0001\u0002+\u001a:dK:$\u0018\u000e\\3ES\u001e,7\u000f^\n\u0003m]\f\u0011b];n[\u0006\u0014\u0018.Z:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011+\u0001\u0003vi&d\u0017\u0002BA\u0012\u0003;\u0011\u0011#U;b]RLG.Z*v[6\f'/[3t\u00035\u0019X/\\7be&,7o\u0018\u0013fcR!\u0011\u0011FA\u0018!\rA\u00181F\u0005\u0004\u0003[I(\u0001B+oSRD\u0011\"!\r9\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'\u0001\u0006tk6l\u0017M]5fg\u0002\"B!a\u000e\u0002<A\u0019\u0011\u0011\b\u001c\u000e\u0003IBq!!\u0006;\u0001\u0004\tI\u0002\u0006\u0003\u00028\u0005}\u0002bBA!w\u0001\u0007\u00111I\u0001\u000ee\u0016d\u0017\r^5wK\u0016\u0013(o\u001c:\u0011\u0007a\f)%C\u0002\u0002He\u0014a\u0001R8vE2,\u0017\u0001D5t\u0007>l\u0007O]3tg\u0016$WCAA'!\rA\u0018qJ\u0005\u0004\u0003#J(a\u0002\"p_2,\u0017M\\\u0001\u0012cV\fg\u000e^5mKN+X.\\1sS\u0016\u001c\u0018aA1eIR!\u0011\u0011FA-\u0011\u001d\tYF\u0010a\u0001\u0003\u0007\nQA^1mk\u0016\fQ!\\3sO\u0016$B!!\u000b\u0002b!9\u00111M A\u0002\u0005]\u0012!B8uQ\u0016\u0014\u0018AD4fiB+'oY3oi&dWm\u001d\u000b\u0005\u0003S\nY\b\u0005\u0004\u0002l\u0005U\u00141\t\b\u0005\u0003[\n\tHD\u0002k\u0003_J\u0011A_\u0005\u0004\u0003gJ\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003o\nIHA\u0002TKFT1!a\u001dz\u0011\u001d\ti\b\u0011a\u0001\u0003\u007f\n1\u0002]3sG\u0016tG/Y4fgB)\u00010!!\u0002D%\u0019\u00111Q=\u0003\u000b\u0005\u0013(/Y=\u0002\u0011\r|W\u000e\u001d:fgN$\"!!\u000b\u00035A+'oY3oi&dW\rR5hKN$8+\u001a:jC2L'0\u001a:\u0014\u0005\t;HCAAH!\r\tIDQ\u0001\u0007Y\u0016tw\r\u001e5\u0015\t\u0005%\u0011Q\u0013\u0005\b\u0003+!\u0005\u0019AA\r\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002\u001c\u0006\r\u0006#\u0002=\u0002\u0002\u0006u\u0005c\u0001=\u0002 &\u0019\u0011\u0011U=\u0003\t\tKH/\u001a\u0005\b\u0003K+\u0005\u0019AA\u001c\u0003\ry'M[\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0003\u00028\u0005-\u0006bBAW\r\u0002\u0007\u00111T\u0001\u0006Ef$Xm]\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAAH\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005e\u00161XAd\u0003\u0017\fy-a5\u0011\u0005y\u0003\u0001bBA_\u0013\u0002\u0007\u0011qX\u0001\u0006G\"LG\u000e\u001a\t\u0005\u0003\u0003\f\u0019-D\u0001P\u0013\r\t)m\u0014\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007bBAe\u0013\u0002\u0007\u0011qX\u0001\u0015a\u0016\u00148-\u001a8uC\u001e,W\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\u00055\u0017\n1\u0001\u0002@\u0006\u0011\u0012mY2ve\u0006\u001c\u00170\u0012=qe\u0016\u001c8/[8o\u0011\u001d\t\t.\u0013a\u0001\u0003\u0013\ta#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0005\b\u0003+L\u0005\u0019AA\u0005\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069QO\\1qa2LH\u0003BAn\u0003O\u0004R\u0001_Ao\u0003CL1!a8z\u0005\u0019y\u0005\u000f^5p]Bi\u00010a9\u0002@\u0006}\u0016qXA\u0005\u0003\u0013I1!!:z\u0005\u0019!V\u000f\u001d7fk!I\u0011\u0011\u001e&\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a<\u0011\t\u0005E\u00181`\u0007\u0003\u0003gTA!!>\u0002x\u0006!A.\u00198h\u0015\t\tI0\u0001\u0003kCZ\f\u0017\u0002BA\u007f\u0003g\u0014aa\u00142kK\u000e$\b\u0003BAa\u0005\u0003I1Aa\u0001P\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0002B\u0004\u0005\u001b\ty,\u0004\u0002\u0003\n)\u0019!1B)\u0002\u000bQ\u0014X-Z:\n\t\t=!\u0011\u0002\u0002\f)\u0016\u0014h.\u0019:z\u0019&\\W\rE\u0002y\u0005'I1A!\u0006z\u0005\u001d\u0001&o\u001c3vGR,\"!a0\u0002\r\rD\u0017\u000e\u001c3!\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002\n1#Y2dkJ\f7-_#yaJ,7o]5p]\u0002\nq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uAQa\u0011\u0011\u0018B\u0013\u0005O\u0011ICa\u000b\u0003.!9\u0011QX\u0006A\u0002\u0005}\u0006bBAe\u0017\u0001\u0007\u0011q\u0018\u0005\b\u0003\u001b\\\u0001\u0019AA`\u0011\u001d\t\tn\u0003a\u0001\u0003\u0013Aq!!6\f\u0001\u0004\tI\u0001\u0006\u0005\u0002:\nE\"1\u0007B\u001b\u0011\u001d\ti\f\u0004a\u0001\u0003\u007fCq!!3\r\u0001\u0004\ty\fC\u0004\u0002N2\u0001\r!a0\u0015\r\u0005e&\u0011\bB\u001e\u0011\u001d\ti,\u0004a\u0001\u0003\u007fCq!!3\u000e\u0001\u0004\ty,A\u0006bG\u000e,(/Y2z\u001dVlWC\u0001B!!\u0011\t\tPa\u0011\n\t\t\u0015\u00131\u001f\u0002\u0007\u001dVl'-\u001a:\u0002\u0011\u0005\u001c7-\u001e:bGf,\"Aa\u0013\u0011\u0007a\u0014i%C\u0002\u0003Pe\u0014A\u0001T8oO\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\tU\u0003CBA6\u0003k\u00129\u0006\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\r\u0011ifU\u0001\u0006if\u0004Xm]\u0005\u0005\u0005C\u0012YF\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKV\u0011!Q\r\t\bq\n\u001d\u0014QJA@\u0013\r\u0011I'\u001f\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,G/\u001e:o!\u0016\u00148-\u001a8uS2,\u0017I\u001d:bsV\u0011\u0011qP\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0005g\u0002BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0004\u0005s\n\u0016\u0001C1oC2L8/[:\n\t\tu$q\u000f\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002C\u00061Q\u000f\u001d3bi\u0016$R!\u0019BD\u0005\u0017CaA!#\u0017\u0001\u0004\t\u0017A\u00022vM\u001a,'\u000fC\u0004\u0003\u000eZ\u0001\rAa$\u0002\u0011%t\u0007/\u001e;S_^\u0004BA!%\u0003\u00146\t\u0011+C\u0002\u0003\u0016F\u00131\"\u00138uKJt\u0017\r\u001c*poR)\u0011M!'\u0003\u001c\"1!\u0011R\fA\u0002\u0005Da!a\u0019\u0018\u0001\u0004\t\u0017\u0001B3wC2$BA!)\u0003(B\u0019\u0001Pa)\n\u0007\t\u0015\u0016PA\u0002B]fDaA!#\u0019\u0001\u0004\t\u0017!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005e&Q\u0016\u0005\b\u0005_K\u0002\u0019AA\u0005\u0003%qWm^(gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003s\u0013)\fC\u0004\u00030j\u0001\r!!\u0003\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003!qW\u000f\u001c7bE2,\u0017\u0001E5oi\u0016\u0014h.\u00197ECR\fG+\u001f9f+\t\u0011\u0019\r\u0005\u0003\u0003Z\t\u0015\u0017\u0002\u0002Bd\u00057\u0012\u0001\u0002R1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\t=\u0007\u0003\u0002Bi\u00053tAAa5\u0003VB\u0011!._\u0005\u0004\u0005/L\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0003\\\nu'AB*ue&twMC\u0002\u0003Xf$B!a'\u0003b\"1\u0011Q\u0015\u0012A\u0002\u0005$2!\u0019Bs\u0011\u001d\tik\ta\u0001\u00037\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0011\u0005e&1\u001eBx\u0005gDqA!<%\u0001\u0004\ty,\u0001\u0005oK^4\u0015N]:u\u0011\u001d\u0011\t\u0010\na\u0001\u0003\u007f\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\u000f\tUH\u00051\u0001\u0002@\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLH\u0003DA]\u0005w\u0014iPa@\u0004\u0002\r\r\u0001\"CA_KA\u0005\t\u0019AA`\u0011%\tI-\nI\u0001\u0002\u0004\ty\fC\u0005\u0002N\u0016\u0002\n\u00111\u0001\u0002@\"I\u0011\u0011[\u0013\u0011\u0002\u0003\u0007\u0011\u0011\u0002\u0005\n\u0003+,\u0003\u0013!a\u0001\u0003\u0013\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\n)\"\u0011qXB\u0006W\t\u0019i\u0001\u0005\u0003\u0004\u0010\reQBAB\t\u0015\u0011\u0019\u0019b!\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAB\fs\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rm1\u0011\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"a!\n+\t\u0005%11B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u00111Q\u0006\t\u0005\u0003c\u001cy#\u0003\u0003\u0003\\\u0006M\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005C\u001b9\u0004C\u0005\u000225\n\t\u00111\u0001\u0002\n\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004>A11qHB#\u0005Ck!a!\u0011\u000b\u0007\r\r\u00130\u0001\u0006d_2dWm\u0019;j_:LAaa\u0012\u0004B\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tie!\u0014\t\u0013\u0005Er&!AA\u0002\t\u0005\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002N\rM\u0003\"CA\u0019a\u0005\u0005\t\u0019\u0001BQQM\u00011qKB/\u0007?\u001a\u0019g!\u001a\u0004j\r-4qNB9!\u0011\t\tm!\u0017\n\u0007\rmsJA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\r\u0005\u0014A\"0\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fY8mY\u0001\u0002XM]2f]R\fw-\u001a\u0011\\Y\u0001\n7mY;sC\u000eLX,\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCR,\u0007\u0005\u00199fe\u000e,g\u000e^5mK\u0002\u0004sN\u001a\u0011uQ\u0016\u0004c.^7fe&\u001c\u0007e\u001c:\u000bA\u0001\u0002\u0003\u0005\t\u0011b]NL\u0007%\u001b8uKJ4\u0018\r\u001c\u0011d_2,XN\u001c\u0011aG>d\u0007\rI<iS\u000eD\u0007%[:!i\",\u0007e]7bY2,7\u000f\u001e\u0011wC2,X\rI5oAQDW\rI8sI\u0016\u0014X\r\u001a\u0011aG>d\u0007\r\t<bYV,7\u000f\t\u0015t_J$X\r\u001a\u0006!A\u0001\u0002\u0003\u0005\t4s_6\u0004C.Z1ti\u0002\"x\u000eI4sK\u0006$Xm\u001d;*AM,8\r\u001b\u0011uQ\u0006$\bE\\8![>\u0014X\r\t;iC:\u0004\u0003\r]3sG\u0016tG/Y4fA\u0002zg\r\t1d_2\u0004\u0007E^1mk\u0016\u001c\b%[:!Y\u0016\u001c8\u000f\t;iC:T\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011wC2,X\rI8sA\u0015\fX/\u00197!i>\u0004C\u000f[1uAY\fG.^3/AQCW\r\t<bYV,\u0007e\u001c4!a\u0016\u00148-\u001a8uC\u001e,\u0007%\\;ti\u0002\u0012W\r\t2fi^,WM\u001c\u00111]A\u0002\u0013M\u001c3!c9\u0002dF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0001\f7mY;sC\u000eL\b\r\t9be\u0006lW\r^3sA!\"WMZ1vYRT\u0004%\r\u00191aAJ\u0003%[:!C\u0002\u0002xn]5uSZ,\u0007E\\;nKJL7\r\t7ji\u0016\u0014\u0018\r\u001c\u0011xQ&\u001c\u0007\u000eI2p]R\u0014x\u000e\\:\u000bA\u0001\u0002\u0003\u0005\t\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0011bG\u000e,(/Y2zA\u0005$\b\u0005\u001e5fA\r|7\u000f\u001e\u0011pM\u0002jW-\\8ss:\u0002\u0003*[4iKJ\u0004c/\u00197vK\u0002zg\r\t1bG\u000e,(/Y2zA\u0002J\u0018.\u001a7eg\u0002\u0012W\r\u001e;fe*\u0001\u0003\u0005\t\u0011!A\u0005\u001c7-\u001e:bGfd\u0003\u0005Y\u0019/a=\n7mY;sC\u000eL\b\rI5tAQDW\r\t:fY\u0006$\u0018N^3!KJ\u0014xN\u001d\u0011pM\u0002\"\b.\u001a\u0011baB\u0014x\u000e_5nCRLwN\u001c\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007\u0005\u00199fe\u000e,g\u000e^1hK\u0002\u0004\u0013n\u001d\u0011b]\u0002\n'O]1zY\u0001*\u0017m\u00195!m\u0006dW/\u001a\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9R\u0001\u0005\t\u0011!A\u0001Je\u000e\t;iSN\u00043-Y:fY\u0001\u0012X\r^;s]N\u0004C\u000f[3!CB\u0004(o\u001c=j[\u0006$X\r\t9fe\u000e,g\u000e^5mK\u0002\n'O]1zA=4\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]*\u0001\u0003\u0005\t\u0011!AA,'oY3oi\u0006<W\rI1se\u0006LhF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAB4\u0003\u0011m&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9\"D\u0006\t\u0019/c%b\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003FM\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I.2YEb\u0003'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t\u0019/k1\u0002\u0013\u0007\r\u0019*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u001c*Y\u0001Bs'\u000b\u0017!QeJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001b-AE\u0002\u0004'\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K%O)\u0016\u0013f+\u0011'!OA:\u0003%T(O)\"KC\u0006\t\u0015J\u001dR+%KV!MA\u001d\nt\u0005I'P\u001dRC\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011N\u001f:#\u0006*\u000b\u0017!Q%sE+\u0012*W\u00032\u0003s%\r\u0019(A5{e\n\u0016%*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a5\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002d&\u000e\u0017!a9:\u0014\u0006\f\u00112aAJ\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\u001aViQ(O\t&b\u0003\u0005K%O)\u0016\u0013f+\u0011'!OE:\u0003eU#D\u001f:#\u0015\u0006\f\u0011)\u0013:#VI\u0015,B\u0019\u0002:#g\n\u0011T\u000b\u000e{e\nR\u0015-A!Je\nV#S-\u0006c\u0005eJ\u00191O\u0001\u001aViQ(O\t&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0006\u0007\t\u00191uA\u0002$\bM\u0019/aA\u0002\u0004\u0007\r\u00191aAb\u0003\u0007\t\u00191uA\u0002$\b\r\u001a/aA\u0002\u0004\u0007\r\u00191aAj&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\r5\u0014!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0019\u0019(A\u00033]Er\u0003\u0007")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
scala.Serializable {
    private Number accuracyNum;
    private long accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private DataType internalDataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private Number accuracyNum$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracyNum = (Number)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accuracyNum;
    }

    private Number accuracyNum() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.accuracyNum$lzycompute();
        }
        return this.accuracyNum;
    }

    private long accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.accuracy = this.accuracyNum().longValue();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.accuracy;
    }

    private long accuracy() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.accuracy$lzycompute();
        }
        return this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, new ArrayType((DataType)DoubleType$.MODULE$, false)})), (List)new .colon.colon((Object)IntegralType$.MODULE$, (List)Nil$.MODULE$)));
    }

    private Tuple2<Object, double[]> x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), null);
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                } else {
                    throw new MatchError(object);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                boolean returnPercentileArray = tuple22._1$mcZ$sp();
                double[] percentages = (double[])tuple22._2();
                this.x$1 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)returnPercentileArray), (Object)percentages);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.x$1;
    }

    private /* synthetic */ Tuple2 x$1() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.x$1$lzycompute();
        }
        return this.x$1;
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.returnPercentileArray$lzycompute();
        }
        return this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.percentages$lzycompute();
        }
        return this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.percentageExpression().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.percentageExpression().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.percentageExpression()))}))));
        }
        if (!this.accuracyExpression().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"accuracy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.accuracyExpression().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.accuracyExpression()))}))));
        }
        if (this.accuracyNum() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"accuracy")}))));
        }
        if (this.accuracy() <= 0L || this.accuracy() > Integer.MAX_VALUE) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"accuracy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(5).append("(0, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToLong((long)this.accuracy()), (DataType)LongType$.MODULE$))}))));
        }
        if (this.percentages() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage")}))));
        }
        if (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0)) {
            return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"percentage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)"[0.0, 1.0]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).map((Function1 & Serializable & scala.Serializable)x$2 -> Cast$.MODULE$.toSQLValue(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x$2)), (DataType)DoubleType$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(","))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        block7: {
            double d;
            Object value = this.child().eval(inputRow);
            if (value == null) break block7;
            DataType dataType = this.child().dataType();
            if (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
                d = BoxesRunTime.unboxToInt((Object)value);
            } else if (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType)) {
                d = BoxesRunTime.unboxToLong((Object)value);
            } else if (dataType instanceof NumericType) {
                NumericType numericType = (NumericType)dataType;
                d = PhysicalNumericType$.MODULE$.numeric(numericType).toDouble(value);
            } else {
                if (dataType != null) {
                    DataType dataType2 = dataType;
                    throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
                }
                throw new MatchError((Object)dataType);
            }
            double doubleValue = d;
            buffer.add(doubleValue);
        }
        return buffer;
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        Seq seq;
        Seq doubleResult = buffer.getPercentiles(this.percentages());
        DataType dataType = this.child().dataType();
        if (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$3 -> (int)x$3, Seq$.MODULE$.canBuildFrom());
        } else if (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType)) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$4 -> (long)x$4, Seq$.MODULE$.canBuildFrom());
        } else if (ByteType$.MODULE$.equals(dataType)) {
            seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToByte((byte)ApproximatePercentile.$anonfun$eval$3(BoxesRunTime.unboxToDouble((Object)x$5))), Seq$.MODULE$.canBuildFrom());
        } else if (ShortType$.MODULE$.equals(dataType)) {
            seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToShort((short)ApproximatePercentile.$anonfun$eval$4(BoxesRunTime.unboxToDouble((Object)x$6))), Seq$.MODULE$.canBuildFrom());
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcID.sp & Serializable & scala.Serializable)x$7 -> (int)x$7, Seq$.MODULE$.canBuildFrom());
        } else if (LongType$.MODULE$.equals(dataType)) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)x$8 -> (long)x$8, Seq$.MODULE$.canBuildFrom());
        } else if (FloatType$.MODULE$.equals(dataType)) {
            seq = (Seq)doubleResult.map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$9 -> (float)x$9, Seq$.MODULE$.canBuildFrom());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            seq = doubleResult;
        } else if (dataType instanceof DecimalType) {
            seq = (Seq)doubleResult.map((Function1 & Serializable & scala.Serializable)x$10 -> Decimal$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)x$10)), Seq$.MODULE$.canBuildFrom());
        } else {
            if (dataType != null) {
                DataType dataType2 = dataType;
                throw QueryExecutionErrors$.MODULE$.dataTypeUnexpectedError(dataType2);
            }
            throw new MatchError((Object)dataType);
        }
        Seq result = seq;
        if (result.length() == 0) {
            return null;
        }
        if (this.returnPercentileArray()) {
            return new GenericArrayData((Seq<Object>)result);
        }
        return result.apply(0);
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$1 = newOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.accuracyExpression();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType internalDataType$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.internalDataType = this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.internalDataType$lzycompute();
        }
        return this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "percentile_approx");
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    @Override
    public ApproximatePercentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5());
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.percentageExpression();
            }
            case 2: {
                return this.accuracyExpression();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ byte $anonfun$eval$3(double x$5) {
        return (byte)x$5;
    }

    public static final /* synthetic */ short $anonfun$eval$4(double x$6) {
        return (short)x$6;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            block0: {
                if (this.isCompressed()) break block0;
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value) {
            this.summaries_$eq(this.summaries().insert(value));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        public Seq<Object> getPercentiles(double[] percentages) {
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                return Predef$.MODULE$.wrapDoubleArray(Array$.MODULE$.emptyDoubleArray());
            }
            return (Seq)this.summaries().query((Seq<Object>)Predef$.MODULE$.wrapDoubleArray(percentages)).get();
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$1 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$2 = relativeError;
            boolean x$3 = true;
            QuantileSummaries.Stats[] x$4 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$5 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$1, x$2, x$4, x$5, x$3));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

