/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeoutException;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.Partition;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkArithmeticException;
import org.apache.spark.SparkArrayIndexOutOfBoundsException;
import org.apache.spark.SparkClassNotFoundException;
import org.apache.spark.SparkConcurrentModificationException;
import org.apache.spark.SparkConcurrentModificationException$;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkFileAlreadyExistsException;
import org.apache.spark.SparkFileNotFoundException;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkIllegalArgumentException$;
import org.apache.spark.SparkNumberFormatException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.SparkSQLFeatureNotSupportedException;
import org.apache.spark.SparkSecurityException;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.analysis.UnresolvedGenerator;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.CircularBuffer;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.InternalCompilerException;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QueryExecutionErrors$
implements QueryErrorsBase {
    public static QueryExecutionErrors$ MODULE$;
    private final String aesFuncName;

    static {
        new QueryExecutionErrors$();
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    public Throwable cannotEvaluateExpressionError(Expression expression) {
        return SparkException$.MODULE$.internalError(new StringBuilder(28).append("Cannot evaluate expression: ").append(expression).toString());
    }

    public Throwable cannotGenerateCodeForExpressionError(Expression expression) {
        return SparkException$.MODULE$.internalError(new StringBuilder(37).append("Cannot generate code for expression: ").append(expression).toString());
    }

    public Throwable cannotTerminateGeneratorError(UnresolvedGenerator generator) {
        return SparkException$.MODULE$.internalError(new StringBuilder(29).append("Cannot terminate expression: ").append(generator).toString());
    }

    public ArithmeticException castingCauseOverflowError(Object t, DataType from, DataType to) {
        return new SparkArithmeticException("CAST_OVERFLOW", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLValue(t, from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public ArithmeticException castingCauseOverflowErrorInTableInsert(DataType from, DataType to, String columnName) {
        return new SparkArithmeticException("CAST_OVERFLOW_IN_TABLE_INSERT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)this.toSQLId(columnName))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public ArithmeticException cannotChangeDecimalPrecisionError(Decimal value, int decimalPrecision, int decimalScale, SQLQueryContext context) {
        return new SparkArithmeticException("NUMERIC_VALUE_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value.toPlainString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(decimalPrecision)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)Integer.toString(decimalScale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public SQLQueryContext cannotChangeDecimalPrecisionError$default$4() {
        return null;
    }

    public Throwable invalidInputInCastToDatetimeError(Object value, DataType from, DataType to, SQLQueryContext context) {
        return new SparkDateTimeException("CAST_INVALID_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLValue(value, from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(from)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public SparkRuntimeException invalidInputSyntaxForBooleanError(UTF8String s, SQLQueryContext context) {
        String x$1 = "CAST_INVALID_INPUT";
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLValue(s, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))}));
        QueryContext[] x$3 = this.getQueryContext(context);
        String x$4 = this.getSummary(context);
        Throwable x$5 = SparkRuntimeException$.MODULE$.$lessinit$greater$default$3();
        return new SparkRuntimeException(x$1, x$2, x$5, x$3, x$4);
    }

    public SparkNumberFormatException invalidInputInCastToNumberError(DataType to, UTF8String s, SQLQueryContext context) {
        return new SparkNumberFormatException("CAST_INVALID_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expression"), (Object)this.toSQLValue(s, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)this.toSQLType(StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public SparkIllegalArgumentException invalidInputInConversionError(DataType to, UTF8String s, UTF8String fmt, String hint) {
        return new SparkIllegalArgumentException("CONVERSION_INVALID_INPUT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"str"), (Object)this.toSQLValue(s, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fmt"), (Object)this.toSQLValue(fmt, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)this.toSQLType(to)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"suggestion"), (Object)this.toSQLId(hint))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotCastFromNullTypeError(DataType to) {
        return new SparkException("CANNOT_CAST_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)NullType$.MODULE$.typeName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)to.typeName())})), null);
    }

    public Throwable cannotCastError(DataType from, DataType to) {
        return new SparkException("CANNOT_CAST_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceType"), (Object)from.typeName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetType"), (Object)to.typeName())})), null);
    }

    public Throwable cannotParseDecimalError() {
        return new SparkRuntimeException("CANNOT_PARSE_DECIMAL", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable dataTypeUnsupportedError(String dataType, String failure) {
        return new SparkIllegalArgumentException("UNSUPPORTED_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)new StringBuilder(0).append(dataType).append(failure).toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failedExecuteUserDefinedFunctionError(String funcCls, String inputTypes, String outputType, Throwable e) {
        return new SparkException("FAILED_EXECUTE_UDF", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)funcCls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"signature"), (Object)inputTypes), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"result"), (Object)outputType)})), e);
    }

    public ArithmeticException divideByZeroError(SQLQueryContext context) {
        return new SparkArithmeticException("DIVIDE_BY_ZERO", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public ArithmeticException intervalDividedByZeroError(SQLQueryContext context) {
        return new SparkArithmeticException("INTERVAL_DIVIDED_BY_ZERO", Predef$.MODULE$.Map().empty(), this.getQueryContext(context), this.getSummary(context));
    }

    public ArrayIndexOutOfBoundsException invalidArrayIndexError(int index, int numElements, SQLQueryContext context) {
        return new SparkArrayIndexOutOfBoundsException("INVALID_ARRAY_INDEX", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexValue"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arraySize"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)numElements), IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public ArrayIndexOutOfBoundsException invalidElementAtIndexError(int index, int numElements, SQLQueryContext context) {
        return new SparkArrayIndexOutOfBoundsException("INVALID_ARRAY_INDEX_IN_ELEMENT_AT", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexValue"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arraySize"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)numElements), IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public DateTimeException invalidFractionOfSecondError() {
        return new SparkDateTimeException("INVALID_FRACTION_OF_SECOND", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkDateTimeException ansiDateTimeParseError(Exception e) {
        return new SparkDateTimeException("CANNOT_PARSE_TIMESTAMP", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkDateTimeException ansiDateTimeError(Exception e) {
        return new SparkDateTimeException("_LEGACY_ERROR_TEMP_2000", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkIllegalArgumentException ansiIllegalArgumentError(String message) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2000", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public IllegalArgumentException ansiIllegalArgumentError(IllegalArgumentException e) {
        return this.ansiIllegalArgumentError(e.getMessage());
    }

    public ArithmeticException overflowInSumOfDecimalError(SQLQueryContext context) {
        String x$1 = "Overflow in sum of decimals";
        SQLQueryContext x$2 = context;
        String x$3 = this.arithmeticOverflowError$default$2();
        return this.arithmeticOverflowError(x$1, x$3, x$2);
    }

    public ArithmeticException overflowInIntegralDivideError(SQLQueryContext context) {
        return this.arithmeticOverflowError("Overflow in integral divide", "try_divide", context);
    }

    public ArithmeticException overflowInConvError(SQLQueryContext context) {
        String x$1 = "Overflow in function conv()";
        SQLQueryContext x$2 = context;
        String x$3 = this.arithmeticOverflowError$default$2();
        return this.arithmeticOverflowError(x$1, x$3, x$2);
    }

    public SparkRuntimeException mapSizeExceedArraySizeWhenZipMapError(int size) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2003", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Integer.toString(size)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public RuntimeException literalTypeUnsupportedError(Object v) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE.LITERAL_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)v.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)v.getClass().toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public RuntimeException pivotColumnUnsupportedError(Object v, DataType dataType) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE.PIVOT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)v.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType(dataType))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException noDefaultForDataTypeError(DataType dataType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2004", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException orderedOperationUnsupportedByDataTypeError(DataType dataType) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2005", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException regexGroupIndexLessThanZeroError() {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2006", Predef$.MODULE$.Map().empty(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException regexGroupIndexExceedGroupCountError(int groupCount, int groupIndex) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2007", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupCount"), (Object)Integer.toString(groupCount)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupIndex"), (Object)Integer.toString(groupIndex))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException invalidUrlError(UTF8String url, URISyntaxException e) {
        String x$1 = "_LEGACY_ERROR_TEMP_2008";
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))}));
        URISyntaxException x$3 = e;
        QueryContext[] x$4 = SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3();
        String x$5 = SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4();
        return new SparkIllegalArgumentException(x$1, x$2, x$4, x$5, (Throwable)x$3);
    }

    public Throwable illegalUrlError(UTF8String url) {
        return new SparkIllegalArgumentException("CANNOT_DECODE_URL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url.toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException mergeUnsupportedByWindowFunctionError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2010", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException dataTypeUnexpectedError(DataType dataType) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2011", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.catalogString())})));
    }

    public SparkIllegalArgumentException typeUnsupportedError(DataType dataType) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2011", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException negativeValueUnexpectedError(Expression frequencyExpression) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2013", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frequencyExpression"), (Object)frequencyExpression.sql())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException addNewFunctionMismatchedWithFunctionError(String funcName) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2014", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotGenerateCodeForIncomparableTypeError(String codeType, DataType dataType) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2015", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"codeType"), (Object)codeType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.catalogString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotInterpolateClassIntoCodeBlockError(Object arg) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2016", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arg"), (Object)arg.getClass().getName())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException customCollectionClsNotResolvedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2017", Predef$.MODULE$.Map().empty());
    }

    public SparkRuntimeException classUnsupportedByMapObjectsError(Class<?> cls) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2018", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls.getName())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException nullAsMapKeyNotAllowedError() {
        return new SparkRuntimeException("NULL_MAP_KEY", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable methodNotDeclaredError(String name) {
        return SparkException$.MODULE$.internalError(new StringBuilder(74).append("A method named \"").append(name).append("\" is not declared in any enclosing class nor any supertype").toString());
    }

    public SparkRuntimeException constructorNotFoundError(String cls) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2020", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException primaryConstructorNotFoundError(Class<?> cls) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2021", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unsupportedNaturalJoinTypeError(JoinType joinType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2022", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType"), (Object)joinType.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException notExpectedUnresolvedEncoderError(AttributeReference attr) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2023", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr"), (Object)attr.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unsupportedEncoderError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2024", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException notOverrideExpectedMethodsError(String className, String m1, String m2) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2025", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m1"), (Object)m1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m2"), (Object)m2)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException failToConvertValueToJsonError(Object value, Class<?> cls, DataType dataType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2026", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unexpectedOperatorInCorrelatedSubquery(LogicalPlan op, String pos) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2027", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"op"), (Object)op.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pos"), (Object)pos)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public String unexpectedOperatorInCorrelatedSubquery$default$2() {
        return "";
    }

    public SparkRuntimeException unreachableError(String err) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2028", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"err"), (Object)err)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public String unreachableError$default$1() {
        return "";
    }

    public SparkRuntimeException unsupportedRoundingMode(Enumeration.Value roundMode) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2029", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"roundMode"), (Object)roundMode.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException resolveCannotHandleNestedSchema(LogicalPlan plan2) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2030", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plan"), (Object)plan2.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException inputExternalRowCannotBeNullError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2031", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public String fieldCannotBeNullMsg(int index, String fieldName) {
        return new StringBuilder(44).append("The ").append(index).append("th field '").append(fieldName).append("' of input row cannot be null.").toString();
    }

    public SparkRuntimeException fieldCannotBeNullError(int index, String fieldName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2032", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldCannotBeNullMsg"), (Object)this.fieldCannotBeNullMsg(index, fieldName))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unableToCreateDatabaseAsFailedToCreateDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2033", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)dbDefinition.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"locationUri"), (Object)dbDefinition.locationUri().toString())})), (Throwable)e);
    }

    public Throwable unableToDropDatabaseAsFailedToDeleteDirectoryError(CatalogDatabase dbDefinition, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2034", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)dbDefinition.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"locationUri"), (Object)dbDefinition.locationUri().toString())})), (Throwable)e);
    }

    public Throwable unableToCreateTableAsFailedToCreateDirectoryError(String table, Path defaultTableLocation, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2035", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultTableLocation"), (Object)defaultTableLocation.toString())})), (Throwable)e);
    }

    public Throwable unableToDeletePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2036", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionPath"), (Object)partitionPath.toString())})), (Throwable)e);
    }

    public Throwable unableToDropTableAsFailedToDeleteDirectoryError(String table, Path dir, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2037", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)dir.toString())})), (Throwable)e);
    }

    public Throwable unableToRenameTableAsFailedToRenameDirectoryError(String oldName, String newName, Path oldDir, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2038", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldName"), (Object)oldName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"newName"), (Object)newName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldDir"), (Object)oldDir.toString())})), (Throwable)e);
    }

    public Throwable unableToCreatePartitionPathError(Path partitionPath, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2039", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionPath"), (Object)partitionPath.toString())})), (Throwable)e);
    }

    public Throwable unableToRenamePartitionPathError(Path oldPartPath, IOException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2040", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldPartPath"), (Object)oldPartPath.toString())})), (Throwable)e);
    }

    public SparkUnsupportedOperationException methodNotImplementedError(String methodName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2041", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)methodName)})));
    }

    public SparkArithmeticException arithmeticOverflowError(ArithmeticException e) {
        return new SparkArithmeticException("_LEGACY_ERROR_TEMP_2042", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ansiConfig"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public ArithmeticException arithmeticOverflowError(String message, String hint, SQLQueryContext context) {
        String alternative = new StringOps(Predef$.MODULE$.augmentString(hint)).nonEmpty() ? new StringBuilder(53).append(" Use '").append(hint).append("' to tolerate overflow and return NULL instead.").toString() : "";
        return new SparkArithmeticException("ARITHMETIC_OVERFLOW", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)alternative), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public String arithmeticOverflowError$default$2() {
        return "";
    }

    public SQLQueryContext arithmeticOverflowError$default$3() {
        return null;
    }

    public SparkArithmeticException unaryMinusCauseOverflowError(int originValue) {
        return new SparkArithmeticException("_LEGACY_ERROR_TEMP_2043", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlValue"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)originValue), IntegerType$.MODULE$))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkArithmeticException binaryArithmeticCauseOverflowError(short eval1, String symbol, short eval2) {
        return new SparkArithmeticException("_LEGACY_ERROR_TEMP_2044", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlValue1"), (Object)this.toSQLValue(BoxesRunTime.boxToShort((short)eval1), ShortType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"symbol"), (Object)symbol), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlValue2"), (Object)this.toSQLValue(BoxesRunTime.boxToShort((short)eval2), ShortType$.MODULE$))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public ArithmeticException intervalArithmeticOverflowError(String message, String hint, SQLQueryContext context) {
        String alternative = new StringOps(Predef$.MODULE$.augmentString(hint)).nonEmpty() ? new StringBuilder(53).append(" Use '").append(hint).append("' to tolerate overflow and return NULL instead.").toString() : "";
        return new SparkArithmeticException("INTERVAL_ARITHMETIC_OVERFLOW", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"alternative"), (Object)alternative)})), this.getQueryContext(context), this.getSummary(context));
    }

    public String intervalArithmeticOverflowError$default$2() {
        return "";
    }

    public String failedToCompileMsg(Exception e) {
        return new StringBuilder(19).append("failed to compile: ").append(e).toString();
    }

    public Throwable internalCompilerError(InternalCompilerException e) {
        return new InternalCompilerException(this.failedToCompileMsg((Exception)((Object)e)), (Throwable)e);
    }

    public Throwable compilerError(CompileException e) {
        return new CompileException(this.failedToCompileMsg((Exception)((Object)e)), e.getLocation());
    }

    public Throwable unsupportedTableChangeError(IllegalArgumentException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2045", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage())})), (Throwable)e);
    }

    public Throwable notADatasourceRDDPartitionError(Partition split) {
        return new SparkException("_LEGACY_ERROR_TEMP_2046", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"split"), (Object)split.toString())})), null);
    }

    public SparkIllegalArgumentException dataPathNotSpecifiedError() {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2047", Predef$.MODULE$.Map().empty(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException createStreamingSourceNotSpecifySchemaError() {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2048", Predef$.MODULE$.Map().empty(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException streamedOperatorUnsupportedByDataSourceError(String className, String operator) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2049", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operator"), (Object)operator)})));
    }

    public SparkIllegalArgumentException multiplePathsSpecifiedError(Seq<String> allPaths) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2050", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)allPaths.mkString(", "))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkClassNotFoundException dataSourceNotFoundError(String provider, Throwable error) {
        return new SparkClassNotFoundException("DATA_SOURCE_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider)})), error);
    }

    public SparkClassNotFoundException removedClassInSpark2Error(String className, Throwable e) {
        return new SparkClassNotFoundException("_LEGACY_ERROR_TEMP_2052", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})), e);
    }

    public Throwable incompatibleDataSourceRegisterError(Throwable e) {
        return new SparkClassNotFoundException("INCOMPATIBLE_DATASOURCE_REGISTER", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage())})), e);
    }

    public SparkUpgradeException sparkUpgradeInReadingDatesError(String format, String config, String option) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION.READ_ANCIENT_DATETIME", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(config)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"option"), (Object)this.toDSOption(option))})), null);
    }

    public SparkUpgradeException sparkUpgradeInWritingDatesError(String format, String config) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION.WRITE_ANCIENT_DATETIME", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(config))})), null);
    }

    public SparkUnsupportedOperationException buildReaderUnsupportedForFileFormatError(String format) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2053", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format)})));
    }

    public Throwable taskFailedWhileWritingRowsError(String path, Throwable cause) {
        return new SparkException("TASK_WRITE_FAILED", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})), cause);
    }

    public SparkFileNotFoundException readCurrentFileNotFoundError(FileNotFoundException e) {
        return new SparkFileNotFoundException("_LEGACY_ERROR_TEMP_2055", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage())})));
    }

    public Throwable saveModeUnsupportedError(Object saveMode, boolean pathExists) {
        String errorSubClass = pathExists ? "EXISTENT_PATH" : "NON_EXISTENT_PATH";
        return new SparkIllegalArgumentException(new StringBuilder(22).append("UNSUPPORTED_SAVE_MODE.").append(errorSubClass).toString(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"saveMode"), (Object)this.toSQLValue(saveMode, StringType$.MODULE$))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotClearOutputDirectoryError(Path staticPrefixPath) {
        return new SparkException("_LEGACY_ERROR_TEMP_2056", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"staticPrefixPath"), (Object)staticPrefixPath.toString())})), null);
    }

    public Throwable cannotClearPartitionDirectoryError(Path path) {
        return new SparkException("_LEGACY_ERROR_TEMP_2057", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path.toString())})), null);
    }

    public SparkRuntimeException failedToCastValueToDataTypeForPartitionColumnError(String value, DataType dataType, String columnName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2058", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)columnName)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable endOfStreamError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2059", Predef$.MODULE$.Map().empty(), null);
    }

    public SparkIllegalArgumentException fallbackV1RelationReportsInconsistentSchemaError(StructType v2Schema, StructType v1Schema) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2060", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v2Schema"), (Object)v2Schema.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v1Schema"), (Object)v1Schema.toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noRecordsFromEmptyDataReaderError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2061", Predef$.MODULE$.Map().empty(), null);
    }

    public SparkFileNotFoundException fileNotFoundError(FileNotFoundException e) {
        return new SparkFileNotFoundException("_LEGACY_ERROR_TEMP_2062", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage())})));
    }

    public Throwable unsupportedSchemaColumnConvertError(String filePath, String column, String logicalType, String physicalType, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2063", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filePath"), (Object)filePath), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"column"), (Object)column), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logicalType"), (Object)logicalType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"physicalType"), (Object)physicalType)})), (Throwable)e);
    }

    public Throwable cannotReadFilesError(Throwable e, String path) {
        return new SparkException("_LEGACY_ERROR_TEMP_2064", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})), e);
    }

    public Throwable cannotCreateColumnarReaderError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2065", Predef$.MODULE$.Map().empty(), null);
    }

    public SparkIllegalArgumentException invalidNamespaceNameError(String[] namespace) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2066", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"namespace"), (Object)CatalogV2Implicits$.MODULE$.NamespaceHelper(namespace).quoted())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException unsupportedPartitionTransformError(Transform transform2) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2067", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transform"), (Object)transform2.toString())})));
    }

    public SparkIllegalArgumentException missingDatabaseLocationError() {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2068", Predef$.MODULE$.Map().empty(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException cannotRemoveReservedPropertyError(String property) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2069", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)property)})));
    }

    public Throwable writingJobFailedError(Throwable cause) {
        return new SparkException("_LEGACY_ERROR_TEMP_2070", Predef$.MODULE$.Map().empty(), cause);
    }

    public Throwable commitDeniedError(int partId, long taskId, int attemptId, int stageId, int stageAttempt) {
        return new SparkException("_LEGACY_ERROR_TEMP_2071", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partId"), (Object)Integer.toString(partId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskId"), (Object)Long.toString(taskId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attemptId"), (Object)Integer.toString(attemptId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageId"), (Object)Integer.toString(stageId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageAttempt"), (Object)Integer.toString(stageAttempt))})), null);
    }

    public Throwable unsupportedTableWritesError(Identifier ident) {
        return new SparkException("_LEGACY_ERROR_TEMP_2072", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"idnt"), (Object)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).quoted())})), null);
    }

    public SparkUnsupportedOperationException cannotCreateJDBCTableWithPartitionsError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2073", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException unsupportedUserSpecifiedSchemaError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2074", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException writeUnsupportedForBinaryFileDataSourceError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2075", Predef$.MODULE$.Map().empty());
    }

    public Throwable fileLengthExceedsMaxLengthError(FileStatus status, int maxLength) {
        return new SparkException("_LEGACY_ERROR_TEMP_2076", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)status.getPath().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"len"), (Object)Long.toString(status.getLen())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxLength"), (Object)Integer.toString(maxLength))})), null);
    }

    public SparkRuntimeException unsupportedFieldNameError(String fieldName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2077", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)fieldName)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotSpecifyBothJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2078", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcTableName"), (Object)jdbcTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcQueryString"), (Object)jdbcQueryString)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException missingJdbcTableNameAndQueryError(String jdbcTableName, String jdbcQueryString) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2079", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcTableName"), (Object)jdbcTableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcQueryString"), (Object)jdbcQueryString)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException emptyOptionError(String optionName) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2080", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"optionName"), (Object)optionName)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException invalidJdbcTxnIsolationLevelError(String jdbcTxnIsolationLevel, String value) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2081", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcTxnIsolationLevel"), (Object)jdbcTxnIsolationLevel)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotGetJdbcTypeError(DataType dt) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2082", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogString"), (Object)dt.catalogString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unrecognizedSqlTypeError(int sqlType) {
        return new SparkSQLException("UNRECOGNIZED_SQL_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)Integer.toString(sqlType))})));
    }

    public SparkSQLException unsupportedJdbcTypeError(String content) {
        return new SparkSQLException("_LEGACY_ERROR_TEMP_2083", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"content"), (Object)content)})));
    }

    public SparkIllegalArgumentException unsupportedArrayElementTypeBasedOnBinaryError(DataType dt) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2084", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogString"), (Object)dt.catalogString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException nestedArraysUnsupportedError() {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2085", Predef$.MODULE$.Map().empty(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotTranslateNonNullValueForFieldError(int pos) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2086", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pos"), (Object)Integer.toString(pos))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException invalidJdbcNumPartitionsError(int n, String jdbcNumPartitions) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2087", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)Integer.toString(n)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbcNumPartitions"), (Object)jdbcNumPartitions)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multiActionAlterError(String tableName) {
        return new SparkSQLFeatureNotSupportedException("UNSUPPORTED_FEATURE.MULTI_ACTION_ALTER", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public SparkUnsupportedOperationException dataTypeUnsupportedYetError(DataType dataType) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2088", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
    }

    public SparkUnsupportedOperationException unsupportedOperationForDataTypeError(DataType dataType) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2089", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogString"), (Object)dataType.catalogString())})));
    }

    public Throwable inputFilterNotFullyConvertibleError(String owner) {
        return new SparkException("_LEGACY_ERROR_TEMP_2090", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)owner)})), null);
    }

    public Throwable cannotReadFooterForFileError(Path file, Exception e) {
        return new SparkException("CANNOT_READ_FILE_FOOTER", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)file.toString())})), (Throwable)e);
    }

    public SparkRuntimeException foundDuplicateFieldInCaseInsensitiveModeError(String requiredFieldName, String matchedOrcFields) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2093", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredFieldName"), (Object)requiredFieldName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matchedOrcFields"), (Object)matchedOrcFields)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException foundDuplicateFieldInFieldIdLookupModeError(int requiredId, String matchedFields) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2094", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredId"), (Object)Integer.toString(requiredId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"matchedFields"), (Object)matchedFields)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable failedToMergeIncompatibleSchemasError(StructType left, StructType right, Throwable e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2095", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)left.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)right.toString())})), e);
    }

    public SparkUnsupportedOperationException ddlUnsupportedTemporarilyError(String ddl) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2096", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ddl"), (Object)ddl)})));
    }

    public Throwable executeBroadcastTimeoutError(long timeout, Option<TimeoutException> ex) {
        return new SparkException("_LEGACY_ERROR_TEMP_2097", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timeout"), (Object)Long.toString(timeout)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTimeout"), (Object)this.toSQLConf(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"autoBroadcastJoinThreshold"), (Object)this.toSQLConf(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()))})), (Throwable)ex.orNull(Predef$.MODULE$.$conforms()));
    }

    public SparkIllegalArgumentException cannotCompareCostWithTargetCostError(String cost) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2098", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cost"), (Object)cost)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException unsupportedArrowTypeError(ArrowType typeName) {
        return new SparkUnsupportedOperationException("UNSUPPORTED_ARROWTYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)typeName.toString())})));
    }

    public SparkUnsupportedOperationException unsupportedDataTypeError(DataType typeName) {
        return new SparkUnsupportedOperationException("UNSUPPORTED_DATATYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)this.toSQLType(typeName))})));
    }

    public Throwable notSupportTypeError(DataType dataType) {
        return new SparkException("_LEGACY_ERROR_TEMP_2100", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), null);
    }

    public SparkRuntimeException notSupportNonPrimitiveTypeError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2101", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsupportedTypeError(DataType dataType) {
        return new SparkException("_LEGACY_ERROR_TEMP_2102", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogString"), (Object)dataType.catalogString())})), null);
    }

    public Throwable useDictionaryEncodingWhenDictionaryOverflowError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2103", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable endOfIteratorError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2104", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable cannotAllocateMemoryToGrowBytesToBytesMapError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2105", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable cannotAcquireMemoryToBuildLongHashedRelationError(long size, long got) {
        return new SparkException("_LEGACY_ERROR_TEMP_2106", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Long.toString(size)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"got"), (Object)Long.toString(got))})), null);
    }

    public Throwable cannotAcquireMemoryToBuildUnsafeHashedRelationError() {
        return new SparkOutOfMemoryError("_LEGACY_ERROR_TEMP_2107");
    }

    public SparkUnsupportedOperationException rowLargerThan256MUnsupportedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2108", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cannotBuildHashedRelationWithUniqueKeysExceededError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2109", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cannotBuildHashedRelationLargerThan8GError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2110", Predef$.MODULE$.Map().empty());
    }

    public Throwable failedToPushRowIntoRowQueueError(String rowQueue) {
        return new SparkException("_LEGACY_ERROR_TEMP_2111", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowQueue"), (Object)rowQueue)})), null);
    }

    public SparkRuntimeException unexpectedWindowFunctionFrameError(String frame) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2112", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"frame"), (Object)frame)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException cannotParseStatisticAsPercentileError(String stats, NumberFormatException e) {
        String x$1 = "_LEGACY_ERROR_TEMP_2113";
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stats"), (Object)stats)}));
        NumberFormatException x$3 = e;
        QueryContext[] x$4 = SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3();
        String x$5 = SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4();
        return new SparkIllegalArgumentException(x$1, x$2, x$4, x$5, (Throwable)x$3);
    }

    public SparkIllegalArgumentException statisticNotRecognizedError(String stats) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2114", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stats"), (Object)stats)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException unknownColumnError(String unknownColumn) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2115", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unknownColumn"), (Object)unknownColumn)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException unexpectedAccumulableUpdateValueError(Object o) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2116", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o"), (Object)o.toString())})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public ArithmeticException unscaledValueTooLargeForPrecisionError(Decimal value, int decimalPrecision, int decimalScale, SQLQueryContext context) {
        return new SparkArithmeticException("NUMERIC_VALUE_OUT_OF_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value.toPlainString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(decimalPrecision)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)Integer.toString(decimalScale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.ANSI_ENABLED().key()))})), this.getQueryContext(context), this.getSummary(context));
    }

    public SQLQueryContext unscaledValueTooLargeForPrecisionError$default$4() {
        return null;
    }

    public SparkArithmeticException decimalPrecisionExceedsMaxPrecisionError(int precision, int maxPrecision) {
        return new SparkArithmeticException("DECIMAL_PRECISION_EXCEEDS_MAX_PRECISION", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)Integer.toString(precision)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPrecision"), (Object)Integer.toString(maxPrecision))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkArithmeticException outOfDecimalTypeRangeError(UTF8String str) {
        return new SparkArithmeticException("NUMERIC_OUT_OF_SUPPORTED_RANGE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)str.toString())})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkRuntimeException unsupportedArrayTypeError(Class<?> clazz) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2120", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unsupportedJavaTypeError(Class<?> clazz) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2121", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException failedParsingStructTypeError(String raw) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2122", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"simpleString"), (Object)StructType$.MODULE$.simpleString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"raw"), (Object)raw)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable cannotMergeDecimalTypesWithIncompatibleScaleError(int leftScale, int rightScale) {
        return new SparkException("_LEGACY_ERROR_TEMP_2124", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftScale"), (Object)Integer.toString(leftScale)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightScale"), (Object)Integer.toString(rightScale))})), null);
    }

    public Throwable cannotMergeIncompatibleDataTypesError(DataType left, DataType right) {
        return new SparkException("CANNOT_MERGE_INCOMPATIBLE_DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"left"), (Object)this.toSQLType(left)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"right"), (Object)this.toSQLType(right))})), null);
    }

    public SparkRuntimeException exceedMapSizeLimitError(int size) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2126", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Integer.toString(size)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException duplicateMapKeyFoundError(Object key) {
        return new SparkRuntimeException("DUPLICATED_MAP_KEY", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapKeyDedupPolicy"), (Object)this.toSQLConf(SQLConf$.MODULE$.MAP_KEY_DEDUP_POLICY().key()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException mapDataKeyArrayLengthDiffersFromValueArrayLengthError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2128", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkDateTimeException fieldDiffersFromDerivedLocalDateError(ChronoField field, int actual, int expected, LocalDate candidate) {
        return new SparkDateTimeException("_LEGACY_ERROR_TEMP_2129", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field"), (Object)field.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actual"), (Object)Integer.toString(actual)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expected"), (Object)Integer.toString(expected)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"candidate"), (Object)candidate.toString())})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public Throwable failToParseDateTimeInNewParserError(String s, Throwable e) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION.PARSE_DATETIME_BY_NEW_PARSER", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)this.toSQLValue(s, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key()))})), e);
    }

    public Throwable failToRecognizePatternAfterUpgradeError(String pattern, Throwable e, String docroot) {
        return new SparkUpgradeException("INCONSISTENT_BEHAVIOR_CROSS_VERSION.DATETIME_PATTERN_RECOGNITION", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)this.toSQLValue(pattern, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)this.toSQLConf(SQLConf$.MODULE$.LEGACY_TIME_PARSER_POLICY().key())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)docroot)})), e);
    }

    public SparkRuntimeException failToRecognizePatternError(String pattern, Throwable e, String docroot) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2130", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)this.toSQLValue(pattern, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)docroot)})), e, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable registeringStreamingQueryListenerError(Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2131", Predef$.MODULE$.Map().empty(), (Throwable)e);
    }

    public Throwable concurrentQueryInstanceError() {
        return new SparkConcurrentModificationException("CONCURRENT_QUERY", Predef$.MODULE$.Map().empty(), SparkConcurrentModificationException$.MODULE$.$lessinit$greater$default$3());
    }

    public SparkRuntimeException cannotParseJsonArraysAsStructsError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2132", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotParseStringAsDataTypeError(JsonParser parser, JsonToken token, DataType dataType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2133", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)parser.getCurrentName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldValue"), (Object)parser.getText()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"token"), (Object)token.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotParseStringAsDataTypeError(String pattern, String value, DataType dataType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2134", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLValue(value, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)this.toSQLValue(pattern, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException emptyJsonFieldValueError(DataType dataType) {
        return new SparkRuntimeException("EMPTY_JSON_FIELD_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(dataType))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotParseJSONFieldError(JsonParser parser, JsonToken jsonType, DataType dataType) {
        return this.cannotParseJSONFieldError(parser.getCurrentName(), parser.getText(), jsonType, dataType);
    }

    public SparkRuntimeException cannotParseJSONFieldError(String fieldName, String fieldValue, JsonToken jsonType, DataType dataType) {
        return new SparkRuntimeException("CANNOT_PARSE_JSON_FIELD", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLValue(fieldName, StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldValue"), (Object)fieldValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jsonType"), (Object)jsonType.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(dataType))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException rootConverterReturnNullError() {
        return new SparkRuntimeException("INVALID_JSON_ROOT_FIELD", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException cannotHaveCircularReferencesInBeanClassError(Class<?> clazz) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2138", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz.toString())})));
    }

    public SparkUnsupportedOperationException cannotHaveCircularReferencesInClassError(String t) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2139", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)t)})));
    }

    public SparkUnsupportedOperationException cannotUseInvalidJavaIdentifierAsFieldNameError(String fieldName, WalkedTypePath walkedTypePath) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2140", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)fieldName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"walkedTypePath"), (Object)walkedTypePath.toString())})));
    }

    public SparkUnsupportedOperationException cannotFindEncoderForTypeError(String typeName, String docroot) {
        return new SparkUnsupportedOperationException("ENCODER_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)typeName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"docroot"), (Object)docroot)})));
    }

    public SparkUnsupportedOperationException attributesForTypeUnsupportedError(ScalaReflection.Schema schema) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2142", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.toString())})));
    }

    public SparkUnsupportedOperationException cannotFindConstructorForTypeError(String tpe) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2144", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tpe"), (Object)tpe)})));
    }

    public SparkRuntimeException paramExceedOneCharError(String paramName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2145", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramName"), (Object)paramName)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException paramIsNotIntegerError(String paramName, String value) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2146", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramName"), (Object)paramName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable paramIsNotBooleanValueError(String paramName) {
        return new SparkException("_LEGACY_ERROR_TEMP_2147", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramName"), (Object)paramName)})), null);
    }

    public SparkRuntimeException foundNullValueForNotNullableFieldError(String name) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2148", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException malformedCSVRecordError(String badRecord) {
        return new SparkRuntimeException("MALFORMED_CSV_RECORD", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"badRecord"), (Object)badRecord)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException elementsOfTupleExceedLimitError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2150", Predef$.MODULE$.Map().empty());
    }

    public SparkRuntimeException expressionDecodingError(Exception e, Seq<Expression> expressions) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2151", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)e.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressions"), (Object)((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.simpleString(SQLConf$.MODULE$.get().maxToStringFields()), Seq$.MODULE$.canBuildFrom())).mkString("\n"))})), (Throwable)e, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException expressionEncodingError(Exception e, Seq<Expression> expressions) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2152", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"e"), (Object)e.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expressions"), (Object)((TraversableOnce)expressions.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.simpleString(SQLConf$.MODULE$.get().maxToStringFields()), Seq$.MODULE$.canBuildFrom())).mkString("\n"))})), (Throwable)e, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException classHasUnexpectedSerializerError(String clsName, Expression objSerializer) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2153", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clsName"), (Object)clsName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objSerializer"), (Object)objSerializer.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotGetOuterPointerForInnerClassError(Class<?> innerCls) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2154", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"innerCls"), (Object)innerCls.getName())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable userDefinedTypeNotAnnotatedAndRegisteredError(UserDefinedType<?> udt) {
        return new SparkException("_LEGACY_ERROR_TEMP_2155", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userClass"), (Object)udt.userClass().getName())})), null);
    }

    public SparkUnsupportedOperationException unsupportedOperandTypeForSizeFunctionError(DataType dataType) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2156", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.getClass().getCanonicalName())})));
    }

    public SparkRuntimeException unexpectedValueForStartInFunctionError(String prettyName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2157", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prettyName"), (Object)prettyName)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unexpectedValueForLengthInFunctionError(String prettyName) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2158", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prettyName"), (Object)prettyName)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public RuntimeException invalidIndexOfZeroError(SQLQueryContext context) {
        String x$1 = "INVALID_INDEX_OF_ZERO";
        Object x$2 = null;
        Map x$3 = Predef$.MODULE$.Map().empty();
        QueryContext[] x$4 = this.getQueryContext(context);
        String x$5 = this.getSummary(context);
        return new SparkRuntimeException(x$1, x$3, null, x$4, x$5);
    }

    public SparkRuntimeException concatArraysWithElementsExceedLimitError(long numberOfElements) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2159", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numberOfElements"), (Object)Long.toString(numberOfElements)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException flattenArraysWithElementsExceedLimitError(long numberOfElements) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2160", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numberOfElements"), (Object)Long.toString(numberOfElements)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException createArrayWithElementsExceedLimitError(Object count) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2161", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)count.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException unionArrayWithElementsExceedLimitError(int length) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2162", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"length"), (Object)Integer.toString(length)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException initialTypeNotTargetDataTypeError(DataType dataType, String target) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2163", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.catalogString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"target"), (Object)target)})));
    }

    public SparkUnsupportedOperationException initialTypeNotTargetDataTypesError(DataType dataType) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2164", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.catalogString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arrayType"), (Object)ArrayType$.MODULE$.simpleString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"structType"), (Object)StructType$.MODULE$.simpleString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapType"), (Object)MapType$.MODULE$.simpleString())})));
    }

    public Throwable malformedRecordsDetectedInSchemaInferenceError(Throwable e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2165", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failFastMode"), (Object)FailFastMode$.MODULE$.name())})), e);
    }

    public Throwable malformedJSONError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2166", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable malformedRecordsDetectedInSchemaInferenceError(DataType dataType) {
        return new SparkException("_LEGACY_ERROR_TEMP_2167", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failFastMode"), (Object)FailFastMode$.MODULE$.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.catalogString())})), null);
    }

    public SparkUnsupportedOperationException decorrelateInnerQueryThroughPlanUnsupportedError(LogicalPlan plan2) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2168", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plan"), (Object)plan2.nodeName())})));
    }

    public SparkRuntimeException methodCalledInAnalyzerNotAllowedError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2169", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException cannotSafelyMergeSerdePropertiesError(Map<String, String> props1, Map<String, String> props2, Set<String> conflictKeys) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2170", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"props1"), (Object)((TraversableOnce)props1.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"props2"), (Object)((TraversableOnce)props2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ",", "}")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conflictKeys"), (Object)conflictKeys.mkString(", "))})));
    }

    public SparkUnsupportedOperationException pairUnsupportedAtFunctionError(ValueInterval r1, ValueInterval r2, String function) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2171", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r1"), (Object)r1.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r2"), (Object)r2.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"function"), (Object)function)})));
    }

    public <TreeType extends TreeNode<?>> SparkRuntimeException onceStrategyIdempotenceIsBrokenForBatchError(String batchName, TreeType plan2, TreeType reOptimized) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2172", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchName"), (Object)batchName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"plan"), (Object)package$.MODULE$.sideBySide(plan2.treeString(), reOptimized.treeString()).mkString("\n"))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable ruleIdNotFoundForRuleError(String ruleName) {
        return new SparkException("_LEGACY_ERROR_TEMP_2175", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ruleName"), (Object)ruleName)})), null);
    }

    public SparkRuntimeException cannotCreateArrayWithElementsExceedLimitError(long numElements, String additionalErrorMessage) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2176", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numElements"), (Object)Long.toString(numElements)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxRoundedArrayLength"), (Object)Integer.toString(0x7FFFFFF0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"additionalErrorMessage"), (Object)additionalErrorMessage)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable malformedRecordsDetectedInRecordParsingError(String badRecord, BadRecordException e) {
        return new SparkException("MALFORMED_RECORD_IN_PARSING", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"badRecord"), (Object)badRecord), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failFastMode"), (Object)FailFastMode$.MODULE$.name())})), (Throwable)e);
    }

    public SparkRuntimeException remoteOperationsUnsupportedError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2178", Predef$.MODULE$.Map().empty(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable invalidKerberosConfigForHiveServer2Error() {
        return new SparkException("_LEGACY_ERROR_TEMP_2179", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable parentSparkUIToAttachTabNotFoundError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2180", Predef$.MODULE$.Map().empty(), null);
    }

    public SparkUnsupportedOperationException inferSchemaUnsupportedForHiveError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2181", Predef$.MODULE$.Map().empty());
    }

    public Throwable requestedPartitionsMismatchTablePartitionsError(CatalogTable table, Map<String, Option<String>> partition) {
        return new SparkException("_LEGACY_ERROR_TEMP_2182", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableIdentifier"), (Object)table.identifier().table()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionKeys"), (Object)partition.keys().mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionColumnNames"), (Object)table.partitionColumnNames().mkString(","))})), null);
    }

    public Throwable dynamicPartitionKeyNotAmongWrittenPartitionPathsError(String key) {
        return new SparkException("_LEGACY_ERROR_TEMP_2183", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLValue(key, StringType$.MODULE$))})), null);
    }

    public SparkRuntimeException cannotRemovePartitionDirError(Path partitionPath) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2184", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitionPath"), (Object)partitionPath.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotCreateStagingDirError(String message, IOException e) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2185", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)})), (Throwable)e, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkClassNotFoundException serDeInterfaceNotFoundError(NoClassDefFoundError e) {
        return new SparkClassNotFoundException("_LEGACY_ERROR_TEMP_2186", Predef$.MODULE$.Map().empty(), (Throwable)e);
    }

    public Throwable convertHiveTableToCatalogTableError(SparkException e, String dbName, String tableName) {
        return new SparkException("_LEGACY_ERROR_TEMP_2187", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbName"), (Object)dbName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})), (Throwable)e);
    }

    public Throwable cannotRecognizeHiveTypeError(ParseException e, String fieldType, String fieldName) {
        return new SparkException("CANNOT_RECOGNIZE_HIVE_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldType"), (Object)this.toSQLType(fieldType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)this.toSQLId(fieldName))})), (Throwable)e);
    }

    public SparkUnsupportedOperationException getTablesByTypeUnsupportedByHiveVersionError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2189", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException dropTableWithPurgeUnsupportedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2190", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException alterTableWithDropPartitionAndPurgeUnsupportedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2191", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException invalidPartitionFilterError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2192", Predef$.MODULE$.Map().empty());
    }

    public SparkRuntimeException getPartitionMetadataByFilterError(InvocationTargetException e) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2193", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hiveMetastorePartitionPruningFallbackOnException"), (Object)SQLConf$.MODULE$.HIVE_METASTORE_PARTITION_PRUNING_FALLBACK_ON_EXCEPTION().key())})), (Throwable)e, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException unsupportedHiveMetastoreVersionError(String version, String key) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2194", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)version), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key)})));
    }

    public SparkClassNotFoundException loadHiveClientCausesNoClassDefFoundError(NoClassDefFoundError cnf, Seq<URL> execJars, String key, InvocationTargetException e) {
        return new SparkClassNotFoundException("_LEGACY_ERROR_TEMP_2195", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cnf"), (Object)cnf.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"execJars"), (Object)execJars.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key)})), (Throwable)e);
    }

    public Throwable cannotFetchTablesOfDatabaseError(String dbName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2196", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbName"), (Object)dbName)})), (Throwable)e);
    }

    public Throwable illegalLocationClauseForViewPartitionError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2197", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable renamePathAsExistsPathError(Path srcPath, Path dstPath) {
        return new SparkFileAlreadyExistsException("FAILED_RENAME_PATH", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourcePath"), (Object)srcPath.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetPath"), (Object)dstPath.toString())})));
    }

    public SparkFileAlreadyExistsException renameAsExistsPathError(Path dstPath) {
        return new SparkFileAlreadyExistsException("_LEGACY_ERROR_TEMP_2198", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dstPath"), (Object)dstPath.toString())})));
    }

    public Throwable renameSrcPathNotFoundError(Path srcPath) {
        return new SparkFileNotFoundException("RENAME_SRC_PATH_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourcePath"), (Object)srcPath.toString())})));
    }

    public Throwable failedRenameTempFileError(Path srcPath, Path dstPath) {
        return new SparkException("_LEGACY_ERROR_TEMP_2199", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcPath"), (Object)srcPath.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dstPath"), (Object)dstPath.toString())})), null);
    }

    public Throwable legacyMetadataPathExistsError(Path metadataPath, Path legacyMetadataPath) {
        return new SparkException("_LEGACY_ERROR_TEMP_2200", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadataPath"), (Object)metadataPath.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"legacyMetadataPath"), (Object)legacyMetadataPath.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"StreamingCheckpointEscaptedPathCheckEnabled"), (Object)SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED().key())})), null);
    }

    public SparkRuntimeException partitionColumnNotFoundInSchemaError(String col, StructType schema) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2201", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"col"), (Object)col), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.toString())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable stateNotDefinedOrAlreadyRemovedError() {
        return new NoSuchElementException("State is either not defined or has already been removed");
    }

    public SparkUnsupportedOperationException cannotSetTimeoutDurationError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2203", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cannotGetEventTimeWatermarkError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2204", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cannotSetTimeoutTimestampError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2205", Predef$.MODULE$.Map().empty());
    }

    public SparkFileNotFoundException batchMetadataFileNotFoundError(Path batchMetadataFile) {
        return new SparkFileNotFoundException("_LEGACY_ERROR_TEMP_2206", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchMetadataFile"), (Object)batchMetadataFile.toString())})));
    }

    public SparkConcurrentModificationException multiStreamingQueriesUsingPathConcurrentlyError(String path, FileAlreadyExistsException e) {
        return new SparkConcurrentModificationException("_LEGACY_ERROR_TEMP_2207", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})), (Throwable)e);
    }

    public SparkUnsupportedOperationException addFilesWithAbsolutePathUnsupportedError(String commitProtocol) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2208", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commitProtocol"), (Object)commitProtocol)})));
    }

    public SparkUnsupportedOperationException microBatchUnsupportedByDataSourceError(String srcName, String disabledSources, Table table) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2209", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"srcName"), (Object)srcName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"disabledSources"), (Object)disabledSources), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.toString())})));
    }

    public SparkUnsupportedOperationException cannotExecuteStreamingRelationExecError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2210", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException invalidStreamingOutputModeError(Option<OutputMode> outputMode) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2211", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputMode"), (Object)outputMode.toString())})));
    }

    public Throwable invalidCatalogNameError(String name) {
        return new SparkException("_LEGACY_ERROR_TEMP_2212", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})), null);
    }

    public Throwable catalogPluginClassNotFoundError(String name) {
        return new CatalogNotFoundException(new StringBuilder(68).append("Catalog '").append(name).append("' plugin class not found: spark.sql.catalog.").append(name).append(" is not defined").toString());
    }

    public Throwable catalogPluginClassNotImplementedError(String name, String pluginClassName) {
        return new SparkException("_LEGACY_ERROR_TEMP_2214", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), null);
    }

    public Throwable catalogPluginClassNotFoundForCatalogError(String name, String pluginClassName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2215", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), (Throwable)e);
    }

    public Throwable catalogFailToFindPublicNoArgConstructorError(String name, String pluginClassName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2216", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), (Throwable)e);
    }

    public Throwable catalogFailToCallPublicNoArgConstructorError(String name, String pluginClassName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2217", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), (Throwable)e);
    }

    public Throwable cannotInstantiateAbstractCatalogPluginClassError(String name, String pluginClassName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2218", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), e.getCause());
    }

    public Throwable failedToInstantiateConstructorForCatalogError(String name, String pluginClassName, Exception e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2219", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluginClassName"), (Object)pluginClassName)})), e.getCause());
    }

    public Throwable noSuchElementExceptionError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2220", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable noSuchElementExceptionError(String key) {
        return new NoSuchElementException(key);
    }

    public SparkUnsupportedOperationException cannotMutateReadOnlySQLConfError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2222", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cannotCloneOrCopyReadOnlySQLConfError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2223", Predef$.MODULE$.Map().empty());
    }

    public SparkRuntimeException cannotGetSQLConfInSchedulerEventLoopThreadError() {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2224", Predef$.MODULE$.Map().empty(), null, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException unsupportedOperationExceptionError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2225", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException nullLiteralsCannotBeCastedError(String name) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2226", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})));
    }

    public Throwable notUserDefinedTypeError(String name, String userClass) {
        return new SparkException("_LEGACY_ERROR_TEMP_2227", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userClass"), (Object)userClass)})), null);
    }

    public Throwable cannotLoadUserDefinedTypeError(String name, String userClass) {
        return new SparkException("_LEGACY_ERROR_TEMP_2228", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"userClass"), (Object)userClass)})), null);
    }

    public SparkUnsupportedOperationException notPublicClassError(String name) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2229", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name)})));
    }

    public SparkUnsupportedOperationException primitiveTypesNotSupportedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2230", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException fieldIndexOnRowWithoutSchemaError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2231", Predef$.MODULE$.Map().empty());
    }

    public Throwable valueIsNullError(int index) {
        return new SparkException("_LEGACY_ERROR_TEMP_2232", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)index), IntegerType$.MODULE$))})), null);
    }

    public Throwable onlySupportDataSourcesProvidingFileFormatError(String providingClass) {
        return new SparkException("_LEGACY_ERROR_TEMP_2233", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"providingClass"), (Object)providingClass)})), null);
    }

    public Throwable cannotRestorePermissionsForPathError(FsPermission permission, Path path) {
        return new SparkSecurityException("CANNOT_RESTORE_PERMISSIONS_FOR_PATH", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"permission"), (Object)permission.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path.toString())})));
    }

    public SparkSecurityException failToSetOriginalACLBackError(String aclEntries, Path path, Throwable e) {
        return new SparkSecurityException("_LEGACY_ERROR_TEMP_2234", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aclEntries"), (Object)aclEntries), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)e.getMessage())})));
    }

    public Throwable multiFailuresInStageMaterializationError(Throwable error) {
        return new SparkException("_LEGACY_ERROR_TEMP_2235", Predef$.MODULE$.Map().empty(), error);
    }

    public SparkUnsupportedOperationException unrecognizedCompressionSchemaTypeIDError(int typeId) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2236", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeId"), (Object)Integer.toString(typeId))})));
    }

    public SparkSQLFeatureNotSupportedException getParentLoggerNotImplementedError(String className) {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2237", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})));
    }

    public SparkRuntimeException cannotCreateParquetConverterForTypeError(DecimalType t, String parquetType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2238", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)t.typeName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquetType"), (Object)parquetType)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotCreateParquetConverterForDecimalTypeError(DecimalType t, String parquetType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2239", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)t.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquetType"), (Object)parquetType)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkRuntimeException cannotCreateParquetConverterForDataTypeError(DataType t, String parquetType) {
        return new SparkRuntimeException("_LEGACY_ERROR_TEMP_2240", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t"), (Object)t.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquetType"), (Object)parquetType)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException cannotAddMultiPartitionsOnNonatomicPartitionTableError(String tableName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2241", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public SparkUnsupportedOperationException userSpecifiedSchemaUnsupportedByDataSourceError(TableProvider provider) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2242", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)provider.getClass().getSimpleName())})));
    }

    public SparkUnsupportedOperationException cannotDropMultiPartitionsOnNonatomicPartitionTableError(String tableName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2243", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public SparkUnsupportedOperationException truncateMultiPartitionUnsupportedError(String tableName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2244", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public Throwable overwriteTableByUnsupportedExpressionError(Table table) {
        return new SparkException("_LEGACY_ERROR_TEMP_2245", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.toString())})), null);
    }

    public Throwable dynamicPartitionOverwriteUnsupportedByTableError(Table table) {
        return new SparkException("_LEGACY_ERROR_TEMP_2246", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"table"), (Object)table.toString())})), null);
    }

    public Throwable failedMergingSchemaError(StructType schema, SparkException e) {
        return new SparkException("_LEGACY_ERROR_TEMP_2247", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)schema.treeString())})), (Throwable)e);
    }

    public Throwable cannotBroadcastTableOverMaxTableRowsError(long maxBroadcastTableRows, long numRows) {
        return new SparkException("_LEGACY_ERROR_TEMP_2248", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxBroadcastTableRows"), (Object)Long.toString(maxBroadcastTableRows)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)Long.toString(numRows))})), null);
    }

    public Throwable cannotBroadcastTableOverMaxTableBytesError(long maxBroadcastTableBytes, long dataSize) {
        return new SparkException("_LEGACY_ERROR_TEMP_2249", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxBroadcastTableBytes"), (Object)Utils$.MODULE$.bytesToString(maxBroadcastTableBytes)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)Utils$.MODULE$.bytesToString(dataSize))})), null);
    }

    public Throwable notEnoughMemoryToBuildAndBroadcastTableError(OutOfMemoryError oe, Seq<TableIdentifier> tables) {
        String analyzeTblMsg = tables.nonEmpty() ? new StringBuilder(35).append(" or analyze these tables through: ").append(((TraversableOnce)tables.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(34).append("ANALYZE TABLE ").append(t).append(" COMPUTE STATISTICS;").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" ")).append(".").toString() : ".";
        return new SparkException("_LEGACY_ERROR_TEMP_2250", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"autoBroadcastjoinThreshold"), (Object)SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driverMemory"), (Object)"spark.driver.memory"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"analyzeTblMsg"), (Object)analyzeTblMsg)})), oe.getCause());
    }

    public SparkUnsupportedOperationException executeCodePathUnsupportedError(String execName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2251", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"execName"), (Object)execName)})));
    }

    public SparkUnsupportedOperationException cannotMergeClassWithOtherClassError(String className, String otherClass) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2252", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"otherClass"), (Object)otherClass)})));
    }

    public SparkUnsupportedOperationException continuousProcessingUnsupportedByDataSourceError(String sourceName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2253", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceName"), (Object)sourceName)})));
    }

    public Throwable failedToReadDataError(Throwable failureReason) {
        return new SparkException("_LEGACY_ERROR_TEMP_2254", Predef$.MODULE$.Map().empty(), failureReason);
    }

    public Throwable failedToGenerateEpochMarkerError(Throwable failureReason) {
        return new SparkException("_LEGACY_ERROR_TEMP_2255", Predef$.MODULE$.Map().empty(), failureReason);
    }

    public Throwable foreachWriterAbortedDueToTaskFailureError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2256", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable incorrectRampUpRate(long rowsPerSecond, long maxSeconds, long rampUpTimeSeconds) {
        return new SparkRuntimeException("INCORRECT_RAMP_UP_RATE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowsPerSecond"), (Object)Long.toString(rowsPerSecond)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxSeconds"), (Object)Long.toString(maxSeconds)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rampUpTimeSeconds"), (Object)Long.toString(rampUpTimeSeconds))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable incorrectEndOffset(long rowsPerSecond, long maxSeconds, long endSeconds) {
        return SparkException$.MODULE$.internalError(new StringBuilder(50).append("Max offset with ").append(Long.toString(rowsPerSecond)).append(" rowsPerSecond is ").append(Long.toString(maxSeconds)).append(", ").append("but it's ").append(Long.toString(endSeconds)).append(" now.").toString());
    }

    public Throwable failedToReadDeltaFileError(Path fileToRead, String clazz, int keySize) {
        return new SparkException("_LEGACY_ERROR_TEMP_2258", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileToRead"), (Object)fileToRead.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keySize"), (Object)Integer.toString(keySize))})), null);
    }

    public Throwable failedToReadSnapshotFileError(Path fileToRead, String clazz, String message) {
        return new SparkException("_LEGACY_ERROR_TEMP_2259", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileToRead"), (Object)fileToRead.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clazz"), (Object)clazz), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)})), null);
    }

    public SparkUnsupportedOperationException cannotPurgeAsBreakInternalStateError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2260", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException cleanUpSourceFilesUnsupportedError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2261", Predef$.MODULE$.Map().empty());
    }

    public SparkUnsupportedOperationException latestOffsetNotCalledError() {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2262", Predef$.MODULE$.Map().empty());
    }

    public Throwable legacyCheckpointDirectoryExistsError(Path checkpointPath, String legacyCheckpointDir) {
        return new SparkException("_LEGACY_ERROR_TEMP_2263", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpointPath"), (Object)checkpointPath.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"legacyCheckpointDir"), (Object)legacyCheckpointDir), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"StreamingCheckpointEscapedPathCheckEnabled"), (Object)SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED().key())})), null);
    }

    public Throwable subprocessExitedError(int exitCode, CircularBuffer stderrBuffer, Throwable cause) {
        return new SparkException("_LEGACY_ERROR_TEMP_2264", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exitCode"), (Object)Integer.toString(exitCode)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stderrBuffer"), (Object)stderrBuffer.toString())})), cause);
    }

    public Throwable outputDataTypeUnsupportedByNodeWithoutSerdeError(String nodeName, DataType dt) {
        return new SparkException("_LEGACY_ERROR_TEMP_2265", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeName"), (Object)nodeName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dt"), (Object)dt.getClass().getSimpleName())})), null);
    }

    public SparkArrayIndexOutOfBoundsException invalidStartIndexError(int numRows, int startIndex) {
        return new SparkArrayIndexOutOfBoundsException("_LEGACY_ERROR_TEMP_2266", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRows"), (Object)Integer.toString(numRows)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startIndex"), (Object)Integer.toString(startIndex))})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public SparkConcurrentModificationException concurrentModificationOnExternalAppendOnlyUnsafeRowArrayError(String className) {
        return new SparkConcurrentModificationException("_LEGACY_ERROR_TEMP_2267", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)})), SparkConcurrentModificationException$.MODULE$.$lessinit$greater$default$3());
    }

    public SparkUnsupportedOperationException doExecuteBroadcastNotImplementedError(String nodeName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2268", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nodeName"), (Object)nodeName)})));
    }

    public Throwable defaultDatabaseNotExistsError(String defaultDatabase) {
        return new SparkException("DEFAULT_DATABASE_NOT_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultDatabase"), (Object)defaultDatabase)})), null);
    }

    public Throwable databaseNameConflictWithSystemPreservedDatabaseError(String globalTempDB) {
        return new SparkException("_LEGACY_ERROR_TEMP_2269", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"globalTempDB"), (Object)globalTempDB), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"globalTempDatabase"), (Object)StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE().key())})), null);
    }

    public SparkSQLFeatureNotSupportedException commentOnTableUnsupportedError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2270", Predef$.MODULE$.Map().empty());
    }

    public SparkSQLFeatureNotSupportedException unsupportedUpdateColumnNullabilityError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2271", Predef$.MODULE$.Map().empty());
    }

    public SparkSQLFeatureNotSupportedException renameColumnUnsupportedForOlderMySQLError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2272", Predef$.MODULE$.Map().empty());
    }

    public SparkException failedToExecuteQueryError(Throwable e) {
        String message = new StringBuilder(35).append("Hit an error when executing a query").append((Object)(e.getMessage() == null ? "" : new StringBuilder(2).append(": ").append(e.getMessage()).toString())).toString();
        return new SparkException("_LEGACY_ERROR_TEMP_2273", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)})), e);
    }

    public SparkUnsupportedOperationException nestedFieldUnsupportedError(String colName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2274", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)colName)})));
    }

    public Throwable transformationsAndActionsNotInvokedByDriverError() {
        return new SparkException("_LEGACY_ERROR_TEMP_2275", Predef$.MODULE$.Map().empty(), null);
    }

    public Throwable repeatedPivotsUnsupportedError(String clause, String operation) {
        return new SparkUnsupportedOperationException("REPEATED_CLAUSE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clause"), (Object)clause), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation)})));
    }

    public Throwable pivotNotAfterGroupByUnsupportedError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE.PIVOT_AFTER_GROUP_BY", Predef$.MODULE$.Map().empty());
    }

    private String aesFuncName() {
        return this.aesFuncName;
    }

    public RuntimeException invalidAesKeyLengthError(int actualLength) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE.AES_KEY_LENGTH", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId("key")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.aesFuncName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualLength"), (Object)Integer.toString(actualLength))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public RuntimeException aesModeUnsupportedError(String mode, String padding) {
        return new SparkRuntimeException("UNSUPPORTED_FEATURE.AES_MODE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)mode), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"padding"), (Object)padding), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.aesFuncName())})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public RuntimeException aesCryptoError(String detailMessage) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE.AES_KEY", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)new StringBuilder(2).append(this.toSQLId("expr")).append(", ").append(this.toSQLId("key")).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.aesFuncName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)detailMessage)})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException hiveTableWithAnsiIntervalsError(String tableName) {
        return new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_2276", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableName"), (Object)tableName)})));
    }

    public Throwable cannotConvertOrcTimestampToTimestampNTZError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE.ORC_TYPE_CAST", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orcType"), (Object)this.toSQLType(TimestampType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toType"), (Object)this.toSQLType(TimestampNTZType$.MODULE$))})));
    }

    public Throwable cannotConvertOrcTimestampNTZToTimestampLTZError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE.ORC_TYPE_CAST", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"orcType"), (Object)this.toSQLType(TimestampNTZType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toType"), (Object)this.toSQLType(TimestampType$.MODULE$))})));
    }

    public Throwable writePartitionExceedConfigSizeWhenDynamicPartitionError(int numWrittenParts, int maxDynamicPartitions, String maxDynamicPartitionsKey) {
        return new SparkException("_LEGACY_ERROR_TEMP_2277", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numWrittenParts"), (Object)Integer.toString(numWrittenParts)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxDynamicPartitionsKey"), (Object)maxDynamicPartitionsKey), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxDynamicPartitions"), (Object)Integer.toString(maxDynamicPartitions)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numWrittenParts"), (Object)Integer.toString(numWrittenParts))})), null);
    }

    public SparkIllegalArgumentException invalidNumberFormatError(String valueType, String input, String format) {
        return new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_2278", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)valueType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)input), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)format)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkUnsupportedOperationException unsupportedMultipleBucketTransformsError() {
        return new SparkUnsupportedOperationException("UNSUPPORTED_FEATURE.MULTIPLE_BUCKET_TRANSFORMS", Predef$.MODULE$.Map().empty());
    }

    public SparkSQLFeatureNotSupportedException unsupportedCreateNamespaceCommentError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2280", Predef$.MODULE$.Map().empty());
    }

    public SparkSQLFeatureNotSupportedException unsupportedRemoveNamespaceCommentError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2281", Predef$.MODULE$.Map().empty());
    }

    public SparkSQLFeatureNotSupportedException unsupportedDropNamespaceRestrictError() {
        return new SparkSQLFeatureNotSupportedException("_LEGACY_ERROR_TEMP_2282", Predef$.MODULE$.Map().empty());
    }

    public ArithmeticException timestampAddOverflowError(long micros, int amount, String unit) {
        return new SparkArithmeticException("DATETIME_OVERFLOW", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)new StringBuilder(9).append("add ").append(this.toSQLValue(BoxesRunTime.boxToInteger((int)amount), IntegerType$.MODULE$)).append(" ").append(unit).append(" to ").append(this.toSQLValue(DateTimeUtils$.MODULE$.microsToInstant(micros), TimestampType$.MODULE$)).toString())})), (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class)), "");
    }

    public Throwable invalidBucketFile(String path) {
        return new SparkException("INVALID_BUCKET_FILE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)})), null);
    }

    public Throwable multipleRowSubqueryError(SQLQueryContext context) {
        return new SparkException("SCALAR_SUBQUERY_TOO_MANY_ROWS", Predef$.MODULE$.Map().empty(), null, this.getQueryContext(context), this.getSummary(context));
    }

    public Throwable comparatorReturnsNull(String firstValue, String secondValue) {
        return new SparkException("COMPARATOR_RETURNS_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"firstValue"), (Object)firstValue), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secondValue"), (Object)secondValue)})), null);
    }

    public RuntimeException invalidPatternError(String funcName, String pattern, Throwable cause) {
        return new SparkRuntimeException("INVALID_PARAMETER_VALUE.PATTERN", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId("regexp")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(funcName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLValue(pattern, StringType$.MODULE$))})), cause, SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException tooManyArrayElementsError(int numElements, int elementSize) {
        return new SparkIllegalArgumentException("TOO_MANY_ARRAY_ELEMENTS", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numElements"), (Object)Integer.toString(numElements)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)Integer.toString(elementSize))})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public SparkIllegalArgumentException invalidEmptyLocationError(String location) {
        return new SparkIllegalArgumentException("INVALID_EMPTY_LOCATION", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)location)})), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$3(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$4(), SparkIllegalArgumentException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable malformedProtobufMessageDetectedInMessageParsingError(Throwable e) {
        return new SparkException("MALFORMED_PROTOBUF_MESSAGE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failFastMode"), (Object)FailFastMode$.MODULE$.name())})), e);
    }

    public Throwable locationAlreadyExists(TableIdentifier tableId, Path location) {
        return new SparkRuntimeException("LOCATION_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), (Object)this.toSQLValue(location.toString(), StringType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)this.toSQLId(tableId.nameParts()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
    }

    private QueryExecutionErrors$() {
        MODULE$ = this;
        QueryErrorsBase.$init$(this);
        this.aesFuncName = new StringBuilder(1).append(this.toSQLId("aes_encrypt")).append("/").append(this.toSQLId("aes_decrypt")).toString();
    }
}

