/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MicrosCalendar;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001D\u0007\u00015!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"\u0002!\u0001\t\u0003\t\u0005\u0002\u0003$\u0001\u0011\u000b\u0007I\u0011B$\t\u0011U\u0003\u0001R1A\u0005\nYCQa\u0017\u0001\u0005BqCQA\u0019\u0001\u0005B\rDQA\u0019\u0001\u0005B\u0019DQA\u0019\u0001\u0005B9DQ\u0001\u001e\u0001\u0005BU\u0014A\u0004T3hC\u000eLh)Y:u)&lWm\u001d;b[B4uN]7biR,'O\u0003\u0002\u000f\u001f\u0005!Q\u000f^5m\u0015\t\u0001\u0012#\u0001\u0005dCR\fG._:u\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"A\u0007\n\u0005\u0011j!A\u0005+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\fq\u0001]1ui\u0016\u0014h\u000e\u0005\u0002(]9\u0011\u0001\u0006\f\t\u0003Sui\u0011A\u000b\u0006\u0003We\ta\u0001\u0010:p_Rt\u0014BA\u0017\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0006\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055j\u0012A\u0002>p]\u0016LE\r\u0005\u00024q5\tAG\u0003\u00026m\u0005!A/[7f\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\ri{g.Z%e\u0003\u0019awnY1mKB\u0011AHP\u0007\u0002{)\u0011aBN\u0005\u0003\u007fu\u0012a\u0001T8dC2,\u0017A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u0012\u0001\u0011\u0015)C\u00011\u0001'\u0011\u0015\tD\u00011\u00013\u0011\u0015QD\u00011\u0001<\u000391\u0017m\u001d;ECR,gi\u001c:nCR,\u0012\u0001\u0013\t\u0003\u0013>k\u0011A\u0013\u0006\u0003k-S!\u0001T'\u0002\u000b1\fgnZ\u001a\u000b\u00059+\u0012aB2p[6|gn]\u0005\u0003!*\u0013aBR1ti\u0012\u000bG/\u001a$pe6\fG\u000f\u000b\u0002\u0006%B\u0011AdU\u0005\u0003)v\u0011\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0007\r\fG.F\u0001X!\t\u0011\u0003,\u0003\u0002Z\u001b\tqQ*[2s_N\u001c\u0015\r\\3oI\u0006\u0014\bF\u0001\u0004S\u0003\u0015\u0001\u0018M]:f)\ti\u0006\r\u0005\u0002\u001d=&\u0011q,\b\u0002\u0005\u0019>tw\rC\u0003b\u000f\u0001\u0007a%A\u0001t\u0003\u00191wN]7biR\u0011a\u0005\u001a\u0005\u0006K\"\u0001\r!X\u0001\ni&lWm\u001d;b[B$\"AJ4\t\u000b!L\u0001\u0019A5\u0002\u0005Q\u001c\bC\u00016m\u001b\u0005Y'B\u0001\n7\u0013\ti7NA\u0005US6,7\u000f^1naR\u0011ae\u001c\u0005\u0006a*\u0001\r!]\u0001\bS:\u001cH/\u00198u!\t\u0019$/\u0003\u0002ti\t9\u0011J\\:uC:$\u0018!\u0006<bY&$\u0017\r^3QCR$XM\u001d8TiJLgn\u001a\u000b\u0003mf\u0004\"\u0001H<\n\u0005al\"\u0001B+oSRDQA_\u0006A\u0002m\f1b\u00195fG.dUmZ1dsB\u0011A\u0004`\u0005\u0003{v\u0011qAQ8pY\u0016\fg\u000e")
public class LegacyFastTimestampFormatter
implements TimestampFormatter {
    private transient FastDateFormat fastDateFormat;
    private transient MicrosCalendar cal;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private volatile transient byte bitmap$trans$0;

    @Override
    public Option<Object> parseOptional(String s) throws ParseException, DateTimeParseException, DateTimeException {
        return TimestampFormatter.parseOptional$(this, s);
    }

    @Override
    public long parseWithoutTimeZone(String s, boolean allowTimeZone) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZone$(this, s, allowTimeZone);
    }

    @Override
    public Option<Object> parseWithoutTimeZoneOptional(String s, boolean allowTimeZone) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZoneOptional$(this, s, allowTimeZone);
    }

    @Override
    public final long parseWithoutTimeZone(String s) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZone$(this, s);
    }

    @Override
    public String format(LocalDateTime localDateTime) throws IllegalStateException {
        return TimestampFormatter.format$(this, localDateTime);
    }

    private FastDateFormat fastDateFormat$lzycompute() {
        LegacyFastTimestampFormatter legacyFastTimestampFormatter = this;
        synchronized (legacyFastTimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.fastDateFormat = FastDateFormat.getInstance((String)this.pattern, (TimeZone)TimeZone.getTimeZone(this.zoneId), (Locale)this.locale);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.fastDateFormat;
    }

    private FastDateFormat fastDateFormat() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.fastDateFormat$lzycompute();
        }
        return this.fastDateFormat;
    }

    private MicrosCalendar cal$lzycompute() {
        LegacyFastTimestampFormatter legacyFastTimestampFormatter = this;
        synchronized (legacyFastTimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.cal = new MicrosCalendar(this.fastDateFormat().getTimeZone(), new StringOps(Predef$.MODULE$.augmentString(this.fastDateFormat().getPattern())).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LegacyFastTimestampFormatter.$anonfun$cal$1(BoxesRunTime.unboxToChar((Object)x$8)))));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.cal;
    }

    private MicrosCalendar cal() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.cal$lzycompute();
        }
        return this.cal;
    }

    @Override
    public long parse(String s) {
        this.cal().clear();
        if (!this.fastDateFormat().parse(s, new ParsePosition(0), (Calendar)this.cal())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("'").append(s).append("' is an invalid timestamp").toString());
        }
        long micros = this.cal().getMicros();
        this.cal().set(14, 0);
        long julianMicros = Math.addExact(DateTimeUtils$.MODULE$.millisToMicros(this.cal().getTimeInMillis()), micros);
        return RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(julianMicros);
    }

    @Override
    public String format(long timestamp) {
        long julianMicros = RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timestamp);
        this.cal().setTimeInMillis(Math.floorDiv(julianMicros, 1000000L) * 1000L);
        this.cal().setMicros(Math.floorMod(julianMicros, 1000000L));
        return this.fastDateFormat().format((Calendar)this.cal());
    }

    @Override
    public String format(Timestamp ts) {
        if (ts.getNanos() == 0) {
            return this.fastDateFormat().format((Date)ts);
        }
        return this.format(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts));
    }

    @Override
    public String format(Instant instant) {
        return this.format(DateTimeUtils$.MODULE$.instantToMicros(instant));
    }

    @Override
    public void validatePatternString(boolean checkLegacy) {
        this.fastDateFormat();
    }

    public static final /* synthetic */ boolean $anonfun$cal$1(char x$8) {
        return x$8 == 'S';
    }

    public LegacyFastTimestampFormatter(String pattern, ZoneId zoneId, Locale locale) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        TimestampFormatter.$init$(this);
    }
}

