/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskKilledException;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.CodegenMetrics$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEquals;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.ByteCodeStats;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.EmptyBlock$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.expressions.codegen.SubExprEliminationState;
import org.apache.spark.sql.catalyst.expressions.codegen.VariableValue;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType$;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.util.ClassFile;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.util.concurrent.ExecutionError;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;

public final class CodeGenerator$
implements Logging {
    public static CodeGenerator$ MODULE$;
    private final LongAccumulator org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime;
    private final LoadingCache<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>> cache;
    private final Seq<String> primitiveTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CodeGenerator$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final int DEFAULT_JVM_HUGE_METHOD_LIMIT() {
        return 8000;
    }

    public final int MAX_JVM_METHOD_PARAMS_LENGTH() {
        return 255;
    }

    public final int MAX_JVM_CONSTANT_POOL_SIZE() {
        return 65535;
    }

    public final int MERGE_SPLIT_METHODS_THRESHOLD() {
        return 3;
    }

    public final int GENERATED_CLASS_SIZE_THRESHOLD() {
        return 1000000;
    }

    public final int OUTER_CLASS_VARIABLES_THRESHOLD() {
        return 10000;
    }

    public final int MUTABLESTATEARRAY_SIZE_LIMIT() {
        return 32768;
    }

    public LongAccumulator org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime() {
        return this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime;
    }

    public long compileTime() {
        return this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().sum();
    }

    public void resetCompileTime() {
        this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().reset();
    }

    public Tuple2<GeneratedClass, ByteCodeStats> compile(CodeAndComment code) {
        Tuple2 tuple2;
        try {
            tuple2 = (Tuple2)this.cache().get((Object)code);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UncheckedExecutionException ? true : throwable2 instanceof ExecutionError) {
                throw throwable2.getCause();
            }
            throw throwable;
        }
        return tuple2;
    }

    public Tuple2<GeneratedClass, ByteCodeStats> org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(CodeAndComment code) {
        ByteCodeStats byteCodeStats;
        ClassBodyEvaluator evaluator = new ClassBodyEvaluator();
        ParentClassLoader parentClassLoader = new ParentClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        evaluator.setParentClassLoader((ClassLoader)parentClassLoader);
        evaluator.setClassName("org.apache.spark.sql.catalyst.expressions.GeneratedClass");
        evaluator.setDefaultImports(new String[]{Platform.class.getName(), InternalRow.class.getName(), UnsafeRow.class.getName(), UTF8String.class.getName(), Decimal.class.getName(), CalendarInterval.class.getName(), ArrayData.class.getName(), UnsafeArrayData.class.getName(), MapData.class.getName(), UnsafeMapData.class.getName(), Expression.class.getName(), TaskContext.class.getName(), TaskKilledException.class.getName(), InputMetrics.class.getName(), new StringOps(Predef$.MODULE$.augmentString(QueryExecutionErrors$.MODULE$.getClass().getName())).stripSuffix("$")});
        evaluator.setExtendedClass(GeneratedClass.class);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
            evaluator.setDebuggingInformation(true, true, false);
            return new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString();
        });
        try {
            evaluator.cook("generated.java", code.body());
            byteCodeStats = this.updateAndGetCompilationStats(evaluator);
        }
        catch (InternalCompilerException e) {
            String msg = QueryExecutionErrors$.MODULE$.failedToCompileMsg((Exception)((Object)e));
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.internalCompilerError(e);
        }
        catch (CompileException e) {
            String msg = QueryExecutionErrors$.MODULE$.failedToCompileMsg((Exception)((Object)e));
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
            this.logGeneratedCode(code);
            throw QueryExecutionErrors$.MODULE$.compilerError(e);
        }
        ByteCodeStats codeStats = byteCodeStats;
        return new Tuple2((Object)((GeneratedClass)evaluator.getClazz().getConstructor(new Class[0]).newInstance(new Object[0])), (Object)codeStats);
    }

    private void logGeneratedCode(CodeAndComment code) {
        int maxLines = SQLConf$.MODULE$.get().loggingMaxLinesForCodegen();
        if (Utils$.MODULE$.isTesting()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, maxLines)).toString());
    }

    private ByteCodeStats updateAndGetCompilationStats(ClassBodyEvaluator evaluator) {
        Map classes = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(evaluator.getBytecodes()).asScala();
        Class codeAttr = Utils$.MODULE$.classForName("org.codehaus.janino.util.ClassFile$CodeAttribute", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        Field codeAttrField = codeAttr.getDeclaredField("code");
        codeAttrField.setAccessible(true);
        Map codeStats = (Map)classes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2.mcII.sp sp2;
                byte[] classBytes = (byte[])tuple2._2();
                int classCodeSize = classBytes.length;
                CodegenMetrics$.MODULE$.METRIC_GENERATED_CLASS_BYTECODE_SIZE().update(classCodeSize);
                try {
                    ClassFile cf = new ClassFile((InputStream)new ByteArrayInputStream(classBytes));
                    int constPoolSize = cf.getConstantPoolSize();
                    Buffer methodCodeSizes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cf.methodInfos).asScala()).flatMap((Function1 & Serializable & scala.Serializable)method -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])method.getAttributes())).filter((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)CodeGenerator$.$anonfun$updateAndGetCompilationStats$3(codeAttr$1, x$25))))).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)CodeGenerator$.$anonfun$updateAndGetCompilationStats$4(codeAttrField$1, cf$1, method, a)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))), Buffer$.MODULE$.canBuildFrom());
                    sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)methodCodeSizes.max((Ordering)Ordering.Int$.MODULE$)), constPoolSize);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error calculating stats of compiled class.", e);
                        sp2 = new Tuple2.mcII.sp(-1, -1);
                    }
                    throw throwable;
                }
                return sp2;
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = codeStats.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable maxMethodSizes = (Iterable)tuple2._1();
        Iterable constPoolSize = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)maxMethodSizes, (Object)constPoolSize);
        Iterable maxMethodSizes2 = (Iterable)tuple22._1();
        Iterable constPoolSize2 = (Iterable)tuple22._2();
        return new ByteCodeStats(BoxesRunTime.unboxToInt((Object)maxMethodSizes2.max((Ordering)Ordering.Int$.MODULE$)), BoxesRunTime.unboxToInt((Object)constPoolSize2.max((Ordering)Ordering.Int$.MODULE$)), classes.size() - 2);
    }

    private LoadingCache<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>> cache() {
        return this.cache;
    }

    public final String JAVA_BOOLEAN() {
        return "boolean";
    }

    public final String JAVA_BYTE() {
        return "byte";
    }

    public final String JAVA_SHORT() {
        return "short";
    }

    public final String JAVA_INT() {
        return "int";
    }

    public final String JAVA_LONG() {
        return "long";
    }

    public final String JAVA_FLOAT() {
        return "float";
    }

    public final String JAVA_DOUBLE() {
        return "double";
    }

    public Seq<String> primitiveTypes() {
        return this.primitiveTypes;
    }

    public boolean isPrimitiveType(String jt) {
        return this.primitiveTypes().contains((Object)jt);
    }

    public boolean isPrimitiveType(DataType dt) {
        return this.isPrimitiveType(this.javaType(dt));
    }

    public String getValue(String input, DataType dataType, String ordinal) {
        String jt;
        while (true) {
            jt = this.javaType(dataType);
            DataType dataType2 = dataType;
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (this.isPrimitiveType(jt)) {
            return new StringBuilder(6).append(input).append(".get").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(")").toString();
        }
        PhysicalDataType physicalDataType = dataType.physicalDataType();
        if (physicalDataType instanceof PhysicalArrayType) {
            return new StringBuilder(11).append(input).append(".getArray(").append(ordinal).append(")").toString();
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return new StringBuilder(12).append(input).append(".getBinary(").append(ordinal).append(")").toString();
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return new StringBuilder(14).append(input).append(".getInterval(").append(ordinal).append(")").toString();
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            PhysicalDecimalType physicalDecimalType = (PhysicalDecimalType)physicalDataType;
            return new StringBuilder(17).append(input).append(".getDecimal(").append(ordinal).append(", ").append(physicalDecimalType.precision()).append(", ").append(physicalDecimalType.scale()).append(")").toString();
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return new StringBuilder(9).append(input).append(".getMap(").append(ordinal).append(")").toString();
        }
        if (PhysicalNullType$.MODULE$.equals(physicalDataType)) {
            return "null";
        }
        if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
            return new StringBuilder(16).append(input).append(".getUTF8String(").append(ordinal).append(")").toString();
        }
        if (physicalDataType instanceof PhysicalStructType) {
            PhysicalStructType physicalStructType = (PhysicalStructType)physicalDataType;
            return new StringBuilder(14).append(input).append(".getStruct(").append(ordinal).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])physicalStructType.fields())).size()).append(")").toString();
        }
        return new StringBuilder(14).append("(").append(jt).append(")").append(input).append(".get(").append(ordinal).append(", null)").toString();
    }

    public String createArrayData(String arrayName, DataType elementType, String numElements, String additionalErrorMessage) {
        int elementSize = this.isPrimitiveType(elementType) ? elementType.defaultSize() : -1;
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(75).append("\n       |ArrayData ").append(arrayName).append(" = ArrayData.allocateArrayData(\n       |  ").append(elementSize).append(", ").append(numElements).append(", \"").append(additionalErrorMessage).append("\");\n     ").toString())).stripMargin();
    }

    public String createArrayAssignment(String dstArray, DataType elementType, String srcArray, String dstArrayIndex, String srcArrayIndex, boolean needNullCheck) {
        return this.setArrayElement(dstArray, elementType, dstArrayIndex, this.getValue(srcArray, elementType, srcArrayIndex), (Option<String>)(needNullCheck ? new Some((Object)new StringBuilder(11).append(srcArray).append(".isNullAt(").append(srcArrayIndex).append(")").toString()) : None$.MODULE$));
    }

    public String setColumn(String row, DataType dataType, int ordinal, String value) {
        DataType dataType2;
        while (true) {
            String jt = this.javaType(dataType);
            dataType2 = dataType;
            if (this.isPrimitiveType(jt)) {
                return new StringBuilder(8).append(row).append(".set").append(this.primitiveTypeName(jt)).append("(").append(ordinal).append(", ").append(value).append(")").toString();
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
                return new StringBuilder(16).append(row).append(".setInterval(").append(ordinal).append(", ").append(value).append(")").toString();
            }
            if (dataType2 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType2;
                return new StringBuilder(17).append(row).append(".setDecimal(").append(ordinal).append(", ").append(value).append(", ").append(decimalType.precision()).append(")").toString();
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        if (StringType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType))) {
            return new StringBuilder(18).append(row).append(".update(").append(ordinal).append(", ").append(value).append(".copy())").toString();
        }
        return new StringBuilder(11).append(row).append(".update(").append(ordinal).append(", ").append(value).append(")").toString();
    }

    public String updateColumn(String row, DataType dataType, int ordinal, ExprCode ev, boolean nullable, boolean isVectorized) {
        if (nullable) {
            if (!isVectorized && UnsafeRowUtils$.MODULE$.avoidSetNullAt(dataType)) {
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(this.setColumn(row, dataType, ordinal, "null")).append(";\n           |}\n         ").toString())).stripMargin();
            }
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n           |if (!").append(ev.isNull()).append(") {\n           |  ").append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";\n           |} else {\n           |  ").append(row).append(".setNullAt(").append(ordinal).append(");\n           |}\n         ").toString())).stripMargin();
        }
        return new StringBuilder(1).append(this.setColumn(row, dataType, ordinal, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public String setValue(String vector, String rowId, DataType dataType, String value) {
        String jt = this.javaType(dataType);
        DataType dataType2 = dataType;
        if (this.isPrimitiveType(jt)) {
            return new StringBuilder(9).append(vector).append(".put").append(this.primitiveTypeName(jt)).append("(").append(rowId).append(", ").append(value).append(");").toString();
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return new StringBuilder(18).append(vector).append(".putDecimal(").append(rowId).append(", ").append(value).append(", ").append(decimalType.precision()).append(");").toString();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            return new StringBuilder(17).append(vector).append(".putInterval(").append(rowId).append(", ").append(value).append(");").toString();
        }
        if (dataType2 instanceof StringType) {
            return new StringBuilder(29).append(vector).append(".putByteArray(").append(rowId).append(", ").append(value).append(".getBytes());").toString();
        }
        throw new IllegalArgumentException(new StringBuilder(43).append("cannot generate code for unsupported type: ").append(dataType).toString());
    }

    public String setArrayElement(String array, DataType elementType, String i, String value, Option<String> isNull) {
        String setFunc;
        boolean isPrimitiveType = this.isPrimitiveType(elementType);
        String string = setFunc = isPrimitiveType ? new StringBuilder(3).append("set").append(this.primitiveTypeName(elementType)).toString() : "update";
        if (isNull.isDefined() && isPrimitiveType) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         |if (").append(isNull.get()).append(") {\n         |  ").append(array).append(".setNullAt(").append(i).append(");\n         |} else {\n         |  ").append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");\n         |}\n       ").toString())).stripMargin();
        }
        return new StringBuilder(6).append(array).append(".").append(setFunc).append("(").append(i).append(", ").append(value).append(");").toString();
    }

    public Option<String> setArrayElement$default$5() {
        return None$.MODULE$;
    }

    public String updateColumn(String vector, String rowId, DataType dataType, ExprCode ev, boolean nullable) {
        if (nullable) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append("\n         |} else {\n         |  ").append(vector).append(".putNull(").append(rowId).append(");\n         |}\n       ").toString())).stripMargin();
        }
        return new StringBuilder(1).append(this.setValue(vector, rowId, dataType, ExprValue$.MODULE$.exprValueToString(ev.value()))).append(";").toString();
    }

    public boolean updateColumn$default$6() {
        return false;
    }

    public String getValueFromVector(String vector, DataType dataType, String rowId) {
        DataType sqlDataType;
        DataType dataType2;
        DataType dataType3 = dataType;
        if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        } else {
            dataType2 = sqlDataType = dataType;
        }
        if (sqlDataType instanceof StructType) {
            return new StringBuilder(12).append(vector).append(".getStruct(").append(rowId).append(")").toString();
        }
        return this.getValue(vector, sqlDataType, rowId);
    }

    public Tuple2<scala.collection.immutable.Set<VariableValue>, scala.collection.immutable.Set<ExprCode>> getLocalInputVariableValues(CodegenContext ctx, Expression expr, scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> subExprs) {
        Set argSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set exprCodesNeedEvaluate = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = ctx.INPUT_ROW() != null ? argSet.$plus$eq((Object)JavaCode$.MODULE$.variable(ctx.INPUT_ROW(), InternalRow.class)) : BoxedUnit.UNIT;
        Function1 & Serializable & scala.Serializable collectLocalVariable = (Function1 & Serializable & scala.Serializable)ev -> {
            ExprValue exprValue = ev;
            if (exprValue instanceof VariableValue) {
                VariableValue variableValue = (VariableValue)exprValue;
                return argSet.$plus$eq((Object)variableValue);
            }
            return BoxedUnit.UNIT;
        };
        Stack stack = (Stack)Stack$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expr}));
        while (stack.nonEmpty()) {
            Option option;
            Expression expression = (Expression)stack.pop();
            if (expression instanceof BoundReference) {
                BoundReference boundReference = (BoundReference)expression;
                if (ctx.currentVars() != null && ctx.currentVars().apply(boundReference.ordinal()) != null) {
                    ExprCode exprCode = (ExprCode)ctx.currentVars().apply(boundReference.ordinal());
                    Block block = exprCode.code();
                    EmptyBlock$ emptyBlock$ = EmptyBlock$.MODULE$;
                    if (block == null ? emptyBlock$ != null : !block.equals(emptyBlock$)) {
                        exprCodesNeedEvaluate.$plus$eq((Object)exprCode.copy(exprCode.copy$default$1(), exprCode.copy$default$2(), exprCode.copy$default$3()));
                        exprCode.code_$eq(EmptyBlock$.MODULE$);
                    }
                    collectLocalVariable.apply((Object)exprCode.value());
                    collectLocalVariable.apply((Object)exprCode.isNull());
                    continue;
                }
            }
            if ((option = subExprs.get((Object)new ExpressionEquals(expression))) instanceof Some) {
                Some some = (Some)option;
                SubExprEliminationState state = (SubExprEliminationState)some.value();
                collectLocalVariable.apply((Object)state.eval().value());
                collectLocalVariable.apply((Object)state.eval().isNull());
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                stack.pushAll(expression.children());
                continue;
            }
            throw new MatchError((Object)option);
        }
        return new Tuple2((Object)argSet.toSet(), (Object)exprCodesNeedEvaluate.toSet());
    }

    public scala.collection.immutable.Map<ExpressionEquals, SubExprEliminationState> getLocalInputVariableValues$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public String primitiveTypeName(String jt) {
        String string = jt;
        if ("int".equals(string)) {
            return "Int";
        }
        return this.boxedType(jt);
    }

    public String primitiveTypeName(DataType dt) {
        return this.primitiveTypeName(this.javaType(dt));
    }

    public String javaType(DataType dt) {
        DataType dataType;
        ObjectType objectType;
        boolean bl;
        while (true) {
            bl = false;
            objectType = null;
            dataType = dt;
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            bl = true;
            objectType = (ObjectType)dataType;
            Class<?> cls = objectType.cls();
            if (cls.isArray()) {
                return new StringBuilder(2).append(this.javaType(new ObjectType(cls.getComponentType()))).append("[]").toString();
            }
        }
        if (bl) {
            Class<?> cls = objectType.cls();
            return cls.getName();
        }
        PhysicalDataType physicalDataType = dt.physicalDataType();
        if (physicalDataType instanceof PhysicalArrayType) {
            return "ArrayData";
        }
        if (PhysicalBinaryType$.MODULE$.equals(physicalDataType)) {
            return "byte[]";
        }
        if (PhysicalBooleanType$.MODULE$.equals(physicalDataType)) {
            return "boolean";
        }
        if (PhysicalByteType$.MODULE$.equals(physicalDataType)) {
            return "byte";
        }
        if (PhysicalCalendarIntervalType$.MODULE$.equals(physicalDataType)) {
            return "CalendarInterval";
        }
        if (PhysicalIntegerType$.MODULE$.equals(physicalDataType)) {
            return "int";
        }
        if (physicalDataType instanceof PhysicalDecimalType) {
            return "Decimal";
        }
        if (PhysicalDoubleType$.MODULE$.equals(physicalDataType)) {
            return "double";
        }
        if (PhysicalFloatType$.MODULE$.equals(physicalDataType)) {
            return "float";
        }
        if (PhysicalLongType$.MODULE$.equals(physicalDataType)) {
            return "long";
        }
        if (physicalDataType instanceof PhysicalMapType) {
            return "MapData";
        }
        if (PhysicalShortType$.MODULE$.equals(physicalDataType)) {
            return "short";
        }
        if (PhysicalStringType$.MODULE$.equals(physicalDataType)) {
            return "UTF8String";
        }
        if (physicalDataType instanceof PhysicalStructType) {
            return "InternalRow";
        }
        return "Object";
    }

    public Class<?> javaClass(DataType dt) {
        DataType dataType;
        while (true) {
            if (BooleanType$.MODULE$.equals(dataType = dt)) {
                return Boolean.TYPE;
            }
            if (ByteType$.MODULE$.equals(dataType)) {
                return Byte.TYPE;
            }
            if (ShortType$.MODULE$.equals(dataType)) {
                return Short.TYPE;
            }
            if (IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : dataType instanceof YearMonthIntervalType)) {
                return Integer.TYPE;
            }
            if (LongType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof DayTimeIntervalType))) {
                return Long.TYPE;
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                return Float.TYPE;
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                return Double.TYPE;
            }
            if (dataType instanceof DecimalType) {
                return Decimal.class;
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return byte[].class;
            }
            if (StringType$.MODULE$.equals(dataType)) {
                return UTF8String.class;
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return CalendarInterval.class;
            }
            if (dataType instanceof StructType) {
                return InternalRow.class;
            }
            if (dataType instanceof ArrayType) {
                return ArrayData.class;
            }
            if (dataType instanceof MapType) {
                return MapData.class;
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            dt = userDefinedType.sqlType();
        }
        if (dataType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)dataType;
            Class<?> cls = objectType.cls();
            return cls;
        }
        return Object.class;
    }

    public String boxedType(String jt) {
        String string = jt;
        if ("boolean".equals(string)) {
            return "Boolean";
        }
        if ("byte".equals(string)) {
            return "Byte";
        }
        if ("short".equals(string)) {
            return "Short";
        }
        if ("int".equals(string)) {
            return "Integer";
        }
        if ("long".equals(string)) {
            return "Long";
        }
        if ("float".equals(string)) {
            return "Float";
        }
        if ("double".equals(string)) {
            return "Double";
        }
        return string;
    }

    public String boxedType(DataType dt) {
        return this.boxedType(this.javaType(dt));
    }

    public String typeName(Class<?> clazz) {
        if (clazz.isArray()) {
            return new StringBuilder(2).append(this.typeName(clazz.getComponentType())).append("[]").toString();
        }
        return clazz.getName();
    }

    public String defaultValue(String jt, boolean typedNull) {
        String string = jt;
        if ("boolean".equals(string)) {
            return "false";
        }
        if ("byte".equals(string)) {
            return "(byte)-1";
        }
        if ("short".equals(string)) {
            return "(short)-1";
        }
        if ("int".equals(string)) {
            return "-1";
        }
        if ("long".equals(string)) {
            return "-1L";
        }
        if ("float".equals(string)) {
            return "-1.0f";
        }
        if ("double".equals(string)) {
            return "-1.0";
        }
        if (typedNull) {
            return new StringBuilder(8).append("((").append(jt).append(")null)").toString();
        }
        return "null";
    }

    public String defaultValue(DataType dt, boolean typedNull) {
        return this.defaultValue(this.javaType(dt), typedNull);
    }

    public boolean defaultValue$default$2() {
        return false;
    }

    public int calculateParamLength(Seq<Expression> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToInteger((int)this.paramLengthForExpr$1(input)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int calculateParamLengthFromExprValues(Seq<ExprValue> params) {
        return 1 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToInteger((int)CodeGenerator$.paramLengthForExpr$2(input)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public boolean isValidParamLength(int paramLength) {
        String string = SQLConf$.MODULE$.get().getConfString("spark.sql.CodeGenerator.validParamLength", null);
        if (string == null ? true : "".equals(string)) {
            return paramLength <= 255;
        }
        return paramLength <= new StringOps(Predef$.MODULE$.augmentString(string)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$updateAndGetCompilationStats$3(Class codeAttr$1, ClassFile.AttributeInfo x$25) {
        return x$25.getClass() == codeAttr$1;
    }

    public static final /* synthetic */ int $anonfun$updateAndGetCompilationStats$4(Field codeAttrField$1, ClassFile cf$1, ClassFile.MethodInfo method$1, ClassFile.AttributeInfo a) {
        int byteCodeSize;
        block0: {
            byteCodeSize = ((byte[])codeAttrField$1.get(a)).length;
            CodegenMetrics$.MODULE$.METRIC_GENERATED_METHOD_BYTECODE_SIZE().update(byteCodeSize);
            if (byteCodeSize <= 8000) break block0;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Generated method too long to be JIT compiled: ").append(cf$1.getThisClassName()).append(".").append(method$1.getName()).append(" is ").append(byteCodeSize).append(" bytes").toString());
        }
        return byteCodeSize;
    }

    private final int paramLengthForExpr$1(Expression input) {
        String string = this.javaType(input.dataType());
        int javaParamLength = ("long".equals(string) ? true : "double".equals(string)) ? 2 : 1;
        return (input.nullable() ? 1 : 0) + javaParamLength;
    }

    private static final int paramLengthForExpr$2(ExprValue input) {
        boolean bl;
        Class<?> clazz = input.javaType();
        Class<Long> clazz2 = Long.TYPE;
        Class<?> clazz3 = clazz;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            bl = true;
        } else {
            Class<Double> clazz4 = Double.TYPE;
            Class<?> clazz5 = clazz;
            bl = !(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null);
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    private CodeGenerator$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime = new LongAccumulator();
        this.cache = CacheBuilder.newBuilder().maximumSize((long)SQLConf$.MODULE$.get().codegenCacheMaxEntries()).build((CacheLoader)new CacheLoader<CodeAndComment, Tuple2<GeneratedClass, ByteCodeStats>>(){

            public Tuple2<GeneratedClass, ByteCodeStats> load(CodeAndComment code) {
                long startTime = System.nanoTime();
                Tuple2<GeneratedClass, ByteCodeStats> result = CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$doCompile(code);
                long endTime = System.nanoTime();
                long duration = endTime - startTime;
                double timeMs = (double)duration / (double)1000000L;
                CodegenMetrics$.MODULE$.METRIC_SOURCE_CODE_SIZE().update(code.body().length());
                CodegenMetrics$.MODULE$.METRIC_COMPILATION_TIME().update((long)timeMs);
                CodeGenerator$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Code generated in ").append(timeMs).append(" ms").toString());
                CodeGenerator$.MODULE$.org$apache$spark$sql$catalyst$expressions$codegen$CodeGenerator$$_compileTime().add(duration);
                return result;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$load$1(double )}, serializedLambda);
            }
        });
        this.primitiveTypes = (Seq)new .colon.colon((Object)"boolean", (List)new .colon.colon((Object)"byte", (List)new .colon.colon((Object)"short", (List)new .colon.colon((Object)"int", (List)new .colon.colon((Object)"long", (List)new .colon.colon((Object)"float", (List)new .colon.colon((Object)"double", (List)Nil$.MODULE$)))))));
    }
}

