/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n\n    _FUNC_(str FROM pos[ FOR len]]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n      > SELECT _FUNC_('Spark SQL' FROM 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL' FROM -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL' FROM 5 FOR 1);\n       k\n      > SELECT _FUNC_(encode('Spark SQL', 'utf-8'), 5);\n       k SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011!\u0001\u0006A!f\u0001\n\u0003I\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000bI\u0003A\u0011A*\t\u000bI\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\t/\t\u000b\r\u0004A\u0011\t3\t\u000bM\u0004A\u0011I%\t\u000bQ\u0004A\u0011I%\t\u000bU\u0004A\u0011I%\t\u000bY\u0004A\u0011I<\t\r}\u0004A\u0011IA\u0001\u0011\u001d\ti\u0002\u0001C)\u0003?A\u0011\"!\f\u0001\u0003\u0003%\t!a\f\t\u0013\u0005]\u0002!%A\u0005\u0002\u0005e\u0002\"CA(\u0001E\u0005I\u0011AA\u001d\u0011%\t\t\u0006AI\u0001\n\u0003\tI\u0004C\u0005\u0002T\u0001\t\t\u0011\"\u0011\u0002V!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003c\u0002\u0011\u0011!C\u0001\u0003gB\u0011\"!\u001f\u0001\u0003\u0003%\t%a\u001f\t\u0013\u0005%\u0005!!A\u0005\u0002\u0005-\u0005\"CAK\u0001\u0005\u0005I\u0011IAL\u000f%\tYlIA\u0001\u0012\u0003\tiL\u0002\u0005#G\u0005\u0005\t\u0012AA`\u0011\u0019\u0011F\u0004\"\u0001\u0002N\"I\u0011q\u001a\u000f\u0002\u0002\u0013\u0015\u0013\u0011\u001b\u0005\n\u0003'd\u0012\u0011!CA\u0003+D\u0011\"!8\u001d\u0003\u0003%\t)a8\t\u0013\u0005EH$!A\u0005\n\u0005M(!C*vEN$(/\u001b8h\u0015\t!S%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u00011C\u0002\u00012kazT\t\u0005\u00023g5\t1%\u0003\u00025G\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I2\u0014BA\u001c$\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001d=\u001d\t\u0011$(\u0003\u0002<G\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aO\u0012\u0011\u0005\u0001\u001bU\"A!\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R!\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001IR\u0005\u0003\u000f\u0006\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1a\u001d;s+\u0005Q\u0005C\u0001\u001aL\u0013\ta5E\u0001\u0006FqB\u0014Xm]:j_:\fAa\u001d;sA\u0005\u0019\u0001o\\:\u0002\tA|7\u000fI\u0001\u0004Y\u0016t\u0017\u0001\u00027f]\u0002\na\u0001P5oSRtD\u0003\u0002+V-^\u0003\"A\r\u0001\t\u000b!;\u0001\u0019\u0001&\t\u000b9;\u0001\u0019\u0001&\t\u000bA;\u0001\u0019\u0001&\u0015\u0007QK&\fC\u0003I\u0011\u0001\u0007!\nC\u0003O\u0011\u0001\u0007!*\u0001\u0005eCR\fG+\u001f9f+\u0005i\u0006C\u00010b\u001b\u0005y&B\u00011(\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011wL\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002KB\u0019a-\u001c9\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u000160\u0003\u0019a$o\\8u}%\t!)\u0003\u0002<\u0003&\u0011an\u001c\u0002\u0004'\u0016\f(BA\u001eB!\tq\u0016/\u0003\u0002s?\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\ta\\XP \t\u0003\u0001fL!A_!\u0003\u0007\u0005s\u0017\u0010C\u0003}\u001d\u0001\u0007\u00010\u0001\u0004tiJLgn\u001a\u0005\u0006\u001d:\u0001\r\u0001\u001f\u0005\u0006!:\u0001\r\u0001_\u0001\nI><UM\\\"pI\u0016$b!a\u0001\u0002\u0010\u0005e\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%1%A\u0004d_\u0012,w-\u001a8\n\t\u00055\u0011q\u0001\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011C\bA\u0002\u0005M\u0011aA2uqB!\u0011QAA\u000b\u0013\u0011\t9\"a\u0002\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111D\bA\u0002\u0005\r\u0011AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004U\u0003C\t)#!\u000b\t\r\u0005\r\u0002\u00031\u0001K\u0003!qWm\u001e$jeN$\bBBA\u0014!\u0001\u0007!*A\u0005oK^\u001cVmY8oI\"1\u00111\u0006\tA\u0002)\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004U\u0003c\t\u0019$!\u000e\t\u000f!\u000b\u0002\u0013!a\u0001\u0015\"9a*\u0005I\u0001\u0002\u0004Q\u0005b\u0002)\u0012!\u0003\u0005\rAS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYDK\u0002K\u0003{Y#!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013\n\u0015AC1o]>$\u0018\r^5p]&!\u0011QJA\"\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002f\u0005m#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002lA\u0019\u0001)!\u001c\n\u0007\u0005=\u0014IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002y\u0003kB\u0011\"a\u001e\u0018\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\bE\u0003\u0002\u0000\u0005\u0015\u00050\u0004\u0002\u0002\u0002*\u0019\u00111Q!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!$\u0002\u0014B\u0019\u0001)a$\n\u0007\u0005E\u0015IA\u0004C_>dW-\u00198\t\u0011\u0005]\u0014$!AA\u0002a\fa!Z9vC2\u001cH\u0003BAG\u00033C\u0001\"a\u001e\u001b\u0003\u0003\u0005\r\u0001\u001f\u0015\u0014\u0001\u0005u\u00151UAS\u0003S\u000bY+a,\u00022\u0006U\u0016q\u0017\t\u0004e\u0005}\u0015bAAQG\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAT\u0003\t\u0005(\u0002\t\u0011!A}3UKT\"`QM$(\u000f\f\u0011q_N\\F\u0006\t7f]vK\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!_\u001a\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;!gR\f'\u000f^:!CR\u0004\u0003\r]8tA\u0002\ng\u000e\u001a\u0011jg\u0002zg\r\t7f]\u001e$\b\u000e\t1mK:\u0004G\u0006I8sAQDW\rI:mS\u000e,\u0007e\u001c4!Ef$X\rI1se\u0006L\b\u0005\u001e5bi\u0002\u001aH/\u0019:ug\u0002\nG\u000f\t1q_N\u0004\u0007%\u00198eA%\u001c\be\u001c4!Y\u0016tw\r\u001e5!A2,g\u000e\u0019\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue\u00022%kT'!a>\u001c8\f\t$P%\u0002bWM\\/^S\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aXOY:ue&tw\rI8gA\u0001\u001cHO\u001d1!i\"\fG\u000fI:uCJ$8\u000fI1uA\u0001\u0004xn\u001d1!C:$\u0007%[:!_\u001a\u0004C.\u001a8hi\"\u0004\u0003\r\\3oA2\u0002sN\u001d\u0011uQ\u0016\u00043\u000f\\5dK\u0002zg\r\t2zi\u0016\u0004\u0013M\u001d:bs\u0002\"\b.\u0019;!gR\f'\u000f^:!CR\u0004\u0003\r]8tA\u0002\ng\u000e\u001a\u0011jg\u0002zg\r\t7f]\u001e$\b\u000e\t1mK:\u0004gF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAW\u0003\rM\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eb\u0003%N\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A-\u00043+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFj\n\u0017![MJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(Y\u0001*D\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001Z'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NAUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I6!'Fc%\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001e\u0002cIU(NA5\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO\u00012%kT'!k\u00012uJ\u0015\u00112SmR\u0001\u0005\t\u0011!A\u0001\u00023N\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015f]\u000e|G-\u001a\u0015('B\f'o\u001b\u0011T#2;C\u0006I\u0014vi\u001al\u0003hJ\u0015-AUJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I6!'Fc%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA]\u00031\u0019HO]5oO~3WO\\2t\u0003%\u0019VOY:ue&tw\r\u0005\u000239M!A$!1F!!\t\u0019-!3K\u0015*#VBAAc\u0015\r\t9-Q\u0001\beVtG/[7f\u0013\u0011\tY-!2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002>\u0006AAo\\*ue&tw\r\u0006\u0002\u0002X\u0005)\u0011\r\u001d9msR9A+a6\u0002Z\u0006m\u0007\"\u0002% \u0001\u0004Q\u0005\"\u0002( \u0001\u0004Q\u0005\"\u0002) \u0001\u0004Q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\fi\u000fE\u0003A\u0003G\f9/C\u0002\u0002f\u0006\u0013aa\u00149uS>t\u0007C\u0002!\u0002j*S%*C\u0002\u0002l\u0006\u0013a\u0001V;qY\u0016\u001c\u0004\u0002CAxA\u0005\u0005\t\u0019\u0001+\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA{!\u0011\tI&a>\n\t\u0005e\u00181\f\u0002\u0007\u001f\nTWm\u0019;")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring substring) {
        return Substring$.MODULE$.unapply(substring);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.pos();
    }

    @Override
    public Expression third() {
        return this.len();
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        DataType dataType = this.str().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            return ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(string, pos, len) -> {
            DataType dataType = this.str().dataType();
            if (StringType$.MODULE$.equals(dataType)) {
                return new StringBuilder(17).append((String)string).append(".substringSQL(").append((String)pos).append(", ").append((String)len).append(")").toString();
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return new StringBuilder(19).append(ByteArray.class.getName()).append(".subStringSQL(").append((String)string).append(", ").append((String)pos).append(", ").append((String)len).append(")").toString();
            }
            throw new MatchError((Object)dataType);
        });
    }

    @Override
    public Substring withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.pos();
            }
            case 2: {
                return this.len();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

