/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0011#\u0001>B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005a!A\u0011\n\u0001BK\u0002\u0013\u0005q\t\u0003\u0005K\u0001\tE\t\u0015!\u00031\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u001dq\u0007A1A\u0005F=Dq!!\u0004\u0001A\u00035\u0001\u000f\u0003\u0006\u0002\u0010\u0001A)\u0019!C!\u0003#Aq!!\u0007\u0001\t\u0003\n\t\u0002C\u0004\u0002\u001c\u0001!\t&!\b\t\u0013\u0005%\u0002!!A\u0005\u0002\u0005-\u0002\"CA\u0019\u0001E\u0005I\u0011AA\u001a\u0011%\tI\u0005AI\u0001\n\u0003\t\u0019\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003S\u0002\u0011\u0011!C\u0001\u0003WB\u0011\"a\u001e\u0001\u0003\u0003%\t%!\u001f\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u000f\u001d\tIL\tE\u0001\u0003w3a!\t\u0012\t\u0002\u0005u\u0006BB&\u001a\t\u0003\t)\rC\u0005\u0002Hf\u0011\r\u0011\"\u0001\u0002N!A\u0011\u0011Z\r!\u0002\u0013\ty\u0005C\u0004\u0002Lf!\t!!4\t\u0013\u0005-\u0017$!A\u0005\u0002\u0006\u0005\b\"CAt3\u0005\u0005I\u0011QAu\u0011%\tY0GA\u0001\n\u0013\tiPA\u0007TKN\u001c\u0018n\u001c8XS:$wn\u001e\u0006\u0003G\u0011\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QEJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M9\u0001\u0001\r\u001b8uu\u001a\u0005CA\u00193\u001b\u0005\u0011\u0013BA\u001a#\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003cUJ!A\u000e\u0012\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\r\u001d\n\u0005e\u0012#aC+oKZ\fG.^1cY\u0016\u0004\"!M\u001e\n\u0005q\u0012#\u0001\u0005(p]N\u000bF*\u0012=qe\u0016\u001c8/[8o!\tq\u0014)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010#\n\u0005\u0015{$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0003;j[\u0016\u001cu\u000e\\;n]V\t\u0001'A\u0006uS6,7i\u001c7v[:\u0004\u0013aC4ba\u0012+(/\u0019;j_:\fAbZ1q\tV\u0014\u0018\r^5p]\u0002\na\u0001P5oSRtDcA'O\u001fB\u0011\u0011\u0007\u0001\u0005\u0006\r\u0016\u0001\r\u0001\r\u0005\u0006\u0013\u0016\u0001\r\u0001M\u0001\u0016S:\u0004X\u000f\u001e+za\u0016|e\u000eV5nK\u000e{G.^7o+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+'\u0003\u0015!\u0018\u0010]3t\u0013\t9FK\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006A1\r[5mIJ,g.F\u0001[!\rY6\r\r\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0015B\u00012@\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0007M+\u0017O\u0003\u0002c\u007f\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003!\u00042aW2S\u0003!!\u0017\r^1UsB,W#A6\u0011\u0005Mc\u0017BA7U\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048pI\u0016\u0004\u0016\r\u001e;fe:\u001cX#\u00019\u0011\u0007m\u001b\u0017\u000fE\u0002s\u0003\u000fq1a]A\u0001\u001d\t!hP\u0004\u0002v{:\u0011a\u000f \b\u0003ont!\u0001\u001f>\u000f\u0005uK\u0018\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u0011q\u0010J\u0001\u0006iJ,Wm]\u0005\u0005\u0003\u0007\t)!A\u0006Ue\u0016,\u0007+\u0019;uKJt'BA@%\u0013\u0011\tI!a\u0003\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0005\u0003\u0007\t)!A\u0007o_\u0012,\u0007+\u0019;uKJt7\u000fI\u0001\te\u0016\u001cx\u000e\u001c<fIV\u0011\u00111\u0003\t\u0004}\u0005U\u0011bAA\f\u007f\t9!i\\8mK\u0006t\u0017\u0001\u00038vY2\f'\r\\3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001\u0019\u0002 !9\u0011\u0011\u0005\bA\u0002\u0005\r\u0012a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BaWA\u0013a%\u0019\u0011qE3\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#B'\u0002.\u0005=\u0002b\u0002$\u0010!\u0003\u0005\r\u0001\r\u0005\b\u0013>\u0001\n\u00111\u00011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u000e+\u0007A\n9d\u000b\u0002\u0002:A!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013!C;oG\",7m[3e\u0015\r\t\u0019eP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA$\u0003{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA(!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\nA\u0001\\1oO*\u0011\u0011\u0011L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002^\u0005M#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002dA\u0019a(!\u001a\n\u0007\u0005\u001dtHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002n\u0005M\u0004c\u0001 \u0002p%\u0019\u0011\u0011O \u0003\u0007\u0005s\u0017\u0010C\u0005\u0002vQ\t\t\u00111\u0001\u0002d\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001f\u0011\r\u0005u\u00141QA7\u001b\t\tyHC\u0002\u0002\u0002~\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t))a \u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003'\tY\tC\u0005\u0002vY\t\t\u00111\u0001\u0002n\u00051Q-];bYN$B!a\u0005\u0002\u0012\"I\u0011QO\f\u0002\u0002\u0003\u0007\u0011Q\u000e\u0015\u0018\u0001\u0005U\u00151TAO\u0003C\u000b\u0019+a*\u0002*\u00065\u0016qVAZ\u0003k\u00032!MAL\u0013\r\tIJ\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty*\u0001B[\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b;j[\u0016|6m\u001c7v[:d\u0003eZ1q?\u0012,(/\u0019;j_:L\u0003%\f\u0011HK:,'/\u0019;fg\u0002\u001aXm]:j_:\u0004s/\u001b8e_^\u0004s-\u001b<f]\u0002\n\u0007\u0005^5nKN$\u0018-\u001c9!gB,7-\u001b4zS:<\u0007eY8mk6t\u0007%\u00198eA\u001d\f\u0007\u000f\t3ve\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!'\u0016,\u0007\u0005P1!QJ,g-\u0010\u0012iiR\u00048OO\u00180gB\f'o\u001b\u0018ba\u0006\u001c\u0007.\u001a\u0018pe\u001e|Cm\\2t_1\fG/Z:u_M$(/^2ukJ,G-L:ue\u0016\fW.\u001b8h[A\u0014xn\u001a:b[6LgnZ\u0017hk&$WM\f5u[2\u001cC/\u001f9fg6zg-\f;j[\u0016ls/\u001b8e_^\u001c(EP\u0014UsB,7\u000fI8gAQLW.\u001a\u0011xS:$wn^:(y=\ng\bI5oAM#(/^2ukJ,G\rI*ue\u0016\fW.\u001b8hA\u001d,\u0018\u000eZ3!I>\u001c\u0007EZ8sA\u0011,G/Y5mK\u0012\u0004S\r\u001f9mC:\fG/[8oA\u0005tG\rI3yC6\u0004H.Z:/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\t)+\u0001C)\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002C/[7f?\u000e|G.^7oA5\u0002C\u000b[3!G>dW/\u001c8!_J\u0004C\u000f[3!Kb\u0004(/Z:tS>t\u0007\u0005^8!kN,\u0007%Y:!i\",\u0007\u0005^5nKN$\u0018-\u001c9!M>\u0014\be^5oI><\u0018N\\4!Ef\u0004C/[7f]\u0001\"\u0006.\u001a\u0011uS6,\u0007eY8mk6t\u0007%\\;ti\u0002\u0012W\rI8gAQKW.Z:uC6\u0004H+\u001f9f])\u0001\u0003\u0005\t\u0011!A)\u0002s-\u00199`IV\u0014\u0018\r^5p]\u0002j\u0003%\u0011\u0011tiJLgn\u001a\u0011ta\u0016\u001c\u0017NZ=j]\u001e\u0004C\u000f[3!i&lWm\\;uA=4\u0007\u0005\u001e5fAM,7o]5p]\u0002\u0012X\r\u001d:fg\u0016tG/\u001a3!CN\u0004#%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XM\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!QM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC.\u001b;fe\u0006d7O\f5u[2\u001c\u0013N\u001c;feZ\fG.\f7ji\u0016\u0014\u0018\r\u001c\u0012?\u0013:$XM\u001d<bY\u0002b\u0015\u000e^3sC2dt&\u0019 !M>\u0014\b%\\8sK\u0002\"W\r^1jYNt\u0013\u0006\t4pe\u0002\"\b.\u001a\u0011gSb,G\rI4ba\u0002\"WO]1uS>tG\u0006I8s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\ng\u000eI3yaJ,7o]5p]\u0002:\b.[2iA%\u001c\b%\u00199qY&,G\r\t4pe\u0002*\u0017m\u00195!S:\u0004X\u000f\u001e\u0011b]\u0012\u0004SM^1mk\u0006$X\r\u001a\u0011u_\u0002\"\b.\u001a\u0011#S:$XM\u001d<bY\u00022\u0018\r\\;fE\u00012wN\u001d\u0011uQ\u0016\u0004C-\u001f8b[&\u001c\u0007eZ1qA\u0011,(/\u0019;j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a+\u0002\u0011oQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!g\u0016\u001c8/[8o?^Lg\u000eZ8x]M$\u0018M\u001d;-AM,7o]5p]~;\u0018N\u001c3po:*g\u000e\u001a\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJ\u0003%Q*!i\u0006\u0014\u0007&\u0019\u0017!E&\u0002sIU(V!\u0002\u0012\u0017\u0010I1-A}3UKT\"`Q\td\u0003eJ\u001b![&tW\u000f^3tO%\u0002sJ\u0015#F%\u0002\u0012\u0015\fI1-AM$\u0018M\u001d;<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n\u0015'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001d;gAJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\n\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uE*$\b\r\u0019\nc)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013IM\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ci\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00197uA\u0002\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!C2\u00023/Z:tS>twl^5oI><hf\u001d;beRd\u0003e]3tg&|gnX<j]\u0012|wOL3oI2\u00023m\\;oi\"R\u0013\u0006I1tA\rtG\u000f\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aQR4\u0007M\u0014*Y\u0001Bs%Q\u0019(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014\u0007\r\u001e1a\u001dJC\u0006\t\u0015(\u0003J:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ci\u0002\u0004gJ\u0015-A!:\u0013IM\u0014-A\u001d\u0012\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002DGO\u001a1O%\u0002\u0013i\u0015\u0011uC\nD\u0013\r\f\u0011cS\u0001:%kT+QA\tL\b%\u0019\u0017!?\u001a+fjQ0)E2\u00023)Q*FA]CUI\u0014\u0011bAu\u0002s%Q\u0019(AQCUI\u0014\u0011(k\u0001j\u0017N\\;uKN<\u0003e\u0016%F\u001d\u0002\n\u0007%\u0010\u0011(\u0003J:\u0003\u0005\u0016%F\u001d\u0002:\u0013\u0007I7j]V$Xm\n\u0011F\u0019N+\u0005eJ\u00191A5Lg.\u001e;fg\u001e\u0002SI\u0014#*A=\u0013F)\u0012*!\u0005f\u0003\u0013\r\f\u0011ti\u0006\u0014Ho\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003FJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0014HO\u001a1\u0013IR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ki\u0002\u0004'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004G\r\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!3\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aUR4\u0007M\u00052\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAY\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!a.\u0002\u000bMr#G\f\u0019\u0002\u001bM+7o]5p]^Kg\u000eZ8x!\t\t\u0014d\u0005\u0003\u001a\u0003\u007f\u001b\u0005c\u0001 \u0002B&\u0019\u00111Y \u0003\r\u0005s\u0017PU3g)\t\tY,\u0001\u0004nCJ\\WM]\u0001\b[\u0006\u00148.\u001a:!\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i\u0015qZAi\u0011\u00151U\u00041\u00011\u0011\u0019IU\u00041\u0001\u0002TB!\u0011Q[Ao\u001d\u0011\t9.!7\u0011\u0005u{\u0014bAAn\u007f\u00051\u0001K]3eK\u001aLA!!\u0018\u0002`*\u0019\u00111\\ \u0015\u000b5\u000b\u0019/!:\t\u000b\u0019s\u0002\u0019\u0001\u0019\t\u000b%s\u0002\u0019\u0001\u0019\u0002\u000fUt\u0017\r\u001d9msR!\u00111^A|!\u0015q\u0014Q^Ay\u0013\r\tyo\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000by\n\u0019\u0010\r\u0019\n\u0007\u0005UxH\u0001\u0004UkBdWM\r\u0005\t\u0003s|\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0004B!!\u0015\u0003\u0002%!!1AA*\u0005\u0019y%M[3di\u0002")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow sessionWindow) {
        return SessionWindow$.MODULE$.unapply(sessionWindow);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    private AbstractDataType inputTypeOnTimeColumn() {
        return TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyTimestampType$.MODULE$, new StructType().add(new StructField("start", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())), new StructType().add(new StructField("start", TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", TimestampNTZType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()))}));
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.timeColumn(), (List)new .colon.colon((Object)this.gapDuration(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)this.inputTypeOnTimeColumn(), (List)new .colon.colon((Object)AnyDataType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", ((Expression)this.children().head()).dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeColumn();
            }
            case 1: {
                return this.gapDuration();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.SESSION_WINDOW(), (List)Nil$.MODULE$);
    }
}

