/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.7604953758285915\n      > SELECT _FUNC_(null);\n       0.7604953758285915\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u00051\t\u0003\u0005H\u0001\tE\t\u0015!\u0003E\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015A\u0005\u0001\"\u0001N\u0011\u0015A\u0005\u0001\"\u0001O\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u00159\u0006\u0001\"\u0015Y\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015\t\b\u0001\"\u0011s\u0011\u00191\u0003\u0001\"\u0011\u0002\u0006!9\u0011q\u0003\u0001\u0005R\u0005e\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\t9\u0003AI\u0001\n\u0003\tI\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\ti\bAA\u0001\n\u0003\nyhB\u0004\u0002*\u0006B\t!a+\u0007\r\u0001\n\u0003\u0012AAW\u0011\u0019A\u0005\u0004\"\u0001\u00026\"9\u0011q\u0017\r\u0005\u0002\u0005e\u0006\"CA\\1\u0005\u0005I\u0011QA_\u0011%\t\u0019\rGI\u0001\n\u0003\t\t\u0005C\u0005\u0002Fb\t\t\u0011\"!\u0002H\"I\u0011\u0011\u001c\r\u0012\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u00037D\u0012\u0011!C\u0005\u0003;\u0014AAU1oI*\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001_MJ\u0004C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005\r\u0011Fi\u0012\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\ta\b\u0005\u00021\u007f%\u0011\u0001)\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0005iS\u0012,7+Z3e+\u0005!\u0005C\u0001\u001bF\u0013\t1UGA\u0004C_>dW-\u00198\u0002\u0013!LG-Z*fK\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002K\u00172\u0003\"\u0001\r\u0001\t\u000bq*\u0001\u0019\u0001 \t\u000f\t+\u0001\u0013!a\u0001\tR\t!\n\u0006\u0002K\u001f\")Ah\u0002a\u0001}\u0005Yq/\u001b;i\u001d\u0016<8+Z3e)\tQ%\u000bC\u0003T\u0011\u0001\u0007A+\u0001\u0003tK\u0016$\u0007C\u0001\u001bV\u0013\t1VG\u0001\u0003M_:<\u0017\u0001D3wC2Le\u000e^3s]\u0006dGCA-]!\t!$,\u0003\u0002\\k\t1Ai\\;cY\u0016DQ!X\u0005A\u0002y\u000bQ!\u001b8qkR\u0004\"a\u00181\u000e\u0003\rJ!!Y\u0012\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2\u0001\u001a6p!\t)\u0007.D\u0001g\u0015\t9\u0017%A\u0004d_\u0012,w-\u001a8\n\u0005%4'\u0001C#yaJ\u001cu\u000eZ3\t\u000b-T\u0001\u0019\u00017\u0002\u0007\r$\b\u0010\u0005\u0002f[&\u0011aN\u001a\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u0001(\u00021\u0001e\u0003\t)g/A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0002gB\u0019A\u000f`@\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=.\u0003\u0019a$o\\8u}%\ta'\u0003\u0002|k\u00059\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005!IE/\u001a:bi>\u0014(BA>6!\r!\u0014\u0011A\u0005\u0004\u0003\u0007)$aA!osV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\tB\u0004\u0003\u0002\f\u00055\u0001C\u0001<6\u0013\r\ty!N\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=Q'\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004\u0015\u0006m\u0001BBA\u000f\u001b\u0001\u0007a(\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u000b)\u000b\u0019#!\n\t\u000fqr\u0001\u0013!a\u0001}!9!I\u0004I\u0001\u0002\u0004!\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003WQ3APA\u0017W\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001dk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007R3\u0001RA\u0017\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0005\u0002N\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\f\t\u0004i\u0005u\u0013bAA0k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q0!\u001a\t\u0013\u0005\u001d4#!AA\u0002\u0005m\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002nA)\u0011qNA;\u007f6\u0011\u0011\u0011\u000f\u0006\u0004\u0003g*\u0014AC2pY2,7\r^5p]&\u0019Q0!\u001d\u0002\u0011\r\fg.R9vC2$2\u0001RA>\u0011!\t9'FA\u0001\u0002\u0004y\u0018AB3rk\u0006d7\u000fF\u0002E\u0003\u0003C\u0001\"a\u001a\u0017\u0003\u0003\u0005\ra \u0015\u0018\u0001\u0005\u0015\u00151RAG\u0003#\u000b\u0019*a&\u0002\u001a\u0006u\u0015qTAR\u0003K\u00032\u0001MAD\u0013\r\tI)\t\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty)AA\u0006?\u001a+fjQ0)7N,W\rZ/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011sC:$w.\u001c\u0011wC2,X\rI<ji\"\u0004\u0013N\u001c3fa\u0016tG-\u001a8uA\u0005tG\rI5eK:$\u0018nY1mYf\u0004C-[:ue&\u0014W\u000f^3eA!Jg&\u001b\u0018e]%\u0002SO\\5g_JlG.\u001f\u0011eSN$(/\u001b2vi\u0016$\u0007E^1mk\u0016\u001c\b%\u001b8!7Bb\u0003%M\u0015/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAK\u0003\u0005}#\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAr\u0013H\u000e\u001a:oQ\u0012\u0014(N\u00195gQ*Dg\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u00188mA\"\u0014(N\u001a8ka\u0012\u0004(N\u001d2k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.\u001e7mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003GL\u001c7aQJTgM\u001c6qIBT'O\u00196\u0015\u0001\u0002\u0013\u0001\u00028pi\u0016\f#!a'\u0002u)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\rI5oA\u001d,g.\u001a:bY\u0002\u001a\u0017m]3/\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAQ\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\t9+\u0001\u0006nCRDwLZ;oGN\fAAU1oIB\u0011\u0001\u0007G\n\u00051\u0005=\u0016\bE\u00025\u0003cK1!a-6\u0005\u0019\te.\u001f*fMR\u0011\u00111V\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0015\u0006m\u0006\"B*\u001b\u0001\u0004!F#\u0002&\u0002@\u0006\u0005\u0007\"\u0002\u001f\u001c\u0001\u0004q\u0004b\u0002\"\u001c!\u0003\u0005\r\u0001R\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u00059QO\\1qa2LH\u0003BAe\u0003+\u0004R\u0001NAf\u0003\u001fL1!!46\u0005\u0019y\u0005\u000f^5p]B)A'!5?\t&\u0019\u00111[\u001b\u0003\rQ+\b\u000f\\33\u0011!\t9.HA\u0001\u0002\u0004Q\u0015a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001c\t\u0005\u0003\u0017\n\t/\u0003\u0003\u0002d\u00065#AB(cU\u0016\u001cG\u000f")
public class Rand
extends RDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringBuilder(28).append(rngTerm).append(" = new ").append(className).append("(").append(this.seed()).append("L + partitionIndex);").toString());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(6).append("rand(").append((Object)(this.hideSeed() ? "" : this.child().sql())).append(")").toString();
    }

    @Override
    public Rand withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.hideSeed() != rand.hideSeed()) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

