/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function4;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u001c9\u0001\u0016C\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0012)A\u0005?\"A1\r\u0001BK\u0002\u0013\u0005a\f\u0003\u0005e\u0001\tE\t\u0015!\u0003`\u0011!)\u0007A!f\u0001\n\u0003q\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B0\t\u0011\u001d\u0004!Q3A\u0005\u0002yC\u0001\u0002\u001b\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\u0006S\u0002!\tA\u001b\u0005\u0006S\u0002!\t\u0001\u001d\u0005\u0006i\u0002!\t%\u001e\u0005\ny\u0002\u0001\r\u00111A\u0005\nuD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010!Q\u00111\u0004\u0001A\u0002\u0003\u0005\u000b\u0015\u0002@\t\u0017\u0005\u0015\u0002\u00011AA\u0002\u0013%\u0011q\u0005\u0005\f\u0003{\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0004C\u0006\u0002D\u0001\u0001\r\u0011!Q!\n\u0005%\u0002bCA$\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d!Y\u0011q\r\u0001A\u0002\u0003\u0005\u000b\u0015BA&\u0011)\tY\u0007\u0001a\u0001\u0002\u0004%I! \u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0007\u0003\u0006\u0002t\u0001\u0001\r\u0011!Q!\nyD!\"a\u001e\u0001\u0011\u000b\u0007I\u0011BA=\u0011%\tI\t\u0001b\u0001\n\u000b\nY\t\u0003\u0005\u0002H\u0002\u0001\u000bQBAG\u0011\u001d\tI\r\u0001C!\u0003\u0017Dq!a9\u0001\t\u0003\n)\u000fC\u0004\u0002r\u0002!\t%a=\t\u000f\u0005u\b\u0001\"\u0011\u0002J!9\u0011q \u0001\u0005R\t\u0005\u0001B\u0002B\u000f\u0001\u0011\u0005c\f\u0003\u0004\u0003 \u0001!\tE\u0018\u0005\u0007\u0005C\u0001A\u0011\t0\t\r\t\r\u0002\u0001\"\u0011_\u0011\u001d\u0011)\u0003\u0001C)\u0005OA\u0011B!\r\u0001\u0003\u0003%\tAa\r\t\u0013\tu\u0002!%A\u0005\u0002\t}\u0002\"\u0003B+\u0001E\u0005I\u0011\u0001B \u0011%\u00119\u0006AI\u0001\n\u0003\u0011y\u0004C\u0005\u0003Z\u0001\t\n\u0011\"\u0001\u0003@!I!1\f\u0001\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005G\u0002\u0011\u0011!C\u0001\u0005KB\u0011B!\u001c\u0001\u0003\u0003%\tAa\u001c\t\u0013\tM\u0004!!A\u0005B\tU\u0004\"\u0003BB\u0001\u0005\u0005I\u0011\u0001BC\u0011%\u0011y\tAA\u0001\n\u0003\u0012\tjB\u0004\u0003<bB\tA!0\u0007\r]B\u0004\u0012\u0001B`\u0011\u0019I\u0017\u0007\"\u0001\u0003H\"9!\u0011Z\u0019\u0005\u0002\t-\u0007\"\u0003Bec\u0005\u0005I\u0011\u0011Bj\u0011%\u0011i.MA\u0001\n\u0003\u0013y\u000eC\u0005\u0003rF\n\t\u0011\"\u0003\u0003t\ni!+Z4FqB\u0014V\r\u001d7bG\u0016T!!\u000f\u001e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003wq\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0019SU\n\u0016.\u0011\u0005\u001dCU\"\u0001\u001d\n\u0005%C$\u0001F)vCR,'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002H\u0017&\u0011A\n\u000f\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a*\u0015\b\u0003\u000f>K!\u0001\u0015\u001d\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u0001\u0006\b\u0005\u0002V16\taKC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIfKA\u0004Qe>$Wo\u0019;\u0011\u0005U[\u0016B\u0001/W\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019XO\u00196fGR,\u0012a\u0018\t\u0003\u000f\u0002L!!\u0019\u001d\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005tk\nTWm\u0019;!\u0003\u0019\u0011XmZ3ya\u00069!/Z4fqB\u0004\u0013a\u0001:fa\u0006!!/\u001a9!\u0003\r\u0001xn]\u0001\u0005a>\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0006W2lgn\u001c\t\u0003\u000f\u0002AQ!X\u0005A\u0002}CQaY\u0005A\u0002}CQ!Z\u0005A\u0002}CQaZ\u0005A\u0002}#Ba[9sg\")QL\u0003a\u0001?\")1M\u0003a\u0001?\")QM\u0003a\u0001?\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zu\u0005A\u0011M\\1msNL7/\u0003\u0002|q\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0005mCN$(+Z4fqV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003\u000fq\u0014AB;og\u00064W-\u0003\u0003\u0002\f\u0005\u0005!AC+U\rb\u001aFO]5oO\u0006iA.Y:u%\u0016<W\r_0%KF$B!!\u0005\u0002\u0018A\u0019Q+a\u0005\n\u0007\u0005UaK\u0001\u0003V]&$\b\u0002CA\r\u001b\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0013'\u0001\u0006mCN$(+Z4fq\u0002B3ADA\u0010!\r)\u0016\u0011E\u0005\u0004\u0003G1&!\u0003;sC:\u001c\u0018.\u001a8u\u0003\u001d\u0001\u0018\r\u001e;fe:,\"!!\u000b\u0011\t\u0005-\u0012\u0011H\u0007\u0003\u0003[QA!a\f\u00022\u0005)!/Z4fq*!\u00111GA\u001b\u0003\u0011)H/\u001b7\u000b\u0005\u0005]\u0012\u0001\u00026bm\u0006LA!a\u000f\u0002.\t9\u0001+\u0019;uKJt\u0017a\u00039biR,'O\\0%KF$B!!\u0005\u0002B!I\u0011\u0011\u0004\t\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\ta\u0006$H/\u001a:oA!\u001a\u0011#a\b\u0002\u001f1\f7\u000f\u001e*fa2\f7-Z7f]R,\"!a\u0013\u0011\t\u00055\u00131\f\b\u0005\u0003\u001f\n9\u0006E\u0002\u0002RYk!!a\u0015\u000b\u0007\u0005UC)\u0001\u0004=e>|GOP\u0005\u0004\u000332\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002^\u0005}#AB*ue&twMC\u0002\u0002ZY\u000b1\u0003\\1tiJ+\u0007\u000f\\1dK6,g\u000e^0%KF$B!!\u0005\u0002f!I\u0011\u0011D\n\u0002\u0002\u0003\u0007\u00111J\u0001\u0011Y\u0006\u001cHOU3qY\u0006\u001cW-\\3oi\u0002B3\u0001FA\u0010\u0003Ua\u0017m\u001d;SKBd\u0017mY3nK:$\u0018J\\+U\rb\n\u0011\u0004\\1tiJ+\u0007\u000f\\1dK6,g\u000e^%o+R3\u0005h\u0018\u0013fcR!\u0011\u0011CA9\u0011!\tIBFA\u0001\u0002\u0004q\u0018A\u00067bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\t\u000f\u0011)\u0007]\ty\"\u0001\u0004sKN,H\u000e^\u000b\u0003\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b)$\u0001\u0003mC:<\u0017\u0002BAC\u0003\u007f\u0012Ab\u0015;sS:<')\u001e4gKJD3\u0001GA\u0010\u00031qw\u000eZ3QCR$XM\u001d8t+\t\ti\t\u0005\u0004\u0002\u0010\u0006]\u0015Q\u0014\b\u0005\u0003#\u000b)J\u0004\u0003\u0002R\u0005M\u0015\"A,\n\u0005A3\u0016\u0002BAM\u00037\u00131aU3r\u0015\t\u0001f\u000b\u0005\u0003\u0002 \u0006\u0005g\u0002BAQ\u0003wsA!a)\u00028:!\u0011QUA[\u001d\u0011\t9+a-\u000f\t\u0005%\u0016\u0011\u0017\b\u0005\u0003W\u000byK\u0004\u0003\u0002R\u00055\u0016\"A\"\n\u0005\u0005\u0013\u0015BA A\u0013\tid(\u0003\u0002<y%\u0019\u0011\u0011\u0018\u001e\u0002\u000bQ\u0014X-Z:\n\t\u0005u\u0016qX\u0001\f)J,W\rU1ui\u0016\u0014hNC\u0002\u0002:jJA!a1\u0002F\nYAK]3f!\u0006$H/\u001a:o\u0015\u0011\ti,a0\u0002\u001b9|G-\u001a)biR,'O\\:!\u00031qW\u000f\u001c7TC\u001a,WI^1m))\ti-a5\u0002X\u0006m\u0017q\u001c\t\u0004+\u0006=\u0017bAAi-\n\u0019\u0011I\\=\t\u000f\u0005U7\u00041\u0001\u0002N\u0006\t1\u000fC\u0004\u0002Zn\u0001\r!!4\u0002\u0003ADq!!8\u001c\u0001\u0004\ti-A\u0001s\u0011\u001d\t\to\u0007a\u0001\u0003\u001b\f\u0011![\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u001d\t\u0005\u0003S\fi/\u0004\u0002\u0002l*\u0019\u00111\u0001\u001f\n\t\u0005=\u00181\u001e\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005U\bCBAH\u0003/\u000b9\u0010\u0005\u0003\u0002j\u0006e\u0018\u0002BA~\u0003W\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-A\u0005e_\u001e+gnQ8eKR1!1\u0001B\b\u00053\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u0013A\u0014aB2pI\u0016<WM\\\u0005\u0005\u0005\u001b\u00119A\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\u0011\tb\ba\u0001\u0005'\t1a\u0019;y!\u0011\u0011)A!\u0006\n\t\t]!q\u0001\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\u0011Yb\ba\u0001\u0005\u0007\t!!\u001a<\u0002\u000b\u0019L'o\u001d;\u0002\rM,7m\u001c8e\u0003\u0015!\b.\u001b:e\u0003\u00191w.\u001e:uQ\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\nW\n%\"1\u0006B\u0017\u0005_AaA!\b%\u0001\u0004y\u0006B\u0002B\u0010I\u0001\u0007q\f\u0003\u0004\u0003\"\u0011\u0002\ra\u0018\u0005\u0007\u0005G!\u0003\u0019A0\u0002\t\r|\u0007/\u001f\u000b\nW\nU\"q\u0007B\u001d\u0005wAq!X\u0013\u0011\u0002\u0003\u0007q\fC\u0004dKA\u0005\t\u0019A0\t\u000f\u0015,\u0003\u0013!a\u0001?\"9q-\nI\u0001\u0002\u0004y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0003R3a\u0018B\"W\t\u0011)\u0005\u0005\u0003\u0003H\tESB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B(-\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tM#\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B0!\u0011\tiH!\u0019\n\t\u0005u\u0013qP\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005O\u00022!\u0016B5\u0013\r\u0011YG\u0016\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001b\u0014\t\bC\u0005\u0002\u001a1\n\t\u00111\u0001\u0003h\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003xA1!\u0011\u0010B@\u0003\u001bl!Aa\u001f\u000b\u0007\tud+\u0001\u0006d_2dWm\u0019;j_:LAA!!\u0003|\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u00119I!$\u0011\u0007U\u0013I)C\u0002\u0003\fZ\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001a9\n\t\u00111\u0001\u0002N\u00061Q-];bYN$BAa\"\u0003\u0014\"I\u0011\u0011D\u0018\u0002\u0002\u0003\u0007\u0011Q\u001a\u0015\u0018\u0001\t]%Q\u0014BP\u0005G\u0013)K!+\u0003,\n=&\u0011\u0017B[\u0005o\u00032a\u0012BM\u0013\r\u0011Y\n\u000f\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t+A4`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u0004H\u0006\t:fanc\u0003\u0005]8tSRLwN\\/*A5\u0002#+\u001a9mC\u000e,7\u000fI1mY\u0002\u001aXOY:ue&twm\u001d\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t1sK\u001e,\u0007\u0010\u001d1!o&$\b\u000e\t1sKB\u0004g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012!qU\u0001\bT*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]\u0002\"x\u000eI:fCJ\u001c\u0007\u000e\t4pe\u0002\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]\u0002\u0002\u0018\r\u001e;fe:\u0004S.\u0019;dQ:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3hKb\u0004\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t&bm\u0006\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]q\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011TS:\u001cW\rI*qCJ\\\u0007E\r\u00181Y\u0001\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u001c\b\u0005K5oG2,H-\u001b8hAI,w-\u001a=!a\u0006$H/\u001a:og&\u0002\u0013M]3!k:,7oY1qK\u0012\u0004\u0013N\u001c\u0011pkJ\u00043+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:tKJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002Co\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005\f\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011g_J\u0004\u0003M]3hKb\u0004\b\rI2b]\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\trF\fX1cG\u0012\u0012c\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a:fA%\u001c\b%\u0019\u0011T#2\u00033m\u001c8gS\u001e\u0004se\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197tO\u0001\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\r\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ1mY\n\f7m\u001b\u0011u_\u0002\"\b.\u001a\u0011Ta\u0006\u00148\u000eI\u0019/m\u0001\u0012W\r[1wS>\u0014\bE]3hCJ$\u0017N\\4!gR\u0014\u0018N\\4!Y&$XM]1mAA\f'o]5oO:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5gAQDW\rI2p]\u001aLw\rI5tA\u0015t\u0017M\u00197fI2\u0002C\u000f[3!AJ,w-\u001a=qA\u0002\"\b.\u0019;!G\u0006t\u0007%\\1uG\"\u0004#\u0005X1cG\n\u0002\u0013n\u001d\u0011#=r\u000b'm\u0019\u0013#])\u0001\u0003\u0005\t\u0011!A)\u0002#/\u001a9![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007E]3qY\u0006\u001cW\rI7bi\u000eDW\r\u001a\u0011tk\n\u001cHO]5oONt#\u0002\t\u0011!A\u0001\u0002#\u0006\t9pg&$\u0018n\u001c8![\u0001\n\u0007\u0005]8tSRLg/\u001a\u0011j]R,w-\u001a:!Y&$XM]1mAQD\u0017\r\u001e\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011q_NLG/[8oA]LG\u000f[5oA\u0001\u001cHO\u001d1!i>\u0004#-Z4j]\u0002\u001aX-\u0019:dQ&twM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011eK\u001a\fW\u000f\u001c;!SN\u0004\u0013G\f\u0011JM\u0002\u0002xn]5uS>t\u0007%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004\u0013N\u001c\u0011agR\u0014\b\r\f\u0011uQ\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011agR\u0014\bM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003.\u0006\u0019&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00142aAj#\u0007\r\u0019(Y\u0001:\u0003\u0006\u0018/eW%:C\u0006I\u0014ok6<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ok6lc.^7\u000bA\u0001\nQa]5oG\u0016\f#Aa-\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\te\u0016\u0001D:ue&twm\u00184v]\u000e\u001c\u0018!\u0004*fO\u0016C\bOU3qY\u0006\u001cW\r\u0005\u0002HcM!\u0011G!1[!\r)&1Y\u0005\u0004\u0005\u000b4&AB!osJ+g\r\u0006\u0002\u0003>\u0006)\u0011\r\u001d9msR91N!4\u0003P\nE\u0007\"B/4\u0001\u0004y\u0006\"B24\u0001\u0004y\u0006\"B34\u0001\u0004yF#C6\u0003V\n]'\u0011\u001cBn\u0011\u0015iF\u00071\u0001`\u0011\u0015\u0019G\u00071\u0001`\u0011\u0015)G\u00071\u0001`\u0011\u00159G\u00071\u0001`\u0003\u001d)h.\u00199qYf$BA!9\u0003nB)QKa9\u0003h&\u0019!Q\u001d,\u0003\r=\u0003H/[8o!\u001d)&\u0011^0`?~K1Aa;W\u0005\u0019!V\u000f\u001d7fi!A!q^\u001b\u0002\u0002\u0003\u00071.A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u001f\t\u0005\u0003{\u001290\u0003\u0003\u0003z\u0006}$AB(cU\u0016\u001cG\u000f")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.pos().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"position"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(this.pos().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.pos()))}))));
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        if (posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"position"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(5).append("(0, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(posEval, this.pos().dataType()))}))));
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        if (!this.bitmap$trans$0) {
            return this.result$lzycompute();
        }
        return this.result;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            try {
                this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
            }
            catch (PatternSyntaxException e) {
                throw QueryExecutionErrors$.MODULE$.invalidPatternError(this.prettyName(), e.getPattern(), e);
            }
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position == 0 || position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                m.appendReplacement(this.result(), this.lastReplacement());
            }
            m.appendTail(this.result());
            return UTF8String.fromString((String)this.result().toString());
        }
        return s;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(subject, regexp, rep, pos) -> new StringBuilder(787).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        try {\n          ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n        } catch (java.util.regex.PatternSyntaxException e) {\n          throw QueryExecutionErrors.invalidPatternError(\"").append(this.prettyName()).append("\", e.getPattern(), e);\n        }\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      String ").append(source).append(" = ").append((String)subject).append(".toString();\n      int ").append(position).append(" = ").append((String)pos).append(" - 1;\n      if (").append(position).append(" == 0 || ").append(position).append(" < ").append(source).append(".length()) {\n        ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n        java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append(source).append(");\n        ").append(matcher).append(".region(").append(position).append(", ").append(source).append(".length());\n\n        while (").append(matcher).append(".find()) {\n          ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n        }\n        ").append(matcher).append(".appendTail(").append(termResult).append(");\n        ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n        ").append(termResult).append(" = null;\n      } else {\n        ").append(ev.value()).append(" = ").append((String)subject).append(";\n      }\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    @Override
    public Expression first() {
        return this.subject();
    }

    @Override
    public Expression second() {
        return this.regexp();
    }

    @Override
    public Expression third() {
        return this.rep();
    }

    @Override
    public Expression fourth() {
        return this.pos();
    }

    @Override
    public RegExpReplace withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.subject();
            }
            case 1: {
                return this.regexp();
            }
            case 2: {
                return this.rep();
            }
            case 3: {
                return this.pos();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.REGEXP_REPLACE(), (List)Nil$.MODULE$);
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

