/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ConvertTimezone$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimeZone;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([sourceTz, ]targetTz, sourceTs) - Converts the timestamp without time zone `sourceTs` from the `sourceTz` time zone to `targetTz`. ", arguments="\n    Arguments:\n      * sourceTz - the time zone for the input timestamp.\n                   If it is missed, the current session time zone is used as the source time zone.\n      * targetTz - the time zone to which the input timestamp should be converted\n      * sourceTs - a timestamp without time zone\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Europe/Brussels', 'America/Los_Angeles', timestamp_ntz'2021-12-06 00:00:00');\n       2021-12-05 15:00:00\n      > SELECT _FUNC_('Europe/Brussels', timestamp_ntz'2021-12-05 15:00:00');\n       2021-12-06 00:00:00\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0012%\u0001FB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011A-\t\u000bq\u0003A\u0011\t&\t\u000bu\u0003A\u0011\t&\t\u000by\u0003A\u0011\t&\t\u000b}\u0003A\u0011\t1\t\u000bI\u0004A\u0011I:\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u00111\u0005\u0001\u0005B\u0005\u0015\u0002bBA\u001c\u0001\u0011E\u0013\u0011\b\u0005\n\u0003\u000f\u0002\u0011\u0011!C\u0001\u0003\u0013B\u0011\"!\u0015\u0001#\u0003%\t!a\u0015\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005M\u0003\"CA6\u0001E\u0005I\u0011AA*\u0011%\ti\u0007AA\u0001\n\u0003\ny\u0007C\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\"I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00111\u0012\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003'C\u0011\"!)\u0001\u0003\u0003%\t!a)\t\u0013\u00055\u0006!!A\u0005B\u0005=v!CAmI\u0005\u0005\t\u0012AAn\r!\u0019C%!A\t\u0002\u0005u\u0007BB*\u001e\t\u0003\tY\u000fC\u0005\u0002nv\t\t\u0011\"\u0012\u0002p\"I\u0011\u0011_\u000f\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0003wl\u0012\u0011!CA\u0003{D\u0011Ba\u0004\u001e\u0003\u0003%IA!\u0005\u0003\u001f\r{gN^3siRKW.\u001a>p]\u0016T!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0007\u0001I2\u0014\b\u0011$\u0011\u0005M\"T\"\u0001\u0013\n\u0005U\"#!\u0005+fe:\f'/_#yaJ,7o]5p]B\u00111gN\u0005\u0003q\u0011\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003uur!aM\u001e\n\u0005q\"\u0013a\u00029bG.\fw-Z\u0005\u0003}}\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002=IA\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA!H\u0013\tA%I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005t_V\u00148-\u001a+{+\u0005Y\u0005CA\u001aM\u0013\tiEE\u0001\u0006FqB\u0014Xm]:j_:\f\u0011b]8ve\u000e,GK\u001f\u0011\u0002\u0011Q\f'oZ3u)j\f\u0011\u0002^1sO\u0016$HK\u001f\u0011\u0002\u0011M|WO]2f)N\f\u0011b]8ve\u000e,Gk\u001d\u0011\u0002\rqJg.\u001b;?)\u0011)fk\u0016-\u0011\u0005M\u0002\u0001\"B%\b\u0001\u0004Y\u0005\"B(\b\u0001\u0004Y\u0005\"B)\b\u0001\u0004YEcA+[7\")q\n\u0003a\u0001\u0017\")\u0011\u000b\u0003a\u0001\u0017\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\t\u0007c\u00012jY:\u00111\r\u001b\b\u0003I\u001el\u0011!\u001a\u0006\u0003MB\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005q\u0012\u0015B\u00016l\u0005\r\u0019V-\u001d\u0006\u0003y\t\u0003\"!\u001c9\u000e\u00039T!a\u001c\u0015\u0002\u000bQL\b/Z:\n\u0005Et'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u0001;\u0011\u00055,\u0018B\u0001<o\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG#B=}}\u0006\u0005\u0001CA!{\u0013\tY(IA\u0002B]fDQ! \bA\u0002e\fQa\u001d:d)jDQa \bA\u0002e\fQ\u0001^4u)jDa!a\u0001\u000f\u0001\u0004I\u0018AB7jGJ|7/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011BA\u000b\u0003?\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003'\tiA\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9b\u0004a\u0001\u00033\t1a\u0019;y!\u0011\tY!a\u0007\n\t\u0005u\u0011Q\u0002\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\tc\u0004a\u0001\u0003\u0013\t!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002(A!\u0011\u0011FA\u0019\u001d\u0011\tY#!\f\u0011\u0005\u0011\u0014\u0015bAA\u0018\u0005\u00061\u0001K]3eK\u001aLA!a\r\u00026\t11\u000b\u001e:j]\u001eT1!a\fC\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004V\u0003w\ty$a\u0011\t\r\u0005u\u0012\u00031\u0001L\u0003!qWm\u001e$jeN$\bBBA!#\u0001\u00071*A\u0005oK^\u001cVmY8oI\"1\u0011QI\tA\u0002-\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004V\u0003\u0017\ni%a\u0014\t\u000f%\u0013\u0002\u0013!a\u0001\u0017\"9qJ\u0005I\u0001\u0002\u0004Y\u0005bB)\u0013!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)FK\u0002L\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u0012\u0015AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\nA\u0001\\1oO*\u0011\u00111P\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005U\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAB!\r\t\u0015QQ\u0005\u0004\u0003\u000f\u0013%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA=\u0002\u000e\"I\u0011q\u0012\r\u0002\u0002\u0003\u0007\u00111Q\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0005#BAL\u0003;KXBAAM\u0015\r\tYJQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAP\u00033\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QUAV!\r\t\u0015qU\u0005\u0004\u0003S\u0013%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001fS\u0012\u0011!a\u0001s\u00061Q-];bYN$B!!*\u00022\"A\u0011qR\u000e\u0002\u0002\u0003\u0007\u0011\u0010K\f\u0001\u0003k\u000bY,!0\u0002B\u0006\r\u0017qYAe\u0003\u001b\fy-a5\u0002VB\u00191'a.\n\u0007\u0005eFEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0016!!\u0006`\rVs5i\u0018\u0015\\g>,(oY3Uu2\u0002S\f^1sO\u0016$HK\u001f\u0017!g>,(oY3Ug&\u0002S\u0006I\"p]Z,'\u000f^:!i\",\u0007\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,\u0007\u0005Y:pkJ\u001cW\rV:aA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0003m]8ve\u000e,GK\u001f1!i&lW\r\t>p]\u0016\u0004Co\u001c\u0011ai\u0006\u0014x-\u001a;Uu\u0002t\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QY\u0001\u0003f)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e]8ve\u000e,GK\u001f\u0011.AQDW\r\t;j[\u0016\u0004#p\u001c8fA\u0019|'\u000f\t;iK\u0002Jg\u000e];uAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ji\u0002J7\u000fI7jgN,G\r\f\u0011uQ\u0016\u00043-\u001e:sK:$\be]3tg&|g\u000e\t;j[\u0016\u0004#p\u001c8fA%\u001c\b%^:fI\u0002\n7\u000f\t;iK\u0002\u001ax.\u001e:dK\u0002\"\u0018.\\3!u>tWM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i\u0006\u0014x-\u001a;Uu\u0002j\u0003\u0005\u001e5fAQLW.\u001a\u0011{_:,\u0007\u0005^8!o\"L7\r\u001b\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI:i_VdG\r\t2fA\r|gN^3si\u0016$'\u0002\t\u0011!A\u0001\u0002#\u0006I:pkJ\u001cW\rV:![\u0001\n\u0007\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a3\u0002\u0003kT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ#ve>\u0004Xm\f\"skN\u001cX\r\\:(Y\u0001:\u0013)\\3sS\u000e\fw\u0006T8t?\u0006sw-\u001a7fg\u001eb\u0003\u0005^5nKN$\u0018-\u001c9`]RTxE\r\u00193c5\n$'\f\u00197AA\u0002$\b\r\u0019;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\nT&\r\u001a.aU\u0002\u0013'\u000e\u001e1ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u000bV\u0014x\u000e]30\u0005J,8o]3mg\u001eb\u0003\u0005^5nKN$\u0018-\u001c9`]RTxE\r\u00193c5\n$'\f\u00196AE*$\b\r\u0019;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\nT&\r\u001a.aY\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!\u0003\u00159'o\\;qC\t\t\t.\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005]\u0017!B\u001a/i9\u0002\u0014aD\"p]Z,'\u000f\u001e+j[\u0016TxN\\3\u0011\u0005Mj2\u0003B\u000f\u0002`\u001a\u0003\u0002\"!9\u0002h.[5*V\u0007\u0003\u0003GT1!!:C\u0003\u001d\u0011XO\u001c;j[\u0016LA!!;\u0002d\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005m\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005E\u0014!B1qa2LHcB+\u0002v\u0006]\u0018\u0011 \u0005\u0006\u0013\u0002\u0002\ra\u0013\u0005\u0006\u001f\u0002\u0002\ra\u0013\u0005\u0006#\u0002\u0002\raS\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tyPa\u0003\u0011\u000b\u0005\u0013\tA!\u0002\n\u0007\t\r!I\u0001\u0004PaRLwN\u001c\t\u0007\u0003\n\u001d1jS&\n\u0007\t%!I\u0001\u0004UkBdWm\r\u0005\t\u0005\u001b\t\u0013\u0011!a\u0001+\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005'\u0001B!a\u001d\u0003\u0016%!!qCA;\u0005\u0019y%M[3di\u0002")
public class ConvertTimezone
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression sourceTz;
    private final Expression targetTz;
    private final Expression sourceTs;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ConvertTimezone convertTimezone) {
        return ConvertTimezone$.MODULE$.unapply(convertTimezone);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ConvertTimezone> tupled() {
        return ConvertTimezone$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ConvertTimezone>>> curried() {
        return ConvertTimezone$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression sourceTz() {
        return this.sourceTz;
    }

    public Expression targetTz() {
        return this.targetTz;
    }

    public Expression sourceTs() {
        return this.sourceTs;
    }

    @Override
    public Expression first() {
        return this.sourceTz();
    }

    @Override
    public Expression second() {
        return this.targetTz();
    }

    @Override
    public Expression third() {
        return this.sourceTs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object srcTz, Object tgtTz, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.convertTimestampNtzToAnotherTz(((UTF8String)srcTz).toString(), ((UTF8String)tgtTz).toString(), BoxesRunTime.unboxToLong((Object)micros)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(srcTz, tgtTz, micros) -> new StringBuilder(59).append(dtu).append(".convertTimestampNtzToAnotherTz(").append((String)srcTz).append(".toString(), ").append((String)tgtTz).append(".toString(), ").append((String)micros).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "convert_timezone";
    }

    @Override
    public ConvertTimezone withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public ConvertTimezone copy(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        return new ConvertTimezone(sourceTz, targetTz, sourceTs);
    }

    public Expression copy$default$1() {
        return this.sourceTz();
    }

    public Expression copy$default$2() {
        return this.targetTz();
    }

    public Expression copy$default$3() {
        return this.sourceTs();
    }

    @Override
    public String productPrefix() {
        return "ConvertTimezone";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTz();
            }
            case 1: {
                return this.targetTz();
            }
            case 2: {
                return this.sourceTs();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTimezone;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTimezone)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTimezone convertTimezone = (ConvertTimezone)x$1;
        Expression expression = this.sourceTz();
        Expression expression2 = convertTimezone.sourceTz();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.targetTz();
        Expression expression4 = convertTimezone.targetTz();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.sourceTs();
        Expression expression6 = convertTimezone.sourceTs();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!convertTimezone.canEqual(this)) return false;
        return true;
    }

    public ConvertTimezone(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        this.sourceTz = sourceTz;
        this.targetTz = targetTz;
        this.sourceTs = sourceTs;
        ExpectsInputTypes.$init$(this);
    }

    public ConvertTimezone(Expression targetTz, Expression sourceTs) {
        this(new CurrentTimeZone(), targetTz, sourceTs);
    }
}

