/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayInsert$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(x, pos, val) - Places val into index pos of array x.\n      Array indices start at 1. The maximum negative index is -1 for which the function inserts\n      new element after the current last element.\n      Index above array size appends the array, or prepends the array if index is negative,\n      with 'null' elements.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, 4), 5, 5);\n       [1,2,3,4,5]\n      > SELECT _FUNC_(array(5, 4, 3, 2), -1, 1);\n       [5,4,3,2,1]\n      > SELECT _FUNC_(array(5, 3, 2, 1), -4, 4);\n       [5,4,3,2,1]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0016-\u0001fB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011!q\u0006A!f\u0001\n\u00039\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u0011\u0001\u0004!Q3A\u0005\u0002\u0005D\u0001\"\u001a\u0001\u0003\u0012\u0003\u0006IA\u0019\u0005\u0006M\u0002!\ta\u001a\u0005\u0006M\u0002!\t!\u001c\u0005\u0006c\u0002!\tE\u001d\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\tY\u0002\u0001C!\u0003;Aq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\r\u0005}\u0003\u0001\"\u0011X\u0011\u0019\t\t\u0007\u0001C!/\"1\u00111\r\u0001\u0005B]Cq!!\u001a\u0001\t\u0003\n9\u0007C\u0004\u0002z\u0001!\t%a\u001f\t\r\u0005\r\u0005\u0001\"\u0011b\u0011)\t)\t\u0001EC\u0002\u0013%\u00111\u0010\u0005\b\u0003\u001f\u0003A\u0011KAI\u0011\u001d\ty\n\u0001C!\u0003CC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007\"CAm\u0001E\u0005I\u0011AAb\u0011%\tY\u000eAI\u0001\n\u0003\t\u0019\rC\u0005\u0002^\u0002\t\n\u0011\"\u0001\u0002`\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0013Q\u001d\u0005\n\u0003k\u0004\u0011\u0011!C\u0001\u0003oD\u0011\"a@\u0001\u0003\u0003%\tA!\u0001\t\u0013\t\u001d\u0001!!A\u0005B\t%\u0001\"\u0003B\f\u0001\u0005\u0005I\u0011\u0001B\r\u0011%\u0011i\u0002AA\u0001\n\u0003\u0012ybB\u0005\u0003D1\n\t\u0011#\u0001\u0003F\u0019A1\u0006LA\u0001\u0012\u0003\u00119\u0005\u0003\u0004gK\u0011\u0005!Q\u000b\u0005\n\u0005/*\u0013\u0011!C#\u00053B\u0011Ba\u0017&\u0003\u0003%\tI!\u0018\t\u0013\t\u001dT%!A\u0005\u0002\n%\u0004\"\u0003B<K\u0005\u0005I\u0011\u0002B=\u0005-\t%O]1z\u0013:\u001cXM\u001d;\u000b\u00055r\u0013aC3yaJ,7o]5p]NT!a\f\u0019\u0002\u0011\r\fG/\u00197zgRT!!\r\u001a\u0002\u0007M\fHN\u0003\u00024i\u0005)1\u000f]1sW*\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0007\u0001\u0019\u0002\u0002\u0001\u001e?\u0003\u0012SUj\u0015\t\u0003wqj\u0011\u0001L\u0005\u0003{1\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYt(\u0003\u0002AY\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002<\u0005&\u00111\t\f\u0002\u001d\u0007>l\u0007\u000f\\3y)f\u0004X-T3sO&tw-\u0012=qe\u0016\u001c8/[8o!\t)\u0005*D\u0001G\u0015\t9\u0005'\u0001\u0004feJ|'o]\u0005\u0003\u0013\u001a\u0013q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003w-K!\u0001\u0014\u0017\u0003'M+\b\u000f]8siF+XM]=D_:$X\r\u001f;\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\u000fA\u0013x\u000eZ;diB\u0011a\nV\u0005\u0003+>\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAb\u001d:d\u0003J\u0014\u0018-_#yaJ,\u0012\u0001\u0017\t\u0003weK!A\u0017\u0017\u0003\u0015\u0015C\bO]3tg&|g.A\u0007te\u000e\f%O]1z\u000bb\u0004(\u000fI\u0001\ba>\u001cX\t\u001f9s\u0003!\u0001xn]#yaJ\u0004\u0013\u0001C5uK6,\u0005\u0010\u001d:\u0002\u0013%$X-\\#yaJ\u0004\u0013a\u00057fO\u0006\u001c\u0017PT3hCRLg/Z%oI\u0016DX#\u00012\u0011\u00059\u001b\u0017B\u00013P\u0005\u001d\u0011un\u001c7fC:\fA\u0003\\3hC\u000eLh*Z4bi&4X-\u00138eKb\u0004\u0013A\u0002\u001fj]&$h\bF\u0003iS*\\G\u000e\u0005\u0002<\u0001!)a+\u0003a\u00011\")A,\u0003a\u00011\")a,\u0003a\u00011\")\u0001-\u0003a\u0001ER!\u0001N\\8q\u0011\u00151&\u00021\u0001Y\u0011\u0015a&\u00021\u0001Y\u0011\u0015q&\u00021\u0001Y\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002gB\u0019A\u000f`@\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=9\u0003\u0019a$o\\8u}%\t\u0001+\u0003\u0002|\u001f\u00069\u0001/Y2lC\u001e,\u0017BA?\u007f\u0005\r\u0019V-\u001d\u0006\u0003w>\u0003B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u0005\u0003\u0007\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Ua&\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tI\"a\u0005\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fA!\u001a<bYR!\u0011qDA\u0013!\rq\u0015\u0011E\u0005\u0004\u0003Gy%aA!os\"I\u0011qE\u0007\u0011\u0002\u0003\u0007\u0011\u0011F\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003W\ti#D\u0001/\u0013\r\tyC\f\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002 \u0005U\u0012\u0011HA\u001f\u0011\u001d\t9D\u0004a\u0001\u0003?\t1!\u0019:s\u0011\u001d\tYD\u0004a\u0001\u0003?\t1\u0001]8t\u0011\u001d\tyD\u0004a\u0001\u0003?\tA!\u001b;f[\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u000b\n\t&a\u0017\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013-\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0014\u0002J\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002T=\u0001\r!!\u0016\u0002\u0007\r$\b\u0010\u0005\u0003\u0002H\u0005]\u0013\u0002BA-\u0003\u0013\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002^=\u0001\r!!\u0012\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u001b\u0011\t\u0005-\u00141\u000f\b\u0005\u0003[\ny\u0007\u0005\u0002w\u001f&\u0019\u0011\u0011O(\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\thT\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011Q\u0010\t\u0005\u0003\u0003\ty(\u0003\u0003\u0002\u0002\u0006\r!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u001aa#!#\u0011\u00079\u000bY)C\u0002\u0002\u000e>\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u00025\u0002\u0014\u0006]\u00151\u0014\u0005\u0007\u0003+;\u0002\u0019\u0001-\u0002\u001f9,wo\u0015:d\u0003J\u0014\u0018-_#yaJDa!!'\u0018\u0001\u0004A\u0016A\u00038foB{7/\u0012=qe\"1\u0011QT\fA\u0002a\u000b1B\\3x\u0013R,W.\u0012=qe\u0006\u0001\u0012N\\5u#V,'/_\"p]R,\u0007\u0010\u001e\u000b\u0003\u0003G\u0003RATAS\u0003SK1!a*P\u0005\u0019y\u0005\u000f^5p]B!\u00111VAY\u001b\t\tiKC\u0002\u00020:\nQ\u0001\u001e:fKNLA!a-\u0002.\ny1+\u0015'Rk\u0016\u0014\u0018pQ8oi\u0016DH/\u0001\u0003d_BLH#\u00035\u0002:\u0006m\u0016QXA`\u0011\u001d1\u0016\u0004%AA\u0002aCq\u0001X\r\u0011\u0002\u0003\u0007\u0001\fC\u0004_3A\u0005\t\u0019\u0001-\t\u000f\u0001L\u0002\u0013!a\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAcU\rA\u0016qY\u0016\u0003\u0003\u0013\u0004B!a3\u0002V6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t.A\u0005v]\u000eDWmY6fI*\u0019\u00111[(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00065'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tOK\u0002c\u0003\u000f\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAt!\u0011\tI/a=\u000e\u0005\u0005-(\u0002BAw\u0003_\fA\u0001\\1oO*\u0011\u0011\u0011_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002v\u0005-\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA}!\rq\u00151`\u0005\u0004\u0003{|%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0010\u0005\u0007A\u0011B!\u0002!\u0003\u0003\u0005\r!!?\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0001\u0005\u0004\u0003\u000e\tM\u0011qD\u0007\u0003\u0005\u001fQ1A!\u0005P\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005+\u0011yA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00012\u0003\u001c!I!Q\u0001\u0012\u0002\u0002\u0003\u0007\u0011qD\u0001\u0007KF,\u0018\r\\:\u0015\u0007\t\u0014\t\u0003C\u0005\u0003\u0006\r\n\t\u00111\u0001\u0002 !\u001a\u0002A!\n\u0003,\t5\"\u0011\u0007B\u001a\u0005o\u0011ID!\u0010\u0003@A\u00191Ha\n\n\u0007\t%BFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t=\u0012Aa'\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006\u001f\u0017!a>\u001cH\u0006\t<bY&\u0002S\u0006\t)mC\u000e,7\u000f\t<bY\u0002Jg\u000e^8!S:$W\r\u001f\u0011q_N\u0004sN\u001a\u0011beJ\f\u0017\u0010\t=/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003J\u0014\u0018-\u001f\u0011j]\u0012L7-Z:!gR\f'\u000f\u001e\u0011bi\u0002\nd\u0006\t+iK\u0002j\u0017\r_5nk6\u0004c.Z4bi&4X\rI5oI\u0016D\b%[:![E\u0002cm\u001c:!o\"L7\r\u001b\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI5og\u0016\u0014Ho\u001d\u0006!A\u0001\u0002\u0003\u0005\t8fo\u0002*G.Z7f]R\u0004\u0013M\u001a;fe\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!Y\u0006\u001cH\u000fI3mK6,g\u000e\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011J]\u0012,\u0007\u0010I1c_Z,\u0007%\u0019:sCf\u00043/\u001b>fA\u0005\u0004\b/\u001a8eg\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010\f\u0011pe\u0002\u0002(/\u001a9f]\u0012\u001c\b\u0005\u001e5fA\u0005\u0014(/Y=!S\u001a\u0004\u0013N\u001c3fq\u0002J7\u000f\t8fO\u0006$\u0018N^3-\u0015\u0001\u0002\u0003\u0005\t\u0011!o&$\b\u000eI\u0014ok2dw\u0005I3mK6,g\u000e^:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\tU\u0012!!/\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\f\u00114Y\u0001\"\u0014\u0006\f\u00116Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012Df\r\u00175YUj&\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\b&\u000e\u0017!i1\u00023\u0007\f\u00113S1\u0002S&\r\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u001b-i1\u001aDF\r\u00172;*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"*D\u0006I\u001a-AIb\u0003%M\u0015-A5\"D\u0006\t\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001ZV\u0007\f\u001b-g1\u0012D&M/\u000bA\u0001\nQa\u001a:pkB\f#Aa\u000f\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0003\nQa\r\u00185]A\n1\"\u0011:sCfLen]3siB\u00111(J\n\u0005K\t%3\u000bE\u0005\u0003L\tE\u0003\f\u0017-cQ6\u0011!Q\n\u0006\u0004\u0005\u001fz\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005'\u0012iEA\tBEN$(/Y2u\rVt7\r^5p]R\"\"A!\u0012\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013!\u0014yF!\u0019\u0003d\t\u0015\u0004\"\u0002,)\u0001\u0004A\u0006\"\u0002/)\u0001\u0004A\u0006\"\u00020)\u0001\u0004A\u0006\"\u00021)\u0001\u0004\u0011\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u0012\u0019\bE\u0003O\u0003K\u0013i\u0007E\u0004O\u0005_B\u0006\f\u00172\n\u0007\tEtJ\u0001\u0004UkBdW\r\u000e\u0005\t\u0005kJ\u0013\u0011!a\u0001Q\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005w\u0002B!!;\u0003~%!!qPAv\u0005\u0019y%M[3di\u0002")
public class ArrayInsert
extends TernaryExpression
implements ImplicitCastInputTypes,
ComplexTypeMergingExpression,
QueryErrorsBase,
SupportQueryContext {
    private transient DataType elementType;
    private final Expression srcArrayExpr;
    private final Expression posExpr;
    private final Expression itemExpr;
    private final boolean legacyNegativeIndex;
    private Option<SQLQueryContext> queryContext;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(ArrayInsert arrayInsert) {
        return ArrayInsert$.MODULE$.unapply(arrayInsert);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, ArrayInsert> tupled() {
        return ArrayInsert$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, ArrayInsert>>>> curried() {
        return ArrayInsert$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public SQLQueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, t);
    }

    @Override
    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String getSummary(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return QueryErrorsBase.getQueryContext$(this, sqlContext);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public Option<SQLQueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<SQLQueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Expression srcArrayExpr() {
        return this.srcArrayExpr;
    }

    public Expression posExpr() {
        return this.posExpr;
    }

    public Expression itemExpr() {
        return this.itemExpr;
    }

    public boolean legacyNegativeIndex() {
        return this.legacyNegativeIndex;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.srcArrayExpr().dataType(), (Object)this.posExpr().dataType(), (Object)this.itemExpr().dataType());
        if (tuple3 != null) {
            DataType dataType = (DataType)tuple3._1();
            DataType e2 = (DataType)tuple3._2();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e3);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            DataType dt = (DataType)some.value();
                            return (Seq)new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$)));
                        }
                        return (Seq)Nil$.MODULE$;
                    }
                }
            }
        }
        if (tuple3 != null) {
            return (Seq)Nil$.MODULE$;
        }
        throw new MatchError((Object)tuple3);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple3 tuple3 = new Tuple3((Object)this.first().dataType(), (Object)this.second().dataType(), (Object)this.third().dataType());
        if (tuple3 != null) {
            DataType e2 = (DataType)tuple3._2();
            if (tuple3._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType(IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.second())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType(this.second().dataType()))}))));
                }
            }
        }
        if (tuple3 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType = (DataType)tuple3._1();
            DataType e3 = (DataType)tuple3._3();
            if (dataType instanceof ArrayType && (e1 = (arrayType = (ArrayType)dataType).elementType()).sameType(e3)) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType(ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType(this.first().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType(this.third().dataType()))}))));
    }

    @Override
    public Object eval(InternalRow input) {
        Object value2;
        Object value1 = this.first().eval(input);
        if (value1 != null && (value2 = this.second().eval(input)) != null) {
            Object value3 = this.third().eval(input);
            return this.nullSafeEval(value1, value2, value3);
        }
        return null;
    }

    @Override
    public Object nullSafeEval(Object arr, Object pos, Object item) {
        boolean newPosExtendsArrayLeft;
        IntRef posInt = IntRef.create((int)BoxesRunTime.unboxToInt((Object)pos));
        if (posInt.elem == 0) {
            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
        }
        ArrayData baseArr = (ArrayData)arr;
        DataType arrayElementType = ((ArrayType)this.dataType()).elementType();
        boolean bl = newPosExtendsArrayLeft = posInt.elem < 0 && -posInt.elem > baseArr.numElements();
        if (newPosExtendsArrayLeft) {
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            int newArrayLength = -posInt.elem + baseOffset;
            if (newArrayLength > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
            }
            Object[] newArray = new Object[newArrayLength];
            baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayInsert.$anonfun$nullSafeEval$9(baseOffset, posInt, baseArr, newArray, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            newArray[0] = item;
            return new GenericArrayData(newArray);
        }
        if (posInt.elem < 0) {
            posInt.elem = posInt.elem + baseArr.numElements() + (this.legacyNegativeIndex() ? 0 : 1);
        } else if (posInt.elem > 0) {
            --posInt.elem;
        }
        int newArrayLength = package$.MODULE$.max(baseArr.numElements() + 1, posInt.elem + 1);
        if (newArrayLength > 0x7FFFFFF0) {
            throw QueryExecutionErrors$.MODULE$.concatArraysWithElementsExceedLimitError(newArrayLength);
        }
        Object[] newArray = new Object[newArrayLength];
        baseArr.foreach(arrayElementType, (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
            ArrayInsert.$anonfun$nullSafeEval$10(posInt, newArray, BoxesRunTime.unboxToInt((Object)i), v);
            return BoxedUnit.UNIT;
        });
        newArray[posInt.elem] = item;
        return new GenericArrayData(newArray);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Function3 & Serializable & scala.Serializable f = (Function3 & Serializable & scala.Serializable)(arrExpr, posExpr, itemExpr) -> {
            ExprValue arr = arrExpr.value();
            ExprValue pos = posExpr.value();
            ExprValue item = itemExpr.value();
            int baseOffset = this.legacyNegativeIndex() ? 1 : 0;
            String itemInsertionIndex = ctx.freshName("itemInsertionIndex");
            String adjustedAllocIdx = ctx.freshName("adjustedAllocIdx");
            String resLength = ctx.freshName("resLength");
            String insertedItemIsNull = ctx.freshName("insertedItemIsNull");
            String i = ctx.freshName("i");
            String j = ctx.freshName("j");
            String values = ctx.freshName("values");
            String allocation = CodeGenerator$.MODULE$.createArrayData(values, this.elementType(), resLength, new StringBuilder(8).append(this.prettyName()).append(" failed.").toString());
            String assignment = CodeGenerator$.MODULE$.createArrayAssignment(values, this.elementType(), ExprValue$.MODULE$.exprValueToString(arr), adjustedAllocIdx, i, ((ArrayType)this.first().dataType()).containsNull());
            String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1540).append("\n         |int ").append(itemInsertionIndex).append(" = 0;\n         |int ").append(resLength).append(" = 0;\n         |int ").append(adjustedAllocIdx).append(" = 0;\n         |boolean ").append(insertedItemIsNull).append(" = ").append(itemExpr.isNull()).append(";\n         |\n         |if (").append(pos).append(" == 0) {\n         |  throw QueryExecutionErrors.invalidIndexOfZeroError(").append(errorContext).append(");\n         |}\n         |\n         |if (").append(pos).append(" < 0 && (java.lang.Math.abs(").append(pos).append(") > ").append(arr).append(".numElements())) {\n         |\n         |  ").append(resLength).append(" = java.lang.Math.abs(").append(pos).append(") + ").append(baseOffset).append(";\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements());\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(" + ").append(pos).append(" + ").append(arr).append(".numElements(); ").append(j).append(" < 0; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(" + ").append(baseOffset).append(" + java.lang.Math.abs(").append(pos).append(" + ").append(arr).append(".numElements()));\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |} else {\n         |\n         |  ").append(itemInsertionIndex).append(" = 0;\n         |  if (").append(pos).append(" < 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" + ").append(arr).append(".numElements() + ").append(this.legacyNegativeIndex() ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1)).append(";\n         |  } else if (").append(pos).append(" > 0) {\n         |    ").append(itemInsertionIndex).append(" = ").append(pos).append(" - 1;\n         |  }\n         |\n         |  ").append(resLength).append(" = java.lang.Math.max(").append(arr).append(".numElements() + 1, ").append(itemInsertionIndex).append(" + 1);\n         |  if (").append(resLength).append(" > ").append(0x7FFFFFF0).append(") {\n         |    throw QueryExecutionErrors.createArrayWithElementsExceedLimitError(").append(resLength).append(");\n         |  }\n         |\n         |  ").append(allocation).append("\n         |  for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(arr).append(".numElements(); ").append(i).append(" ++) {\n         |    ").append(adjustedAllocIdx).append(" = ").append(i).append(";\n         |    if (").append(i).append(" >= ").append(itemInsertionIndex).append(") {\n         |      ").append(adjustedAllocIdx).append(" = ").append(adjustedAllocIdx).append(" + 1;\n         |    }\n         |    ").append(assignment).append("\n         |  }\n         |  ").append(CodeGenerator$.MODULE$.setArrayElement(values, this.elementType(), itemInsertionIndex, ExprValue$.MODULE$.exprValueToString(item), (Option<String>)new Some((Object)insertedItemIsNull))).append("\n         |\n         |  for (int ").append(j).append(" = ").append(arr).append(".numElements(); ").append(j).append(" < ").append(resLength).append(" - 1; ").append(j).append(" ++) {\n         |    ").append(values).append(".setNullAt(").append(j).append(");\n         |  }\n         |\n         |  ").append(ev.value()).append(" = ").append(values).append(";\n         |}\n      ").toString())).stripMargin();
        };
        ExprCode leftGen = this.first().genCode(ctx);
        ExprCode midGen = this.second().genCode(ctx);
        ExprCode rightGen = this.third().genCode(ctx);
        String resultCode = (String)f.apply((Object)leftGen, (Object)midGen, (Object)rightGen);
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(this.first().nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)midGen.code()), ctx.nullSafeExec(this.second().nullable(), ExprValue$.MODULE$.exprValueToString(midGen.isNull()), new StringBuilder(67).append("\n              ").append(rightGen.code()).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n            ").toString()))));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", "\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), midGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Expression first() {
        return this.srcArrayExpr();
    }

    @Override
    public Expression second() {
        return this.posExpr();
    }

    @Override
    public Expression third() {
        return this.itemExpr();
    }

    @Override
    public String prettyName() {
        return "array_insert";
    }

    @Override
    public DataType dataType() {
        return this.first().dataType().asNullable();
    }

    @Override
    public boolean nullable() {
        return this.first().nullable() | this.second().nullable();
    }

    private DataType elementType$lzycompute() {
        ArrayInsert arrayInsert = this;
        synchronized (arrayInsert) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.srcArrayExpr().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    private DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public ArrayInsert withNewChildrenInternal(Expression newSrcArrayExpr, Expression newPosExpr, Expression newItemExpr) {
        return this.copy(newSrcArrayExpr, newPosExpr, newItemExpr, this.copy$default$4());
    }

    @Override
    public Option<SQLQueryContext> initQueryContext() {
        return new Some((Object)this.origin().context());
    }

    public ArrayInsert copy(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        return new ArrayInsert(srcArrayExpr, posExpr, itemExpr, legacyNegativeIndex);
    }

    public Expression copy$default$1() {
        return this.srcArrayExpr();
    }

    public Expression copy$default$2() {
        return this.posExpr();
    }

    public Expression copy$default$3() {
        return this.itemExpr();
    }

    public boolean copy$default$4() {
        return this.legacyNegativeIndex();
    }

    @Override
    public String productPrefix() {
        return "ArrayInsert";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcArrayExpr();
            }
            case 1: {
                return this.posExpr();
            }
            case 2: {
                return this.itemExpr();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.legacyNegativeIndex());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayInsert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayInsert)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayInsert arrayInsert = (ArrayInsert)x$1;
        Expression expression = this.srcArrayExpr();
        Expression expression2 = arrayInsert.srcArrayExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.posExpr();
        Expression expression4 = arrayInsert.posExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.itemExpr();
        Expression expression6 = arrayInsert.itemExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.legacyNegativeIndex() != arrayInsert.legacyNegativeIndex()) return false;
        if (!arrayInsert.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$9(int baseOffset$1, IntRef posInt$1, ArrayData baseArr$1, Object[] newArray$2, int i, Object v) {
        int elementPosition = i + baseOffset$1 + package$.MODULE$.abs(posInt$1.elem + baseArr$1.numElements());
        newArray$2[elementPosition] = v;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$10(IntRef posInt$1, Object[] newArray$3, int i, Object v) {
        if (i >= posInt$1.elem) {
            newArray$3[i + 1] = v;
            return;
        }
        newArray$3[i] = v;
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr, boolean legacyNegativeIndex) {
        this.srcArrayExpr = srcArrayExpr;
        this.posExpr = posExpr;
        this.itemExpr = itemExpr;
        this.legacyNegativeIndex = legacyNegativeIndex;
        ExpectsInputTypes.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
        QueryErrorsBase.$init$(this);
        SupportQueryContext.$init$(this);
    }

    public ArrayInsert(Expression srcArrayExpr, Expression posExpr, Expression itemExpr) {
        this(srcArrayExpr, posExpr, itemExpr, SQLConf$.MODULE$.get().legacyNegativeIndexInArrayInsert());
    }
}

