/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import java.io.Serializable;
import org.apache.spark.SparkThrowable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$JSortedObject$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@Stable
public final class DataType$ {
    public static DataType$ MODULE$;
    private final Regex FIXED_DECIMAL;
    private final Regex CHAR_TYPE;
    private final Regex VARCHAR_TYPE;
    private final Map<String, DataType> otherTypes;
    private final Regex SparkGeneratedName;

    static {
        new DataType$();
    }

    private Regex FIXED_DECIMAL() {
        return this.FIXED_DECIMAL;
    }

    private Regex CHAR_TYPE() {
        return this.CHAR_TYPE;
    }

    private Regex VARCHAR_TYPE() {
        return this.VARCHAR_TYPE;
    }

    public DataType fromDDL(String ddl) {
        return this.parseTypeWithFallback(ddl, (Function1<String, DataType>)(Function1 & Serializable & scala.Serializable)sqlText -> CatalystSqlParser$.MODULE$.parseDataType((String)sqlText), (Function1<String, DataType>)(Function1 & Serializable & scala.Serializable)str -> CatalystSqlParser$.MODULE$.parseTableSchema((String)str));
    }

    public DataType parseTypeWithFallback(String schema, Function1<String, DataType> parser, Function1<String, DataType> fallbackParser) {
        DataType dataType;
        try {
            dataType = (DataType)parser.apply((Object)schema);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                try {
                    dataType = (DataType)fallbackParser.apply((Object)schema);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        if (e instanceof SparkThrowable) {
                            throw e;
                        }
                        throw QueryCompilationErrors$.MODULE$.schemaFailToParseError(schema, e);
                    }
                    throw throwable3;
                }
            }
            throw throwable;
        }
        return dataType;
    }

    public DataType fromJson(String json) {
        return this.parseDataType(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    private Map<String, DataType> otherTypes() {
        return this.otherTypes;
    }

    private DataType nameToType(String name) {
        String string = name;
        if ("decimal".equals(string)) {
            return DecimalType$.MODULE$.USER_DEFAULT();
        }
        Option option = this.FIXED_DECIMAL().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String precision = (String)((LinearSeqOptimized)option.get()).apply(0);
            String scale = (String)((LinearSeqOptimized)option.get()).apply(1);
            return new DecimalType(new StringOps(Predef$.MODULE$.augmentString(precision)).toInt(), new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
        }
        Option option2 = this.CHAR_TYPE().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
            String length = (String)((LinearSeqOptimized)option2.get()).apply(0);
            return new CharType(new StringOps(Predef$.MODULE$.augmentString(length)).toInt());
        }
        Option option3 = this.VARCHAR_TYPE().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
            String length = (String)((LinearSeqOptimized)option3.get()).apply(0);
            return new VarcharType(new StringOps(Predef$.MODULE$.augmentString(length)).toInt());
        }
        if ("null".equals(string)) {
            return NullType$.MODULE$;
        }
        if ("timestamp_ltz".equals(string)) {
            return TimestampType$.MODULE$;
        }
        return (DataType)this.otherTypes().getOrElse((Object)string, (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(52).append("Failed to convert the JSON string '").append(name).append("' to a data type.").toString());
        });
    }

    public DataType parseDataType(JsonAST.JValue json2) {
        Option<List<Tuple2<String, JsonAST.JValue>>> option;
        Option<List<Tuple2<String, JsonAST.JValue>>> option2;
        Option<List<Tuple2<String, JsonAST.JValue>>> option3;
        Option<List<Tuple2<String, JsonAST.JValue>>> option4;
        JsonAST.JValue jValue = json2;
        if (jValue instanceof JsonAST.JString) {
            JsonAST.JString jString = (JsonAST.JString)jValue;
            String name = jString.s();
            return this.nameToType(name);
        }
        Option<List<Tuple2<String, JsonAST.JValue>>> option5 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue);
        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(3) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(0);
            Tuple2 tuple22 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(1);
            Tuple2 tuple23 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(2);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue jValue2 = (JsonAST.JValue)tuple2._2();
                if ("containsNull".equals(string) && jValue2 instanceof JsonAST.JBool) {
                    JsonAST.JBool jBool = (JsonAST.JBool)jValue2;
                    boolean n = jBool.value();
                    if (tuple22 != null) {
                        String string2 = (String)tuple22._1();
                        JsonAST.JValue t = (JsonAST.JValue)tuple22._2();
                        if ("elementType".equals(string2) && t != null) {
                            JsonAST.JValue jValue3 = t;
                            if (tuple23 != null) {
                                JsonAST.JString jString;
                                String string3;
                                String string4 = (String)tuple23._1();
                                JsonAST.JValue jValue4 = (JsonAST.JValue)tuple23._2();
                                if ("type".equals(string4) && jValue4 instanceof JsonAST.JString && "array".equals(string3 = (jString = (JsonAST.JString)jValue4).s())) {
                                    return new ArrayType(this.parseDataType(jValue3), n);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!(option4 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(0);
            Tuple2 tuple24 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(1);
            Tuple2 tuple25 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(2);
            Tuple2 tuple26 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue k = (JsonAST.JValue)tuple2._2();
                if ("keyType".equals(string) && k != null) {
                    JsonAST.JValue jValue5 = k;
                    if (tuple24 != null) {
                        JsonAST.JString jString;
                        String string5;
                        String string6 = (String)tuple24._1();
                        JsonAST.JValue jValue6 = (JsonAST.JValue)tuple24._2();
                        if ("type".equals(string6) && jValue6 instanceof JsonAST.JString && "map".equals(string5 = (jString = (JsonAST.JString)jValue6).s()) && tuple25 != null) {
                            String string7 = (String)tuple25._1();
                            JsonAST.JValue jValue7 = (JsonAST.JValue)tuple25._2();
                            if ("valueContainsNull".equals(string7) && jValue7 instanceof JsonAST.JBool) {
                                JsonAST.JBool jBool = (JsonAST.JBool)jValue7;
                                boolean n = jBool.value();
                                if (tuple26 != null) {
                                    String string8 = (String)tuple26._1();
                                    JsonAST.JValue v = (JsonAST.JValue)tuple26._2();
                                    if ("valueType".equals(string8) && v != null) {
                                        JsonAST.JValue jValue8 = v;
                                        return new MapType(this.parseDataType(jValue5), this.parseDataType(jValue8), n);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!(option3 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option3.get()).apply(0);
            Tuple2 tuple27 = (Tuple2)((LinearSeqOptimized)option3.get()).apply(1);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue jValue9 = (JsonAST.JValue)tuple2._2();
                if ("fields".equals(string) && jValue9 instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue9;
                    List fields = jArray.arr();
                    if (tuple27 != null) {
                        JsonAST.JString jString;
                        String string9;
                        String string10 = (String)tuple27._1();
                        JsonAST.JValue jValue10 = (JsonAST.JValue)tuple27._2();
                        if ("type".equals(string10) && jValue10 instanceof JsonAST.JString && "struct".equals(string9 = (jString = (JsonAST.JString)jValue10).s())) {
                            return StructType$.MODULE$.apply((Seq<StructField>)((Seq)fields.map((Function1 & Serializable & scala.Serializable)json -> MODULE$.parseStructField((JsonAST.JValue)json), List$.MODULE$.canBuildFrom())));
                        }
                    }
                }
            }
        }
        if (!(option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(0);
            Tuple2 tuple28 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(1);
            Tuple2 tuple29 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(2);
            Tuple2 tuple210 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue jValue11 = (JsonAST.JValue)tuple2._2();
                if ("class".equals(string) && jValue11 instanceof JsonAST.JString) {
                    String string11;
                    String string12;
                    JsonAST.JString jString = (JsonAST.JString)jValue11;
                    String udtClass = jString.s();
                    if (tuple28 != null && "pyClass".equals(string12 = (String)tuple28._1()) && tuple29 != null && "sqlType".equals(string11 = (String)tuple29._1()) && tuple210 != null) {
                        JsonAST.JString jString2;
                        String string13;
                        String string14 = (String)tuple210._1();
                        JsonAST.JValue jValue12 = (JsonAST.JValue)tuple210._2();
                        if ("type".equals(string14) && jValue12 instanceof JsonAST.JString && "udt".equals(string13 = (jString2 = (JsonAST.JString)jValue12).s())) {
                            return (DataType)Utils$.MODULE$.classForName(udtClass, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                }
            }
        }
        if (!(option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option.get()).apply(0);
            Tuple2 tuple211 = (Tuple2)((LinearSeqOptimized)option.get()).apply(1);
            Tuple2 tuple212 = (Tuple2)((LinearSeqOptimized)option.get()).apply(2);
            Tuple2 tuple213 = (Tuple2)((LinearSeqOptimized)option.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue jValue13 = (JsonAST.JValue)tuple2._2();
                if ("pyClass".equals(string) && jValue13 instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue13;
                    String pyClass = jString.s();
                    if (tuple211 != null) {
                        String string15 = (String)tuple211._1();
                        JsonAST.JValue jValue14 = (JsonAST.JValue)tuple211._2();
                        if ("serializedClass".equals(string15) && jValue14 instanceof JsonAST.JString) {
                            JsonAST.JString jString3 = (JsonAST.JString)jValue14;
                            String serialized = jString3.s();
                            if (tuple212 != null) {
                                String string16 = (String)tuple212._1();
                                JsonAST.JValue v = (JsonAST.JValue)tuple212._2();
                                if ("sqlType".equals(string16) && v != null) {
                                    JsonAST.JValue jValue15 = v;
                                    if (tuple213 != null) {
                                        JsonAST.JString jString4;
                                        String string17;
                                        String string18 = (String)tuple213._1();
                                        JsonAST.JValue jValue16 = (JsonAST.JValue)tuple213._2();
                                        if ("type".equals(string18) && jValue16 instanceof JsonAST.JString && "udt".equals(string17 = (jString4 = (JsonAST.JString)jValue16).s())) {
                                            return new PythonUserDefinedType(this.parseDataType(jValue15), pyClass, serialized);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        JsonAST.JValue x$1 = jValue;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
        throw new IllegalArgumentException(new StringBuilder(52).append("Failed to convert the JSON string '").append(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2))).append("' to a data type.").toString());
    }

    private StructField parseStructField(JsonAST.JValue json) {
        Option<List<Tuple2<String, JsonAST.JValue>>> option;
        JsonAST.JValue jValue = json;
        Option<List<Tuple2<String, JsonAST.JValue>>> option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(0);
            Tuple2 tuple22 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(1);
            Tuple2 tuple23 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(2);
            Tuple2 tuple24 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(3);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue metadata = (JsonAST.JValue)tuple2._2();
                if ("metadata".equals(string) && metadata instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)metadata;
                    if (tuple22 != null) {
                        String string2 = (String)tuple22._1();
                        JsonAST.JValue jValue2 = (JsonAST.JValue)tuple22._2();
                        if ("name".equals(string2) && jValue2 instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue2;
                            String name = jString.s();
                            if (tuple23 != null) {
                                String string3 = (String)tuple23._1();
                                JsonAST.JValue jValue3 = (JsonAST.JValue)tuple23._2();
                                if ("nullable".equals(string3) && jValue3 instanceof JsonAST.JBool) {
                                    JsonAST.JBool jBool = (JsonAST.JBool)jValue3;
                                    boolean nullable = jBool.value();
                                    if (tuple24 != null) {
                                        String string4 = (String)tuple24._1();
                                        JsonAST.JValue dataType = (JsonAST.JValue)tuple24._2();
                                        if ("type".equals(string4) && dataType != null) {
                                            JsonAST.JValue jValue4 = dataType;
                                            return new StructField(name, this.parseDataType(jValue4), nullable, Metadata$.MODULE$.fromJObject(jObject));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!(option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option.get()).apply(0);
            Tuple2 tuple25 = (Tuple2)((LinearSeqOptimized)option.get()).apply(1);
            Tuple2 tuple26 = (Tuple2)((LinearSeqOptimized)option.get()).apply(2);
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                JsonAST.JValue jValue5 = (JsonAST.JValue)tuple2._2();
                if ("name".equals(string) && jValue5 instanceof JsonAST.JString) {
                    JsonAST.JString jString = (JsonAST.JString)jValue5;
                    String name = jString.s();
                    if (tuple25 != null) {
                        String string5 = (String)tuple25._1();
                        JsonAST.JValue jValue6 = (JsonAST.JValue)tuple25._2();
                        if ("nullable".equals(string5) && jValue6 instanceof JsonAST.JBool) {
                            JsonAST.JBool jBool = (JsonAST.JBool)jValue6;
                            boolean nullable = jBool.value();
                            if (tuple26 != null) {
                                String string6 = (String)tuple26._1();
                                JsonAST.JValue dataType = (JsonAST.JValue)tuple26._2();
                                if ("type".equals(string6) && dataType != null) {
                                    JsonAST.JValue jValue7 = dataType;
                                    return new StructField(name, this.parseDataType(jValue7), nullable, StructField$.MODULE$.apply$default$4());
                                }
                            }
                        }
                    }
                }
            }
        }
        JsonAST.JValue x$1 = jValue;
        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
        throw new IllegalArgumentException(new StringBuilder(48).append("Failed to convert the JSON string '").append(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2))).append("' to a field.").toString());
    }

    public void buildFormattedString(DataType dataType, String prefix, StringUtils.StringConcat stringConcat, int maxDepth) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            arrayType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            structType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            mapType.buildFormattedString(prefix, stringConcat, maxDepth - 1);
            return;
        }
    }

    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        Tuple2 tuple2;
        block8: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)left, (Object)right)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType leftElementType = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType rightElementType;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            right = rightElementType = arrayType2.elementType();
                            left = leftElementType;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block8;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block8;
                MapType mapType = (MapType)dataType;
                DataType leftKeyType = mapType.keyType();
                DataType leftValueType = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block8;
                MapType mapType2 = (MapType)dataType3;
                DataType rightKeyType = mapType2.keyType();
                DataType rightValueType = mapType2.valueType();
                if (!this.equalsIgnoreNullability(leftKeyType, rightKeyType)) break;
                right = rightValueType;
                left = leftValueType;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] leftFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] rightFields = structType2.fields();
                    return leftFields.length == rightFields.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])leftFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rightFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreNullability$1(x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType l = (DataType)tuple2._1();
            DataType r = (DataType)tuple2._2();
            DataType dataType = l;
            DataType dataType5 = r;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsIgnoreCompatibleNullability(DataType from, DataType to) {
        return this.equalsIgnoreCompatibleNullability(from, to, false);
    }

    public boolean equalsIgnoreNameAndCompatibleNullability(DataType from, DataType to) {
        return this.equalsIgnoreCompatibleNullability(from, to, true);
    }

    private boolean equalsIgnoreCompatibleNullability(DataType from, DataType to, boolean ignoreName) {
        Tuple2 tuple2;
        block9: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType fromElement = arrayType.elementType();
                        boolean fn = arrayType.containsNull();
                        if (dataType2 instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            DataType toElement = arrayType2.elementType();
                            boolean tn = arrayType2.containsNull();
                            if (tn || !fn) {
                                to = toElement;
                                from = fromElement;
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (tuple2 == null) break block9;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block9;
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                boolean fn = mapType.valueContainsNull();
                if (!(dataType3 instanceof MapType)) break block9;
                MapType mapType2 = (MapType)dataType3;
                DataType toKey = mapType2.keyType();
                DataType toValue = mapType2.valueType();
                boolean tn = mapType2.valueContainsNull();
                if (!tn && fn || !this.equalsIgnoreCompatibleNullability(fromKey, toKey, ignoreName)) break;
                to = toValue;
                from = fromValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreCompatibleNullability$1(ignoreName, x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType5 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    private boolean equalsIgnoreCompatibleNullability$default$3() {
        return false;
    }

    public boolean equalsIgnoreCaseAndNullability(DataType from, DataType to) {
        Tuple2 tuple2;
        block8: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType fromElement = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType toElement;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            to = toElement = arrayType2.elementType();
                            from = fromElement;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block8;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block8;
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block8;
                MapType mapType2 = (MapType)dataType3;
                DataType toKey = mapType2.keyType();
                DataType toValue = mapType2.valueType();
                if (!this.equalsIgnoreCaseAndNullability(fromKey, toKey)) break;
                to = toValue;
                from = fromValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsIgnoreCaseAndNullability$1(x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType5 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType5) : dataType5 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsStructurally(DataType from, DataType to, boolean ignoreNullability) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType left = (DataType)tuple2._1();
            DataType right = (DataType)tuple2._2();
            if (left instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)left;
                if (right instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)right;
                    return this.equalsStructurally(arrayType.elementType(), arrayType2.elementType(), ignoreNullability) && (ignoreNullability || arrayType.containsNull() == arrayType2.containsNull());
                }
            }
        }
        if (tuple2 != null) {
            DataType left = (DataType)tuple2._1();
            DataType right = (DataType)tuple2._2();
            if (left instanceof MapType) {
                MapType mapType = (MapType)left;
                if (right instanceof MapType) {
                    MapType mapType2 = (MapType)right;
                    return this.equalsStructurally(mapType.keyType(), mapType2.keyType(), ignoreNullability) && this.equalsStructurally(mapType.valueType(), mapType2.valueType(), ignoreNullability) && (ignoreNullability || mapType.valueContainsNull() == mapType2.valueContainsNull());
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsStructurally$1(ignoreNullability, x0$1)));
                }
            }
        }
        if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType3 = toDataType;
            return !(dataType != null ? !dataType.equals(dataType3) : dataType3 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsStructurally$default$3() {
        return false;
    }

    public boolean equalsStructurallyByName(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2;
        block7: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                    DataType left = (DataType)tuple2._1();
                    DataType right = (DataType)tuple2._2();
                    if (left instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)left;
                        if (right instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)right;
                            to = arrayType2.elementType();
                            from = arrayType.elementType();
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block7;
                DataType left = (DataType)tuple2._1();
                DataType right = (DataType)tuple2._2();
                if (!(left instanceof MapType)) break block7;
                MapType mapType = (MapType)left;
                if (!(right instanceof MapType)) break block7;
                MapType mapType2 = (MapType)right;
                if (!this.equalsStructurallyByName(mapType.keyType(), mapType2.keyType(), resolver)) break;
                to = mapType2.valueType();
                from = mapType.valueType();
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] toFields = structType2.fields();
                    return fromFields.length == toFields.length && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataType$.$anonfun$equalsStructurallyByName$1(resolver, x0$1)));
                }
            }
        }
        return true;
    }

    private Regex SparkGeneratedName() {
        return this.SparkGeneratedName;
    }

    private boolean isSparkGeneratedName(String name) {
        String string = name;
        Option option = this.SparkGeneratedName().unapplySeq((CharSequence)string);
        return !option.isEmpty();
    }

    public boolean canWrite(DataType write, DataType read, boolean byName, Function2<String, String, Object> resolver, String context, Enumeration.Value storeAssignmentPolicy, Function1<String, BoxedUnit> addError) {
        DataType r;
        DataType w;
        Tuple2 tuple2 = new Tuple2((Object)write, (Object)read);
        if (tuple2 != null) {
            DataType wArr = (DataType)tuple2._1();
            DataType rArr = (DataType)tuple2._2();
            if (wArr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)wArr;
                if (rArr instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)rArr;
                    boolean typesCompatible = this.canWrite(arrayType.elementType(), arrayType2.elementType(), byName, resolver, new StringBuilder(8).append(context).append(".element").toString(), storeAssignmentPolicy, addError);
                    if (arrayType.containsNull() && !arrayType2.containsNull()) {
                        addError.apply((Object)new StringBuilder(56).append("Cannot write nullable elements to array of non-nulls: '").append(context).append("'").toString());
                        return false;
                    }
                    return typesCompatible;
                }
            }
        }
        if (tuple2 != null) {
            DataType wMap = (DataType)tuple2._1();
            DataType rMap = (DataType)tuple2._2();
            if (wMap instanceof MapType) {
                MapType mapType = (MapType)wMap;
                if (rMap instanceof MapType) {
                    MapType mapType2 = (MapType)rMap;
                    boolean keyCompatible = this.canWrite(mapType.keyType(), mapType2.keyType(), byName, resolver, new StringBuilder(4).append(context).append(".key").toString(), storeAssignmentPolicy, addError);
                    boolean valueCompatible = this.canWrite(mapType.valueType(), mapType2.valueType(), byName, resolver, new StringBuilder(6).append(context).append(".value").toString(), storeAssignmentPolicy, addError);
                    if (mapType.valueContainsNull() && !mapType2.valueContainsNull()) {
                        addError.apply((Object)new StringBuilder(52).append("Cannot write nullable values to map of non-nulls: '").append(context).append("'").toString());
                        return false;
                    }
                    return keyCompatible && valueCompatible;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] writeFields = structType.fields();
                if (dataType2 instanceof StructType) {
                    StructType structType2 = (StructType)dataType2;
                    StructField[] readFields = structType2.fields();
                    BooleanRef fieldCompatible = BooleanRef.create((boolean)true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])writeFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        DataType$.$anonfun$canWrite$1(resolver, context, byName, storeAssignmentPolicy, addError, fieldCompatible, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).size() > new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeFields)).size()) {
                        String missingFieldsStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).takeRight(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).size() - new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeFields)).size()))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append("'").append(f.name()).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
                        if (new StringOps(Predef$.MODULE$.augmentString(missingFieldsStr)).nonEmpty()) {
                            addError.apply((Object)new StringBuilder(26).append("Struct '").append(context).append("' missing fields: ").append(missingFieldsStr).toString());
                            fieldCompatible.elem = false;
                        }
                    } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeFields)).size() > new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).size()) {
                        String extraFieldsStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeFields)).takeRight(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeFields)).size() - new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readFields)).size()))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(2).append("'").append(f.name()).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ");
                        addError.apply((Object)new StringBuilder(40).append("Cannot write extra fields to struct '").append(context).append("': ").append(extraFieldsStr).toString());
                        fieldCompatible.elem = false;
                    }
                    return fieldCompatible.elem;
                }
            }
        }
        if (tuple2 != null) {
            DataType w2 = (DataType)tuple2._1();
            DataType r2 = (DataType)tuple2._2();
            if (w2 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)w2;
                if (r2 instanceof AtomicType) {
                    AtomicType atomicType2 = (AtomicType)r2;
                    Enumeration.Value value = storeAssignmentPolicy;
                    Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        if (!Cast$.MODULE$.canUpCast(atomicType, atomicType2)) {
                            addError.apply((Object)new StringBuilder(27).append("Cannot safely cast '").append(context).append("': ").append(atomicType.catalogString()).append(" to ").append(atomicType2.catalogString()).toString());
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof NullType) {
            Enumeration.Value value = storeAssignmentPolicy;
            Enumeration.Value value3 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
            if (!(value != null ? !value.equals(value3) : value3 != null)) {
                return true;
            }
        }
        if (tuple2 != null) {
            DataType w3 = (DataType)tuple2._1();
            DataType r3 = (DataType)tuple2._2();
            if (w3 instanceof AtomicType) {
                AtomicType atomicType = (AtomicType)w3;
                if (r3 instanceof AtomicType) {
                    AtomicType atomicType3 = (AtomicType)r3;
                    Enumeration.Value value = storeAssignmentPolicy;
                    Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
                    if (!(value != null ? !value.equals(value4) : value4 != null)) {
                        if (!Cast$.MODULE$.canANSIStoreAssign(atomicType, atomicType3)) {
                            addError.apply((Object)new StringBuilder(27).append("Cannot safely cast '").append(context).append("': ").append(atomicType.catalogString()).append(" to ").append(atomicType3.catalogString()).toString());
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        if (tuple2 != null && (w = (DataType)tuple2._1()).sameType(r = (DataType)tuple2._2()) && !(w instanceof NullType)) {
            return true;
        }
        if (tuple2 != null) {
            DataType w4 = (DataType)tuple2._1();
            DataType r4 = (DataType)tuple2._2();
            addError.apply((Object)new StringBuilder(39).append("Cannot write '").append(context).append("': ").append(w4.catalogString()).append(" is incompatible with ").append(r4.catalogString()).toString());
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            String string = l.name();
            String string2 = r.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && MODULE$.equalsIgnoreNullability(l.dataType(), r.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCompatibleNullability$1(boolean ignoreName$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StructField fromField = (StructField)tuple2._1();
        StructField toField = (StructField)tuple2._2();
        if (!ignoreName$1) {
            String string = fromField.name();
            String string2 = toField.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
        }
        if (!toField.nullable()) {
            if (fromField.nullable()) return false;
        }
        if (!MODULE$.equalsIgnoreCompatibleNullability(fromField.dataType(), toField.dataType(), ignoreName$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$equalsIgnoreCaseAndNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return l.name().equalsIgnoreCase(r.name()) && MODULE$.equalsIgnoreCaseAndNullability(l.dataType(), r.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsStructurally$1(boolean ignoreNullability$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return MODULE$.equalsStructurally(l.dataType(), r.dataType(), ignoreNullability$1) && (ignoreNullability$1 || l.nullable() == r.nullable());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$equalsStructurallyByName$1(Function2 resolver$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField l = (StructField)tuple2._1();
            StructField r = (StructField)tuple2._2();
            return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)l.name(), (Object)r.name())) && MODULE$.equalsStructurallyByName(l.dataType(), r.dataType(), (Function2<String, String, Object>)resolver$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$canWrite$1(Function2 resolver$2, String context$1, boolean byName$1, Enumeration.Value storeAssignmentPolicy$1, Function1 addError$1, BooleanRef fieldCompatible$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                StructField rField = (StructField)tuple22._1();
                StructField wField = (StructField)tuple22._2();
                boolean nameMatch = BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)wField.name(), (Object)rField.name())) || MODULE$.isSparkGeneratedName(wField.name());
                String fieldContext = new StringBuilder(1).append(context$1).append(".").append(rField.name()).toString();
                boolean typesCompatible = MODULE$.canWrite(wField.dataType(), rField.dataType(), byName$1, (Function2<String, String, Object>)resolver$2, fieldContext, storeAssignmentPolicy$1, (Function1<String, BoxedUnit>)addError$1);
                if (byName$1 && !nameMatch) {
                    addError$1.apply((Object)new StringBuilder(84).append("Struct '").append(context$1).append("' ").append(i).append("-th field name does not match ").append("(may be out of order): expected '").append(rField.name()).append("', found '").append(wField.name()).append("'").toString());
                    fieldCompatible$1.elem = false;
                    return;
                }
                if (!rField.nullable() && wField.nullable()) {
                    addError$1.apply((Object)new StringBuilder(50).append("Cannot write nullable values to non-null field: '").append(fieldContext).append("'").toString());
                    fieldCompatible$1.elem = false;
                    return;
                }
                if (!typesCompatible) {
                    fieldCompatible$1.elem = false;
                    return;
                }
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private DataType$() {
        MODULE$ = this;
        this.FIXED_DECIMAL = new StringOps(Predef$.MODULE$.augmentString("decimal\\(\\s*(\\d+)\\s*,\\s*(\\-?\\d+)\\s*\\)")).r();
        this.CHAR_TYPE = new StringOps(Predef$.MODULE$.augmentString("char\\(\\s*(\\d+)\\s*\\)")).r();
        this.VARCHAR_TYPE = new StringOps(Predef$.MODULE$.augmentString("varchar\\(\\s*(\\d+)\\s*\\)")).r();
        this.otherTypes = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{NullType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$, IntegerType$.MODULE$, BooleanType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$, StringType$.MODULE$, CalendarIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.DAY()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.HOUR()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.MINUTE()), new DayTimeIntervalType(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()), DayTimeIntervalType$.MODULE$.apply(DayTimeIntervalType$.MODULE$.SECOND()), YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.YEAR()), YearMonthIntervalType$.MODULE$.apply(YearMonthIntervalType$.MODULE$.MONTH()), new YearMonthIntervalType(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()), TimestampNTZType$.MODULE$}))).map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.typeName()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.SparkGeneratedName = new StringOps(Predef$.MODULE$.augmentString("col\\d+")).r();
    }
}

