/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayAggregate$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.QuaternaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(expr, start, merge, finish) - Applies a binary operator to an initial state and all\n      elements in the array, and reduces this to a single state. The final state is converted\n      into the final result by applying a finish function.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 0, (acc, x) -> acc + x);\n       6\n      > SELECT _FUNC_(array(1, 2, 3), 0, (acc, x) -> acc + x, acc -> acc * 10);\n       60\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\tmd\u0001\u0002\u00192\u0001zB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\t;\u0002\u0011\t\u0012)A\u0005\u007f!Aa\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005`\u0001\tE\t\u0015!\u0003@\u0011!\u0001\u0007A!f\u0001\n\u0003a\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B \t\u0011\t\u0004!Q3A\u0005\u0002qC\u0001b\u0019\u0001\u0003\u0012\u0003\u0006Ia\u0010\u0005\u0006I\u0002!\t!\u001a\u0005\u0006I\u0002!\ta\u001b\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006{\u0002!\tE \u0005\u0007\u0003\u001b\u0001A\u0011\t9\t\r\u0005=\u0001\u0001\"\u0011\u007f\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002&\u0001!\t%a\n\t\u000f\u0005U\u0002\u0001\"\u0015\u00028!a\u0011\u0011\u000b\u0001\u0011\u0002#\u001d\r\u0015\"\u0003\u0002T!Q\u0011Q\f\u0001\t\u0006\u0004%\t!a\u0018\t\u0015\u0005%\u0004\u0001#b\u0001\n\u0003\ty\u0006\u0003\u0006\u0002n\u0001A)\u0019!C\u0001\u0003?Bq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002\b\u0002!\t%!#\t\r\u0005m\u0005\u0001\"\u0011]\u0011\u0019\ti\n\u0001C!9\"1\u0011q\u0014\u0001\u0005BqCa!!)\u0001\t\u0003b\u0006bBAR\u0001\u0011E\u0013Q\u0015\u0005\n\u0003_\u0003\u0011\u0011!C\u0001\u0003cC\u0011\"a/\u0001#\u0003%\t!!0\t\u0013\u0005M\u0007!%A\u0005\u0002\u0005u\u0006\"CAk\u0001E\u0005I\u0011AA_\u0011%\t9\u000eAI\u0001\n\u0003\ti\fC\u0005\u0002Z\u0002\t\t\u0011\"\u0011\u0002\\\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003k\u0004\u0011\u0011!C\u0001\u0003oD\u0011\"!@\u0001\u0003\u0003%\t%a@\t\u0013\t5\u0001!!A\u0005\u0002\t=\u0001\"\u0003B\n\u0001\u0005\u0005I\u0011\tB\u000b\u000f%\u0011I$MA\u0001\u0012\u0003\u0011YD\u0002\u00051c\u0005\u0005\t\u0012\u0001B\u001f\u0011\u0019!'\u0006\"\u0001\u0003L!I!Q\n\u0016\u0002\u0002\u0013\u0015#q\n\u0005\n\u0005#R\u0013\u0011!CA\u0005'B\u0011B!\u0018+\u0003\u0003%\tIa\u0018\t\u0013\tE$&!A\u0005\n\tM$AD!se\u0006L\u0018iZ4sK\u001e\fG/\u001a\u0006\u0003eM\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A'N\u0001\tG\u0006$\u0018\r\\=ti*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001M9\u0001aP\"G\u0019JC\u0006C\u0001!B\u001b\u0005\t\u0014B\u0001\"2\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0001\u0012K!!R\u0019\u0003'!Kw\r[3s\u001fJ$WM\u001d$v]\u000e$\u0018n\u001c8\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u000b\u0014aB2pI\u0016<WM\\\u0005\u0003\u0017\"\u0013qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0004\u001bB{T\"\u0001(\u000b\u0005=\u001b\u0014!\u0002;sK\u0016\u001c\u0018BA)O\u00059\tV/\u0019;fe:\f'/\u001f'jW\u0016\u0004\"a\u0015,\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002T3&\u0011!\f\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tCJ<W/\\3oiV\tq(A\u0005be\u001e,X.\u001a8uA\u0005!!0\u001a:p\u0003\u0015QXM]8!\u0003\u0015iWM]4f\u0003\u0019iWM]4fA\u00051a-\u001b8jg\"\fqAZ5oSND\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006M\u001eD\u0017N\u001b\t\u0003\u0001\u0002AQaW\u0005A\u0002}BQAX\u0005A\u0002}BQ\u0001Y\u0005A\u0002}BQAY\u0005A\u0002}\"BA\u001a7n]\")1L\u0003a\u0001\u007f!)aL\u0003a\u0001\u007f!)\u0001M\u0003a\u0001\u007f\u0005I\u0011M]4v[\u0016tGo]\u000b\u0002cB\u0019!O_ \u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<>\u0003\u0019a$o\\8u}%\tQ+\u0003\u0002z)\u00069\u0001/Y2lC\u001e,\u0017BA>}\u0005\r\u0019V-\u001d\u0006\u0003sR\u000bQ\"\u0019:hk6,g\u000e\u001e+za\u0016\u001cX#A@\u0011\tIT\u0018\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011qA\u001b\u0002\u000bQL\b/Z:\n\t\u0005-\u0011Q\u0001\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0011BZ;oGRLwN\\:\u0002\u001b\u0019,hn\u0019;j_:$\u0016\u0010]3t\u0003!qW\u000f\u001c7bE2,WCAA\u000b!\r\u0019\u0016qC\u0005\u0004\u00033!&a\u0002\"p_2,\u0017M\\\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0004\t\u0005\u0003\u0007\t\t#\u0003\u0003\u0002$\u0005\u0015!\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005%\u0002\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=2'\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t\u0019$!\f\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fABY5oI&sG/\u001a:oC2$2AZA\u001d\u0011\u001d\tYD\u0005a\u0001\u0003{\t\u0011A\u001a\t\t'\u0006}r(a\u0011\u0002L%\u0019\u0011\u0011\t+\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003\u0002:{\u0003\u000b\u0002raUA$\u0003?\t)\"C\u0002\u0002JQ\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001!\u0002N%\u0019\u0011qJ\u0019\u0003\u001d1\u000bWN\u00193b\rVt7\r^5p]\u0006!\u0001\u0010\n\u001b:+\t\t)\u0006E\u0004T\u0003\u000f\n9&a\u0016\u0011\u0007\u0001\u000bI&C\u0002\u0002\\E\u00121CT1nK\u0012d\u0015-\u001c2eCZ\u000b'/[1cY\u0016\fa\"Y2d\r>\u0014X*\u001a:hKZ\u000b'/\u0006\u0002\u0002X!\u001aA#a\u0019\u0011\u0007M\u000b)'C\u0002\u0002hQ\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0015\u0015dW-\\3oiZ\u000b'\u000fK\u0002\u0016\u0003G\nq\"Y2d\r>\u0014h)\u001b8jg\"4\u0016M\u001d\u0015\u0004-\u0005\r\u0014\u0001B3wC2$B!!\u001e\u0002|A\u00191+a\u001e\n\u0007\u0005eDKA\u0002B]fD\u0011\"! \u0018!\u0003\u0005\r!a \u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\u0005\u00151Q\u0007\u0002g%\u0019\u0011QQ\u001a\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\t]>$WMT1nKV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b)J\u0004\u0003\u0002\u0010\u0006E\u0005C\u0001;U\u0013\r\t\u0019\nV\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0015\u0011\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ME+A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u0007M>,(\u000f\u001e5\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u00034\u0002(\u0006%\u00161VAW\u0011\u0019\tY*\ba\u0001\u007f!1\u0011QT\u000fA\u0002}Ba!a(\u001e\u0001\u0004y\u0004BBAQ;\u0001\u0007q(\u0001\u0003d_BLH#\u00034\u00024\u0006U\u0016qWA]\u0011\u001dYf\u0004%AA\u0002}BqA\u0018\u0010\u0011\u0002\u0003\u0007q\bC\u0004a=A\u0005\t\u0019A \t\u000f\tt\u0002\u0013!a\u0001\u007f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA`U\ry\u0014\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u001a+\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001c\t\u0005\u0003?\fI/\u0004\u0002\u0002b*!\u00111]As\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0018\u0001\u00026bm\u0006LA!a&\u0002b\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u001e\t\u0004'\u0006E\u0018bAAz)\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QOA}\u0011%\tY0JA\u0001\u0002\u0004\ty/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0003\u0001bAa\u0001\u0003\n\u0005UTB\u0001B\u0003\u0015\r\u00119\u0001V\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0006\u0005\u000b\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0003B\t\u0011%\tYpJA\u0001\u0002\u0004\t)(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\u00119\u0002C\u0005\u0002|\"\n\t\u00111\u0001\u0002v!\u001a\u0002Aa\u0007\u0003\"\t\r\"q\u0005B\u0015\u0005[\u0011yCa\r\u00036A\u0019\u0001I!\b\n\u0007\t}\u0011GA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u0015\u0012!a@\u000bA\u0001\u0002\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006I:uCJ$H\u0006I7fe\u001e,G\u0006\t4j]&\u001c\b.\u000b\u0011.A\u0005\u0003\b\u000f\\5fg\u0002\n\u0007EY5oCJL\be\u001c9fe\u0006$xN\u001d\u0011u_\u0002\ng\u000eI5oSRL\u0017\r\u001c\u0011ti\u0006$X\rI1oI\u0002\nG\u000e\u001c\u0006!A\u0001\u0002\u0003\u0005I3mK6,g\u000e^:!S:\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0017!C:$\u0007E]3ek\u000e,7\u000f\t;iSN\u0004Co\u001c\u0011bAMLgn\u001a7fAM$\u0018\r^3/AQCW\r\t4j]\u0006d\u0007e\u001d;bi\u0016\u0004\u0013n\u001d\u0011d_:4XM\u001d;fI*\u0001\u0003\u0005\t\u0011!A%tGo\u001c\u0011uQ\u0016\u0004c-\u001b8bY\u0002\u0012Xm];mi\u0002\u0012\u0017\u0010I1qa2L\u0018N\\4!C\u00022\u0017N\\5tQ\u00022WO\\2uS>tgF\u0003\u0011!A\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005W\t\u0011q\r\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012D\u0006I\u001a*Y\u0001\u0002D\u0006\t\u0015bG\u000ed\u0003\u0005_\u0015![y\u0002\u0013mY2!W\u0001B\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00117\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003\u0005\r\u0017!Q\u0005\u001c7\r\f\u0011yS\u0001jc\bI1dG\u0002Z\u0003\u0005\u001f\u0017!C\u000e\u001c\u0007%\f !C\u000e\u001c\u0007E\u000b\u00112a%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\u000e\u0019\u000bA\u0001\nQa]5oG\u0016\f#A!\r\u0002\u000bIrCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t]\u0012\u0001\u00047b[\n$\u0017m\u00184v]\u000e\u001c\u0018AD!se\u0006L\u0018iZ4sK\u001e\fG/\u001a\t\u0003\u0001*\u001aBA\u000bB 1BI!\u0011\tB$\u007f}ztHZ\u0007\u0003\u0005\u0007R1A!\u0012U\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0013\u0003D\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\tm\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0017!B1qa2LH#\u00034\u0003V\t]#\u0011\fB.\u0011\u0015YV\u00061\u0001@\u0011\u0015qV\u00061\u0001@\u0011\u0015\u0001W\u00061\u0001@\u0011\u0015\u0011W\u00061\u0001@\u0003\u001d)h.\u00199qYf$BA!\u0019\u0003nA)1Ka\u0019\u0003h%\u0019!Q\r+\u0003\r=\u0003H/[8o!\u001d\u0019&\u0011N @\u007f}J1Aa\u001bU\u0005\u0019!V\u000f\u001d7fi!A!q\u000e\u0018\u0002\u0002\u0003\u0007a-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u000f\t\u0005\u0003?\u00149(\u0003\u0003\u0003z\u0005\u0005(AB(cU\u0016\u001cG\u000f")
public class ArrayAggregate
extends Expression
implements HigherOrderFunction,
CodegenFallback,
QuaternaryLike<Expression>,
Serializable {
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$49;
    private transient NamedLambdaVariable accForMergeVar;
    private transient NamedLambdaVariable elementVar;
    private transient NamedLambdaVariable accForFinishVar;
    private final Expression argument;
    private final Expression zero;
    private final Expression merge;
    private final Expression finish;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(ArrayAggregate arrayAggregate) {
        return ArrayAggregate$.MODULE$.unapply(arrayAggregate);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Expression>, ArrayAggregate> tupled() {
        return ArrayAggregate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, ArrayAggregate>>>> curried() {
        return ArrayAggregate$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return QuaternaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return QuaternaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    @Override
    public final HigherOrderFunction bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        return HigherOrderFunction.bind$(this, f);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = QuaternaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.argumentsResolved$lzycompute();
        }
        return this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.functionsForEval$lzycompute();
        }
        return this.functionsForEval;
    }

    private Expression canonicalized$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.canonicalized = HigherOrderFunction.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression argument() {
        return this.argument;
    }

    public Expression zero() {
        return this.zero;
    }

    public Expression merge() {
        return this.merge;
    }

    public Expression finish() {
        return this.finish;
    }

    @Override
    public Seq<Expression> arguments() {
        Expression expression = this.argument();
        Expression expression2 = this.zero();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        ArrayType$ arrayType$ = ArrayType$.MODULE$;
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$).$colon$colon((Object)arrayType$);
    }

    @Override
    public Seq<Expression> functions() {
        Expression expression = this.merge();
        Expression expression2 = this.finish();
        return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        DataType dataType = this.zero().dataType();
        AnyDataType$ anyDataType$ = AnyDataType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)anyDataType$).$colon$colon((Object)dataType);
    }

    @Override
    public boolean nullable() {
        return this.argument().nullable() || this.finish().nullable();
    }

    @Override
    public DataType dataType() {
        return this.finish().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = this.checkArgumentDataTypes();
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult)) {
            if (!DataType$.MODULE$.equalsStructurally(this.zero().dataType(), this.merge().dataType(), true)) {
                return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)Cast$.MODULE$.toSQLType(this.zero().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)Cast$.MODULE$.toSQLExpr(this.merge())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType(this.merge().dataType()))}))));
            }
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return typeCheckResult;
    }

    @Override
    public ArrayAggregate bindInternal(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        Tuple2 acc;
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        DataType elementType2 = (DataType)tuple2._1();
        boolean containsNull2 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = acc = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.zero().dataType()), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction newMerge = (LambdaFunction)f.apply((Object)this.merge(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22));
        Tuple2 tuple24 = acc;
        LambdaFunction newFinish = (LambdaFunction)f.apply((Object)this.finish(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple24));
        LambdaFunction x$1 = newMerge;
        LambdaFunction x$2 = newFinish;
        Expression x$3 = this.copy$default$1();
        Expression x$4 = this.copy$default$2();
        return this.copy(x$3, x$4, x$1, x$2);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$49$lzycompute() {
        block5: {
            ArrayAggregate arrayAggregate = this;
            synchronized (arrayAggregate) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression elementVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.merge();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression accForMergeVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        elementVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(accForMergeVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)accForMergeVar;
                        if (elementVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)elementVar;
                this.x$49 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$49;
    }

    private /* synthetic */ Tuple2 x$49() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$49$lzycompute();
        }
        return this.x$49;
    }

    private NamedLambdaVariable accForMergeVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.accForMergeVar = (NamedLambdaVariable)this.x$49()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.accForMergeVar;
    }

    public NamedLambdaVariable accForMergeVar() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.accForMergeVar$lzycompute();
        }
        return this.accForMergeVar;
    }

    private NamedLambdaVariable elementVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.elementVar = (NamedLambdaVariable)this.x$49()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.elementVar;
    }

    public NamedLambdaVariable elementVar() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.elementVar$lzycompute();
        }
        return this.elementVar;
    }

    private NamedLambdaVariable accForFinishVar$lzycompute() {
        ArrayAggregate arrayAggregate = this;
        synchronized (arrayAggregate) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                NamedExpression accForFinishVar;
                LambdaFunction lambdaFunction;
                Seq<NamedExpression> seq;
                Some some;
                Expression expression = this.finish();
                if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((accForFinishVar = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof NamedLambdaVariable)) {
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable = (NamedLambdaVariable)accForFinishVar;
                this.accForFinishVar = namedLambdaVariable;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.accForFinishVar;
    }

    public NamedLambdaVariable accForFinishVar() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.accForFinishVar$lzycompute();
        }
        return this.accForFinishVar;
    }

    @Override
    public Object eval(InternalRow input) {
        ArrayData arr = (ArrayData)this.argument().eval(input);
        if (arr == null) {
            return null;
        }
        Seq<Expression> seq = this.functionsForEval();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        Expression mergeForEval = (Expression)((SeqLike)some.get()).apply(0);
        Expression finishForEval = (Expression)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)mergeForEval, (Object)finishForEval);
        Expression mergeForEval2 = (Expression)tuple2._1();
        Expression finishForEval2 = (Expression)tuple2._2();
        this.accForMergeVar().value().set(this.zero().eval(input));
        for (int i = 0; i < arr.numElements(); ++i) {
            this.elementVar().value().set(arr.get(i, this.elementVar().dataType()));
            this.accForMergeVar().value().set(InternalRow$.MODULE$.copyValue(mergeForEval2.eval(input)));
        }
        this.accForFinishVar().value().set(this.accForMergeVar().value().get());
        return finishForEval2.eval(input);
    }

    @Override
    public String nodeName() {
        return "aggregate";
    }

    @Override
    public Expression first() {
        return this.argument();
    }

    @Override
    public Expression second() {
        return this.zero();
    }

    @Override
    public Expression third() {
        return this.merge();
    }

    @Override
    public Expression fourth() {
        return this.finish();
    }

    @Override
    public ArrayAggregate withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public ArrayAggregate copy(Expression argument, Expression zero, Expression merge, Expression finish) {
        return new ArrayAggregate(argument, zero, merge, finish);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.zero();
    }

    public Expression copy$default$3() {
        return this.merge();
    }

    public Expression copy$default$4() {
        return this.finish();
    }

    @Override
    public String productPrefix() {
        return "ArrayAggregate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.argument();
            }
            case 1: {
                return this.zero();
            }
            case 2: {
                return this.merge();
            }
            case 3: {
                return this.finish();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayAggregate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayAggregate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayAggregate arrayAggregate = (ArrayAggregate)x$1;
        Expression expression = this.argument();
        Expression expression2 = arrayAggregate.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.zero();
        Expression expression4 = arrayAggregate.zero();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.merge();
        Expression expression6 = arrayAggregate.merge();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.finish();
        Expression expression8 = arrayAggregate.finish();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!arrayAggregate.canEqual(this)) return false;
        return true;
    }

    public ArrayAggregate(Expression argument, Expression zero, Expression merge, Expression finish) {
        this.argument = argument;
        this.zero = zero;
        this.merge = merge;
        this.finish = finish;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
        QuaternaryLike.$init$(this);
    }

    public ArrayAggregate(Expression argument, Expression zero, Expression merge) {
        this(argument, zero, merge, LambdaFunction$.MODULE$.identity());
    }
}

