/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$ParseState$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class IntervalUtils$ {
    public static IntervalUtils$ MODULE$;
    private final long MAX_DAY;
    private final long MAX_HOUR;
    private final long MAX_MINUTE;
    private final long MAX_SECOND;
    private final long MIN_SECOND;
    private final String yearMonthPatternString;
    private final Regex yearMonthRegex;
    private final Regex yearMonthLiteralRegex;
    private final String yearMonthIndividualPatternString;
    private final Regex yearMonthIndividualRegex;
    private final Regex yearMonthIndividualLiteralRegex;
    private final Map<Tuple2<Object, Object>, Seq<String>> supportedFormat;
    private final String normalPattern;
    private final String dayBoundPattern;
    private final String hourBoundPattern;
    private final String minuteBoundPattern;
    private final String secondBoundPattern;
    private final String microPattern;
    private final String dayHourPatternString;
    private final Regex dayHourRegex;
    private final Regex dayHourLiteralRegex;
    private final String dayMinutePatternString;
    private final Regex dayMinuteRegex;
    private final Regex dayMinuteLiteralRegex;
    private final String daySecondPatternString;
    private final Regex daySecondRegex;
    private final Regex daySecondLiteralRegex;
    private final String hourMinutePatternString;
    private final Regex hourMinuteRegex;
    private final Regex hourMinuteLiteralRegex;
    private final String hourSecondPatternString;
    private final Regex hourSecondRegex;
    private final Regex hourSecondLiteralRegex;
    private final String minuteSecondPatternString;
    private final Regex minuteSecondRegex;
    private final Regex minuteSecondLiteralRegex;
    private final String dayTimeIndividualPatternString;
    private final Regex dayTimeIndividualRegex;
    private final Regex dayTimeIndividualLiteralRegex;
    private final Regex dayTimePatternLegacy;
    private final String fallbackNotice;
    private final UTF8String intervalStr;
    private final UTF8String yearStr;
    private final UTF8String monthStr;
    private final UTF8String weekStr;
    private final UTF8String dayStr;
    private final UTF8String hourStr;
    private final UTF8String minuteStr;
    private final UTF8String secondStr;
    private final UTF8String millisStr;
    private final UTF8String microsStr;
    private final UTF8String nanosStr;
    private final long minDurationSeconds;

    static {
        new IntervalUtils$();
    }

    private long MAX_DAY() {
        return this.MAX_DAY;
    }

    private long MAX_HOUR() {
        return this.MAX_HOUR;
    }

    private long MAX_MINUTE() {
        return this.MAX_MINUTE;
    }

    private long MAX_SECOND() {
        return this.MAX_SECOND;
    }

    private long MIN_SECOND() {
        return this.MIN_SECOND;
    }

    public int getYears(int months) {
        return months / 12;
    }

    public int getYears(CalendarInterval interval) {
        return this.getYears(interval.months);
    }

    public byte getMonths(int months) {
        return (byte)(months % 12);
    }

    public byte getMonths(CalendarInterval interval) {
        return this.getMonths(interval.months);
    }

    public int getDays(long microseconds) {
        return (int)(microseconds / 86400000000L);
    }

    public int getDays(CalendarInterval interval) {
        int daysInMicroseconds = this.getDays(interval.microseconds);
        return Math.addExact(interval.days, daysInMicroseconds);
    }

    public byte getHours(long microseconds) {
        return (byte)(microseconds % 86400000000L / 3600000000L);
    }

    public byte getHours(CalendarInterval interval) {
        return this.getHours(interval.microseconds);
    }

    public byte getMinutes(long microseconds) {
        return (byte)(microseconds % 3600000000L / 60000000L);
    }

    public byte getMinutes(CalendarInterval interval) {
        return this.getMinutes(interval.microseconds);
    }

    public Decimal getSeconds(long microseconds) {
        return Decimal$.MODULE$.apply(microseconds % 60000000L, 8, 6);
    }

    public Decimal getSeconds(CalendarInterval interval) {
        return this.getSeconds(interval.microseconds);
    }

    private long toLongWithRange(UTF8String fieldName, String s, long minValue, long maxValue) {
        long result = s == null ? 0L : new StringOps(Predef$.MODULE$.augmentString(s)).toLong();
        Predef$.MODULE$.require(minValue <= result && result <= maxValue, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append(fieldName).append(" ").append(result).append(" outside range [").append(minValue).append(", ").append(maxValue).append("]").toString());
        return result;
    }

    private String yearMonthPatternString() {
        return this.yearMonthPatternString;
    }

    private Regex yearMonthRegex() {
        return this.yearMonthRegex;
    }

    private Regex yearMonthLiteralRegex() {
        return this.yearMonthLiteralRegex;
    }

    private String yearMonthIndividualPatternString() {
        return this.yearMonthIndividualPatternString;
    }

    private Regex yearMonthIndividualRegex() {
        return this.yearMonthIndividualRegex;
    }

    private Regex yearMonthIndividualLiteralRegex() {
        return this.yearMonthIndividualLiteralRegex;
    }

    private int finalSign(String firstSign, String secondSign) {
        String string;
        String string2;
        Tuple2 tuple2 = new Tuple2((Object)firstSign, (Object)secondSign);
        if (tuple2 != null) {
            String string3 = (String)tuple2._1();
            String string4 = (String)tuple2._2();
            if ("-".equals(string3) && "-".equals(string4)) {
                return 1;
            }
        }
        if (tuple2 != null && "-".equals(string2 = (String)tuple2._1())) {
            return -1;
        }
        if (tuple2 != null && "-".equals(string = (String)tuple2._2())) {
            return -1;
        }
        if (tuple2 != null) {
            return 1;
        }
        throw new MatchError((Object)tuple2);
    }

    private String finalSign$default$2() {
        return null;
    }

    private Nothing$ throwIllegalIntervalFormatException(UTF8String input, byte startFiled, byte endField, String intervalStr, String typeName, Option<String> fallBackNotice) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(58).append("Interval string does not match ").append(intervalStr).append(" format of ").append(((TraversableOnce)((TraversableLike)this.supportedFormat().apply((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)startFiled), (Object)BoxesRunTime.boxToByte((byte)endField)))).map((Function1 & Serializable & scala.Serializable)format -> new java.lang.StringBuilder(2).append("`").append((String)format).append("`").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(" ").append("when cast to ").append(typeName).append(": ").append(input.toString()).append(fallBackNotice.map((Function1 & Serializable & scala.Serializable)s -> new java.lang.StringBuilder(2).append(", ").append((String)s).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
    }

    private Option<String> throwIllegalIntervalFormatException$default$6() {
        return None$.MODULE$;
    }

    public Map<Tuple2<Object, Object>, Seq<String>> supportedFormat() {
        return this.supportedFormat;
    }

    public int castStringToYMInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        String string = input.trimAll().toString();
        Option option3 = this.yearMonthRegex().unapplySeq((CharSequence)string);
        if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String year = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String month = (String)((LinearSeqOptimized)option3.get()).apply(2);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option2 = this.yearMonthLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String year = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String month = (String)((LinearSeqOptimized)option2.get()).apply(3);
            if (IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                return this.toYMInterval(year, month, this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option = this.yearMonthIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option.get()).apply(0);
            String value = (String)((LinearSeqOptimized)option.get()).apply(1);
            return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                if (endField == YearMonthIntervalType$.MODULE$.YEAR()) {
                    return sign * Math.toIntExact(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 12L);
                }
                if (startField == YearMonthIntervalType$.MODULE$.MONTH()) {
                    return Math.toIntExact((long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
            }));
        }
        Option option4 = this.yearMonthIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option4.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option4.get()).apply(1);
            String value = (String)((LinearSeqOptimized)option4.get()).apply(2);
            String unit = (String)((LinearSeqOptimized)option4.get()).apply(3);
            return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                if ("YEAR".equals(string) && IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.YEAR(), startField, endField)) {
                    return sign * Math.toIntExact(new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 12L);
                }
                if ("MONTH".equals(string) && IntervalUtils$.checkTargetType$1(YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH(), startField, endField)) {
                    return Math.toIntExact((long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong());
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), MODULE$.throwIllegalIntervalFormatException$default$6());
            }));
        }
        throw this.throwIllegalIntervalFormatException(input, startField, endField, "year-month", new YearMonthIntervalType(startField, endField).typeName(), this.throwIllegalIntervalFormatException$default$6());
    }

    public CalendarInterval fromYearMonthString(String input) {
        return this.fromYearMonthString(input, YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH());
    }

    public CalendarInterval fromYearMonthString(String input, byte startField, byte endField) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval year-month string must be not null");
        int months = this.castStringToYMInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(months, 0, 0L);
    }

    private <T> T safeToInterval(String interval, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new IllegalArgumentException(new java.lang.StringBuilder(32).append("Error parsing interval ").append(interval).append(" string: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        return (T)object;
    }

    private int toYMInterval(String year, String month, int sign) {
        return BoxesRunTime.unboxToInt(this.safeToInterval("year-month", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            long years = MODULE$.toLongWithRange(MODULE$.yearStr(), year, 0L, 0xAAAAAAAL);
            long totalMonths = (long)sign * (years * 12L + MODULE$.toLongWithRange(MODULE$.monthStr(), month, 0L, 11L));
            return Math.toIntExact(totalMonths);
        }));
    }

    private String normalPattern() {
        return this.normalPattern;
    }

    private String dayBoundPattern() {
        return this.dayBoundPattern;
    }

    private String hourBoundPattern() {
        return this.hourBoundPattern;
    }

    private String minuteBoundPattern() {
        return this.minuteBoundPattern;
    }

    private String secondBoundPattern() {
        return this.secondBoundPattern;
    }

    private String microPattern() {
        return this.microPattern;
    }

    private String dayHourPatternString() {
        return this.dayHourPatternString;
    }

    private Regex dayHourRegex() {
        return this.dayHourRegex;
    }

    private Regex dayHourLiteralRegex() {
        return this.dayHourLiteralRegex;
    }

    private String dayMinutePatternString() {
        return this.dayMinutePatternString;
    }

    private Regex dayMinuteRegex() {
        return this.dayMinuteRegex;
    }

    private Regex dayMinuteLiteralRegex() {
        return this.dayMinuteLiteralRegex;
    }

    private String daySecondPatternString() {
        return this.daySecondPatternString;
    }

    private Regex daySecondRegex() {
        return this.daySecondRegex;
    }

    private Regex daySecondLiteralRegex() {
        return this.daySecondLiteralRegex;
    }

    private String hourMinutePatternString() {
        return this.hourMinutePatternString;
    }

    private Regex hourMinuteRegex() {
        return this.hourMinuteRegex;
    }

    private Regex hourMinuteLiteralRegex() {
        return this.hourMinuteLiteralRegex;
    }

    private String hourSecondPatternString() {
        return this.hourSecondPatternString;
    }

    private Regex hourSecondRegex() {
        return this.hourSecondRegex;
    }

    private Regex hourSecondLiteralRegex() {
        return this.hourSecondLiteralRegex;
    }

    private String minuteSecondPatternString() {
        return this.minuteSecondPatternString;
    }

    private Regex minuteSecondRegex() {
        return this.minuteSecondRegex;
    }

    private Regex minuteSecondLiteralRegex() {
        return this.minuteSecondLiteralRegex;
    }

    private String dayTimeIndividualPatternString() {
        return this.dayTimeIndividualPatternString;
    }

    private Regex dayTimeIndividualRegex() {
        return this.dayTimeIndividualRegex;
    }

    private Regex dayTimeIndividualLiteralRegex() {
        return this.dayTimeIndividualLiteralRegex;
    }

    public long castStringToDTInterval(UTF8String input, byte startField, byte endField) {
        Option option;
        Option option2;
        Option option3;
        Option option4;
        Option option5;
        Option option6;
        Option option7;
        Option option8;
        Option option9;
        Option option10;
        Option option11;
        Option option12;
        String string = input.trimAll().toString();
        Option option13 = this.dayHourRegex().unapplySeq((CharSequence)string);
        if (!option13.isEmpty() && option13.get() != null && ((LinearSeqOptimized)option13.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option13.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option13.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option13.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option12 = this.dayHourLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option12.get() != null && ((LinearSeqOptimized)option12.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option12.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option12.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option12.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option12.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                return this.toDTInterval(day, hour, "0", "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option11 = this.dayMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOptimized)option11.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option11.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option11.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option11.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option10 = this.dayMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option10.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option10.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option10.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option10.get()).apply(3);
            String minute = (String)((LinearSeqOptimized)option10.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option9 = this.daySecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(6) == 0) {
            String sign = (String)((LinearSeqOptimized)option9.get()).apply(0);
            String day = (String)((LinearSeqOptimized)option9.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option9.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option9.get()).apply(3);
            String second = (String)((LinearSeqOptimized)option9.get()).apply(4);
            String micro = (String)((LinearSeqOptimized)option9.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option8 = this.daySecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(7) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option8.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option8.get()).apply(1);
            String day = (String)((LinearSeqOptimized)option8.get()).apply(2);
            String hour = (String)((LinearSeqOptimized)option8.get()).apply(3);
            String minute = (String)((LinearSeqOptimized)option8.get()).apply(4);
            String second = (String)((LinearSeqOptimized)option8.get()).apply(5);
            String micro = (String)((LinearSeqOptimized)option8.get()).apply(6);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(day, hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option7 = this.hourMinuteRegex().unapplySeq((CharSequence)string)).isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(3) == 0) {
            String sign = (String)((LinearSeqOptimized)option7.get()).apply(0);
            String hour = (String)((LinearSeqOptimized)option7.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option7.get()).apply(2);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option6 = this.hourMinuteLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(4) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option6.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option6.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option6.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option6.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                return this.toDTInterval(hour, minute, "0", this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option5 = this.hourSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(5) == 0) {
            String sign = (String)((LinearSeqOptimized)option5.get()).apply(0);
            String hour = (String)((LinearSeqOptimized)option5.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option5.get()).apply(2);
            String second = (String)((LinearSeqOptimized)option5.get()).apply(3);
            String micro = (String)((LinearSeqOptimized)option5.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option4 = this.hourSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(6) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option4.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option4.get()).apply(1);
            String hour = (String)((LinearSeqOptimized)option4.get()).apply(2);
            String minute = (String)((LinearSeqOptimized)option4.get()).apply(3);
            String second = (String)((LinearSeqOptimized)option4.get()).apply(4);
            String micro = (String)((LinearSeqOptimized)option4.get()).apply(5);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(hour, minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option3 = this.minuteSecondRegex().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(4) == 0) {
            String sign = (String)((LinearSeqOptimized)option3.get()).apply(0);
            String minute = (String)((LinearSeqOptimized)option3.get()).apply(1);
            String second = (String)((LinearSeqOptimized)option3.get()).apply(2);
            String micro = (String)((LinearSeqOptimized)option3.get()).apply(3);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(sign, this.finalSign$default$2()));
            }
        }
        if (!(option2 = this.minuteSecondLiteralRegex().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String minute = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String second = (String)((LinearSeqOptimized)option2.get()).apply(3);
            String micro = (String)((LinearSeqOptimized)option2.get()).apply(4);
            if (IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                return this.toDTInterval(minute, IntervalUtils$.secondAndMicro$1(second, micro), this.finalSign(firstSign, secondSign));
            }
        }
        if (!(option = this.dayTimeIndividualRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option.get()).apply(0);
            String value = (String)((LinearSeqOptimized)option.get()).apply(1);
            String suffix = (String)((LinearSeqOptimized)option.get()).apply(2);
            return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, MODULE$.finalSign$default$2());
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)startField), (Object)BoxesRunTime.boxToByte((byte)endField));
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by2 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.DAY() == by && DayTimeIntervalType$.MODULE$.DAY() == by2 && suffix == null && value.length() <= 9) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by3 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.HOUR() == by && DayTimeIntervalType$.MODULE$.HOUR() == by3 && suffix == null && value.length() <= 10) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 3600000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by4 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.MINUTE() == by && DayTimeIntervalType$.MODULE$.MINUTE() == by4 && suffix == null && value.length() <= 12) {
                        return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 60000000L;
                    }
                }
                if (tuple2 != null) {
                    byte by = BoxesRunTime.unboxToByte((Object)tuple2._1());
                    byte by5 = BoxesRunTime.unboxToByte((Object)tuple2._2());
                    if (DayTimeIntervalType$.MODULE$.SECOND() == by && DayTimeIntervalType$.MODULE$.SECOND() == by5 && value.length() <= 13) {
                        int n = sign;
                        switch (n) {
                            case 1: {
                                return MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix));
                            }
                            case -1: {
                                return MODULE$.parseSecondNano(new java.lang.StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString());
                            }
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                    }
                }
                if (tuple2 != null) {
                    throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        Option option14 = this.dayTimeIndividualLiteralRegex().unapplySeq((CharSequence)string);
        if (!option14.isEmpty() && option14.get() != null && ((LinearSeqOptimized)option14.get()).lengthCompare(5) == 0) {
            String firstSign = (String)((LinearSeqOptimized)option14.get()).apply(0);
            String secondSign = (String)((LinearSeqOptimized)option14.get()).apply(1);
            String value = (String)((LinearSeqOptimized)option14.get()).apply(2);
            String suffix = (String)((LinearSeqOptimized)option14.get()).apply(3);
            String unit = (String)((LinearSeqOptimized)option14.get()).apply(4);
            return BoxesRunTime.unboxToLong(this.safeToInterval("day-time", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                int sign = MODULE$.finalSign(firstSign, secondSign);
                String string = unit.toUpperCase(Locale.ROOT);
                if ("DAY".equals(string) && suffix == null && value.length() <= 9 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.DAY(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 86400000000L;
                }
                if ("HOUR".equals(string) && suffix == null && value.length() <= 10 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.HOUR(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 3600000000L;
                }
                if ("MINUTE".equals(string) && suffix == null && value.length() <= 12 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.MINUTE(), startField, endField)) {
                    return (long)sign * new StringOps(Predef$.MODULE$.augmentString(value)).toLong() * 60000000L;
                }
                if ("SECOND".equals(string) && value.length() <= 13 && IntervalUtils$.checkTargetType$2(DayTimeIntervalType$.MODULE$.SECOND(), DayTimeIntervalType$.MODULE$.SECOND(), startField, endField)) {
                    int n = sign;
                    switch (n) {
                        case 1: {
                            return MODULE$.parseSecondNano(IntervalUtils$.secondAndMicro$1(value, suffix));
                        }
                        case -1: {
                            return MODULE$.parseSecondNano(new java.lang.StringBuilder(1).append("-").append(IntervalUtils$.secondAndMicro$1(value, suffix)).toString());
                        }
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
                throw MODULE$.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)MODULE$.fallbackNotice()));
            }));
        }
        throw this.throwIllegalIntervalFormatException(input, startField, endField, "day-time", new DayTimeIntervalType(startField, endField).typeName(), (Option<String>)new Some((Object)this.fallbackNotice()));
    }

    public long toDTInterval(String day, String hour, String minute, String second, int sign) {
        long micros = 0L;
        int days = (int)this.toLongWithRange(this.dayStr(), day, 0L, this.MAX_DAY());
        micros = Math.addExact(micros, (long)(sign * days) * 86400000000L);
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, 23L);
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public long toDTInterval(String hour, String minute, String second, int sign) {
        long micros = 0L;
        long hours = this.toLongWithRange(this.hourStr(), hour, 0L, this.MAX_HOUR());
        micros = Math.addExact(micros, (long)sign * hours * 3600000000L);
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, 59L);
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public long toDTInterval(String minute, String second, int sign) {
        long micros = 0L;
        long minutes = this.toLongWithRange(this.minuteStr(), minute, 0L, this.MAX_MINUTE());
        micros = Math.addExact(micros, (long)sign * minutes * 60000000L);
        micros = Math.addExact(micros, (long)sign * this.parseSecondNano(second));
        return micros;
    }

    public CalendarInterval castDayTimeStringToInterval(String input, byte startField, byte endField) {
        long micros = this.castStringToDTInterval(UTF8String.fromString((String)input), startField, endField);
        return new CalendarInterval(0, (int)(micros / 86400000000L), micros % 86400000000L);
    }

    public CalendarInterval fromDayTimeString(String s) {
        return this.fromDayTimeString(s, DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND());
    }

    public CalendarInterval fromDayTimeString(String input, byte from, byte to) {
        Predef$.MODULE$.require(input != null, (Function0 & Serializable & scala.Serializable)() -> "Interval day-time string must be not null");
        if (BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING()))) {
            return this.parseDayTimeLegacy(input, from, to);
        }
        return this.castDayTimeStringToInterval(input, from, to);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CalendarInterval fromIntervalString(String input) {
        try {
            Object micros;
            CalendarInterval calendarInterval;
            if (!input.toLowerCase(Locale.ROOT).trim().startsWith("interval")) {
                calendarInterval = this.stringToInterval(UTF8String.fromString((String)input));
                return calendarInterval;
            }
            boolean bl = false;
            Literal literal = null;
            Expression expression = CatalystSqlParser$.MODULE$.parseExpression(input);
            if (expression instanceof Literal) {
                bl = true;
                literal = (Literal)expression;
                Object months = literal.value();
                if (months instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)months);
                    if (literal.dataType() instanceof YearMonthIntervalType) {
                        calendarInterval = new CalendarInterval(n, 0, 0L);
                        return calendarInterval;
                    }
                }
            }
            if (bl && (micros = literal.value()) instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)micros);
                if (literal.dataType() instanceof DayTimeIntervalType) {
                    calendarInterval = new CalendarInterval(0, 0, l);
                    return calendarInterval;
                }
            }
            if (!bl) throw new MatchError((Object)expression);
            Object cal = literal.value();
            DataType dataType = literal.dataType();
            if (!(cal instanceof CalendarInterval)) throw new MatchError((Object)expression);
            CalendarInterval calendarInterval2 = (CalendarInterval)cal;
            if (!CalendarIntervalType$.MODULE$.equals(dataType)) throw new MatchError((Object)expression);
            calendarInterval = calendarInterval2;
            return calendarInterval;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) throw throwable;
            Throwable e = (Throwable)option.get();
            throw QueryCompilationErrors$.MODULE$.cannotParseIntervalError(input, e);
        }
    }

    private Regex dayTimePatternLegacy() {
        return this.dayTimePatternLegacy;
    }

    private String fallbackNotice() {
        return this.fallbackNotice;
    }

    /*
     * Unable to fully structure code
     */
    private CalendarInterval parseDayTimeLegacy(String input, byte from, byte to) {
        Predef$.MODULE$.assert(input.length() == input.trim().length());
        m = this.dayTimePatternLegacy().pattern().matcher(input);
        Predef$.MODULE$.require(m.matches(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseDayTimeLegacy$1(java.lang.String ), ()Ljava/lang/String;)((String)input));
        try {
            if (m.group(1) == null) ** GOTO lbl-1000
            v0 = m.group(1);
            var7_5 = "-";
            if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
                v1 = -1;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 1;
            }
            sign = v1;
            days = m.group(2) == null ? 0 : (int)this.toLongWithRange(this.dayStr(), m.group(3), 0L, 0x7FFFFFFFL);
            hours = 0L;
            minutes = 0L;
            seconds = 0L;
            if (m.group(5) != null || from == DayTimeIntervalType$.MODULE$.MINUTE()) {
                hours = this.toLongWithRange(this.hourStr(), m.group(5), 0L, 23L);
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else if (m.group(8) != null) {
                minutes = this.toLongWithRange(this.minuteStr(), m.group(6), 0L, 59L);
                seconds = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            } else {
                hours = this.toLongWithRange(this.hourStr(), m.group(6), 0L, 23L);
                minutes = this.toLongWithRange(this.secondStr(), m.group(7), 0L, 59L);
            }
            secondsFraction = this.parseNanos(m.group(9), seconds < 0L);
            var17_12 = to;
            if (DayTimeIntervalType$.MODULE$.HOUR() == var17_12) {
                minutes = 0L;
                seconds = 0L;
                secondsFraction = 0L;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == var17_12) {
                seconds = 0L;
                secondsFraction = 0L;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == var17_12) {
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(44).append("Cannot support (").append("interval '").append(input).append("' ").append(DayTimeIntervalType$.MODULE$.fieldToString(from)).append(" to ").append(DayTimeIntervalType$.MODULE$.fieldToString(to)).append(") expression").toString());
            }
            micros = secondsFraction;
            micros = Math.addExact(micros, Math.multiplyExact(hours, 3600000000L));
            micros = Math.addExact(micros, Math.multiplyExact(minutes, 60000000L));
            micros = Math.addExact(micros, Math.multiplyExact(seconds, 1000000L));
            v2 = new CalendarInterval(0, sign * days, (long)sign * micros);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(40).append("Error parsing interval day-time string: ").append(e.getMessage()).toString(), e);
        }
        return v2;
    }

    private long parseNanos(String nanos, boolean isNegative) {
        if (nanos != null) {
            int maxNanosLen = 9;
            String alignedStr = nanos.length() < maxNanosLen ? new java.lang.StringBuilder(9).append(nanos).append("000000000").toString().substring(0, maxNanosLen) : nanos;
            long nanoSecond = this.toLongWithRange(this.nanosStr(), alignedStr, 0L, 999999999L);
            long microSecond = nanoSecond / 1000L;
            if (isNegative) {
                return -microSecond;
            }
            return microSecond;
        }
        return 0L;
    }

    private long parseSecondNano(String secondNano) {
        Option option;
        String[] stringArray = secondNano.split("\\.");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            String secondsStr = (String)((SeqLike)option2.get()).apply(0);
            return this.parseSeconds$1(secondsStr);
        }
        Option option3 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
            String string = (String)((SeqLike)option3.get()).apply(0);
            String nanosStr = (String)((SeqLike)option3.get()).apply(1);
            if ("".equals(string)) {
                return this.parseNanos(nanosStr, false);
            }
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            long seconds;
            String secondsStr = (String)((SeqLike)option.get()).apply(0);
            String nanosStr = (String)((SeqLike)option.get()).apply(1);
            return Math.addExact(seconds, this.parseNanos(nanosStr, (seconds = this.parseSeconds$1(secondsStr)) < 0L));
        }
        throw new IllegalArgumentException("Interval string does not match second-nano format of ss.nnnnnnnnn");
    }

    public long getDuration(CalendarInterval interval, TimeUnit targetUnit, int daysPerMonth) {
        long monthsDuration = Math.multiplyExact((long)daysPerMonth * 86400000000L, (long)interval.months);
        long daysDuration = Math.multiplyExact(86400000000L, (long)interval.days);
        long result = Math.addExact(interval.microseconds, Math.addExact(daysDuration, monthsDuration));
        return targetUnit.convert(result, TimeUnit.MICROSECONDS);
    }

    public int getDuration$default$3() {
        return 31;
    }

    public boolean isNegative(CalendarInterval interval, int daysPerMonth) {
        return this.getDuration(interval, TimeUnit.MICROSECONDS, daysPerMonth) < 0L;
    }

    public int isNegative$default$2() {
        return 31;
    }

    private CalendarInterval fromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedMonths = MathUtils$.MODULE$.toIntExact((long)monthsWithFraction);
        int truncatedDays = MathUtils$.MODULE$.toIntExact((long)daysWithFraction);
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval(truncatedMonths, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    private CalendarInterval safeFromDoubles(double monthsWithFraction, double daysWithFraction, double microsWithFraction) {
        int truncatedDays = (int)daysWithFraction;
        double micros = microsWithFraction + (double)86400000000L * (daysWithFraction - (double)truncatedDays);
        return new CalendarInterval((int)monthsWithFraction, truncatedDays, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(micros)));
    }

    public CalendarInterval negateExact(CalendarInterval interval) {
        int months = MathUtils$.MODULE$.negateExact(interval.months);
        int days = MathUtils$.MODULE$.negateExact(interval.days);
        long microseconds = MathUtils$.MODULE$.negateExact(interval.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval negate(CalendarInterval interval) {
        return new CalendarInterval(-interval.months, -interval.days, -interval.microseconds);
    }

    public CalendarInterval addExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.addExact(left.months, right.months);
        int days = MathUtils$.MODULE$.addExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.addExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval add(CalendarInterval left, CalendarInterval right) {
        int months = left.months + right.months;
        int days = left.days + right.days;
        long microseconds = left.microseconds + right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtractExact(CalendarInterval left, CalendarInterval right) {
        int months = MathUtils$.MODULE$.subtractExact(left.months, right.months);
        int days = MathUtils$.MODULE$.subtractExact(left.days, right.days);
        long microseconds = MathUtils$.MODULE$.subtractExact(left.microseconds, right.microseconds);
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval subtract(CalendarInterval left, CalendarInterval right) {
        int months = left.months - right.months;
        int days = left.days - right.days;
        long microseconds = left.microseconds - right.microseconds;
        return new CalendarInterval(months, days, microseconds);
    }

    public CalendarInterval multiply(CalendarInterval interval, double num) {
        return this.safeFromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval multiplyExact(CalendarInterval interval, double num) {
        return this.fromDoubles(num * (double)interval.months, num * (double)interval.days, num * (double)interval.microseconds);
    }

    public CalendarInterval divide(CalendarInterval interval, double num) {
        if (num == 0.0) {
            return null;
        }
        return this.safeFromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    public CalendarInterval divideExact(CalendarInterval interval, double num) {
        if (num == 0.0) {
            throw QueryExecutionErrors$.MODULE$.intervalDividedByZeroError(null);
        }
        return this.fromDoubles((double)interval.months / num, (double)interval.days / num, (double)interval.microseconds / num);
    }

    private final UTF8String intervalStr() {
        return this.intervalStr;
    }

    private UTF8String unitToUtf8(String unit) {
        return UTF8String.fromString((String)unit);
    }

    private final UTF8String yearStr() {
        return this.yearStr;
    }

    private final UTF8String monthStr() {
        return this.monthStr;
    }

    private final UTF8String weekStr() {
        return this.weekStr;
    }

    private final UTF8String dayStr() {
        return this.dayStr;
    }

    private final UTF8String hourStr() {
        return this.hourStr;
    }

    private final UTF8String minuteStr() {
        return this.minuteStr;
    }

    private final UTF8String secondStr() {
        return this.secondStr;
    }

    private final UTF8String millisStr() {
        return this.millisStr;
    }

    private final UTF8String microsStr() {
        return this.microsStr;
    }

    private final UTF8String nanosStr() {
        return this.nanosStr;
    }

    public CalendarInterval safeStringToInterval(UTF8String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CalendarInterval stringToInterval(UTF8String input) {
        boolean bl;
        boolean bl2;
        if (input == null) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be null", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        UTF8String s = input.trimAll().toLowerCase();
        byte[] bytes = s.getBytes();
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
        }
        ObjectRef state = ObjectRef.create((Object)IntervalUtils$ParseState$.MODULE$.PREFIX());
        IntRef i = IntRef.create((int)0);
        long currentValue = 0L;
        boolean isNegative = false;
        int months = 0;
        int days = 0;
        long microseconds = 0L;
        int fractionScale = 0;
        int initialFractionScale = (int)100000000L;
        int fraction = 0;
        boolean pointPrefixed = false;
        while (i.elem < bytes.length) {
            byte b = bytes[i.elem];
            Enumeration.Value value = (Enumeration.Value)state.elem;
            Enumeration.Value value2 = IntervalUtils$ParseState$.MODULE$.PREFIX();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                if (s.startsWith(this.intervalStr())) {
                    if (s.numBytes() == this.intervalStr().numBytes()) {
                        throw IntervalUtils$.throwIAE$1("interval string cannot be empty", IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    if (!Character.isWhitespace(bytes[i.elem + this.intervalStr().numBytes()])) {
                        throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(24).append("invalid interval prefix ").append(IntervalUtils$.currentWord$1(s, i)).toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    }
                    i.elem += this.intervalStr().numBytes() + 1;
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                continue;
            }
            Enumeration.Value value4 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.SIGN(), i, state);
                continue;
            }
            Enumeration.Value value6 = IntervalUtils$ParseState$.MODULE$.SIGN();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                currentValue = 0L;
                fraction = 0;
                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                fractionScale = -1;
                pointPrefixed = false;
                byte by = b;
                if (45 == by) {
                    isNegative = true;
                    ++i.elem;
                    continue;
                }
                if (43 == by) {
                    isNegative = false;
                    ++i.elem;
                    continue;
                }
                if (48 <= b && b <= 57) {
                    isNegative = false;
                    continue;
                }
                if (46 != by) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(22).append("unrecognized number '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                isNegative = false;
                fractionScale = initialFractionScale;
                pointPrefixed = true;
                ++i.elem;
                state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                continue;
            }
            Enumeration.Value value8 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.VALUE(), i, state);
                continue;
            }
            Enumeration.Value value10 = IntervalUtils$ParseState$.MODULE$.VALUE();
            Enumeration.Value value11 = value;
            if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                byte by = b;
                if (48 <= b && b <= 57) {
                    try {
                        currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                    }
                    catch (ArithmeticException e) {
                        throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                    }
                } else if (Character.isWhitespace(b)) {
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                } else {
                    if (46 != by) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fractionScale = initialFractionScale;
                    state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                }
                ++i.elem;
                continue;
            }
            Enumeration.Value value12 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            Enumeration.Value value13 = value;
            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                if (48 <= b && b <= 57 && fractionScale > 0) {
                    fraction += (b - 48) * fractionScale;
                    fractionScale /= 10;
                } else {
                    if (!Character.isWhitespace(b) || pointPrefixed && fractionScale >= initialFractionScale) throw 48 <= b && b <= 57 ? IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(66).append("interval can only support nanosecond precision, '").append(IntervalUtils$.currentWord$1(s, i)).append("' is out").append(" of range").toString(), IntervalUtils$.throwIAE$default$2$1(), input) : IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(16).append("invalid value '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                    fraction /= (int)1000L;
                    state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                }
                ++i.elem;
                continue;
            }
            Enumeration.Value value14 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
            Enumeration.Value value15 = value;
            if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
                IntervalUtils$.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN(), i, state);
                continue;
            }
            Enumeration.Value value16 = IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN();
            Enumeration.Value value17 = value;
            if (!(value16 != null ? !value16.equals(value17) : value17 != null)) {
                if (b != 115 && fractionScale >= 0) {
                    throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(30).append("'").append(IntervalUtils$.currentWord$1(s, i)).append("' cannot have fractional part").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                }
                if (isNegative) {
                    currentValue = -currentValue;
                    fraction = -fraction;
                }
                try {
                    byte by = b;
                    switch (by) {
                        case 121: {
                            if (!s.matchAt(this.yearStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long monthsInYears = Math.multiplyExact(12L, currentValue);
                            months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                            i.elem += this.yearStr().numBytes();
                            break;
                        }
                        case 119: {
                            if (!s.matchAt(this.weekStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long daysInWeeks = Math.multiplyExact(7L, currentValue);
                            days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                            i.elem += this.weekStr().numBytes();
                            break;
                        }
                        case 100: {
                            if (!s.matchAt(this.dayStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            days = Math.addExact(days, Math.toIntExact(currentValue));
                            i.elem += this.dayStr().numBytes();
                            break;
                        }
                        case 104: {
                            if (!s.matchAt(this.hourStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long hoursUs = Math.multiplyExact(currentValue, 3600000000L);
                            microseconds = Math.addExact(microseconds, hoursUs);
                            i.elem += this.hourStr().numBytes();
                            break;
                        }
                        case 115: {
                            if (!s.matchAt(this.secondStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            long secondsUs = Math.multiplyExact(currentValue, 1000000L);
                            microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                            i.elem += this.secondStr().numBytes();
                            break;
                        }
                        case 109: {
                            if (s.matchAt(this.monthStr(), i.elem)) {
                                months = Math.addExact(months, Math.toIntExact(currentValue));
                                i.elem += this.monthStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.minuteStr(), i.elem)) {
                                long minutesUs = Math.multiplyExact(currentValue, 60000000L);
                                microseconds = Math.addExact(microseconds, minutesUs);
                                i.elem += this.minuteStr().numBytes();
                                break;
                            }
                            if (s.matchAt(this.millisStr(), i.elem)) {
                                long millisUs = DateTimeUtils$.MODULE$.millisToMicros(currentValue);
                                microseconds = Math.addExact(microseconds, millisUs);
                                i.elem += this.millisStr().numBytes();
                                break;
                            }
                            if (!s.matchAt(this.microsStr(), i.elem)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().numBytes();
                            break;
                        }
                        default: {
                            throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        }
                    }
                }
                catch (ArithmeticException e) {
                    throw IntervalUtils$.throwIAE$1(e.getMessage(), e, input);
                }
                state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
                continue;
            }
            Enumeration.Value value18 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                byte by = b;
                switch (by) {
                    case 115: {
                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_END();
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                        break;
                    }
                }
                ++i.elem;
                continue;
            }
            Enumeration.Value value20 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value21 = value;
            if (value20 == null) {
                if (value21 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value20.equals(value21)) throw new MatchError((Object)value);
            if (!Character.isWhitespace(b)) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(15).append("invalid unit '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
            ++i.elem;
            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
        }
        Enumeration.Value value = (Enumeration.Value)state.elem;
        Enumeration.Value value22 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
        Enumeration.Value value23 = value;
        if (!(value22 != null ? !value22.equals(value23) : value23 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value24 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            Enumeration.Value value25 = value;
            if (!(value24 != null ? !value24.equals(value25) : value25 != null)) {
                bl2 = true;
            } else {
                Enumeration.Value value26 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                Enumeration.Value value27 = value;
                bl2 = !(value26 != null ? !value26.equals(value27) : value27 != null);
            }
        }
        if (bl2) return new CalendarInterval(months, days, microseconds);
        Enumeration.Value value28 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
        Enumeration.Value value29 = value;
        if (value28 == null) {
            if (value29 == null) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
        } else if (value28.equals(value29)) {
            throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(36).append("expect a number after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
        }
        Enumeration.Value value30 = IntervalUtils$ParseState$.MODULE$.VALUE();
        Enumeration.Value value31 = value;
        if (!(value30 != null ? !value30.equals(value31) : value31 != null)) {
            bl = true;
        } else {
            Enumeration.Value value32 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            Enumeration.Value value33 = value;
            bl = !(value32 != null ? !value32.equals(value33) : value33 != null);
        }
        if (!bl) throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(29).append("unknown error when parsing '").append(IntervalUtils$.currentWord$1(s, i)).append("'").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
        throw IntervalUtils$.throwIAE$1(new java.lang.StringBuilder(39).append("expect a unit name after '").append(IntervalUtils$.currentWord$1(s, i)).append("' but hit EOL").toString(), IntervalUtils$.throwIAE$default$2$1(), input);
    }

    public CalendarInterval makeInterval(int years, int months, int weeks, int days, int hours, int mins, Decimal secs) {
        int totalMonths = Math.addExact(months, Math.multiplyExact(years, 12));
        int totalDays = Math.addExact(days, Math.multiplyExact(weeks, 7));
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return new CalendarInterval(totalMonths, totalDays, micros);
    }

    public long makeDayTimeInterval(int days, int hours, int mins, Decimal secs) {
        Predef$.MODULE$.assert(secs.scale() == 6, (Function0 & Serializable & scala.Serializable)() -> "Seconds fractional must have 6 digits for microseconds");
        long micros = secs.toUnscaledLong();
        micros = Math.addExact(micros, Math.multiplyExact((long)days, 86400000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)hours, 3600000000L));
        micros = Math.addExact(micros, Math.multiplyExact((long)mins, 60000000L));
        return micros;
    }

    private final long minDurationSeconds() {
        return this.minDurationSeconds;
    }

    public long durationToMicros(Duration duration) {
        return this.durationToMicros(duration, DayTimeIntervalType$.MODULE$.SECOND());
    }

    public long durationToMicros(Duration duration, byte endField) {
        long l;
        long seconds = duration.getSeconds();
        if (seconds == this.minDurationSeconds()) {
            long microsInSeconds = (this.minDurationSeconds() + 1L) * 1000000L;
            int nanoAdjustment = duration.getNano();
            Predef$.MODULE$.assert(0 <= nanoAdjustment && (long)nanoAdjustment < 1000000000L, (Function0 & Serializable & scala.Serializable)() -> "Duration.getNano() must return the adjustment to the seconds field in the range from 0 to 999999999 nanoseconds, inclusive.");
            l = Math.addExact(microsInSeconds, ((long)nanoAdjustment - 1000000000L) / 1000L);
        } else {
            long microsInSeconds = Math.multiplyExact(seconds, 1000000L);
            l = Math.addExact(microsInSeconds, (long)duration.getNano() / 1000L);
        }
        long micros = l;
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            return micros - micros % 86400000000L;
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return micros - micros % 3600000000L;
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return micros - micros % 60000000L;
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return micros;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public Duration microsToDuration(long micros) {
        return Duration.of(micros, ChronoUnit.MICROS);
    }

    public int periodToMonths(Period period) {
        return this.periodToMonths(period, YearMonthIntervalType$.MODULE$.MONTH());
    }

    public int periodToMonths(Period period, byte endField) {
        int monthsInYears = Math.multiplyExact(period.getYears(), 12);
        int months = Math.addExact(monthsInYears, period.getMonths());
        if (endField == YearMonthIntervalType$.MODULE$.YEAR()) {
            return months - months % 12;
        }
        return months;
    }

    public Period monthsToPeriod(int months) {
        return Period.ofMonths(months).normalized();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toYearMonthIntervalString(int months, Enumeration.Value style, byte startField, byte endField) {
        String sign = "";
        long absMonths = months;
        if (months < 0) {
            sign = "-";
            absMonths = -absMonths;
        }
        String year = new java.lang.StringBuilder(0).append(sign).append(absMonths / 12L).toString();
        String yearAndMonth = new java.lang.StringBuilder(1).append(year).append("-").append(absMonths % 12L).toString();
        Enumeration.Value value = style;
        Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            StringBuilder stringBuilder;
            StringBuilder formatBuilder = new StringBuilder("INTERVAL '");
            if (startField == endField) {
                byte by = startField;
                if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
                    stringBuilder = formatBuilder.append(new java.lang.StringBuilder(6).append(year).append("' YEAR").toString());
                    return formatBuilder.toString();
                } else {
                    if (YearMonthIntervalType$.MODULE$.MONTH() != by) throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                    stringBuilder = formatBuilder.append(new java.lang.StringBuilder(7).append(months).append("' MONTH").toString());
                }
                return formatBuilder.toString();
            } else {
                stringBuilder = formatBuilder.append(new java.lang.StringBuilder(15).append(yearAndMonth).append("' YEAR TO MONTH").toString());
            }
            return formatBuilder.toString();
        }
        Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
        Enumeration.Value value5 = value;
        if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
        return String.valueOf(yearAndMonth);
    }

    public String toDayTimeIntervalString(long micros, Enumeration.Value style, byte startField, byte endField) {
        String string;
        String sign = "";
        long rest = micros;
        String from = DayTimeIntervalType$.MODULE$.fieldToString(startField).toUpperCase();
        String to = DayTimeIntervalType$.MODULE$.fieldToString(endField).toUpperCase();
        String prefix = "INTERVAL '";
        String postfix = new java.lang.StringBuilder(2).append("' ").append((Object)(startField == endField ? from : new java.lang.StringBuilder(4).append(from).append(" TO ").append(to).toString())).toString();
        if (micros < 0L) {
            if (micros == Long.MIN_VALUE) {
                String string2;
                String baseStr = "-106751991 04:00:54.775808000";
                Enumeration.Value value = style;
                Enumeration.Value value2 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    String string3;
                    String string4;
                    byte by = startField;
                    if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_DAY()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_HOUR()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                        string4 = new java.lang.StringBuilder(1).append("-").append(this.MAX_MINUTE()).toString();
                    } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                        string4 = new java.lang.StringBuilder(8).append("-").append(this.MAX_SECOND()).append(".775808").toString();
                    } else {
                        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                    }
                    String firstStr = string4;
                    if (startField == endField) {
                        string3 = "";
                    } else {
                        int n;
                        int n2;
                        byte by2 = startField;
                        if (DayTimeIntervalType$.MODULE$.DAY() == by2) {
                            n2 = 10;
                        } else if (DayTimeIntervalType$.MODULE$.HOUR() == by2) {
                            n2 = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by2) {
                            n2 = 16;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by2));
                        }
                        int substrStart = n2;
                        byte by3 = endField;
                        if (DayTimeIntervalType$.MODULE$.HOUR() == by3) {
                            n = 13;
                        } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by3) {
                            n = 16;
                        } else if (DayTimeIntervalType$.MODULE$.SECOND() == by3) {
                            n = 26;
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by3));
                        }
                        int substrEnd = n;
                        string3 = baseStr.substring(substrStart, substrEnd);
                    }
                    String followingStr = string3;
                    string2 = new java.lang.StringBuilder(0).append(prefix).append(firstStr).append(followingStr).append(postfix).toString();
                } else {
                    Enumeration.Value value4 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        string2 = baseStr;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                String minIntervalString = string2;
                return minIntervalString;
            }
            sign = "-";
            rest = -rest;
        }
        Enumeration.Value value = style;
        Enumeration.Value value6 = IntervalStringStyles$.MODULE$.ANSI_STYLE();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            BoxedUnit boxedUnit;
            StringBuilder formatBuilder = new StringBuilder(sign);
            ArrayBuffer formatArgs = new ArrayBuffer();
            byte by = startField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                formatBuilder.append(rest / 86400000000L);
                rest %= 86400000000L;
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{rest / 3600000000L}));
                rest %= 3600000000L;
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                formatBuilder.append("%02d");
                formatArgs.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{rest / 60000000L}));
                rest %= 60000000L;
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                String leadZero = rest < 10000000L ? "0" : "";
                formatBuilder.append(new java.lang.StringBuilder(0).append(leadZero).append(java.math.BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString()).toString());
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            if (startField < DayTimeIntervalType$.MODULE$.HOUR() && DayTimeIntervalType$.MODULE$.HOUR() <= endField) {
                formatBuilder.append(" %02d");
                formatArgs.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{rest / 3600000000L}));
                rest %= 3600000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.MINUTE() && DayTimeIntervalType$.MODULE$.MINUTE() <= endField) {
                formatBuilder.append(":%02d");
                formatArgs.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{rest / 60000000L}));
                rest %= 60000000L;
            }
            if (startField < DayTimeIntervalType$.MODULE$.SECOND() && DayTimeIntervalType$.MODULE$.SECOND() <= endField) {
                String leadZero = rest < 10000000L ? "0" : "";
                boxedUnit = formatBuilder.append(new java.lang.StringBuilder(1).append(":").append(leadZero).append(java.math.BigDecimal.valueOf(rest, 6).stripTrailingZeros().toPlainString()).toString());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            string = new java.lang.StringBuilder(0).append(prefix).append(new StringOps(Predef$.MODULE$.augmentString(formatBuilder.toString())).format(formatArgs.toSeq())).append(postfix).toString();
        } else {
            Enumeration.Value value8 = IntervalStringStyles$.MODULE$.HIVE_STYLE();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                long secondsWithFraction = rest % 60000000L;
                long minutes = (rest /= 60000000L) % 60L;
                long hours = (rest /= 60L) % 24L;
                long days = rest / 24L;
                long seconds = secondsWithFraction / 1000000L;
                long nanos = secondsWithFraction % 1000000L * 1000L;
                String arg$macro$1 = sign;
                Long arg$macro$2 = BoxesRunTime.boxToLong((long)days);
                long arg$macro$3 = hours;
                long arg$macro$4 = minutes;
                long arg$macro$5 = seconds;
                long arg$macro$6 = nanos;
                string = new StringOps("%s%s %02d:%02d:%02d.%09d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, BoxesRunTime.boxToLong((long)arg$macro$3), BoxesRunTime.boxToLong((long)arg$macro$4), BoxesRunTime.boxToLong((long)arg$macro$5), BoxesRunTime.boxToLong((long)arg$macro$6)}));
            } else {
                throw new MatchError((Object)value);
            }
        }
        String intervalString = string;
        return intervalString;
    }

    public int intToYearMonthInterval(int v, byte startField, byte endField) {
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            int n;
            try {
                n = Math.multiplyExact(v, 12);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), IntegerType$.MODULE$, new YearMonthIntervalType(startField, endField));
            }
            return n;
        }
        if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            return v;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public int longToYearMonthInterval(long v, byte startField, byte endField) {
        int vInt = (int)v;
        if (v != (long)vInt) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), LongType$.MODULE$, new YearMonthIntervalType(startField, endField));
        }
        return this.intToYearMonthInterval(vInt, startField, endField);
    }

    public int decimalToYearMonthInterval(Decimal d, int p, int s, byte startField, byte endField) {
        int n;
        try {
            BigDecimal months = endField == YearMonthIntervalType$.MODULE$.YEAR() ? d.toBigDecimal().$times(BigDecimal$.MODULE$.int2bigDecimal(12)) : d.toBigDecimal();
            n = months.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toIntExact();
        }
        catch (ArithmeticException arithmeticException) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(d, new DecimalType(p, s), new YearMonthIntervalType(startField, endField));
        }
        return n;
    }

    public int yearMonthIntervalToInt(int v, byte startField, byte endField) {
        byte by = endField;
        if (YearMonthIntervalType$.MODULE$.YEAR() == by) {
            return v / 12;
        }
        if (YearMonthIntervalType$.MODULE$.MONTH() == by) {
            return v;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public short yearMonthIntervalToShort(int v, byte startField, byte endField) {
        short vShort;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vShort = (short)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), new YearMonthIntervalType(startField, endField), ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte yearMonthIntervalToByte(int v, byte startField, byte endField) {
        byte vByte;
        int vInt = this.yearMonthIntervalToInt(v, startField, endField);
        if (vInt != (vByte = (byte)vInt)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), new YearMonthIntervalType(startField, endField), ByteType$.MODULE$);
        }
        return vByte;
    }

    public long intToDayTimeInterval(int v, byte startField, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            long l;
            try {
                l = Math.multiplyExact((long)v, 86400000000L);
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToInteger((int)v), IntegerType$.MODULE$, new DayTimeIntervalType(startField, endField));
            }
            return l;
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return (long)v * 3600000000L;
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return (long)v * 60000000L;
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return (long)v * 1000000L;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long longToDayTimeInterval(long v, byte startField, byte endField) {
        long l;
        block6: {
            try {
                byte by = endField;
                if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                    l = Math.multiplyExact(v, 86400000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                    l = Math.multiplyExact(v, 3600000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                    l = Math.multiplyExact(v, 60000000L);
                    break block6;
                }
                if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                    l = Math.multiplyExact(v, 1000000L);
                    break block6;
                }
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            catch (ArithmeticException arithmeticException) {
                throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), LongType$.MODULE$, new DayTimeIntervalType(startField, endField));
            }
        }
        return l;
    }

    public long dayTimeIntervalToLong(long v, byte startField, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            return v / 86400000000L;
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return v / 3600000000L;
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return v / 60000000L;
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return v / 1000000L;
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public Decimal dayTimeIntervalToDecimal(long v, byte endField) {
        byte by = endField;
        if (DayTimeIntervalType$.MODULE$.DAY() == by) {
            return Decimal$.MODULE$.apply(v / 86400000000L);
        }
        if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
            return Decimal$.MODULE$.apply(v / 3600000000L);
        }
        if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
            return Decimal$.MODULE$.apply(v / 60000000L);
        }
        if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
            return Decimal$.MODULE$.apply(v, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6);
        }
        throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
    }

    public long decimalToDayTimeInterval(Decimal d, int p, int s, byte startField, byte endField) {
        long l;
        try {
            BigDecimal bigDecimal;
            byte by = endField;
            if (DayTimeIntervalType$.MODULE$.DAY() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(86400000000L));
            } else if (DayTimeIntervalType$.MODULE$.HOUR() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(3600000000L));
            } else if (DayTimeIntervalType$.MODULE$.MINUTE() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(60000000L));
            } else if (DayTimeIntervalType$.MODULE$.SECOND() == by) {
                bigDecimal = d.toBigDecimal().$times(BigDecimal$.MODULE$.long2bigDecimal(1000000L));
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
            }
            BigDecimal micros = bigDecimal;
            l = micros.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toLongExact();
        }
        catch (ArithmeticException arithmeticException) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(d, new DecimalType(p, s), new DayTimeIntervalType(startField, endField));
        }
        return l;
    }

    public int dayTimeIntervalToInt(long v, byte startField, byte endField) {
        int vInt;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vInt = (int)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), IntegerType$.MODULE$);
        }
        return vInt;
    }

    public short dayTimeIntervalToShort(long v, byte startField, byte endField) {
        short vShort;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vShort = (short)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), ShortType$.MODULE$);
        }
        return vShort;
    }

    public byte dayTimeIntervalToByte(long v, byte startField, byte endField) {
        byte vByte;
        long vLong = this.dayTimeIntervalToLong(v, startField, endField);
        if (vLong != (long)(vByte = (byte)vLong)) {
            throw QueryExecutionErrors$.MODULE$.castingCauseOverflowError(BoxesRunTime.boxToLong((long)v), new DayTimeIntervalType(startField, endField), ByteType$.MODULE$);
        }
        return vByte;
    }

    private static final boolean checkTargetType$1(byte targetStartField, byte targetEndField, byte startField$1, byte endField$1) {
        return startField$1 == targetStartField && endField$1 == targetEndField;
    }

    private static final String secondAndMicro$1(String second, String micro) {
        if (micro != null) {
            return new java.lang.StringBuilder(0).append(second).append(micro).toString();
        }
        return second;
    }

    private static final boolean checkTargetType$2(byte targetStartField, byte targetEndField, byte startField$2, byte endField$2) {
        return startField$2 == targetStartField && endField$2 == targetEndField;
    }

    public static final /* synthetic */ String $anonfun$parseDayTimeLegacy$1(String input$3) {
        return new java.lang.StringBuilder(61).append("Interval string must match day-time format of 'd h:m:s.n': ").append(input$3).append(", ").append(MODULE$.fallbackNotice()).toString();
    }

    private final long parseSeconds$1(String secondsStr) {
        return this.toLongWithRange(this.secondStr(), secondsStr, this.MIN_SECOND(), this.MAX_SECOND()) * 1000000L;
    }

    private static final Nothing$ throwIAE$1(String msg, Exception e, UTF8String input$4) {
        throw new IllegalArgumentException(new java.lang.StringBuilder(30).append("Error parsing '").append(input$4).append("' to interval, ").append(msg).toString(), e);
    }

    private static final Exception throwIAE$default$2$1() {
        return null;
    }

    private static final void trimToNextState$1(byte b, Enumeration.Value next, IntRef i$1, ObjectRef state$1) {
        if (Character.isWhitespace(b)) {
            ++i$1.elem;
            return;
        }
        state$1.elem = next;
    }

    private static final String currentWord$1(UTF8String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.toString().split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.numBytes()).toString().split(sep).length;
        return strings[strings.length - lenRight];
    }

    private IntervalUtils$() {
        MODULE$ = this;
        this.MAX_DAY = 106751991L;
        this.MAX_HOUR = 2562047788L;
        this.MAX_MINUTE = 153722867280L;
        this.MAX_SECOND = 9223372036854L;
        this.MIN_SECOND = -9223372036854L;
        this.yearMonthPatternString = "([+|-])?(\\d+)-(\\d+)";
        this.yearMonthRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.yearMonthPatternString()).append("$").toString())).r();
        this.yearMonthLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.yearMonthPatternString()).append("'\\s+YEAR\\s+TO\\s+MONTH$").toString())).r();
        this.yearMonthIndividualPatternString = "([+|-])?(\\d+)";
        this.yearMonthIndividualRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.yearMonthIndividualPatternString()).append("$").toString())).r();
        this.yearMonthIndividualLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(42).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.yearMonthIndividualPatternString()).append("'\\s+(YEAR|MONTH)$").toString())).r();
        this.supportedFormat = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new .colon.colon((Object)"[+|-]y-m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]y-m' YEAR TO MONTH", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.YEAR()))), (Object)new .colon.colon((Object)"[+|-]y", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]y' YEAR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()), (Object)BoxesRunTime.boxToByte((byte)YearMonthIntervalType$.MODULE$.MONTH()))), (Object)new .colon.colon((Object)"[+|-]m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m' MONTH", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()))), (Object)new .colon.colon((Object)"[+|-]d", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d' DAY", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)new .colon.colon((Object)"[+|-]d h", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h' DAY TO HOUR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]d h:m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h:m' DAY TO MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]d h:m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]d h:m:s.n' DAY TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()))), (Object)new .colon.colon((Object)"[+|-]h", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h' HOUR", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]h:m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h:m' HOUR TO MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]h:m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]h:m:s.n' HOUR TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()))), (Object)new .colon.colon((Object)"[+|-]m", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m' MINUTE", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]m:s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]m:s.n' MINUTE TO SECOND", (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))), (Object)new .colon.colon((Object)"[+|-]s.n", (List)new .colon.colon((Object)"INTERVAL [+|-]'[+|-]s.n' SECOND", (List)Nil$.MODULE$)))}));
        this.normalPattern = "(\\d{1,2})";
        this.dayBoundPattern = "(\\d{1,9})";
        this.hourBoundPattern = "(\\d{1,10})";
        this.minuteBoundPattern = "(\\d{1,12})";
        this.secondBoundPattern = "(\\d{1,13})";
        this.microPattern = "(\\.\\d{1,9})";
        this.dayHourPatternString = new java.lang.StringBuilder(9).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).toString();
        this.dayHourRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.dayHourPatternString()).append("$").toString())).r();
        this.dayHourLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(47).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.dayHourPatternString()).append("\\'\\s+DAY\\s+TO\\s+HOUR$").toString())).r();
        this.dayMinutePatternString = new java.lang.StringBuilder(10).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).toString();
        this.dayMinuteRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.dayMinutePatternString()).append("$").toString())).r();
        this.dayMinuteLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.dayMinutePatternString()).append("\\'\\s+DAY\\s+TO\\s+MINUTE$").toString())).r();
        this.daySecondPatternString = new java.lang.StringBuilder(12).append("([+|-])?").append(this.dayBoundPattern()).append(" ").append(this.normalPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.daySecondRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.daySecondPatternString()).append("$").toString())).r();
        this.daySecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(49).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.daySecondPatternString()).append("\\'\\s+DAY\\s+TO\\s+SECOND$").toString())).r();
        this.hourMinutePatternString = new java.lang.StringBuilder(9).append("([+|-])?").append(this.hourBoundPattern()).append(":").append(this.normalPattern()).toString();
        this.hourMinuteRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.hourMinutePatternString()).append("$").toString())).r();
        this.hourMinuteLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.hourMinutePatternString()).append("\\'\\s+HOUR\\s+TO\\s+MINUTE$").toString())).r();
        this.hourSecondPatternString = new java.lang.StringBuilder(11).append("([+|-])?").append(this.hourBoundPattern()).append(":").append(this.normalPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.hourSecondRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.hourSecondPatternString()).append("$").toString())).r();
        this.hourSecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.hourSecondPatternString()).append("\\'\\s+HOUR\\s+TO\\s+SECOND$").toString())).r();
        this.minuteSecondPatternString = new java.lang.StringBuilder(10).append("([+|-])?").append(this.minuteBoundPattern()).append(":").append(this.normalPattern()).append(this.microPattern()).append("?").toString();
        this.minuteSecondRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.minuteSecondPatternString()).append("$").toString())).r();
        this.minuteSecondLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(52).append("(?i)^INTERVAL\\s+([+|-])?\\'").append(this.minuteSecondPatternString()).append("\\'\\s+MINUTE\\s+TO\\s+SECOND$").toString())).r();
        this.dayTimeIndividualPatternString = new java.lang.StringBuilder(20).append("([+|-])?").append(this.secondBoundPattern()).append("(\\.\\d{1,9})?").toString();
        this.dayTimeIndividualRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(2).append("^").append(this.dayTimeIndividualPatternString()).append("$").toString())).r();
        this.dayTimeIndividualLiteralRegex = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(54).append("(?i)^INTERVAL\\s+([+|-])?'").append(this.dayTimeIndividualPatternString()).append("'\\s+(DAY|HOUR|MINUTE|SECOND)$").toString())).r();
        this.dayTimePatternLegacy = new StringOps(Predef$.MODULE$.augmentString("^([+|-])?((\\d+) )?((\\d+):)?(\\d+):(\\d+)(\\.(\\d+))?$")).r();
        this.fallbackNotice = new java.lang.StringBuilder(54).append("set ").append(SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()).append(" to true ").append("to restore the behavior before Spark 3.0.").toString();
        this.intervalStr = this.unitToUtf8("interval");
        this.yearStr = this.unitToUtf8("year");
        this.monthStr = this.unitToUtf8("month");
        this.weekStr = this.unitToUtf8("week");
        this.dayStr = this.unitToUtf8("day");
        this.hourStr = this.unitToUtf8("hour");
        this.minuteStr = this.unitToUtf8("minute");
        this.secondStr = this.unitToUtf8("second");
        this.millisStr = this.unitToUtf8("millisecond");
        this.microsStr = this.unitToUtf8("microsecond");
        this.nanosStr = this.unitToUtf8("nanosecond");
        this.minDurationSeconds = Math.floorDiv(Long.MIN_VALUE, 1000000L);
    }
}

