/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatchRow;

@DeveloperApi
public class ColumnarBatch
implements AutoCloseable {
    protected int numRows;
    protected final ColumnVector[] columns;
    protected final ColumnarBatchRow row;

    @Override
    public void close() {
        for (ColumnVector c : this.columns) {
            c.close();
        }
    }

    public Iterator<InternalRow> rowIterator() {
        final int maxRows = this.numRows;
        final ColumnarBatchRow row = new ColumnarBatchRow(this.columns);
        return new Iterator<InternalRow>(){
            int rowId = 0;

            @Override
            public boolean hasNext() {
                return this.rowId < maxRows;
            }

            @Override
            public InternalRow next() {
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                row.rowId = this.rowId++;
                return row;
            }
        };
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int numCols() {
        return this.columns.length;
    }

    public int numRows() {
        return this.numRows;
    }

    public ColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }

    public InternalRow getRow(int rowId) {
        assert (rowId >= 0 && rowId < this.numRows);
        this.row.rowId = rowId;
        return this.row;
    }

    public ColumnarBatch(ColumnVector[] columns) {
        this(columns, 0);
    }

    public ColumnarBatch(ColumnVector[] columns, int numRows) {
        this.columns = columns;
        this.numRows = numRows;
        this.row = new ColumnarBatchRow(columns);
    }
}

