/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0003\t\u0012!\u0003\r\taE\u000e\t\u000b\t\u0002A\u0011\u0001\u0013\t\u000b!\u0002A\u0011A\u0015\t\u000b\t\u0003A\u0011B\"\t\u000b\u0019\u0003A\u0011A$\t\u000b)\u0003A\u0011A&\t\u000b)\u0003A\u0011A,\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0015\u0004A\u0011\u00014\t\u000b!\u0004A\u0011A5\t\u000b1\u0004A\u0011A7\t\u000ba\u0004A\u0011A=\t\u000bq\u0004A\u0011A?\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\ty\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cXM\u0003\u0002\u0013'\u00051QM\u001d:peNT!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h'\t\u0001A\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\tQ\u0005\u0005\u0002\u001eM%\u0011qE\b\u0002\u0005+:LG/\u0001\u0006u_N\u000bFJV1mk\u0016$2AK\u001b;!\tY#G\u0004\u0002-aA\u0011QFH\u0007\u0002])\u0011qfI\u0001\u0007yI|w\u000e\u001e \n\u0005Er\u0012A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0010\t\u000bY\u0012\u0001\u0019A\u001c\u0002\u0003Y\u0004\"!\b\u001d\n\u0005er\"aA!os\")1H\u0001a\u0001y\u0005\tA\u000f\u0005\u0002>\u00016\taH\u0003\u0002@'\u0005)A/\u001f9fg&\u0011\u0011I\u0010\u0002\t\t\u0006$\u0018\rV=qK\u0006q\u0011/^8uK\nKH)\u001a4bk2$HC\u0001\u0016E\u0011\u0015)5\u00011\u0001+\u0003\u0011)G.Z7\u0002\u0013Q|7+\u0015'Ti6$HC\u0001\u0016I\u0011\u0015IE\u00011\u0001+\u0003\u0011!X\r\u001f;\u0002\u000fQ|7+\u0015'JIR\u0011!\u0006\u0014\u0005\u0006\u001b\u0016\u0001\rAT\u0001\u0006a\u0006\u0014Ho\u001d\t\u0004\u001fRScB\u0001)S\u001d\ti\u0013+C\u0001 \u0013\t\u0019f$A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&aA*fc*\u00111K\b\u000b\u0003UaCQ!\u0014\u0004A\u0002)\n\u0011\u0002^8T#2#\u0016\u0010]3\u0015\u0005)Z\u0006\"B\u001e\b\u0001\u0004a\u0006CA\u001f^\u0013\tqfH\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKR\u0011!\u0006\u0019\u0005\u0006\u0013\"\u0001\rAK\u0001\ni>\u001c\u0016\u000bT\"p]\u001a$\"AK2\t\u000b\u0011L\u0001\u0019\u0001\u0016\u0002\t\r|gNZ\u0001\ri>\u001c\u0016\u000bT\"p]\u001a4\u0016\r\u001c\u000b\u0003U\u001dDQ\u0001\u001a\u0006A\u0002)\n!\u0002^8E'>\u0003H/[8o)\tQ#\u000eC\u0003l\u0017\u0001\u0007!&\u0001\u0004paRLwN\\\u0001\ni>\u001c\u0016\u000bT#yaJ$\"A\u000b8\t\u000b=d\u0001\u0019\u00019\u0002\u0003\u0015\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003kN\t\u0001bY1uC2L8\u000f^\u0005\u0003oJ\u0014!\"\u0012=qe\u0016\u001c8/[8o\u0003-!xnU)M'\u000eDW-\\1\u0015\u0005)R\b\"B>\u000e\u0001\u0004Q\u0013AB:dQ\u0016l\u0017-\u0001\u0006hKR\u001cV/\\7bef$\"A\u000b@\t\r}t\u0001\u0019AA\u0001\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001;\u0002\u000bQ\u0014X-Z:\n\t\u0005-\u0011Q\u0001\u0002\u0010'Fc\u0015+^3ss\u000e{g\u000e^3yi\u0006yq-\u001a;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0006\u0003\u0002\u0012\u0005}\u0001#B\u000f\u0002\u0014\u0005]\u0011bAA\u000b=\t)\u0011I\u001d:bsB!\u0011\u0011DA\u000e\u001b\u0005)\u0012bAA\u000f+\ta\u0011+^3ss\u000e{g\u000e^3yi\"1qp\u0004a\u0001\u0003\u0003\u0001")
public interface QueryErrorsBase {
    public static /* synthetic */ String toSQLValue$(QueryErrorsBase $this, Object v, DataType t) {
        return $this.toSQLValue(v, t);
    }

    default public String toSQLValue(Object v, DataType t) {
        Object object;
        Literal literal = Literal$.MODULE$.create(v, t);
        if (literal != null && (object = literal.value()) == null) {
            return "NULL";
        }
        if (literal != null) {
            Object v2 = literal.value();
            DataType dataType = literal.dataType();
            if (v2 instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)v2);
                if (FloatType$.MODULE$.equals(dataType)) {
                    if (Float.isNaN(f)) {
                        return "NaN";
                    }
                    if (RichFloat$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "Infinity";
                    }
                    if (RichFloat$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.floatWrapper(f))) {
                        return "-Infinity";
                    }
                    return Float.toString(f);
                }
            }
        }
        if (literal != null) {
            Object v3 = literal.value();
            DataType dataType = literal.dataType();
            if (v3 instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)v3);
                if (DoubleType$.MODULE$.equals(dataType)) {
                    if (Double.isNaN(d)) {
                        return "NaN";
                    }
                    if (RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                        return "Infinity";
                    }
                    if (RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(d))) {
                        return "-Infinity";
                    }
                    return literal.sql();
                }
            }
        }
        return literal.sql();
    }

    private String quoteByDefault(String elem) {
        return new StringBuilder(2).append("\"").append(elem).append("\"").toString();
    }

    public static /* synthetic */ String toSQLStmt$(QueryErrorsBase $this, String text) {
        return $this.toSQLStmt(text);
    }

    default public String toSQLStmt(String text) {
        return text.toUpperCase(Locale.ROOT);
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, Seq parts) {
        return $this.toSQLId((Seq<String>)parts);
    }

    default public String toSQLId(Seq<String> parts) {
        return ((TraversableOnce)parts.map((Function1 & Serializable & scala.Serializable)name -> package$.MODULE$.quoteIdentifier((String)name), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public static /* synthetic */ String toSQLId$(QueryErrorsBase $this, String parts) {
        return $this.toSQLId(parts);
    }

    default public String toSQLId(String parts) {
        return this.toSQLId(UnresolvedAttribute$.MODULE$.parseAttributeName(parts));
    }

    public static /* synthetic */ String toSQLType$(QueryErrorsBase $this, AbstractDataType t) {
        return $this.toSQLType(t);
    }

    default public String toSQLType(AbstractDataType t2) {
        AbstractDataType abstractDataType = t2;
        Option<Seq<AbstractDataType>> option = TypeCollection$.MODULE$.unapply(abstractDataType);
        if (!option.isEmpty()) {
            Seq types = (Seq)option.get();
            return ((TraversableOnce)types.map((Function1 & Serializable & scala.Serializable)t -> this.toSQLType((AbstractDataType)t), Seq$.MODULE$.canBuildFrom())).mkString("(", " or ", ")");
        }
        if (abstractDataType instanceof DataType) {
            DataType dataType = (DataType)abstractDataType;
            return this.quoteByDefault(dataType.sql());
        }
        return this.quoteByDefault(abstractDataType.simpleString().toUpperCase(Locale.ROOT));
    }

    public static /* synthetic */ String toSQLType$(QueryErrorsBase $this, String text) {
        return $this.toSQLType(text);
    }

    default public String toSQLType(String text) {
        return this.quoteByDefault(text.toUpperCase(Locale.ROOT));
    }

    public static /* synthetic */ String toSQLConf$(QueryErrorsBase $this, String conf) {
        return $this.toSQLConf(conf);
    }

    default public String toSQLConf(String conf) {
        return this.quoteByDefault(conf);
    }

    public static /* synthetic */ String toSQLConfVal$(QueryErrorsBase $this, String conf) {
        return $this.toSQLConfVal(conf);
    }

    default public String toSQLConfVal(String conf) {
        return this.quoteByDefault(conf);
    }

    public static /* synthetic */ String toDSOption$(QueryErrorsBase $this, String option) {
        return $this.toDSOption(option);
    }

    default public String toDSOption(String option) {
        return this.quoteByDefault(option);
    }

    public static /* synthetic */ String toSQLExpr$(QueryErrorsBase $this, Expression e) {
        return $this.toSQLExpr(e);
    }

    default public String toSQLExpr(Expression e) {
        return this.quoteByDefault(package$.MODULE$.toPrettySQL(e));
    }

    public static /* synthetic */ String toSQLSchema$(QueryErrorsBase $this, String schema) {
        return $this.toSQLSchema(schema);
    }

    default public String toSQLSchema(String schema) {
        return this.quoteByDefault(schema);
    }

    public static /* synthetic */ String getSummary$(QueryErrorsBase $this, SQLQueryContext sqlContext) {
        return $this.getSummary(sqlContext);
    }

    default public String getSummary(SQLQueryContext sqlContext) {
        if (sqlContext == null) {
            return "";
        }
        return sqlContext.summary();
    }

    public static /* synthetic */ QueryContext[] getQueryContext$(QueryErrorsBase $this, SQLQueryContext sqlContext) {
        return $this.getQueryContext(sqlContext);
    }

    default public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        if (sqlContext == null) {
            return (QueryContext[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(QueryContext.class));
        }
        return (QueryContext[])((Object[])new QueryContext[]{sqlContext});
    }

    public static void $init$(QueryErrorsBase $this) {
    }
}

