/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.SupportsDeleteV2;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.internal.connector.PredicateUtils;
import org.apache.spark.sql.sources.AlwaysTrue;
import org.apache.spark.sql.sources.Filter;

@Evolving
public interface SupportsDelete
extends SupportsDeleteV2 {
    default public boolean canDeleteWhere(Filter[] filters) {
        return true;
    }

    public void deleteWhere(Filter[] var1);

    @Override
    default public boolean canDeleteWhere(Predicate[] predicates) {
        Filter[] v1Filters = PredicateUtils.toV1(predicates);
        if (v1Filters.length < predicates.length) {
            return false;
        }
        return this.canDeleteWhere(v1Filters);
    }

    @Override
    default public void deleteWhere(Predicate[] predicates) {
        this.deleteWhere(PredicateUtils.toV1(predicates));
    }

    @Override
    default public boolean truncateTable() {
        Filter[] filters = new Filter[]{new AlwaysTrue()};
        boolean canDelete = this.canDeleteWhere(filters);
        if (canDelete) {
            this.deleteWhere(filters);
        }
        return canDelete;
    }
}

