/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class UnsafeRowUtils$ {
    public static UnsafeRowUtils$ MODULE$;

    static {
        new UnsafeRowUtils$();
    }

    public boolean validateStructuralIntegrity(UnsafeRow row, StructType expectedSchema) {
        boolean bl;
        Object object = new Object();
        try {
            if (expectedSchema.fields().length != row.numFields()) {
                return false;
            }
            int bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
            int rowSizeInBytes = row.getSizeInBytes();
            if (expectedSchema.fields().length > 0 && bitSetWidthInBytes >= rowSizeInBytes) {
                return false;
            }
            IntRef varLenFieldsSizeInBytes = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                UnsafeRowUtils$.$anonfun$validateStructuralIntegrity$1(row, bitSetWidthInBytes, rowSizeInBytes, object, varLenFieldsSizeInBytes, x0$1);
                return BoxedUnit.UNIT;
            });
            if (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem > rowSizeInBytes) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Tuple2<Object, Object> getOffsetAndSize(UnsafeRow row, int index) {
        long offsetAndSize = row.getLong(index);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return new Tuple2.mcII.sp(offset, size);
    }

    public boolean avoidSetNullAt(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        if (dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return true;
        }
        return CalendarIntervalType$.MODULE$.equals(dataType);
    }

    public static final /* synthetic */ void $anonfun$validateStructuralIntegrity$1(UnsafeRow row$1, int bitSetWidthInBytes$1, int rowSizeInBytes$1, Object nonLocalReturnKey1$1, IntRef varLenFieldsSizeInBytes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (!UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row$1, index);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                int offset = tuple22._1$mcI$sp();
                int size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                int offset2 = sp2._1$mcI$sp();
                int size2 = sp2._2$mcI$sp();
                if (size2 < 0 || offset2 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset2 + size2 > rowSizeInBytes$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                varLenFieldsSizeInBytes$1.elem += size2;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 1 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 8 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 16 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                }
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (row$1.isNullAt(index)) {
                DecimalType decimalType;
                DataType dataType = field.dataType();
                if (dataType instanceof DecimalType && !UnsafeRow.isFixedLength(decimalType = (DecimalType)dataType)) {
                    Tuple2<Object, Object> tuple23 = MODULE$.getOffsetAndSize(row$1, index);
                    if (tuple23 == null) {
                        throw new MatchError(tuple23);
                    }
                    int offset = tuple23._1$mcI$sp();
                    int size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(offset, size);
                    int offset3 = sp3._1$mcI$sp();
                    int size3 = sp3._2$mcI$sp();
                    if (size3 != 0 || offset3 != 0 && (offset3 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset3 > rowSizeInBytes$1)) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                } else if (row$1.getLong(index) != 0L) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                return;
            }
        }
    }

    private UnsafeRowUtils$() {
        MODULE$ = this;
    }
}

