/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectList$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a list of non-unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2,1]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001\u0002\u0014(\u0001ZB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005#\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003Y\u0011!a\u0006A!f\u0001\n\u00039\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u0011\u0019\u0004\u0001R1A\u0005B\u001dDQA\u001c\u0001\u0005B=DQA\u001d\u0001\u0005BMDQ!\u001f\u0001\u0005BiDQ! \u0001\u0005ByDaa \u0001\u0005B\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003C\u0001A\u0011KA\u0012\u0011%\tI\u0003AA\u0001\n\u0003\tY\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003\u001bB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0011\u0005\u0015\u0004!!A\u0005\u0002]C\u0011\"a\u001a\u0001\u0003\u0003%\t!!\u001b\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\t9\tAA\u0001\n\u0003\nIiB\u0005\u00024\u001e\n\t\u0011#\u0001\u00026\u001aAaeJA\u0001\u0012\u0003\t9\f\u0003\u0004_9\u0011\u0005\u0011Q\u0019\u0005\n\u0003\u000fd\u0012\u0011!C#\u0003\u0013D\u0011\"a3\u001d\u0003\u0003%\t)!4\t\u0013\u0005UG$%A\u0005\u0002\u00055\u0003\"CAl9E\u0005I\u0011AA'\u0011%\tI\u000eHA\u0001\n\u0003\u000bY\u000eC\u0005\u0002nr\t\n\u0011\"\u0001\u0002N!I\u0011q\u001e\u000f\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003cd\u0012\u0011!C\u0005\u0003g\u00141bQ8mY\u0016\u001cG\u000fT5ti*\u0011\u0001&K\u0001\nC\u001e<'/Z4bi\u0016T!AK\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Y5\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0005\u0001]JE\nE\u00029smj\u0011aJ\u0005\u0003u\u001d\u0012qaQ8mY\u0016\u001cG\u000fE\u0002=\u0007\u0016k\u0011!\u0010\u0006\u0003}}\nq!\\;uC\ndWM\u0003\u0002A\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R\u001f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003\r\u001ek\u0011!Q\u0005\u0003\u0011\u0006\u00131!\u00118z!\t1%*\u0003\u0002L\u0003\n9\u0001K]8ek\u000e$\bC\u0001$N\u0013\tq\u0015I\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001R!\t\u00116+D\u0001*\u0013\t!\u0016F\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003a\u0003\"AR-\n\u0005i\u000b%aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"B\u0001Y1cGB\u0011\u0001\b\u0001\u0005\u0006\u001f\u001e\u0001\r!\u0015\u0005\b-\u001e\u0001\n\u00111\u0001Y\u0011\u001dav\u0001%AA\u0002a#\"\u0001Y3\t\u000b=C\u0001\u0019A)\u0002#\t,hMZ3s\u000b2,W.\u001a8u)f\u0004X-F\u0001i!\tIG.D\u0001k\u0015\tYW&A\u0003usB,7/\u0003\u0002nU\nAA)\u0019;b)f\u0004X-\u0001\fd_:4XM\u001d;U_\n+hMZ3s\u000b2,W.\u001a8u)\t)\u0005\u000fC\u0003r\u0015\u0001\u0007Q)A\u0003wC2,X-A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\t!x\u000f\u0005\u00029k&\u0011ao\n\u0002\u0014\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\u0005\u0006q.\u0001\r\u0001W\u0001\u001a]\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0003inDQ\u0001 \u0007A\u0002a\u000bqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#A\u001e\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0004A!\u0011QAA\n\u001d\u0011\t9!a\u0004\u0011\u0007\u0005%\u0011)\u0004\u0002\u0002\f)\u0019\u0011QB\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\"Q\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0011)\u0001\u0003fm\u0006dGcA#\u0002\u001e!1\u0011qD\bA\u0002m\naAY;gM\u0016\u0014\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002a\u0003KAa!a\n\u0011\u0001\u0004\t\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\bA\u00065\u0012qFA\u0019\u0011\u001dy\u0015\u0003%AA\u0002ECqAV\t\u0011\u0002\u0003\u0007\u0001\fC\u0004]#A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004#\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0013)\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\n\u0016\u00041\u0006e\u0012AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0003\u0003BA-\u0003Gj!!a\u0017\u000b\t\u0005u\u0013qL\u0001\u0005Y\u0006twM\u0003\u0002\u0002b\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0017\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q)a\u001b\t\u0011\u00055t#!AA\u0002a\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA:!\u0015\t)(a\u001eF\u001b\u0005y\u0014bAA=\u007f\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty(!\"\u0011\u0007\u0019\u000b\t)C\u0002\u0002\u0004\u0006\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002ne\t\t\u00111\u0001F\u0003\u0019)\u0017/^1mgR!\u0011qPAF\u0011!\tiGGA\u0001\u0002\u0004)\u0005f\u0006\u0001\u0002\u0010\u0006U\u0015qSAN\u0003;\u000b\t+a)\u0002(\u0006%\u0016QVAX!\r\u0011\u0016\u0011S\u0005\u0004\u0003'K#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00033\u000b!i\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I\"pY2,7\r^:!C:$\u0007E]3ukJt7\u000fI1!Y&\u001cH\u000fI8gA9|g.L;oSF,X\rI3mK6,g\u000e^:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAP\u0003\tT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QEJC\u0006\t\u00153S1\u0002\u0003&M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012D&M/\u000bA\u0001\nAA\\8uK\u0006\u0012\u0011QU\u0001\u0002L)\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI5tA9|g.\f3fi\u0016\u0014X.\u001b8jgRL7\r\t2fG\u0006,8/\u001a\u0011uQ\u0016\u0004sN\u001d3fe\u0002zg\rI2pY2,7\r^3eAI,7/\u001e7ug\u0002\"W\r]3oINT\u0001\u0005\t\u0011!_:\u0004C\u000f[3!_J$WM\u001d\u0011pM\u0002\"\b.\u001a\u0011s_^\u001c\be\u001e5jG\"\u0004S.Y=!E\u0016\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!C\u001a$XM\u001d\u0011bAMDWO\u001a4mK:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\u000b\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0016!\u0002\u001a/a9\u0002\u0014aC\"pY2,7\r\u001e'jgR\u0004\"\u0001\u000f\u000f\u0014\tq\tI\f\u0014\t\t\u0003w\u000b\t-\u0015-YA6\u0011\u0011Q\u0018\u0006\u0004\u0003\u007f\u000b\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003\u0007\fiLA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!.\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0001\fy-!5\u0002T\")qj\ba\u0001#\"9ak\bI\u0001\u0002\u0004A\u0006b\u0002/ !\u0003\u0005\r\u0001W\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u\u0017\u0011\u001e\t\u0006\r\u0006}\u00171]\u0005\u0004\u0003C\f%AB(qi&|g\u000e\u0005\u0004G\u0003K\f\u0006\fW\u0005\u0004\u0003O\f%A\u0002+va2,7\u0007\u0003\u0005\u0002l\n\n\t\u00111\u0001a\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\b\u0003BA-\u0003oLA!!?\u0002\\\t1qJ\u00196fGR\u0004")
public class CollectList
extends Collect<ArrayBuffer<Object>>
implements Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectList$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectList$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectList collectList) {
        return CollectList$.MODULE$.unapply(collectList);
    }

    public static int apply$default$3() {
        return CollectList$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectList$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectList> tupled() {
        return CollectList$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectList>>> curried() {
        return CollectList$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectList collectList = this;
        synchronized (collectList) {
            if (!this.bitmap$0) {
                this.bufferElementType = this.child().dataType();
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        if (!this.bitmap$0) {
            return this.bufferElementType$lzycompute();
        }
        return this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        return InternalRow$.MODULE$.copyValue(value);
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public ArrayBuffer<Object> createAggregationBuffer() {
        return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }

    @Override
    public String prettyName() {
        return "collect_list";
    }

    @Override
    public Object eval(ArrayBuffer<Object> buffer) {
        return new GenericArrayData((Object[])buffer.toArray(ClassTag$.MODULE$.Any()));
    }

    @Override
    public CollectList withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public CollectList copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectList(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectList";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectList)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectList collectList = (CollectList)x$1;
        Expression expression = this.child();
        Expression expression2 = collectList.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != collectList.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectList.inputAggBufferOffset()) return false;
        if (!collectList.canEqual(this)) return false;
        return true;
    }

    public CollectList(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public CollectList(Expression child) {
        this(child, 0, 0);
    }
}

