/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0013'\u0001NB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003a\u0005\u0002\u0003+\u0001\u0005#\u0005\u000b\u0011B'\t\u000bU\u0003A\u0011\u0001,\t\u000bU\u0003A\u0011A.\t\u000bU\u0003A\u0011A0\t\u000b\u0005\u0004A\u0011\t'\t\u000b\t\u0004A\u0011\t'\t\u000b\r\u0004A\u0011\t'\t\u000b\u0011\u0004A\u0011I3\t\u000b]\u0004A\u0011\t=\t\u0011q\u0004\u0001R1A\u0005\nuDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002 \u0001!\t&!\t\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u0011\u0011\u000b\u0001\u0005R\u0005M\u0003\"CA1\u0001\u0005\u0005I\u0011AA2\u0011%\tY\u0007AI\u0001\n\u0003\ti\u0007C\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002n!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003\u000f\u0003\u0011\u0011!C!\u0003\u0013C\u0011\"!'\u0001\u0003\u0003%\t!a'\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u0011%\tY\fAA\u0001\n\u0003\ti\fC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\u001eI\u0011Q\u001e\u0014\u0002\u0002#\u0005\u0011q\u001e\u0004\tK\u0019\n\t\u0011#\u0001\u0002r\"1Qk\bC\u0001\u0003\u007fD\u0011B!\u0001 \u0003\u0003%)Ea\u0001\t\u0013\t\u0015q$!A\u0005\u0002\n\u001d\u0001\"\u0003B\b?\u0005\u0005I\u0011\u0011B\t\u0011%\u0011\u0019cHA\u0001\n\u0013\u0011)CA\u0006TiJLgn\u001a+p\u001b\u0006\u0004(BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!\u0004h\u000f\"I!\t)d'D\u0001'\u0013\t9dEA\tUKJt\u0017M]=FqB\u0014Xm]:j_:\u0004\"!N\u001d\n\u0005i2#!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011Ah\u0010\b\u0003kuJ!A\u0010\u0014\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tqd\u0005\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0004Qe>$Wo\u0019;\u0011\u0005\rK\u0015B\u0001&E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011!X\r\u001f;\u0016\u00035\u0003\"!\u000e(\n\u0005=3#AC#yaJ,7o]5p]\u0006)A/\u001a=uA\u0005I\u0001/Y5s\t\u0016d\u0017.\\\u0001\u000ba\u0006L'\u000fR3mS6\u0004\u0013!D6fsZ\u000bG.^3EK2LW.\u0001\blKf4\u0016\r\\;f\t\u0016d\u0017.\u001c\u0011\u0002\rqJg.\u001b;?)\u00119\u0006,\u0017.\u0011\u0005U\u0002\u0001\"B&\b\u0001\u0004i\u0005\"B)\b\u0001\u0004i\u0005\"B*\b\u0001\u0004iEcA,]=\")Q\f\u0003a\u0001\u001b\u0006)1\r[5mI\")\u0011\u000b\u0003a\u0001\u001bR\u0011q\u000b\u0019\u0005\u0006;&\u0001\r!T\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001g!\r9g.\u001d\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0015B\u0001 E\u0013\ty\u0007OA\u0002TKFT!A\u0010#\u0011\u0005I,X\"A:\u000b\u0005QT\u0013!\u0002;za\u0016\u001c\u0018B\u0001<t\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005I\bC\u0001:{\u0013\tY8O\u0001\u0005ECR\fG+\u001f9f\u0003)i\u0017\r\u001d\"vS2$WM]\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002Q\u0005!Q\u000f^5m\u0013\u0011\t9!!\u0001\u0003)\u0005\u0013(/Y=CCN,G-T1q\u0005VLG\u000eZ3s\u00031qW\u000f\u001c7TC\u001a,WI^1m)!\ti!a\u0005\u0002\u0018\u0005m\u0001cA\"\u0002\u0010%\u0019\u0011\u0011\u0003#\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0016A\u0001\r!!\u0004\u0002\u0017%t\u0007/\u001e;TiJLgn\u001a\u0005\b\u00033\u0001\u0002\u0019AA\u0007\u0003=\u0019HO]5oO\u0012+G.[7ji\u0016\u0014\bbBA\u000f!\u0001\u0007\u0011QB\u0001\u0012W\u0016Lh+\u00197vK\u0012+G.[7ji\u0016\u0014\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019#a\f\u0002:A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0019\nqaY8eK\u001e,g.\u0003\u0003\u0002.\u0005\u001d\"\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005E\u0012\u00031\u0001\u00024\u0005\u00191\r\u001e=\u0011\t\u0005\u0015\u0012QG\u0005\u0005\u0003o\t9C\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005m\u0012\u00031\u0001\u0002$\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,WCAA!!\u0011\t\u0019%a\u0013\u000f\t\u0005\u0015\u0013q\t\t\u0003S\u0012K1!!\u0013E\u0003\u0019\u0001&/\u001a3fM&!\u0011QJA(\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\n#\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcB'\u0002V\u0005e\u0013Q\f\u0005\u0007\u0003/\u001a\u0002\u0019A'\u0002\u00119,wOR5sgRDa!a\u0017\u0014\u0001\u0004i\u0015!\u00038foN+7m\u001c8e\u0011\u0019\tyf\u0005a\u0001\u001b\u0006Aa.Z<UQ&\u0014H-\u0001\u0003d_BLHcB,\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\b\u0017R\u0001\n\u00111\u0001N\u0011\u001d\tF\u0003%AA\u00025Cqa\u0015\u000b\u0011\u0002\u0003\u0007Q*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=$fA'\u0002r-\u0012\u00111\u000f\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003%)hn\u00195fG.,GMC\u0002\u0002~\u0011\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t)a\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006!A.\u00198h\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BA'\u0003\u001f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!(\u0011\u0007\r\u000by*C\u0002\u0002\"\u0012\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0004\u0002(\"I\u0011\u0011\u0016\u000e\u0002\u0002\u0003\u0007\u0011QT\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0006CBAY\u0003o\u000bi!\u0004\u0002\u00024*\u0019\u0011Q\u0017#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a0\u0002FB\u00191)!1\n\u0007\u0005\rGIA\u0004C_>dW-\u00198\t\u0013\u0005%F$!AA\u0002\u00055\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002@\u0006-\u0007\"CAU;\u0005\u0005\t\u0019AA\u0007QM\u0001\u0011qZAk\u0003/\fY.!8\u0002b\u0006\r\u0018q]Au!\r)\u0014\u0011[\u0005\u0004\u0003'4#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00033\f!qC0G+:\u001bu\f\u000b;fqR\\F\u0006\t9bSJ$U\r\\5n72\u00023.Z=WC2,X\rR3mS6lV,\u000b\u0011.A\r\u0013X-\u0019;fg\u0002\n\u0007%\\1qA\u00054G/\u001a:!gBd\u0017\u000e\u001e;j]\u001e\u0004C\u000f[3!i\u0016DH\u000fI5oi>\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148\u000fI;tS:<\u0007\u0005Z3mS6LG/\u001a:t]\u0001\"UMZ1vYR\u0004C-\u001a7j[&$XM]:!CJ,\u0007e\n\u0017(A\u0019|'\u000f\t1qC&\u0014H)\u001a7j[\u0002\u0004\u0013M\u001c3!Oi:\u0003EZ8sA\u0001\\W-\u001f,bYV,G)\u001a7j[\u0002t\u0003EQ8uQ\u0002\u0002\u0007/Y5s\t\u0016d\u0017.\u001c1!C:$\u0007\u0005Y6fsZ\u000bG.^3EK2LW\u000e\u0019\u0011be\u0016\u0004CO]3bi\u0016$\u0007%Y:!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gn\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a8\u0002\u0003CQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ1;c1\u0012'H\r\u0017duM:C\u0006I\u0014-O1\u0002sEO\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;EE\u0012CF\t2#u\t\u0012$\u0005\f\u0012dEi\u00123GI?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\n'E\u000f8vY2l(\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u0015\u0018!\u0002\u001a/a9\n\u0014!B4s_V\u0004\u0018EAAv\u0003%i\u0017\r]0gk:\u001c7/A\u0006TiJLgn\u001a+p\u001b\u0006\u0004\bCA\u001b '\u0011y\u00121\u001f%\u0011\u0011\u0005U\u00181`'N\u001b^k!!a>\u000b\u0007\u0005eH)A\u0004sk:$\u0018.\\3\n\t\u0005u\u0018q\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAAx\u0003!!xn\u0015;sS:<GCAAF\u0003\u0015\t\u0007\u000f\u001d7z)\u001d9&\u0011\u0002B\u0006\u0005\u001bAQa\u0013\u0012A\u00025CQ!\u0015\u0012A\u00025CQa\u0015\u0012A\u00025\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0014\t}\u0001#B\"\u0003\u0016\te\u0011b\u0001B\f\t\n1q\n\u001d;j_:\u0004ba\u0011B\u000e\u001b6k\u0015b\u0001B\u000f\t\n1A+\u001e9mKNB\u0001B!\t$\u0003\u0003\u0005\raV\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\n\u0011\t\u00055%\u0011F\u0005\u0005\u0005W\tyI\u0001\u0004PE*,7\r\u001e")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
scala.Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap stringToMap) {
        return StringToMap$.MODULE$.unapply(stringToMap);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(StringType$.MODULE$, StringType$.MODULE$);
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if (!this.bitmap$0) {
                this.mapBuilder = new ArrayBasedMapBuilder(StringType$.MODULE$, StringType$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if (!this.bitmap$0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = ((UTF8String)inputString).split((UTF8String)stringDelimiter, -1);
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = keyValues[i].split(keyValueDelimiterUTF8String, 2);
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(text, pd, kvd) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(230).append("\n         |UTF8String[] ").append(keyValues).append(" = ").append((String)text).append(".split(").append((String)pd).append(", -1);\n         |for(UTF8String kvEntry: ").append(keyValues).append(") {\n         |  UTF8String[] kv = kvEntry.split(").append((String)kvd).append(", 2);\n         |  ").append(builderTerm).append(".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |").append(ev.value()).append(" = ").append(builderTerm).append(".build();\n         |").toString())).stripMargin());
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

